/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import php.java.bridge.Util;

public class ChunkedOutputStream
extends FilterOutputStream {
    private static final byte[] RN0 = "0\r\n\r\n".getBytes();
    private byte[] buf = new byte[8];

    public ChunkedOutputStream(OutputStream out) {
        super(new BufferedOutputStream(out));
    }

    private void writeEOF() throws IOException {
        this.out.write(RN0);
    }

    private void writeHex(int length) throws IOException {
        int i = this.buf.length - 1;
        while (length > 0) {
            this.buf[i] = Util.HEX_DIGITS[0xF & length];
            length >>>= 4;
            --i;
        }
        this.out.write(this.buf, ++i, this.buf.length - i);
    }

    public void write(byte[] buf, int pos, int len) throws IOException {
        if (len == 0) {
            this.writeEOF();
        } else {
            this.writeHex(len);
            this.out.write(Util.RN);
            this.out.write(buf, pos, len);
            this.out.write(Util.RN);
        }
        this.out.flush();
    }

    public void eof() throws IOException {
        this.writeEOF();
        super.flush();
    }
}

