/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import php.java.bridge.NotImplementedException;
import php.java.bridge.http.FCGIConnectionException;
import php.java.bridge.http.FCGIConnectionPool;

public class FCGIConnectionOutputStream
extends OutputStream {
    protected FCGIConnectionPool.Connection connection;
    private BufferedOutputStream out;

    protected void setConnection(FCGIConnectionPool.Connection connection) throws FCGIConnectionException {
        this.connection = connection;
        try {
            this.out = new BufferedOutputStream(connection.channel.getOutputStream());
        }
        catch (IOException e) {
            throw new FCGIConnectionException(connection, e);
        }
    }

    public void write(byte[] buf) throws FCGIConnectionException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int buflength) throws FCGIConnectionException {
        try {
            this.out.write(buf, off, buflength);
        }
        catch (IOException ex) {
            throw new FCGIConnectionException(this.connection, ex);
        }
    }

    public void write(int b) throws FCGIConnectionException {
        throw new NotImplementedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws FCGIConnectionException {
        try {
            this.flush();
        }
        finally {
            this.connection.state |= 2;
            if (this.connection.state == this.connection.ostate) {
                try {
                    this.connection.close();
                }
                catch (IOException e) {
                    throw new FCGIConnectionException(this.connection, e);
                }
            }
        }
    }

    public void flush() throws FCGIConnectionException {
        try {
            this.out.flush();
        }
        catch (IOException ex) {
            throw new FCGIConnectionException(this.connection, ex);
        }
    }
}

