/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.UnknownHostException;
import java.util.Map;
import php.java.bridge.Util;
import php.java.bridge.http.FCGIConnectException;
import php.java.bridge.http.FCGIConnection;
import php.java.bridge.http.FCGIConnectionFactory;
import php.java.bridge.http.IFCGIProcessFactory;
import php.java.bridge.http.NPChannel;

public class NPChannelFactory
extends FCGIConnectionFactory {
    public static final String PREFIX = "\\\\.\\pipe\\";
    private String raPath;
    private String testRaPath;

    public NPChannelFactory(IFCGIProcessFactory processFactory) {
        super(processFactory);
    }

    public void test() throws FCGIConnectException {
        if (!new File(this.raPath).canWrite()) {
            String reason = "File " + this.raPath + " not writable";
            if (this.lastException != null) {
                throw new FCGIConnectException(reason, this.lastException);
            }
            throw new FCGIConnectException(new IOException(reason));
        }
    }

    private NPChannel doConnect() throws FCGIConnectException {
        try {
            return new NPChannel(new RandomAccessFile(this.raPath, "rw"));
        }
        catch (IOException e) {
            throw new FCGIConnectException(e);
        }
    }

    public FCGIConnection connect() throws FCGIConnectException {
        return this.doConnect();
    }

    protected Util.Process doBind(Map env, String php, boolean includeJava) throws IOException {
        if (this.proc != null) {
            return null;
        }
        if (this.raPath == null) {
            throw new IOException("No pipe name available.");
        }
        File home = null;
        if (php != null) {
            try {
                home = new File(php).getParentFile();
            }
            catch (Exception e) {
                Util.printStackTrace(e);
            }
        }
        this.proc = this.processFactory.createFCGIProcess(new String[]{php, this.raPath}, includeJava, home, env);
        this.proc.start();
        return (Util.Process)((Object)this.proc);
    }

    protected void waitForDaemon() throws UnknownHostException, InterruptedException {
        Thread.sleep(5000L);
    }

    public String getFcgiStartCommand(String base, String php_fcgi_max_requests) {
        String msg = "cd \"" + base + File.separator + Util.osArch + "-" + Util.osName + "\"\n" + "set %REDIRECT_STATUS%=200\n" + "set %X_JAVABRIDGE_OVERRIDE_HOSTS%=/\n" + "set %PHP_FCGI_CHILDREN%=5\n" + "set %PHP_FCGI_MAX_REQUESTS%=\"" + php_fcgi_max_requests + "\"\n" + "\"c:\\Program Files\\PHP\\php-cgi.exe\" -v\n" + ".\\launcher.exe \"c:\\Program Files\\PHP\\php-cgi.exe\" \"" + this.getPath() + "\"\n\n";
        return msg;
    }

    public void findFreePort(boolean select) {
        try {
            if (select) {
                File testRafile = File.createTempFile("JavaBridge", ".socket");
                this.testRaPath = PREFIX + testRafile.getCanonicalPath();
                testRafile.delete();
            } else {
                this.testRaPath = "\\\\.\\pipe\\JavaBridge@9667";
            }
        }
        catch (IOException e) {
            Util.printStackTrace(e);
        }
    }

    public void setDefaultPort() {
        this.raPath = "\\\\.\\pipe\\JavaBridge@9667";
    }

    public void setDynamicPort() {
        this.raPath = this.testRaPath;
    }

    public String getPath() {
        return this.raPath;
    }

    public String toString() {
        return "ChannelName@" + (this.getPath() == null ? "<not initialized>" : this.getPath());
    }
}

