/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import php.java.bridge.ISession;
import php.java.bridge.JavaBridge;
import php.java.bridge.Request;
import php.java.bridge.Util;
import php.java.bridge.http.Context;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.IContextFactoryVisitor;

public class SimpleContextFactory
implements IContextFactoryVisitor {
    protected ISession session;
    protected IContextFactory visited;
    protected IContext context;
    private boolean isContextRunnerRunning = false;
    private boolean isValid = true;
    private boolean isManaged;

    protected SimpleContextFactory(String webContext, boolean isManaged) {
        this.isManaged = isManaged;
        ContextFactory visited = new ContextFactory(webContext, isManaged);
        visited.accept(this);
        this.visited = visited;
    }

    public void recycle(String id) {
        this.visited.recycle(id);
    }

    public void destroy() {
        this.visited.destroy();
        this.session = null;
    }

    public synchronized void invalidate() {
        this.isValid = false;
        this.notifyAll();
    }

    public synchronized void initialize() {
        this.isContextRunnerRunning = true;
        this.getContext().setAttribute("php.java.bridge.JavaBridge", this.getBridge(), 100);
    }

    public synchronized void releaseManaged() throws InterruptedException {
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet is waiting for ContextRunner " + System.identityHashCode(this));
        }
        if (this.isContextRunnerRunning) {
            while (this.isValid) {
                this.wait();
            }
            if (Util.logLevel > 4) {
                Util.logDebug("contextfactory: servlet done waiting for ContextRunner " + System.identityHashCode(this));
            }
        } else {
            if (Util.logLevel > 4) {
                Util.logDebug("contextfactory: servlet done w/o ContextRunner " + System.identityHashCode(this));
            }
            if (this.isManaged) {
                this.destroy();
            } else {
                this.release();
            }
        }
    }

    public synchronized void waitFor(long timeout) throws InterruptedException {
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet waitFor() ContextFactory " + System.identityHashCode(this) + " for " + timeout + " ms");
        }
        if (this.isValid) {
            this.wait(timeout);
        }
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet waitFor() ContextRunner " + System.identityHashCode(this));
        }
        if (this.isContextRunnerRunning && this.isValid) {
            this.wait();
        }
        if (Util.logLevel > 4) {
            Util.logDebug("contextfactory: servlet done waitFor() ContextRunner " + System.identityHashCode(this));
        }
    }

    public String getId() {
        return this.visited.getId();
    }

    public String toString() {
        return "ContextFactory: " + this.visited + ", SimpleContextFactory: " + this.getClass();
    }

    protected IContext createContext() {
        return new Context();
    }

    public IContext getContext() {
        if (this.context == null) {
            this.setContext(this.createContext());
        }
        return this.context;
    }

    public boolean isNew() {
        return this.visited.isNew();
    }

    public JavaBridge getBridge() {
        return this.visited.getBridge();
    }

    public void visit(IContextFactory visited) {
        this.visited = visited;
    }

    public ISession getSession(String name, short clientIsNew, int timeout) {
        return this.getSimpleSession(name, clientIsNew, timeout);
    }

    public ISession getSimpleSession(String name, short clientIsNew, int timeout) {
        if (name != null) {
            return this.visited.getSimpleSession(name, clientIsNew, timeout);
        }
        if (this.session != null) {
            return this.session;
        }
        this.session = this.visited.getSimpleSession(name, clientIsNew, timeout);
        return this.session;
    }

    public void setContext(IContext context) {
        this.context = context;
    }

    public void release() {
        this.visited.release();
    }

    public void recycle() {
        this.visited.recycle();
    }

    public void flushBuffer() throws IOException {
        this.visited.flushBuffer();
    }

    public void parseHeader(Request req, InputStream in) throws IOException {
        this.visited.parseHeader(req, in);
    }
}

