/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import php.java.bridge.JavaBridge;

class GlobalRef {
    public static final int DEFAULT_SIZE = 1021;
    private int threshold;
    private Entry[] globalRef;
    private int id = 1;
    private int count = 0;

    public GlobalRef(int initialCapacity) {
        this.globalRef = new Entry[initialCapacity];
        this.threshold = (initialCapacity >>> 2) * 3;
    }

    public GlobalRef() {
        this(1021);
    }

    public Object get(int id) {
        int index = (id & Integer.MAX_VALUE) % this.globalRef.length;
        Entry e = this.globalRef[index];
        while (e != null) {
            if (e.id == id) {
                return e.value;
            }
            e = e.next;
        }
        throw new NullPointerException("cannot manipulate the object #" + id + " which has already been destroyed by PHP");
    }

    public void remove(int id) {
        int index = (id & Integer.MAX_VALUE) % this.globalRef.length;
        Entry e = this.globalRef[index];
        Entry prev = null;
        while (e != null) {
            if (e.id == id) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    this.globalRef[index] = e.next;
                }
                --this.count;
            }
            prev = e;
            e = e.next;
        }
    }

    public String dump() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (this.globalRef[i] == null) continue;
            Entry e = this.globalRef[i];
            while (e != null) {
                result.append("globalRef[" + i + "]=" + JavaBridge.objectDebugDescription(e.value) + "\n");
                e = e.next;
            }
        }
        return result.toString();
    }

    public String toString() {
        return "GlobalRef: " + this.dump();
    }

    public int append(Object value) {
        return this.put(this.id++, value);
    }

    private int put(int id, Object value) {
        int index = (id & Integer.MAX_VALUE) % this.globalRef.length;
        Entry e = this.globalRef[index];
        while (e != null) {
            if (e.id == id) {
                e.value = value;
                return id;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(id, value);
        }
        this.globalRef[index] = new Entry(id, value, this.globalRef[index]);
        ++this.count;
        return id;
    }

    private void rehash() {
        int oldCapacity = this.globalRef.length;
        Entry[] oldTable = this.globalRef;
        int newCapacity = (oldCapacity << 1) + 1;
        Entry[] newTable = new Entry[newCapacity];
        this.threshold = (newCapacity >>> 2) * 3;
        this.globalRef = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.id & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    class Entry {
        int id;
        Object value;
        Entry next;

        public Entry(int id, Object value, Entry entry) {
            this.id = id;
            this.value = value;
            this.next = entry;
        }
    }
}

