/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.util.Map;
import php.java.bridge.ILogger;
import php.java.bridge.Util;
import php.java.bridge.http.FCGIConnectException;
import php.java.bridge.http.FCGIConnection;
import php.java.bridge.http.IFCGIProcess;
import php.java.bridge.http.IFCGIProcessFactory;
import php.java.bridge.http.NPChannelFactory;
import php.java.bridge.http.SocketChannelFactory;

public abstract class FCGIConnectionFactory {
    protected boolean promiscuous;
    protected IFCGIProcessFactory processFactory;
    protected IFCGIProcess proc = null;
    private boolean fcgiStarted = false;
    private final Object fcgiStartLock = new Object();
    protected Exception lastException;

    public FCGIConnectionFactory(IFCGIProcessFactory processFactory) {
        this.processFactory = processFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean startServer(ILogger logger) {
        Object object = this.fcgiStartLock;
        synchronized (object) {
            if (!this.fcgiStarted) {
                if (this.canStartFCGI()) {
                    try {
                        this.bind(logger);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.fcgiStarted = true;
            }
        }
        return this.fcgiStarted;
    }

    public abstract void test() throws FCGIConnectException;

    protected abstract void waitForDaemon() throws UnknownHostException, InterruptedException;

    protected final void runFcgi(Map env, String php, boolean includeJava) {
        byte[] buf = new byte[8192];
        try {
            int c;
            Util.Process proc = this.doBind(env, php, includeJava);
            if (proc == null || proc.getInputStream() == null) {
                return;
            }
            proc.getInputStream().close();
            InputStream in = proc.getErrorStream();
            while ((c = in.read(buf)) != -1) {
                System.err.write(buf, 0, c);
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        catch (Exception e) {
            this.lastException = e;
            System.err.println("Could not start FCGI server: " + e);
        }
    }

    protected abstract Util.Process doBind(Map var1, String var2, boolean var3) throws IOException;

    protected void bind(ILogger logger) throws InterruptedException, IOException {
        Util.Thread t = new Util.Thread("JavaBridgeFastCGIRunner"){

            public void run() {
                Map env = (Map)FCGIConnectionFactory.this.processFactory.getEnvironment().clone();
                env.put("PHP_FCGI_CHILDREN", FCGIConnectionFactory.this.processFactory.getPhpConnectionPoolSize());
                env.put("PHP_FCGI_MAX_REQUESTS", FCGIConnectionFactory.this.processFactory.getPhpMaxRequests());
                FCGIConnectionFactory.this.runFcgi(env, FCGIConnectionFactory.this.processFactory.getPhp(), FCGIConnectionFactory.this.processFactory.getPhpIncludeJava());
            }
        };
        t.start();
        this.waitForDaemon();
    }

    private boolean canStartFCGI() {
        return this.processFactory.canStartFCGI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.fcgiStartLock;
        synchronized (object) {
            this.fcgiStarted = false;
            if (this.proc == null) {
                return;
            }
            try {
                OutputStream out = this.proc.getOutputStream();
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                Util.printStackTrace(e);
            }
            try {
                this.proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.proc.destroy();
            this.proc = null;
        }
    }

    public abstract FCGIConnection connect() throws FCGIConnectException;

    public void initialize() {
        this.setDynamicPort();
    }

    protected abstract void setDynamicPort();

    protected abstract void setDefaultPort();

    public abstract String getFcgiStartCommand(String var1, String var2);

    public abstract void findFreePort(boolean var1);

    public static FCGIConnectionFactory createChannelFactory(IFCGIProcessFactory processFactory, boolean promiscuous) {
        if (Util.USE_SH_WRAPPER) {
            return new SocketChannelFactory(processFactory, promiscuous);
        }
        return new NPChannelFactory(processFactory);
    }

    public abstract String toString();
}

