/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import php.java.bridge.Util;
import php.java.bridge.http.FCGIConnectException;
import php.java.bridge.http.FCGIConnection;
import php.java.bridge.http.FCGIConnectionException;
import php.java.bridge.http.FCGIConnectionFactory;
import php.java.bridge.http.FCGIConnectionInputStream;
import php.java.bridge.http.FCGIConnectionOutputStream;
import php.java.bridge.http.FCGIIOFactory;

public class FCGIConnectionPool {
    private int limit;
    private long timeout;
    private int connections = 0;
    private List freeList = new LinkedList();
    private List connectionList = new LinkedList();
    private FCGIIOFactory factory;
    private int maxRequests;
    private FCGIConnectionFactory channelName;

    private FCGIConnectionPool(FCGIConnectionFactory channelName, int limit, int maxRequests, FCGIIOFactory factory) throws FCGIConnectException {
        if (Util.logLevel > 3) {
            Util.logDebug("Creating new connection pool for: " + channelName);
        }
        this.channelName = channelName;
        this.limit = limit;
        this.factory = factory;
        this.maxRequests = maxRequests;
        this.timeout = -1L;
        channelName.test();
    }

    public FCGIConnectionPool(FCGIConnectionFactory channelName, int limit, int maxRequests, FCGIIOFactory factory, long timeout) throws FCGIConnectException {
        this(channelName, limit, maxRequests, factory);
        this.timeout = timeout;
    }

    private Connection createNewConnection() {
        Connection connection = new Connection(this.channelName, this.maxRequests, this.factory);
        this.connectionList.add(connection);
        ++this.connections;
        return connection;
    }

    public synchronized Connection openConnection() throws InterruptedException, FCGIConnectException {
        Connection connection;
        if (this.freeList.isEmpty() && this.connections < this.limit) {
            connection = this.createNewConnection();
        } else {
            while (this.freeList.isEmpty()) {
                if (this.timeout > 0L) {
                    long t1 = System.currentTimeMillis();
                    this.wait(this.timeout);
                    long t2 = System.currentTimeMillis();
                    long t = t2 - t1;
                    if (t < this.timeout) continue;
                    throw new FCGIConnectException(new IOException("pool timeout " + this.timeout + " exceeded: " + t));
                }
                this.wait();
            }
            connection = (Connection)this.freeList.remove(0);
            connection.reset();
        }
        return connection.reopen();
    }

    private synchronized void closeConnection(Connection connection) {
        this.freeList.add(connection);
        this.notify();
    }

    public synchronized void destroy() {
        Iterator ii = this.connectionList.iterator();
        while (ii.hasNext()) {
            Connection connection = (Connection)ii.next();
            connection.destroy();
        }
        if (this.channelName != null) {
            this.channelName.destroy();
        }
    }

    public final class Connection {
        protected int ostate;
        protected int state;
        protected FCGIConnectionFactory channelName;
        protected FCGIConnection channel;
        private FCGIConnectionOutputStream outputStream;
        private FCGIConnectionInputStream inputStream;
        private boolean isClosed;
        private FCGIIOFactory factory;
        private int maxRequests;
        private int counter;

        protected void reset() {
            this.ostate = 0;
            this.state = 0;
        }

        protected void init() {
            this.inputStream = null;
            this.outputStream = null;
            this.counter = this.maxRequests;
            this.reset();
        }

        protected Connection reopen() throws FCGIConnectException {
            if (this.isClosed) {
                this.channel = this.factory.connect(this.channelName);
            }
            this.isClosed = false;
            return this;
        }

        protected Connection(FCGIConnectionFactory channelName, int maxRequests, FCGIIOFactory factory) {
            this.channelName = channelName;
            this.factory = factory;
            this.isClosed = true;
            this.maxRequests = maxRequests;
            this.init();
        }

        public void setIsClosed() {
            this.isClosed = true;
        }

        protected void close() throws FCGIConnectException {
            if (this.maxRequests > 0 && --this.counter == 0) {
                this.isClosed = true;
            }
            if (this.isClosed) {
                this.destroy();
                this.init();
            }
            FCGIConnectionPool.this.closeConnection(this);
        }

        private void destroy() {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public OutputStream getOutputStream() throws FCGIConnectionException {
            if (this.outputStream != null) {
                return this.outputStream;
            }
            FCGIConnectionOutputStream outputStream = (FCGIConnectionOutputStream)this.factory.createOutputStream();
            outputStream.setConnection(this);
            this.ostate |= 2;
            return outputStream;
        }

        public InputStream getInputStream() throws FCGIConnectionException {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            FCGIConnectionInputStream inputStream = (FCGIConnectionInputStream)this.factory.createInputStream();
            inputStream.setConnection(this);
            this.ostate |= 1;
            return inputStream;
        }
    }
}

