/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import php.java.bridge.NotImplementedException;
import php.java.bridge.Util;

public class HttpResponse {
    private HashMap headers;
    private OutputStream outputStream;
    private boolean headersWritten;
    private final byte[] h1 = Util.toBytes("HTTP/1.0 200 OK\r\n");
    private final byte[] h2 = Util.toBytes("Host: localhost\r\nConnection: close\r\n");
    private final byte[] h4 = Util.toBytes(": ");

    public HttpResponse(OutputStream outputStream) {
        this.headers = new HashMap();
        this.outputStream = new BufferedOutputStream(outputStream){

            public void write(byte[] buf, int pos, int len) throws IOException {
                if (!HttpResponse.this.headersWritten) {
                    HttpResponse.this.headersWritten = true;
                    HttpResponse.this.writeHeaders();
                }
                super.write(buf, pos, len);
            }
        };
    }

    public void setHeader(String string, String val) {
        this.headers.put(string, val);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setStatus(int code) {
        throw new NotImplementedException();
    }

    public void addHeader(String string, String string2) {
        this.setHeader(string, string2);
    }

    private void writeHeaders() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.h1);
        out.write(this.h2);
        Iterator ii = this.headers.keySet().iterator();
        while (ii.hasNext()) {
            Object key = ii.next();
            Object val = this.headers.get(key);
            out.write(Util.toBytes((String)key));
            out.write(this.h4);
            out.write(Util.toBytes((String)val));
            out.write(Util.RN);
        }
        out.write(Util.RN);
        out.writeTo(this.outputStream);
    }

    public void setContentLength(int length) throws IOException {
        this.setHeader("Content-Length", String.valueOf(length));
    }

    public void close() throws IOException {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        finally {
            this.outputStream = null;
        }
    }

    public void flushBuffer() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }
}

