/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;
import php.java.bridge.classloader.SimpleJavaBridgeClassLoader;
import php.java.bridge.http.Context;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.IContextFactoryVisitor;
import php.java.bridge.http.ISession;
import php.java.bridge.parser.Request;
import php.java.bridge.util.Logger;

public class SimpleContextFactory
implements IContextFactoryVisitor {
    protected ISession session;
    protected IContextFactory visited;
    protected IContext context;
    private boolean isContextRunnerRunning = false;
    private boolean isValid = true;
    private boolean isManaged;
    private ClassLoader loader;

    protected SimpleContextFactory(String webContext, boolean isManaged) {
        this.isManaged = isManaged;
        ContextFactory visited = new ContextFactory(webContext, isManaged);
        visited.accept(this);
        this.setClassLoader(Util.getContextClassLoader());
        this.visited = visited;
    }

    @Override
    public void recycle(String id) {
        this.visited.recycle(id);
    }

    @Override
    public void destroy() {
        this.visited.destroy();
        this.session = null;
    }

    @Override
    public synchronized void invalidate() {
        this.isValid = false;
        this.notifyAll();
    }

    @Override
    public synchronized void initialize() {
        this.isContextRunnerRunning = true;
        this.getContext().setAttribute("php.java.bridge.JavaBridge", this.getBridge(), 100);
    }

    @Override
    public synchronized void releaseManaged() throws InterruptedException {
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: servlet is waiting for ContextRunner " + System.identityHashCode(this));
        }
        if (this.isContextRunnerRunning) {
            while (this.isValid) {
                this.wait();
            }
            if (Logger.getLogLevel() > 4) {
                Logger.logDebug("contextfactory: servlet done waiting for ContextRunner " + System.identityHashCode(this));
            }
        } else {
            if (Logger.getLogLevel() > 4) {
                Logger.logDebug("contextfactory: servlet done w/o ContextRunner " + System.identityHashCode(this));
            }
            if (this.isManaged) {
                this.destroy();
            } else {
                this.release();
            }
        }
    }

    @Override
    public synchronized void waitFor(long timeout) throws InterruptedException {
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: servlet waitFor() ContextFactory " + System.identityHashCode(this) + " for " + timeout + " ms");
        }
        if (this.isValid) {
            this.wait(timeout);
        }
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: servlet waitFor() ContextRunner " + System.identityHashCode(this));
        }
        if (this.isContextRunnerRunning && this.isValid) {
            this.wait();
        }
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("contextfactory: servlet done waitFor() ContextRunner " + System.identityHashCode(this));
        }
    }

    @Override
    public String getId() {
        return this.visited.getId();
    }

    public String toString() {
        return "ContextFactory: " + this.visited + ", SimpleContextFactory: " + this.getClass() + ", current loader: " + this.loader;
    }

    protected IContext createContext() {
        return new Context();
    }

    @Override
    public IContext getContext() {
        if (this.context == null) {
            this.setContext(this.createContext());
        }
        return this.context;
    }

    @Override
    public boolean isNew() {
        return this.visited.isNew();
    }

    @Override
    public JavaBridge getBridge() {
        return this.visited.getBridge();
    }

    @Override
    public void visit(IContextFactory visited) {
        this.visited = visited;
    }

    @Override
    public ISession getSession(String name, short clientIsNew, int timeout) {
        return this.getSimpleSession(name, clientIsNew, timeout);
    }

    @Override
    public ISession getSimpleSession(String name, short clientIsNew, int timeout) {
        if (name != null) {
            return this.visited.getSimpleSession(name, clientIsNew, timeout);
        }
        if (this.session != null) {
            return this.session;
        }
        this.session = this.visited.getSimpleSession(name, clientIsNew, timeout);
        return this.session;
    }

    @Override
    public void setContext(IContext context) {
        this.context = context;
    }

    @Override
    public void release() {
        this.visited.release();
    }

    @Override
    public void recycle() {
        this.visited.recycle();
    }

    @Override
    public void flushBuffer() throws IOException {
        this.visited.flushBuffer();
    }

    @Override
    public void parseHeader(Request req, InputStream in) throws IOException {
        this.visited.parseHeader(req, in);
    }

    @Override
    public SimpleJavaBridgeClassLoader getJavaBridgeClassLoader() {
        return this.visited.getJavaBridgeClassLoader();
    }

    private void setClassLoader(ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException("loader");
        }
        this.loader = loader;
    }
}

