/*
 * Decompiled with CFR 0.152.
 */
package php.java.fastcgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.java.fastcgi.FCGIInputStream;
import php.java.fastcgi.FCGIOutputStream;
import php.java.fastcgi.FCGIProcessException;

public abstract class Connection {
    private boolean isClosed;
    private int maxRequests;
    private int counter;
    private int id;

    public int getMaxRequests() {
        return this.maxRequests;
    }

    protected void init() {
        this.counter = this.maxRequests;
    }

    protected Connection(int maxRequests) {
        this.maxRequests = maxRequests;
        this.init();
    }

    public void setIsClosed() throws FCGIProcessException {
        this.init();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract void closeConnection();

    protected InputStream getInputStream(InputStream in) {
        return new FCGIInputStream(in);
    }

    protected OutputStream getOutputStream(OutputStream out) {
        return new FCGIOutputStream(out);
    }

    protected boolean decrementCounter() {
        return this.maxRequests > 0 && --this.counter == 0;
    }

    public boolean isLast() {
        return this.maxRequests > 0 && this.counter == 1;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

