/*
 * Decompiled with CFR 0.152.
 */
package php.java.fastcgi;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import php.java.bridge.Util;
import php.java.bridge.util.Logger;
import php.java.fastcgi.CloseableConnection;
import php.java.fastcgi.Connection;
import php.java.fastcgi.ConnectionException;
import php.java.fastcgi.FCGIFactory;
import php.java.fastcgi.FCGIHelper;
import php.java.fastcgi.FCGIProcess;
import php.java.fastcgi.FCGIProcessException;
import php.java.fastcgi.SocketConnection;

class SocketFactory
extends FCGIFactory {
    public static final String LOCAL_HOST = "127.0.0.1";
    private int port;
    private ServerSocket fcgiTestSocket = null;
    private int fcgiTestPort;

    public SocketFactory(String[] args, Map env, CloseableConnection fcgiConnectionPool, FCGIHelper helper) {
        super(args, env, fcgiConnectionPool, helper);
    }

    @Override
    public void test(String errorMessage) throws FCGIProcessException, ConnectionException {
        try {
            Socket testSocket = new Socket(InetAddress.getByName(this.getName()), this.port);
            testSocket.close();
        }
        catch (IOException e) {
            if (this.fcgiProcessStartException != null) {
                throw new FCGIProcessException(this.fcgiProcessStartException);
            }
            throw new ConnectionException(errorMessage, e);
        }
    }

    private Socket doConnect(String host, int port) throws FCGIProcessException {
        Socket s = null;
        try {
            s = new Socket(InetAddress.getByName(host), port);
        }
        catch (IOException e) {
            throw new FCGIProcessException(e);
        }
        try {
            s.setTcpNoDelay(true);
        }
        catch (SocketException e) {
            Logger.printStackTrace(e);
        }
        return s;
    }

    @Override
    public Connection connect() throws FCGIProcessException {
        Socket s = this.doConnect(this.getName(), this.getPort());
        return new SocketConnection(this.helper.getPhpFcgiMaxRequests(), s);
    }

    @Override
    protected void waitForDaemon() throws UnknownHostException, InterruptedException {
        int count = 15;
        InetAddress addr = InetAddress.getByName(LOCAL_HOST);
        if (Logger.getLogLevel() > 3) {
            Logger.logDebug("Waiting for PHP FastCGI daemon");
        }
        while (count-- > 0) {
            try {
                Socket s = new Socket(addr, this.getPort());
                s.close();
                break;
            }
            catch (IOException iOException) {
                Thread.sleep(100L);
            }
        }
        if (count == -1) {
            Logger.logError("Timeout waiting for PHP FastCGI daemon");
        }
        if (Logger.getLogLevel() > 3) {
            Logger.logDebug("done waiting for PHP FastCGI daemon");
        }
    }

    @Override
    protected FCGIProcess doBind() throws IOException {
        if (this.proc != null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(Util.JAVABRIDGE_PROMISCUOUS || this.promiscuous ? "" : LOCAL_HOST);
        buf.append(':');
        buf.append(String.valueOf(this.getPort()));
        String port = buf.toString();
        String[] args = new String[this.args.length + 2];
        args[0] = this.args[0];
        args[1] = "-b";
        args[2] = port;
        System.arraycopy(this.args, 1, args, 3, this.args.length - 1);
        this.proc = this.createFCGIProcess(args, this.env);
        this.proc.start();
        return this.proc;
    }

    protected int getPort() {
        return this.port;
    }

    protected String getName() {
        return LOCAL_HOST;
    }

    @Override
    public String getFcgiStartCommand(String base, int php_fcgi_max_requests) {
        String msg = "cd " + base + File.separator + Util.osArch + "-" + Util.osName + "\n" + "REDIRECT_STATUS=200 " + "X_JAVABRIDGE_OVERRIDE_HOSTS=\"/\" " + "PHP_FCGI_CHILDREN=\"5\" " + "PHP_FCGI_MAX_REQUESTS=\"" + php_fcgi_max_requests + "\" php-cgi -b 127.0.0.1:" + this.getPort() + "\n\n";
        return msg;
    }

    @Override
    protected void bind() throws InterruptedException, IOException {
        if (this.fcgiTestSocket != null) {
            this.fcgiTestSocket.close();
            this.fcgiTestSocket = null;
        }
        super.bind();
    }

    @Override
    public void findFreePort(boolean select) {
        this.fcgiTestPort = 9667;
        this.fcgiTestSocket = null;
        int i = 9668;
        while (select && i < 9767) {
            try {
                ServerSocket s = new ServerSocket(i, 20, InetAddress.getByName(LOCAL_HOST));
                this.fcgiTestPort = i;
                this.fcgiTestSocket = s;
                break;
            }
            catch (IOException iOException) {
                ++i;
            }
        }
    }

    @Override
    public void setDefaultPort() {
        this.port = Integer.parseInt(this.helper.getSocketPort());
    }

    @Override
    protected void setDynamicPort() {
        this.port = this.fcgiTestPort;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.fcgiTestSocket != null) {
            try {
                this.fcgiTestSocket.close();
                this.fcgiTestSocket = null;
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        return "ChannelName@127.0.0.1:" + this.port;
    }
}

