/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import php.java.bridge.JavaBridge;
import php.java.bridge.http.AbstractChannel;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.parser.Request;
import php.java.bridge.util.Logger;

final class HttpContextRunner
implements Serializable {
    private static final long serialVersionUID = 6280393106090501730L;
    private Request request;
    private InputStream in;
    private OutputStream out;
    private AbstractChannel channel;
    private IContextFactory ctx;
    private byte shortPathHeader;

    public HttpContextRunner(AbstractChannel channel, IContextFactory ctx) {
        this.channel = channel;
        this.ctx = ctx;
    }

    private int readLength() throws IOException {
        byte[] buf = new byte[1];
        this.in.read(buf);
        this.shortPathHeader = (byte)(0xFF & buf[0]);
        buf = new byte[2];
        this.in.read(buf);
        return 0xFF & buf[0] | 0xFF00 & buf[1] << 8;
    }

    private String readString(int length) throws IOException {
        byte[] buf = new byte[length];
        this.in.read(buf);
        return new String(buf, "ASCII");
    }

    private String readName() throws IOException {
        return this.readString(this.readLength());
    }

    private void setIO(JavaBridge bridge, InputStream in, OutputStream out) {
        bridge.request.reset();
        bridge.in = in;
        bridge.out = out;
    }

    private boolean init() throws IOException {
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug((String)("starting a new ContextRunner " + this));
        }
        this.out = this.channel.getOuptutStream();
        this.in = this.channel.getInputStream();
        int c = this.in.read();
        if (c != 127) {
            if (c == -1) {
                return false;
            }
            try {
                this.out.write(0);
            }
            catch (IOException iOException) {}
            throw new IOException("Protocol violation");
        }
        this.out.write(0);
        this.out.flush();
        this.readName();
        JavaBridge bridge = this.ctx.getBridge();
        if (this.shortPathHeader != -1) {
            bridge.request = new Request(bridge);
            bridge.request.init(this.shortPathHeader);
        }
        this.setIO(bridge, this.in, this.out);
        this.request = bridge.request;
        this.ctx.initialize();
        return true;
    }

    public void run() {
        try {
            try {
                if (this.init()) {
                    this.request.handleRequests();
                } else {
                    Logger.warn((String)"context runner init failed");
                }
            }
            catch (IOException e) {
                if (Logger.getLogLevel() > 4) {
                    Logger.printStackTrace((Throwable)e);
                }
                if (this.ctx != null) {
                    this.ctx.destroy();
                }
                this.channel.shutdown();
            }
            catch (Exception e) {
                block13: {
                    Logger.printStackTrace((Throwable)e);
                    if (this.ctx == null) break block13;
                    this.ctx.destroy();
                }
                this.channel.shutdown();
            }
        }
        finally {
            if (this.ctx != null) {
                this.ctx.destroy();
            }
            this.channel.shutdown();
        }
    }
}

