/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet.fastcgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.util.Logger;
import php.java.bridge.util.NotImplementedException;
import php.java.fastcgi.FCGIInputStream;
import php.java.fastcgi.FCGIOutputStream;
import php.java.fastcgi.FCGIUtil;
import php.java.servlet.ContextLoaderListener;
import php.java.servlet.PhpJavaServlet;
import php.java.servlet.ServletContextFactory;
import php.java.servlet.ServletUtil;
import php.java.servlet.fastcgi.FCGIServletHeaderParser;

public class FastCGIServlet
extends HttpServlet {
    protected static final String _80 = "80";
    protected static final String _443 = "443";
    private static final long serialVersionUID = 3545800996174312757L;
    protected String documentRoot;
    protected String serverSignature;
    protected ServletContext context;
    protected ContextLoaderListener contextLoaderListener;
    protected String serverInfo;
    protected boolean phpRequestURIisUnique;
    private ErrorLogOutputStream err = new ErrorLogOutputStream();
    private FCGIServletHeaderParser headerParser = new FCGIServletHeaderParser();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = config.getServletContext();
        String value = config.getInitParameter("php_request_uri_is_unique");
        if ("on".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
            this.phpRequestURIisUnique = true;
        }
        this.contextLoaderListener = (ContextLoaderListener)this.context.getAttribute(ContextLoaderListener.CONTEXT_LOADER_LISTENER);
        this.serverInfo = config.getServletName();
        if (this.serverInfo == null) {
            this.serverInfo = "FastCGIServlet";
        }
        this.documentRoot = ServletUtil.getRealPath(this.context, "");
        this.serverSignature = this.context.getServerInfo();
    }

    public void destroy() {
        super.destroy();
    }

    protected void setupRequestVariables(HttpServletRequest req, Environment env) {
        env.allHeaders = new ArrayList();
        env.includedJava = this.contextLoaderListener.getHelper().isPhpIncludeJava() && PhpJavaServlet.getHeader("X_JAVABRIDGE_INCLUDE", req) == null;
        env.includedDebugger = this.contextLoaderListener.getHelper().isPhpIncludeDebugger() && PhpJavaServlet.getHeader("X_JAVABRIDGE_INCLUDE", req) == null;
        env.contextPath = (String)req.getAttribute("javax.servlet.include.context_path");
        if (env.contextPath == null) {
            env.contextPath = req.getContextPath();
        }
        env.pathInfo = (String)req.getAttribute("javax.servlet.include.path_info");
        if (env.pathInfo == null) {
            env.pathInfo = req.getPathInfo();
        }
        env.servletPath = (String)req.getAttribute("javax.servlet.include.servlet_path");
        if (env.servletPath == null) {
            env.servletPath = req.getServletPath();
        }
        env.queryString = (String)req.getAttribute("javax.servlet.include.query_string");
        if (env.queryString == null) {
            env.queryString = req.getQueryString();
        }
        env.requestUri = this.phpRequestURIisUnique ? (String)req.getAttribute("javax.servlet.include.request_uri") : (String)req.getAttribute("javax.servlet.forward.request_uri");
        if (env.requestUri == null) {
            env.requestUri = req.getRequestURI();
        }
    }

    protected void setPathInfo(HttpServletRequest req, HashMap envp, Environment env) {
        String pathInfo = env.pathInfo;
        if (pathInfo != null) {
            envp.put("PATH_INFO", pathInfo);
            envp.put("PATH_TRANSLATED", String.valueOf(this.documentRoot) + pathInfo);
        }
        envp.put("SCRIPT_FILENAME", ServletUtil.getRealPath(this.context, env.servletPath));
    }

    protected void setupCGIEnvironment(HttpServletRequest req, HttpServletResponse res, Environment env) throws ServletException {
        String id;
        HashMap<String, String> envp = new HashMap<String, String>();
        envp.put("SERVER_SOFTWARE", this.serverInfo);
        envp.put("SERVER_NAME", ServletUtil.nullsToBlanks(req.getServerName()));
        envp.put("GATEWAY_INTERFACE", "CGI/1.1");
        envp.put("SERVER_PROTOCOL", ServletUtil.nullsToBlanks(req.getProtocol()));
        int port = ServletUtil.getLocalPort((ServletRequest)req);
        Integer iPort = port == 0 ? new Integer(-1) : new Integer(port);
        envp.put("SERVER_PORT", iPort.toString());
        envp.put("REQUEST_METHOD", ServletUtil.nullsToBlanks(req.getMethod()));
        envp.put("SCRIPT_NAME", String.valueOf(env.contextPath) + env.servletPath);
        envp.put("QUERY_STRING", ServletUtil.nullsToBlanks(env.queryString));
        envp.put("REMOTE_HOST", ServletUtil.nullsToBlanks(req.getRemoteHost()));
        envp.put("REMOTE_ADDR", ServletUtil.nullsToBlanks(req.getRemoteAddr()));
        envp.put("AUTH_TYPE", ServletUtil.nullsToBlanks(req.getAuthType()));
        envp.put("REMOTE_USER", ServletUtil.nullsToBlanks(req.getRemoteUser()));
        envp.put("REMOTE_IDENT", "");
        envp.put("CONTENT_TYPE", ServletUtil.nullsToBlanks(req.getContentType()));
        this.setPathInfo(req, envp, env);
        int contentLength = req.getContentLength();
        String sContentLength = contentLength <= 0 ? "" : new Integer(contentLength).toString();
        envp.put("CONTENT_LENGTH", sContentLength);
        Enumeration headers = req.getHeaderNames();
        String header = null;
        StringBuffer buffer = new StringBuffer();
        while (headers.hasMoreElements()) {
            header = ((String)headers.nextElement()).toUpperCase();
            if ("AUTHORIZATION".equalsIgnoreCase(header) || "PROXY_AUTHORIZATION".equalsIgnoreCase(header)) continue;
            if ("HOST".equalsIgnoreCase(header)) {
                String host = req.getHeader(header);
                int idx = host.indexOf(":");
                if (idx < 0) {
                    idx = host.length();
                }
                envp.put("HTTP_" + header.replace('-', '_'), host.substring(0, idx));
                continue;
            }
            if (header.startsWith("X_")) {
                envp.put(header, req.getHeader(header));
                continue;
            }
            envp.put("HTTP_" + header.replace('-', '_'), ServletUtil.getHeaders(buffer, req.getHeaders(header)));
        }
        env.environment = envp;
        if (env.includedJava || env.includedDebugger) {
            env.environment.put("X_JAVABRIDGE_INCLUDE_ONLY", String.valueOf((env.includedJava ? 10 : 0) + (env.includedDebugger ? 1 : 0)));
            env.environment.put("X_JAVABRIDGE_INCLUDE", ServletUtil.getRealPath(this.getServletContext(), env.servletPath));
        }
        env.environment.put("REDIRECT_STATUS", "200");
        env.environment.put("SERVER_SOFTWARE", Util.EXTENSION_NAME);
        String sPort = (String)env.environment.get("SERVER_PORT");
        String standardPort = req.isSecure() ? _443 : _80;
        StringBuffer httpHost = new StringBuffer((String)env.environment.get("SERVER_NAME"));
        if (!standardPort.equals(sPort)) {
            httpHost.append(":");
            httpHost.append(sPort);
        }
        env.environment.put("HTTP_HOST", httpHost.toString());
        String remotePort = null;
        try {
            remotePort = String.valueOf(req.getRemotePort());
        }
        catch (Throwable t) {
            remotePort = String.valueOf(t);
        }
        env.environment.put("REMOTE_PORT", remotePort);
        String query = env.queryString;
        if (query != null) {
            env.environment.put("REQUEST_URI", ServletUtil.nullsToBlanks(String.valueOf(env.requestUri) + "?" + query));
        } else {
            env.environment.put("REQUEST_URI", ServletUtil.nullsToBlanks(env.requestUri));
        }
        env.environment.put("SERVER_ADDR", req.getServerName());
        env.environment.put("SERVER_SIGNATURE", this.serverSignature);
        env.environment.put("DOCUMENT_ROOT", this.documentRoot);
        if (req.isSecure()) {
            env.environment.put("HTTPS", "On");
        }
        if ((id = PhpJavaServlet.getHeader("X_JAVABRIDGE_CONTEXT", req)) == null) {
            env.ctx = ServletContextFactory.addNew(this.contextLoaderListener.getContextServer(), (Servlet)this, this.getServletContext(), req, req, res);
            id = env.ctx.getId();
            AbstractChannelName channelName = this.contextLoaderListener.getContextServer().getChannelName(env.ctx);
            if (channelName != null) {
                env.environment.put("X_JAVABRIDGE_REDIRECT", channelName.getName());
                env.ctx.getBridge();
                this.contextLoaderListener.getContextServer().start(channelName);
            }
        }
        env.environment.put("X_JAVABRIDGE_CONTEXT", id);
    }

    /*
     * Unable to fully structure code
     */
    protected void doExecute(HttpServletRequest req, HttpServletResponse res, Environment env) throws IOException, ServletException, InterruptedException {
        buf = new byte[65535];
        in = null;
        out = null;
        natIn = null;
        natOut = null;
        connection = null;
        try {
            block7: {
                connection = this.contextLoaderListener.getConnectionPool().openConnection();
                natIn = (FCGIInputStream)connection.getInputStream();
                natOut = (FCGIOutputStream)connection.getOutputStream();
                natOut.setId(connection.getId());
                in = req.getInputStream();
                out = ServletUtil.getServletOutputStream(res);
                natOut.writeBegin(connection.isLast());
                natOut.writeParams((Map)env.environment);
                natOut.write(4, FCGIUtil.FCGI_EMPTY_RECORD);
                if (!"chunked".equalsIgnoreCase(PhpJavaServlet.getHeader("Transfer-Encoding", req)) && !"upgrade".equalsIgnoreCase(PhpJavaServlet.getHeader("Connection", req))) ** GOTO lbl25
                inputStream = in;
                in = null;
                natOutputStream = natOut;
                natOut = null;
                new Thread((InputStream)inputStream, buf){
                    private final /* synthetic */ InputStream val$inputStream;
                    private final /* synthetic */ byte[] val$buf;
                    {
                        this.val$inputStream = inputStream;
                        this.val$buf = byArray;
                    }

                    @Override
                    public void run() {
                        block12: {
                            try {
                                try {
                                    int n;
                                    while ((n = this.val$inputStream.read(this.val$buf)) != -1) {
                                        natOutputStream.write(5, this.val$buf, n);
                                    }
                                    natOutputStream.write(5, FCGIUtil.FCGI_EMPTY_RECORD);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                    try {
                                        natOutputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                    break block12;
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    natOutputStream.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                natOutputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }.start();
                break block7;
lbl-1000:
                // 1 sources

                {
                    natOut.write(5, buf, n);
lbl25:
                    // 2 sources

                    ** while ((n = in.read((byte[])buf)) != -1)
                }
lbl26:
                // 1 sources

                natOut.write(5, FCGIUtil.FCGI_EMPTY_RECORD);
                natOut.close();
                natOut = null;
            }
            this.headerParser.setEnv(env);
            this.headerParser.setResponse(res);
            this.headerParser.parseBody(buf, (InputStream)natIn, out, this.err);
            natIn.close();
            natIn = null;
        }
        finally {
            if (natIn != null) {
                connection.setIsClosed();
            }
            if (connection != null) {
                this.contextLoaderListener.getConnectionPool().closeConnection(connection);
            }
        }
    }

    protected Environment getEnvironment() {
        return new Environment();
    }

    protected void execute(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException, InterruptedException {
        Environment env = this.getEnvironment();
        this.setupRequestVariables(req, env);
        this.setupCGIEnvironment(req, res, env);
        try {
            this.doExecute(req, res, env);
        }
        finally {
            if (env.ctx != null) {
                env.ctx.releaseManaged();
            }
            env.ctx = null;
        }
    }

    protected void handle(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.execute(req, res);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handle(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.handle(req, res);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handle(req, res);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (Logger.getLogLevel() > 4) {
            if (req.getAttribute("javax.servlet.include.request_uri") != null) {
                this.log("doGet (included):" + req.getAttribute("javax.servlet.include.request_uri"));
            }
            this.log("doGet:" + req.getRequestURI());
        }
        this.handle(req, res);
    }

    protected static class Environment {
        public IContextFactory ctx;
        public String contextPath;
        public String pathInfo;
        public String servletPath;
        public String queryString;
        public String requestUri;
        public HashMap environment;
        public boolean includedJava;
        public boolean includedDebugger;
        public ArrayList allHeaders;

        protected Environment() {
        }
    }

    private final class ErrorLogOutputStream
    extends OutputStream {
        private ErrorLogOutputStream() {
        }

        @Override
        public void write(byte[] buf, int s, int n) throws IOException {
            Logger.logError((String)new String(buf, s, n));
        }

        @Override
        public void write(int b) throws IOException {
            throw new NotImplementedException();
        }
    }
}

