/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import php.java.bridge.DefaultOptions;
import php.java.bridge.JavaBridge;
import php.java.bridge.Options;
import php.java.bridge.parser.IDocHandler;
import php.java.bridge.parser.ParserString;
import php.java.bridge.parser.ParserTag;
import php.java.bridge.util.Logger;

class Parser {
    static final int RECV_SIZE = 8192;
    static final int MAX_ARGS = 100;
    static final int SLEN = 256;
    static final short OK = 0;
    static final short PING = 1;
    static final short EOF = 2;
    static final short IO_ERROR = 3;
    IDocHandler handler;
    JavaBridge bridge;
    private boolean response = true;
    private ParserTag[] tag = null;
    private byte[] buf = new byte[8192];
    private int len = 256;
    private byte[] s = new byte[this.len];
    private byte ch;
    private static final short BEGIN = 0;
    private static final short KEY = 1;
    private static final short VAL = 2;
    private static final short ENTITY = 3;
    private static final short VOJD = 5;
    private static final short END = 6;
    short type = (short)5;
    private short level = 0;
    private short eof = 0;
    private short eor = 0;
    boolean in_dquote;
    boolean eot = false;
    private int clen = 0;
    private int c = 0;
    private int i = 0;
    private int i0 = 0;
    private int e;

    Parser(JavaBridge bridge, IDocHandler handler) {
        this.bridge = bridge;
        this.handler = handler;
        this.tag = new ParserTag[]{new ParserTag(1), new ParserTag(100), new ParserTag(100)};
    }

    void initOptions(byte ch) {
        this.bridge.setOptions(new Options());
        if ((ch & 0x40) != 0) {
            this.bridge.getOptions().updateOptions((byte)(ch & 3));
        }
        if ((ch & 0x80) != 0) {
            if (this.bridge.logLevel > 3 && this.bridge.logLevel != (ch >> 2 & 7)) {
                this.bridge.logDebug("Client changed its request log level to: " + (ch >> 2 & 7));
            }
            this.bridge.logLevel = ch >> 2 & 7;
        }
    }

    short initOptions(InputStream in, OutputStream out) throws IOException {
        this.clen = this.read(in);
        if (this.clen > 0) {
            this.ch = this.buf[this.c];
            switch (this.ch) {
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: 
                case 60: {
                    this.bridge.setOptions(new DefaultOptions());
                    break;
                }
                case 0: {
                    return 1;
                }
                default: {
                    if (this.ch == 127) {
                        if (++this.c == this.clen) {
                            this.clen = this.read(in);
                            if (this.clen <= 0) {
                                throw new IllegalArgumentException("Illegal header length");
                            }
                            this.c = 0;
                            this.ch = this.buf[0];
                        } else {
                            this.ch = this.buf[this.c];
                        }
                    } else {
                        throw new IllegalArgumentException("Illegal header.");
                    }
                    this.initOptions(this.ch);
                    ++this.c;
                    break;
                }
            }
        } else {
            return 2;
        }
        return 0;
    }

    private int read(InputStream in) throws IOException {
        try {
            return in.read(this.buf, 0, 8192);
        }
        catch (SocketException e) {
            if (Logger.getLogLevel() > 5) {
                Logger.printStackTrace(e);
            }
            return -1;
        }
        catch (InterruptedIOException e) {
            if (Logger.getLogLevel() > 5) {
                Logger.printStackTrace(e);
            }
            return -1;
        }
        catch (IOException e) {
            Logger.printStackTrace(e);
            throw e;
        }
    }

    void RESET() {
        this.type = (short)5;
        this.level = 0;
        this.eor = 0;
        this.in_dquote = false;
        this.i = 0;
        this.i0 = 0;
    }

    void APPEND(byte c) {
        if (this.i >= this.len - 1) {
            int newlen = this.len * 2;
            byte[] s1 = new byte[newlen];
            System.arraycopy(this.s, 0, s1, 0, this.len);
            this.len = newlen;
            this.s = s1;
        }
        this.s[this.i++] = c;
    }

    void CALL_BEGIN() {
        if (this.bridge.logLevel >= 4) {
            StringBuffer buf = new StringBuffer("--> <");
            buf.append(this.tag[0].strings[0].getUTF8StringValue());
            buf.append(" ");
            int i = 0;
            while (i < this.tag[1].n) {
                buf.append(this.tag[1].strings[i].getUTF8StringValue());
                buf.append("=\"");
                buf.append(this.tag[2].strings[i].getUTF8StringValue());
                buf.append("\" ");
                ++i;
            }
            buf.append(this.eot ? "/>" : ">");
            this.eot = false;
            this.bridge.logDebug(buf.toString());
        }
        this.response = this.handler.begin(this.tag);
    }

    void CALL_END() {
        if (this.bridge.logLevel >= 4) {
            StringBuffer buf = new StringBuffer("--> </");
            buf.append(this.tag[0].strings[0].getUTF8StringValue());
            buf.append(">");
            this.bridge.logDebug(buf.toString());
        }
        this.handler.end(this.tag[0].strings);
    }

    void PUSH(int t) {
        ParserString[] str = this.tag[t].strings;
        short n = this.tag[t].n;
        this.s[this.i] = 0;
        if (str[n] == null) {
            str[n] = this.createParserString();
        }
        str[n].string = this.s;
        str[n].off = this.i0;
        str[n].length = this.i - this.i0;
        this.tag[t].n = (short)(this.tag[t].n + 1);
        this.APPEND((byte)0);
        this.i0 = this.i;
    }

    /*
     * Unable to fully structure code
     */
    short parse(final InputStream in) throws IOException {
        if (this.eof == 0) ** GOTO lbl109
        return 2;
lbl-1000:
        // 1 sources

        {
            if (this.c == this.clen) {
                this.clen = this.read(in);
                if (this.clen <= 0) {
                    this.eof = 2;
                    return 2;
                }
                this.c = 0;
            }
            this.ch = this.buf[this.c];
            switch (this.ch) {
                case 60: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    this.level = (short)(this.level + 1);
                    this.type = 0;
                    break;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    if (this.type != 0) break;
                    this.PUSH(this.type);
                    this.type = 1;
                    break;
                }
                case 61: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    this.PUSH(this.type);
                    this.type = (short)2;
                    break;
                }
                case 47: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    if (this.type == 0) {
                        this.type = (short)6;
                        this.level = (short)(this.level - 1);
                    }
                    this.level = (short)(this.level - 1);
                    this.eot = true;
                    break;
                }
                case 62: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    if (this.type == 6) {
                        this.PUSH(0);
                        this.CALL_END();
                    } else {
                        if (this.type == 2) {
                            this.PUSH(this.type);
                        }
                        this.CALL_BEGIN();
                    }
                    this.tag[2].n = 0;
                    this.tag[1].n = 0;
                    this.tag[0].n = 0;
                    this.i = 0;
                    this.i0 = 0;
                    this.type = (short)5;
                    if (this.level != 0 || !this.response) break;
                    this.eor = 1;
                    break;
                }
                case 59: {
                    if (this.type == 3) {
                        switch (this.s[this.e + 1]) {
                            case 108: {
                                this.s[this.e] = 60;
                                this.i = this.e + 1;
                                break;
                            }
                            case 103: {
                                this.s[this.e] = 62;
                                this.i = this.e + 1;
                                break;
                            }
                            case 97: {
                                this.s[this.e] = (byte)(this.s[this.e + 2] == 109 ? 38 : 39);
                                this.i = this.e + 1;
                                break;
                            }
                            case 113: {
                                this.s[this.e] = 34;
                                this.i = this.e + 1;
                                break;
                            }
                            default: {
                                this.APPEND(this.ch);
                            }
                        }
                        this.type = (short)2;
                        break;
                    }
                    this.APPEND(this.ch);
                    break;
                }
                case 38: {
                    this.type = (short)3;
                    this.e = this.i;
                    this.APPEND(this.ch);
                    break;
                }
                case 34: {
                    v0 = this.in_dquote = this.in_dquote == false;
                    if (this.in_dquote || this.type != 2) break;
                    this.PUSH(this.type);
                    this.type = 1;
                    break;
                }
                case 127: {
                    if (this.in_dquote) {
                        this.APPEND(this.ch);
                        break;
                    }
                    this.handler.parseHeader(new InputStream(){

                        @Override
                        public int read() throws IOException {
                            if (Parser.this.c == Parser.this.clen) {
                                Parser.this.clen = Parser.this.read(in);
                                if (Parser.this.clen <= 0) {
                                    throw new IOException("parse header");
                                }
                                Parser.this.c = 0;
                            }
                            byte[] byArray = Parser.this.buf;
                            Parser parser = Parser.this;
                            int n = parser.c;
                            parser.c = n + 1;
                            return byArray[n];
                        }
                    });
                    --this.c;
                    break;
                }
                default: {
                    this.APPEND(this.ch);
                }
            }
            ++this.c;
lbl109:
            // 2 sources

            ** while (this.eor == 0)
        }
lbl110:
        // 1 sources

        this.RESET();
        return 0;
    }

    public void reset() {
        this.eof = 0;
        this.clen = 0;
        this.c = 0;
        this.len = 256;
        this.s = new byte[this.len];
    }

    public void setBridge(JavaBridge bridge) {
        this.bridge = bridge;
    }

    private ParserString createParserString() {
        return new ParserString(this.bridge);
    }
}

