/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import php.java.bridge.IJavaBridgeFactory;
import php.java.bridge.Options;
import php.java.bridge.Standalone;
import php.java.bridge.Util;
import php.java.bridge.classloader.SimpleJavaBridgeClassLoader;
import php.java.bridge.http.IContext;
import php.java.bridge.http.ISession;
import php.java.bridge.http.ISocketFactory;
import php.java.bridge.http.SessionFactory;
import php.java.bridge.parser.ConstructorCache;
import php.java.bridge.parser.GlobalRef;
import php.java.bridge.parser.MethodCache;
import php.java.bridge.parser.PhpArray;
import php.java.bridge.parser.PhpExactNumber;
import php.java.bridge.parser.PhpMap;
import php.java.bridge.parser.PhpProcedure;
import php.java.bridge.parser.PhpString;
import php.java.bridge.parser.Request;
import php.java.bridge.parser.Response;
import php.java.bridge.parser.StringCache;
import php.java.bridge.util.AppThreadPool;
import php.java.bridge.util.ILogger;
import php.java.bridge.util.JavaBridgeIllegalArgumentException;
import php.java.bridge.util.JavaBridgeSecurityManager;
import php.java.bridge.util.Logger;
import php.java.bridge.util.NoSuchConstantException;
import php.java.bridge.util.NoSuchProcedureException;
import php.java.bridge.util.Thread;

public class JavaBridge
implements Runnable {
    public Throwable lastException = null;
    private Throwable lastAsyncException;
    private GlobalRef globalRef = new GlobalRef();
    private static HashMap sessionHash = new HashMap();
    public InputStream in;
    public OutputStream out;
    public int logLevel = Logger.getLogLevel();
    public Request request;
    boolean canModifySecurityPermission = true;
    private MethodCache methodCache = new MethodCache();
    private ConstructorCache constructorCache = new ConstructorCache();
    private StringCache stringCache = new StringCache(this);
    private IJavaBridgeFactory sessionFactory;
    private Options options;
    private static final Iterator EMPTY_ITERATOR = new LinkedList().iterator();
    private Object[] o = new Object[1];
    private Class[] c = new Class[1];
    static final FindMatchingInterfaceVoid MATCH_VOID_ICASE = new FindMatchingInterfaceVoid(true);
    static final FindMatchingInterfaceVoid MATCH_VOID_CASE = new FindMatchingInterfaceVoid(false);
    private static final int DISPLAY_MAX_ELEMENTS = 10;
    private static final int DISPLAY_MAX_CHARS = 80;
    private IContext contextCache = null;
    private static final HashMap emptyMap = new HashMap();
    public static final String PHPSESSION = "PHPSESSION";
    protected static final String INTERNAL_PHPSESSION = "INTERNAL_PHPSESSION";
    private static int counter = 0;

    public int getLogLevel() {
        return this.logLevel;
    }

    public void handleRequests(InputStream in, OutputStream out, ILogger logger) throws IOException {
        this.handleRequests(in, out);
    }

    public void handleRequests(InputStream in, OutputStream out) throws IOException {
        this.request = new Request(this);
        this.in = in;
        this.out = out;
        if (this.request.init(this.in, this.out)) {
            this.request.handleRequests();
        } else {
            Logger.warn("handleHttpConnection init failed");
        }
    }

    public IJavaBridgeFactory getFactory() {
        if (this.sessionFactory == null) {
            throw new NullPointerException("session factory");
        }
        return this.sessionFactory;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    @Override
    public void run() {
        try {
            this.logDebug("START: JavaBridge.run()");
            this.request = new Request(this);
            try {
                if (!this.request.init(this.in, this.out)) {
                    return;
                }
            }
            catch (Throwable e) {
                this.printStackTrace(e);
                return;
            }
            try {
                this.request.handleRequests();
            }
            catch (Exception e) {
                this.printStackTrace(e);
            }
            this.setGlobalRef(null);
            this.logDebug("END: JavaBridge.run()");
        }
        catch (Exception t) {
            this.printStackTrace(t);
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e1) {
                    this.printStackTrace(e1);
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e2) {
                    this.printStackTrace(e2);
                }
            }
            this.sessionFactory.destroy();
        }
    }

    public static ISocketFactory bind(String sockname) throws IOException {
        return Standalone.bind(Logger.getLogLevel(), sockname);
    }

    public static void init(String[] s) {
        new Standalone().init(s);
    }

    public static void initLog(String socket, int logLevel, String[] s) {
        String logFile = null;
        String rawLogFile = null;
        if (logLevel == -1) {
            logLevel = Util.DEFAULT_LOG_LEVEL;
        }
        Logger.setLogLevel(logLevel);
        boolean logTostderr = s.length > 0 || System.err != null && System.getProperty("java.library.path", "").contains("eclipse");
        try {
            try {
                logFile = logTostderr ? "" : Util.DEFAULT_LOG_FILE;
                rawLogFile = logFile;
                if (s.length > 2) {
                    rawLogFile = logFile = s[2];
                    Logger.setLogger(logFile);
                    if (Logger.getLogLevel() > 3) {
                        System.err.println(Util.EXTENSION_NAME + " log: " + rawLogFile);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            Logger.redirectOutput(logFile);
            Logger.logMessage("VM                  : " + Util.VM_NAME);
            if (Util.VERSION != null) {
                Logger.logMessage(Util.EXTENSION_NAME + " version             : " + Util.VERSION);
            }
            Logger.logMessage("logFile             : " + rawLogFile);
            Logger.logMessage("default logLevel    : " + Logger.getLogLevel());
            Logger.logMessage("socket              : " + socket);
            Logger.logMessage("java.ext.dirs       : " + System.getProperty("java.ext.dirs"));
            Logger.logMessage("php.java.bridge.base: " + Util.JAVABRIDGE_BASE);
            Logger.logMessage("thread pool size    : " + Util.THREAD_POOL_MAX_SIZE);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void init(ISocketFactory socket, int logLevel, String[] s) {
        try {
            AppThreadPool pool = AppThreadPool.createThreadPool(Util.EXTENSION_NAME + "ThreadPool");
            try {
                String policy = System.getProperty("java.security.policy");
                String base = Util.JAVABRIDGE_BASE;
                if (policy != null && base != null) {
                    JavaBridgeSecurityManager manager = new JavaBridgeSecurityManager();
                    System.setSecurityManager(manager);
                    Logger.logMessage(Util.EXTENSION_NAME + " policy base     : " + base);
                    Logger.logMessage(Util.EXTENSION_NAME + " security policy : " + policy);
                }
            }
            catch (Exception e) {
                Logger.logMessage("Cannot install security manager: " + e);
            }
            Logger.logDebug("Starting to accept Socket connections");
            while (true) {
                Socket sock = socket.accept();
                Logger.logDebug("Socket connection accepted");
                JavaBridge bridge = new SessionFactory().getBridge();
                bridge.in = sock.getInputStream();
                bridge.out = sock.getOutputStream();
                if (pool != null) {
                    Logger.logDebug("Starting bridge thread from thread pool");
                    pool.start(bridge);
                    continue;
                }
                Logger.logDebug("Starting new bridge thread");
                Thread t = new Thread(bridge);
                t.start();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void main(String[] s) {
        Standalone.main(s);
    }

    public void printStackTrace(Throwable t) {
        if (this.logLevel > 0 && (t instanceof Error || this.logLevel > 1)) {
            Logger.getLogger().printStackTrace(t);
        }
    }

    private String getId() {
        return Integer.toHexString(System.identityHashCode(this)) + "@" + Integer.toHexString(System.identityHashCode(java.lang.Thread.currentThread()));
    }

    public void logDebug(String msg) {
        if (this.logLevel > 3) {
            Logger.println(4, this.getId() + " " + msg);
        }
    }

    public void logFatal(String msg) {
        if (this.logLevel > 0) {
            Logger.println(1, this.getId() + " " + msg);
        }
    }

    public void logError(String msg) {
        if (this.logLevel > 1) {
            Logger.println(2, this.getId() + " " + msg);
        }
    }

    public void logMessage(String msg) {
        if (this.logLevel > 2) {
            Logger.println(3, this.getId() + " " + msg);
        }
    }

    public void warn(String msg) {
        if (this.logLevel > 0) {
            Logger.warn(this.getId() + " " + msg);
        }
    }

    void setException(Response response, Throwable e, String method, Object obj, String name, Object[] args, Class[] params, boolean hasDeclaredExceptions) {
        if (e instanceof InvocationTargetException) {
            Throwable t = ((InvocationTargetException)e).getTargetException();
            if (t != null) {
                e = t;
            }
            if (this.logLevel > 3 || !this.options.preferValues() && !hasDeclaredExceptions) {
                this.printStackTrace(e);
            }
        } else {
            this.printStackTrace(e);
        }
        StringBuffer buf = new StringBuffer(method);
        buf.append(" failed: ");
        if (obj != null) {
            buf.append("[");
            Util.appendShortObject(obj, buf);
            buf.append("]->");
        } else {
            buf.append("new ");
        }
        buf.append(name);
        String arguments = Util.argsToString(args, params);
        if (arguments.length() > 0) {
            buf.append("(");
            Util.appendArgs(args, params, buf);
            buf.append(")");
        }
        buf.append(".");
        buf.append(" Cause: ");
        buf.append(String.valueOf(e));
        buf.append(" VM: ");
        buf.append(Util.VM_NAME);
        this.lastException = new Exception(buf.toString(), e);
        StackTraceElement[] trace = e.getStackTrace();
        if (trace != null) {
            this.lastException.setStackTrace(trace);
        }
        response.setResultException(this.lastException, hasDeclaredExceptions);
    }

    private Exception getUnresolvedExternalReferenceException(Throwable e, String what) {
        return new ClassNotFoundException("Unresolved external reference: " + e + ". -- Unable to " + what + ", see the README section \"Java platform issues\" for details and DO NOT REPORT THIS PROBLEM TO THE PHP/Java Bridge MAILING LIST!", e);
    }

    public void CreateObject(String name, boolean createInstance, Object[] args, Response response) {
        Class[] params = null;
        LinkedList candidates = new LinkedList();
        LinkedList matches = new LinkedList();
        boolean hasDeclaredExceptions = true;
        try {
            Constructor selected = null;
            ConstructorCache.Entry entry = null;
            Class clazz = Util.classForName(name);
            if (createInstance && (selected = this.constructorCache.get(entry = this.constructorCache.getEntry(name, args))) == null) {
                Constructor<?>[] cons = clazz.getConstructors();
                for (int i = 0; i < cons.length; ++i) {
                    candidates.add(cons[i]);
                    if (cons[i].getParameterTypes().length != args.length) continue;
                    matches.add(cons[i]);
                }
                selected = (Constructor)this.select(matches, args);
                if (selected != null) {
                    this.constructorCache.put(entry, selected);
                }
            }
            if (selected == null) {
                if (args.length > 0) {
                    throw createInstance ? new InstantiationException("No matching constructor found. Candidates: " + String.valueOf(candidates)) : new JavaBridgeIllegalArgumentException("ReferenceClass must be called w/o arguments; either write new JavaClass(\"" + name + "\") or new Java(\"" + name + "\", args...).");
                }
                if (createInstance && this.logLevel > 2) {
                    this.logMessage("No visible constructor found in: " + name + ", returning the class instead of an instance; this may not be what you want. Please correct this error or please use the function java(\"" + name + "\") instead.");
                }
                response.setResultClass(clazz);
                return;
            }
            params = entry.getParameterTypes(selected);
            Object[] coercedArgs = this.coerce(params, args, response);
            boolean bl = hasDeclaredExceptions = selected.getExceptionTypes().length != 0;
            if (this.logLevel > 4) {
                Object result = selected.newInstance(coercedArgs);
                JavaBridge.logInvoke(result, name, coercedArgs);
                response.setResult(result, clazz, hasDeclaredExceptions);
            } else {
                response.setResult(selected.newInstance(coercedArgs), clazz, hasDeclaredExceptions);
            }
        }
        catch (Throwable e2) {
            Exception e2;
            Throwable e1 = e2;
            if (e1 instanceof InvocationTargetException) {
                e1 = ((InvocationTargetException)e1).getTargetException();
            }
            if (e1 instanceof Request.AbortException) {
                throw (Request.AbortException)e1;
            }
            if (e1 instanceof OutOfMemoryError) {
                Logger.logFatal("OutOfMemoryError");
                throw (OutOfMemoryError)e1;
            }
            if (e1 instanceof NoClassDefFoundError) {
                this.getClassLoader().reset();
                e2 = this.getUnresolvedExternalReferenceException(e1, "call constructor");
            }
            this.setException(response, e2, createInstance ? "CreateInstance" : "ReferenceClass", null, name, args, params, hasDeclaredExceptions);
        }
    }

    private int weight(Class param, Class arg, Object phpArrayValue) {
        int w = 0;
        if (param.isAssignableFrom(arg)) {
            Class c = arg;
            while ((c = c.getSuperclass()) != null && param.isAssignableFrom(c)) {
                w += 16;
            }
        } else if (param == String.class) {
            if (!String.class.isAssignableFrom(arg) && !PhpString.class.isAssignableFrom(arg)) {
                w = byte[].class.isAssignableFrom(arg) ? (w += 32) : (w += 8000);
            }
        } else if (param.isArray()) {
            if (PhpString.class.isAssignableFrom(arg)) {
                Class<?> c = param.getComponentType();
                w = c == Byte.TYPE ? (w += 32) : (w += 9999);
            } else if (arg == PhpArray.class) {
                Iterator iterator;
                Iterator iterator2 = iterator = phpArrayValue == null ? EMPTY_ITERATOR : ((Map)phpArrayValue).values().iterator();
                if (iterator.hasNext()) {
                    Class<?> atype;
                    Object elem = iterator.next();
                    Class<?> ptype = param.getComponentType();
                    if (ptype != (atype = elem.getClass())) {
                        w += (ptype == Object.class ? 10 : 8200) + this.weight(ptype, atype, null);
                    }
                }
            } else if (arg.isArray()) {
                Class<?> atype;
                Class<?> ptype = param.getComponentType();
                if (ptype != (atype = arg.getComponentType())) {
                    w += (ptype == Object.class ? 10 : 8200) + this.weight(ptype, atype, null);
                }
            } else {
                w += 9999;
            }
        } else if (Collection.class.isAssignableFrom(param)) {
            if (Map.class.isAssignableFrom(arg)) {
                w += 8100;
            } else if (!PhpArray.class.isAssignableFrom(arg)) {
                w += 9999;
            }
        } else if (param.isPrimitive()) {
            Class c = param;
            if (Number.class.isAssignableFrom(arg)) {
                w = Double.class.isAssignableFrom(arg) ? (c == Float.TYPE ? ++w : (c == Double.TYPE ? (w += 0) : (w += 256))) : (c == Boolean.TYPE ? (w += 5) : (c == Character.TYPE ? (w += 4) : (c == Byte.TYPE ? (w += 3) : (c == Short.TYPE ? (w += 2) : (c == Integer.TYPE ? ++w : (c == Long.TYPE ? (w += 0) : (w += 256)))))));
            } else if (Boolean.class.isAssignableFrom(arg)) {
                if (c != Boolean.TYPE) {
                    w += 9999;
                }
            } else if (Character.class.isAssignableFrom(arg)) {
                if (c != Character.TYPE) {
                    w += 9999;
                }
            } else {
                w = String.class.isAssignableFrom(arg) || PhpString.class.isAssignableFrom(arg) ? (w += 64) : (w += 9999);
            }
        } else if (Number.class.isAssignableFrom(param)) {
            if (param == Float.class || param == Double.class) {
                if (!Double.class.isAssignableFrom(arg)) {
                    w += 9999;
                }
            } else if (!PhpExactNumber.class.isAssignableFrom(arg)) {
                w += 9999;
            }
        } else {
            w += 9999;
        }
        if (this.logLevel > 4) {
            this.logDebug("weight " + param + " " + arg + ": " + w);
        }
        return w;
    }

    private Object select(LinkedList methods, Object[] args) {
        if (methods.size() == 1) {
            return methods.getFirst();
        }
        Object similar = null;
        Object selected = null;
        int best = Integer.MAX_VALUE;
        for (Object element : methods) {
            int w = 0;
            Class<?>[] parms = element instanceof Method ? ((Method)element).getParameterTypes() : ((Constructor)element).getParameterTypes();
            for (int i = 0; i < parms.length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                w += this.weight(parms[i], arg.getClass(), arg);
            }
            if (w < best) {
                if (w == 0) {
                    if (this.logLevel > 4) {
                        this.logDebug("Selected: " + element + " " + w);
                    }
                    return element;
                }
                best = w;
                selected = element;
                if (this.logLevel <= 2) continue;
                similar = null;
                if (this.logLevel <= 4) continue;
                this.logDebug("best: " + selected + " " + w);
                continue;
            }
            if (this.logLevel <= 2) continue;
            if (w == best) {
                similar = element;
            }
            if (this.logLevel <= 4) continue;
            this.logDebug("skip: " + element + " " + w);
        }
        if (this.logLevel > 2 && similar != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < args.length; ++i) {
                Util.appendParam(args[i], buf);
            }
            this.logMessage("Portability warning: " + selected + " and " + similar + " both match " + buf.toString());
        }
        if (this.logLevel > 4) {
            this.logDebug("Selected: " + selected + " " + best);
        }
        return selected;
    }

    public Object coerce(Class param, Object arg, Response response) {
        this.o[0] = arg;
        this.c[0] = param;
        return this.coerce(this.c, this.o, response)[0];
    }

    Object[] coerce(Class[] parms, Object[] args, Response response) {
        Object[] result = args;
        int size = 0;
        for (int i = 0; i < args.length; ++i) {
            Class c;
            Object arg = args[i];
            if (arg == null) continue;
            if (parms[i] == String.class) {
                if (arg instanceof PhpString) {
                    result[i] = ((PhpString)arg).getString();
                    continue;
                }
                result[i] = arg.toString();
                continue;
            }
            if (arg instanceof PhpString || arg instanceof String) {
                if (!parms[i].isArray()) {
                    c = parms[i];
                    String s = arg instanceof String ? (String)arg : ((PhpString)arg).getString();
                    result[i] = s;
                    try {
                        if (c == Boolean.TYPE) {
                            result[i] = new Boolean(s);
                            continue;
                        }
                        if (c == Byte.TYPE) {
                            result[i] = new Byte(s);
                            continue;
                        }
                        if (c == Short.TYPE) {
                            result[i] = new Short(s);
                            continue;
                        }
                        if (c == Integer.TYPE) {
                            result[i] = new Integer(s);
                            continue;
                        }
                        if (c == Float.TYPE) {
                            result[i] = new Float(s);
                            continue;
                        }
                        if (c == Double.TYPE) {
                            result[i] = new Double(s);
                            continue;
                        }
                        if (c == Long.TYPE) {
                            result[i] = new Long(s);
                            continue;
                        }
                        if (c != Character.TYPE || s.length() <= 0) continue;
                        result[i] = new Character(s.charAt(0));
                    }
                    catch (NumberFormatException n) {
                        this.printStackTrace(n);
                    }
                    continue;
                }
                result[i] = ((PhpString)arg).getBytes();
                continue;
            }
            if (arg instanceof Number) {
                if (parms[i].isPrimitive()) {
                    c = parms[i];
                    Number n = (Number)arg;
                    if (c == Boolean.TYPE) {
                        result[i] = new Boolean(0.0 != (double)n.floatValue());
                        continue;
                    }
                    if (c == Byte.TYPE) {
                        result[i] = new Byte(n.byteValue());
                        continue;
                    }
                    if (c == Short.TYPE) {
                        result[i] = new Short(n.shortValue());
                        continue;
                    }
                    if (c == Integer.TYPE) {
                        result[i] = new Integer(n.intValue());
                        continue;
                    }
                    if (c == Float.TYPE) {
                        result[i] = new Float(n.floatValue());
                        continue;
                    }
                    if (c == Double.TYPE) {
                        result[i] = new Double(n.doubleValue());
                        continue;
                    }
                    if (c != Long.TYPE || n instanceof Long) continue;
                    result[i] = new Long(n.longValue());
                    continue;
                }
                if (arg.getClass() != PhpExactNumber.class) continue;
                c = parms[i];
                if (c.isAssignableFrom(Integer.class)) {
                    result[i] = new Integer(((Number)arg).intValue());
                    continue;
                }
                result[i] = new Long(((Number)arg).longValue());
                continue;
            }
            if (!(arg instanceof PhpArray)) continue;
            if (parms[i].isArray()) {
                Map.Entry e2 = null;
                Object tempArray = null;
                PhpArray ht = null;
                Class<?> targetType = parms[i].getComponentType();
                try {
                    ht = (PhpArray)arg;
                    size = ht.arraySize();
                    targetType = parms[i].getComponentType();
                    tempArray = Array.newInstance(targetType, size);
                }
                catch (Exception ex) {
                    throw new JavaBridgeIllegalArgumentException("Could not create array from Map: " + JavaBridge.firstChars(arg), ex);
                }
                try {
                    for (Map.Entry e2 : ht.entrySet()) {
                        Array.set(tempArray, ((Number)e2.getKey()).intValue(), this.coerce(targetType, e2.getValue(), response));
                    }
                    result[i] = tempArray;
                    continue;
                }
                catch (Exception ex) {
                    throw new JavaBridgeIllegalArgumentException("Could not create array of type: " + targetType + ", size: " + size + ",  failed entry at: " + e2, ex);
                }
            }
            if (Collection.class.isAssignableFrom(parms[i])) {
                try {
                    Map m = (Map)arg;
                    Collection c2 = m.values();
                    if (!parms[i].isInstance(c2)) {
                        try {
                            Collection collection = (Collection)parms[i].newInstance();
                            collection.addAll(c2);
                            c2 = collection;
                        }
                        catch (Exception e) {
                            try {
                                c2 = new ArrayList(c2);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    result[i] = c2;
                    continue;
                }
                catch (Exception ex) {
                    throw new JavaBridgeIllegalArgumentException("Could not create Collection from Map: " + JavaBridge.firstChars(arg), ex);
                }
            }
            if (Hashtable.class.isAssignableFrom(parms[i])) {
                try {
                    Map ht = (Map)arg;
                    Hashtable res = (Hashtable)parms[i].newInstance();
                    res.putAll(ht);
                    result[i] = res;
                    continue;
                }
                catch (Exception ex) {
                    this.logError("Could not create Hashtable from Map: " + JavaBridge.objectDebugDescription(arg) + ". Cause: " + ex);
                    throw new JavaBridgeIllegalArgumentException("Could not create Hashtable from Map: " + JavaBridge.firstChars(arg), ex);
                }
            }
            if (Map.class.isAssignableFrom(parms[i])) {
                result[i] = arg;
                continue;
            }
            if (!(arg instanceof PhpString)) continue;
            result[i] = ((PhpString)arg).getString();
        }
        return result;
    }

    private static ClassIterator getClassClassIterator(Class clazz) {
        if (clazz == Class.class) {
            return new MetaClassIterator();
        }
        return new ClassClassIterator();
    }

    private static void logInvoke(Object obj, String method, Object[] args) {
        String dmsg = "\nInvoking " + JavaBridge.objectDebugDescription(obj) + "." + method + "(";
        for (int t = 0; t < args.length; ++t) {
            if (t > 0) {
                dmsg = dmsg + ",";
            }
            dmsg = dmsg + JavaBridge.objectDebugDescription(args[t]);
        }
        dmsg = dmsg + ");\n";
        Logger.logDebug(dmsg);
    }

    private static void logResult(Object obj) {
        String dmsg = "\nResult " + JavaBridge.objectDebugDescription(obj) + "\n";
        Logger.logDebug(dmsg);
    }

    public void Invoke(Object object, String method, Object[] args, Response response) {
        Object[] coercedArgs = null;
        Class[] params = null;
        LinkedList<Method> candidates = new LinkedList<Method>();
        LinkedList<Method> matches = new LinkedList<Method>();
        Method selected = null;
        boolean hasDeclaredExceptions = true;
        try {
            boolean again;
            if (object == null) {
                object = Request.PHPNULL;
                throw new NullPointerException("cannot call \"" + method + "()\" on a Java null object. A previous Java call has returned a null value, use java_is_null($jvalue) to check.");
            }
            MethodCache.Entry entry = this.methodCache.getEntry(method, object, args);
            selected = this.methodCache.get(entry);
            do {
                again = false;
                if (selected == null) {
                    Class jclass;
                    ClassIterator iter = ClassIterator.getInstance(object, FindMatchingInterfaceForInvoke.getInstance(this, method, args, true, this.canModifySecurityPermission));
                    while ((jclass = iter.getNext()) != null) {
                        Method[] methods = jclass.getMethods();
                        for (int i = 0; i < methods.length; ++i) {
                            Method meth = methods[i];
                            if (!meth.getName().equalsIgnoreCase(method) || !iter.isVisible(meth.getModifiers())) continue;
                            candidates.add(meth);
                            if (meth.getParameterTypes().length != args.length) continue;
                            matches.add(meth);
                        }
                    }
                    selected = (Method)this.select(matches, args);
                    if (selected == null) {
                        this.checkM(object, String.valueOf(method) + "(" + Util.argsToString(args, params) + "). Candidates: " + String.valueOf(candidates));
                    }
                    this.methodCache.put(entry, selected);
                    if (!iter.checkAccessible(selected)) {
                        this.logDebug("Security restriction: Cannot use setAccessible(), reverting to interface searching.");
                        this.canModifySecurityPermission = false;
                        candidates.clear();
                        matches.clear();
                        again = true;
                    }
                }
                params = entry.getParameterTypes(selected);
                coercedArgs = this.coerce(params, args, response);
            } while (again);
            boolean bl = hasDeclaredExceptions = selected.getExceptionTypes().length != 0;
            if (this.logLevel > 4) {
                JavaBridge.logInvoke(object, method, coercedArgs);
                Object result = selected.invoke(object, coercedArgs);
                JavaBridge.logResult(result);
                response.setResult(result, selected.getReturnType(), hasDeclaredExceptions);
            } else {
                response.setResult(selected.invoke(object, coercedArgs), selected.getReturnType(), hasDeclaredExceptions);
            }
        }
        catch (Throwable e2) {
            Exception e2;
            Throwable e1 = e2;
            if (e1 instanceof InvocationTargetException) {
                e1 = ((InvocationTargetException)e1).getTargetException();
            }
            if (e1 instanceof Request.AbortException) {
                throw (Request.AbortException)e1;
            }
            if (e1 instanceof OutOfMemoryError) {
                Logger.logFatal("OutOfMemoryError");
                throw (OutOfMemoryError)e1;
            }
            if (e1 instanceof NoClassDefFoundError) {
                this.getClassLoader().reset();
                e2 = this.getUnresolvedExternalReferenceException(e1, "call the method");
            }
            if (selected != null && e1 instanceof IllegalArgumentException && this.logLevel > 3) {
                int k;
                String errMsg = "\nInvoked " + method + " on " + JavaBridge.objectDebugDescription(object) + "\n";
                errMsg = errMsg + " Expected Arguments for this Method:\n";
                Class<?>[] paramTypes = selected.getParameterTypes();
                for (k = 0; k < paramTypes.length; ++k) {
                    errMsg = errMsg + "   (" + k + ") " + JavaBridge.classDebugDescription(paramTypes[k]) + "\n";
                }
                errMsg = errMsg + " Plain Arguments for this Method:\n";
                for (k = 0; k < args.length; ++k) {
                    errMsg = errMsg + "   (" + k + ") " + JavaBridge.objectDebugDescription(args[k]) + "\n";
                }
                if (coercedArgs != null) {
                    errMsg = errMsg + " Coerced Arguments for this Method:\n";
                    for (k = 0; k < coercedArgs.length; ++k) {
                        errMsg = errMsg + "   (" + k + ") " + JavaBridge.objectDebugDescription(coercedArgs[k]) + "\n";
                    }
                }
                this.logDebug(errMsg);
            }
            this.setException(response, e2, "Invoke", object, method, args, params, hasDeclaredExceptions);
        }
    }

    private void checkM(Object object, String string) throws NoSuchMethodException {
        if (object instanceof Class) {
            throw new NoSuchProcedureException(string);
        }
        throw new NoSuchMethodException(string);
    }

    private static String firstChars(Object o) {
        String append = "";
        String s = o instanceof Proxy ? o.getClass().getName() : String.valueOf(o);
        int len = s.length();
        if (len > 80) {
            append = "...";
            len = 80;
        }
        s = s.substring(0, len) + append;
        return s;
    }

    public static String objectDebugDescription(Object ob) {
        return JavaBridge.objectDebugDescription(ob, 0);
    }

    private static String objectDebugDescription(Object ob, int level) {
        if (ob == null) {
            return "[Object null]";
        }
        Object[] obj = ob;
        if (obj instanceof Collection) {
            obj = ((Collection)obj).toArray();
        } else if (obj instanceof List) {
            obj = ((List)obj).toArray();
        } else if (obj instanceof Map) {
            obj = ((Map)obj).values().toArray();
        }
        if (level < 10 && obj.getClass().isArray()) {
            StringBuffer buf = new StringBuffer("[Object " + System.identityHashCode(ob) + " - Class: " + JavaBridge.classDebugDescription(ob.getClass()) + "]: ");
            buf.append("{\n");
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                buf.append(JavaBridge.objectDebugDescription(Array.get(obj, i), level + 1));
                if (i >= 10) {
                    buf.append("...\n");
                    break;
                }
                buf.append("\n");
            }
            buf.append("}");
            return buf.toString();
        }
        return "[Object " + System.identityHashCode(obj) + " - Class: " + JavaBridge.classDebugDescription(obj.getClass()) + "]";
    }

    public static String classDebugDescription(Class cls) {
        return cls.getName() + ":ID" + System.identityHashCode(cls) + ":LOADER-ID" + System.identityHashCode(cls.getClassLoader());
    }

    public void GetSetProp(Object object, String prop, Object[] args, Response response) throws NullPointerException {
        LinkedList<Object> matches = new LinkedList<Object>();
        boolean set = args != null && args.length > 0;
        Class[] params = null;
        boolean hasDeclaredExceptions = true;
        try {
            Object res;
            Field fld;
            Field[] jfields2;
            Class jclass;
            if (object == null) {
                object = Request.PHPNULL;
                throw new NullPointerException("cannot get property \"" + prop + "\" from a Java null object. A previous Java call has returned a null value, use java_is_null($jvalue) to check");
            }
            ClassIterator iter = ClassIterator.getInstance(object, FindMatchingInterfaceForGetSetProp.getInstance(this, prop, args, false, this.canModifySecurityPermission));
            block8: while ((jclass = iter.getNext()) != null) {
                try {
                    jfields2 = jclass.getFields();
                    for (int i = 0; i < jfields2.length; ++i) {
                        fld = jfields2[i];
                        if (!fld.getName().equals(prop) || !iter.isVisible(fld.getModifiers())) continue;
                        matches.add(fld.getName());
                        res = null;
                        if (!iter.checkAccessible(fld)) {
                            this.logDebug("Security restriction: Cannot use setAccessible(), reverting to interface searching.");
                            this.canModifySecurityPermission = false;
                            matches.clear();
                            break block8;
                        }
                        Class<?> ctype = fld.getType();
                        if (set) {
                            params = new Class[]{ctype};
                            args = this.coerce(params, args, response);
                            fld.set(object, args[0]);
                        } else {
                            res = fld.get(object);
                        }
                        response.setResult(res, ctype, false);
                        return;
                    }
                }
                catch (Exception jfields2) {
                }
            }
            matches.clear();
            iter = ClassIterator.getInstance(object, FindMatchingInterfaceForInvoke.getInstance(this, prop, args, true, this.canModifySecurityPermission));
            block10: while ((jclass = iter.getNext()) != null) {
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(jclass);
                    PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
                    for (int i = 0; i < props.length; ++i) {
                        Method method;
                        if (!props[i].getName().equalsIgnoreCase(prop)) continue;
                        if (set) {
                            method = props[i].getWriteMethod();
                            params = method.getParameterTypes();
                            args = this.coerce(params, args, response);
                        } else {
                            method = props[i].getReadMethod();
                        }
                        matches.add(method);
                        if (!iter.checkAccessible(method)) {
                            this.logDebug("Security restriction: Cannot use setAccessible(), reverting to interface searching.");
                            this.canModifySecurityPermission = false;
                            matches.clear();
                            break block10;
                        }
                        hasDeclaredExceptions = method.getExceptionTypes().length != 0;
                        response.setResult(method.invoke(object, args), method.getReturnType(), hasDeclaredExceptions);
                        return;
                    }
                }
                catch (Exception beanInfo) {
                }
            }
            matches.clear();
            iter = ClassIterator.getInstance(object, FindMatchingInterfaceForGetSetProp.getInstance(this, prop, args, true, this.canModifySecurityPermission));
            block12: while ((jclass = iter.getNext()) != null) {
                try {
                    jfields2 = jclass.getFields();
                    for (int i = 0; i < jfields2.length; ++i) {
                        fld = jfields2[i];
                        if (!fld.getName().equalsIgnoreCase(prop) || !iter.isVisible(fld.getModifiers())) continue;
                        matches.add(prop);
                        res = null;
                        if (!iter.checkAccessible(fld)) {
                            this.logDebug("Security restriction: Cannot use setAccessible(), reverting to interface searching.");
                            this.canModifySecurityPermission = false;
                            matches.clear();
                            break block12;
                        }
                        Class<?> ctype = fld.getType();
                        if (set) {
                            params = new Class[]{ctype};
                            args = this.coerce(params, args, response);
                            fld.set(object, args[0]);
                        } else {
                            res = fld.get(object);
                        }
                        response.setResult(res, ctype, false);
                        return;
                    }
                }
                catch (Exception exception) {
                }
            }
            this.checkF(object, String.valueOf(prop) + " (with args:" + Util.argsToString(args, params) + "). Candidates: " + String.valueOf(matches));
        }
        catch (Throwable e2) {
            Exception e2;
            Throwable e1 = e2;
            if (e1 instanceof InvocationTargetException) {
                e1 = ((InvocationTargetException)e1).getTargetException();
            }
            if (e1 instanceof Request.AbortException) {
                throw (Request.AbortException)e1;
            }
            if (e1 instanceof OutOfMemoryError) {
                Logger.logFatal("OutOfMemoryError");
                throw (OutOfMemoryError)e1;
            }
            if (e1 instanceof NoClassDefFoundError) {
                this.getClassLoader().reset();
                e2 = this.getUnresolvedExternalReferenceException(e1, "invoke a property");
            }
            this.setException(response, e2, set ? "SetProperty" : "GetProperty", object, prop, args, params, hasDeclaredExceptions);
        }
    }

    private void checkF(Object object, String string) throws NoSuchFieldException {
        if (object instanceof Class) {
            throw new NoSuchConstantException(string);
        }
        throw new NoSuchFieldException(string);
    }

    public Object getValues(Object ob) {
        Response res = this.request.response;
        res.setArrayValuesWriter();
        return ob;
    }

    public long unwrapClosure(Object closure) throws IllegalArgumentException {
        return PhpProcedure.unwrap(this.castToExact(closure));
    }

    public Object cast(Object ob, Class type) {
        Response res = this.request.response;
        res.setCoerceWriter().setType(type);
        return ob;
    }

    public Object castToString(Object ob) {
        return this.cast(ob, String.class);
    }

    public Object castToString(Exception throwable, String trace) {
        StringBuffer buf = new StringBuffer();
        Util.appendObject(throwable, buf);
        Util.appendTrace(throwable, trace, buf);
        return this.castToString(buf);
    }

    public Object castToExact(Object ob) {
        return this.cast(ob, Long.TYPE);
    }

    public Object castToBoolean(Object ob) {
        return this.cast(ob, Boolean.TYPE);
    }

    public Object castToInexact(Object ob) {
        return this.cast(ob, Double.TYPE);
    }

    public Object castToArray(Object ob) {
        Response res = this.request.response;
        res.setArrayValueWriter();
        return ob;
    }

    public JavaBridge(IJavaBridgeFactory factory) {
        this.setFactory(factory);
    }

    public PhpMap getPhpMap(Object value) {
        return PhpMap.getPhpMap(value, this);
    }

    public void updateJarLibraryPath(String path, String extensionDir) throws IOException {
        this.updateJarLibraryPath(path, extensionDir, null, null);
    }

    public void updateJarLibraryPath(String path, String extensionDir, String cwd, String searchpath) throws IOException {
        this.getClassLoader().updateJarLibraryPath(path, extensionDir.intern(), cwd, searchpath);
    }

    public String inspect(Object object) {
        int i;
        Class jclass;
        StringBuffer buf = new StringBuffer("[");
        buf.append(String.valueOf(Util.getClass(object)));
        buf.append(":\nConstructors:\n");
        ClassIterator iter = ClassIterator.getInstance(object, MATCH_VOID_CASE);
        while ((jclass = iter.getNext()) != null) {
            Constructor<?>[] constructors = jclass.getConstructors();
            for (i = 0; i < constructors.length; ++i) {
                buf.append(String.valueOf(constructors[i]));
                buf.append("\n");
            }
        }
        buf.append("\nFields:\n");
        iter = ClassIterator.getInstance(object, MATCH_VOID_CASE);
        while ((jclass = iter.getNext()) != null) {
            Field[] jfields = jclass.getFields();
            for (i = 0; i < jfields.length; ++i) {
                buf.append(String.valueOf(jfields[i]));
                buf.append("\n");
            }
        }
        buf.append("\nMethods:\n");
        iter = ClassIterator.getInstance(object, MATCH_VOID_CASE);
        while ((jclass = iter.getNext()) != null) {
            Method[] jmethods = jclass.getMethods();
            for (i = 0; i < jmethods.length; ++i) {
                buf.append(String.valueOf(jmethods[i]));
                buf.append("\n");
            }
        }
        buf.append("\nClasses:\n");
        iter = ClassIterator.getInstance(object, MATCH_VOID_CASE);
        while ((jclass = iter.getNext()) != null) {
            Class<?>[] jclasses = jclass.getClasses();
            for (i = 0; i < jclasses.length; ++i) {
                buf.append(String.valueOf(jclasses[i].getName()));
                buf.append("\n");
            }
        }
        buf.append("]");
        return (String)this.castToString(buf.toString());
    }

    public void setFileEncoding(String fileEncoding) {
        this.options.setEncoding(fileEncoding.intern());
    }

    public boolean InstanceOf(Object ob, Object claz) {
        Class clazz = Util.getClass(claz);
        return clazz.isInstance(this.castToBoolean(ob));
    }

    public Object ObjectToString(Object ob) {
        if (ob == null && !this.options.preferValues()) {
            ob = Request.PHPNULL;
        }
        return this.castToString(Util.stringValueOf(ob));
    }

    public Object ObjectToString(Boolean ob) {
        if (ob == null) {
            return this.ObjectToString((Object)null);
        }
        return this.castToString(ob != false ? "1" : "");
    }

    public Object ObjectToString(String ob) {
        if (ob == null) {
            return this.ObjectToString((Object)null);
        }
        return this.castToString(ob);
    }

    public Object ObjectToString(byte[] ob) {
        if (ob == null) {
            return this.ObjectToString((Object)null);
        }
        return this.castToString(ob);
    }

    public Object ObjectToString(Throwable ob, String trace) {
        StringBuffer buf = new StringBuffer("[");
        try {
            Util.appendObject(ob, buf);
            Util.appendTrace(ob, trace, buf);
        }
        catch (Request.AbortException sub) {
            throw sub;
        }
        catch (Exception t) {
            Logger.printStackTrace(t);
            buf.append("[Exception in toString(): ");
            buf.append(t);
            if (t.getCause() != null) {
                buf.append(", Cause: ");
                buf.append(t.getCause());
            }
            buf.append("]");
        }
        buf.append("]");
        return this.castToString(buf.toString());
    }

    public IContext getContext() {
        if (this.contextCache != null) {
            return this.contextCache;
        }
        this.contextCache = this.sessionFactory.getContext();
        return this.contextCache;
    }

    public ISession getSession(String name, short clientIsNew, int timeout) throws Exception {
        if (timeout == 0) {
            timeout = -1;
        }
        try {
            return this.sessionFactory.getSession(name, clientIsNew, timeout);
        }
        catch (Exception t) {
            this.printStackTrace(t);
            throw t;
        }
    }

    public Object makeClosure(long object, Map names) {
        if (names == null) {
            return this.makeClosure(object);
        }
        return PhpProcedure.createProxy(this.getFactory(), null, names, Util.ZERO_PARAM, object);
    }

    public Object makeClosure(long object, Map names, Class[] interfaces) {
        if (names == null) {
            names = emptyMap;
        }
        return PhpProcedure.createProxy(this.getFactory(), null, names, interfaces, object);
    }

    public Object makeClosure(long object, String name, Class iface) {
        Class[] classArray;
        if (iface == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = iface;
        }
        Class[] interfaces = classArray;
        return this.makeClosure(object, name, interfaces);
    }

    public Object makeClosure(long object, Map names, Class iface) {
        Class[] classArray;
        if (iface == null) {
            classArray = null;
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = iface;
        }
        Class[] interfaces = classArray;
        return this.makeClosure(object, names, interfaces);
    }

    public Object makeClosure(long object, String name) {
        if (name == null) {
            return this.makeClosure(object);
        }
        return PhpProcedure.createProxy(this.getFactory(), name, null, Util.ZERO_PARAM, object);
    }

    public Object makeClosure(long object, String name, Class[] interfaces) {
        if (name == null) {
            return this.makeClosure(object, (Map)emptyMap, interfaces);
        }
        return PhpProcedure.createProxy(this.getFactory(), name, null, interfaces, object);
    }

    public Object makeClosure(long object) {
        return PhpProcedure.createProxy(this.getFactory(), null, emptyMap, Util.ZERO_PARAM, object);
    }

    public void reset() {
        if (this.logLevel > 3) {
            this.warn("Your PHP script has called the privileged procedure \"reset()\", which resets the backend to its initial state. Therefore all session variables and all caches are now gone.");
        }
        this.getClassLoader().reset();
    }

    void setFactory(IJavaBridgeFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public int deserialize(String serialID, int timeout) throws IllegalArgumentException {
        ISession session = this.sessionFactory.getSession(INTERNAL_PHPSESSION, (short)0, timeout);
        Object obj = session.get(serialID);
        if (obj == null) {
            throw new IllegalArgumentException("Session serialID " + serialID + " expired.");
        }
        return this.getGlobalRef().append(this.castToExact(obj));
    }

    private static synchronized int getSerialID() {
        return counter++;
    }

    public String serialize(Object obj, int timeout) throws IllegalArgumentException {
        if (obj == null) {
            obj = Request.PHPNULL;
        }
        ISession session = this.sessionFactory.getSession(INTERNAL_PHPSESSION, (short)0, timeout);
        String id = Integer.toHexString(JavaBridge.getSerialID());
        session.put(id, obj);
        return (String)this.castToString(id);
    }

    public SimpleJavaBridgeClassLoader getClassLoader() {
        return this.getFactory().getJavaBridgeClassLoader();
    }

    private boolean offsetExists(Map value, Object pos) {
        this.castToBoolean(null);
        return value.containsKey(pos);
    }

    private Object offsetGet(Map value, Object pos) {
        return value.get(pos);
    }

    private void offsetSet(Map value, Object pos, Object val) {
        Class<?> type = value.getClass().getComponentType();
        if (type != null) {
            val = this.coerce(type, val, this.request.response);
        }
        if (pos == null) {
            pos = new Integer(value.size());
        }
        value.put(pos, val);
    }

    private void offsetUnset(Map value, Object pos) {
        value.remove(pos);
    }

    private boolean offsetExists(List value, int pos) {
        this.castToBoolean(null);
        try {
            this.offsetGet(value, pos);
            return true;
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    private Object offsetGet(List value, int pos) {
        return value.get(pos);
    }

    private void offsetSet(List value, Number off, Object val) {
        if (off == null) {
            value.add(val);
        } else {
            int pos = off.intValue();
            value.set(pos, val);
        }
    }

    private void offsetUnset(List value, int pos) {
        value.remove(pos);
    }

    boolean offsetExists(int length, int pos) {
        this.castToBoolean(null);
        int i = pos;
        return i > 0 && i < length;
    }

    private boolean offsetExists(Object value, int pos) {
        return this.offsetExists(Array.getLength(value), pos);
    }

    public boolean offsetExists(Object table, Object off) {
        if (table.getClass().isArray()) {
            return this.offsetExists(table, ((Number)off).intValue());
        }
        if (table instanceof List) {
            return this.offsetExists((List)table, ((Number)off).intValue());
        }
        return this.offsetExists((Map)table, off);
    }

    private Object offsetGet(Object value, int pos) {
        int i = pos;
        Object o = Array.get(value, i);
        return o == this ? null : o;
    }

    public Object offsetGet(Object table, Object off) {
        if (table.getClass().isArray()) {
            return this.offsetGet(table, ((Number)off).intValue());
        }
        if (table instanceof List) {
            return this.offsetGet((List)table, ((Number)off).intValue());
        }
        return this.offsetGet((Map)table, off);
    }

    public void beginDocument() {
        Response res = this.request.response;
        res.setObjectWriter();
        this.setLastAsyncException(null);
    }

    public void endDocument() throws Throwable {
        Response res = this.request.response;
        res.setDefaultWriter();
        if (this.getLastAsyncException() != null) {
            throw this.getLastAsyncException();
        }
    }

    private void offsetSet(Object value, int pos, Object val) {
        Array.set(value, pos, this.coerce(value.getClass().getComponentType(), val, this.request.response));
    }

    public void offsetSet(Object table, Object off, Object val) {
        if (table.getClass().isArray()) {
            this.offsetSet(table, ((Number)off).intValue(), val);
        } else if (table instanceof List) {
            this.offsetSet((List)table, (Number)off, val);
        } else {
            this.offsetSet((Map)table, off, val);
        }
    }

    private void offsetUnset(Object value, int pos) {
        int i = pos;
        Array.set(value, i, null);
    }

    public void offsetUnset(Object table, Object off) {
        if (table.getClass().isArray()) {
            this.offsetUnset(table, ((Number)off).intValue());
        } else if (table instanceof List) {
            this.offsetUnset((List)table, ((Number)off).intValue());
        } else {
            this.offsetUnset((Map)table, off);
        }
    }

    public void recycle() {
        this.contextCache = null;
        this.setGlobalRef(new GlobalRef());
        this.options.recycle();
        this.request.recycle();
        this.sessionFactory.recycle();
        this.methodCache.clear();
        this.constructorCache.clear();
        this.getStringCache().clear();
        this.lastException = this.setLastAsyncException(null);
    }

    public String getString(byte[] b, int start, int length) {
        try {
            return new String(b, start, length, this.options.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.printStackTrace(e);
            return new String(b, start, length);
        }
    }

    public String getCachedString(byte[] b, int start, int length) {
        return this.getStringCache().getString(b, start, length, this.options.getEncoding());
    }

    public Response createResponse() {
        return new Response(this);
    }

    public boolean typeExists(String name) {
        try {
            Util.classForName(name);
            this.castToBoolean(null);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.castToBoolean(null);
            return false;
        }
    }

    public Throwable getLastException() {
        this.request.response.setCoerceWriter().setType(Object.class);
        if (this.getLastAsyncException() != null) {
            return this.getLastAsyncException();
        }
        return this.lastException;
    }

    public Throwable setLastAsyncException(Throwable t) {
        if (this.lastAsyncException == null) {
            this.lastException = this.lastAsyncException = t;
        }
        return t;
    }

    public void clearLastException() {
        this.lastException = this.setLastAsyncException(null);
    }

    public GlobalRef getGlobalRef() {
        return this.globalRef;
    }

    public void setGlobalRef(GlobalRef globalRef) {
        this.globalRef = globalRef;
    }

    public Throwable getLastAsyncException() {
        return this.lastAsyncException;
    }

    public static HashMap getSessionHash() {
        return sessionHash;
    }

    public static void setSessionHash(HashMap sessionHash) {
        JavaBridge.sessionHash = sessionHash;
    }

    public StringCache getStringCache() {
        return this.stringCache;
    }

    public void setStringCache(StringCache stringCache) {
        this.stringCache = stringCache;
    }

    static class MetaClassIterator
    extends ClassIterator {
        MetaClassIterator() {
        }

        private Class next() {
            if (this.current == null) {
                this.current = (Class)this.object;
                return this.current;
            }
            return null;
        }

        @Override
        public Class getNext() {
            return this.next();
        }

        @Override
        public boolean checkAccessible(AccessibleObject o) {
            return true;
        }

        @Override
        public boolean isVisible(int modifier) {
            return true;
        }
    }

    static class ClassClassIterator
    extends ClassIterator {
        boolean hasNext = false;

        ClassClassIterator() {
        }

        private Class next() {
            if (this.current == null) {
                this.hasNext = true;
                this.current = (Class)this.object;
                return this.current;
            }
            if (this.hasNext) {
                this.hasNext = false;
                return this.object.getClass();
            }
            return null;
        }

        @Override
        public Class getNext() {
            return this.next();
        }

        @Override
        public boolean checkAccessible(AccessibleObject o) {
            return true;
        }

        @Override
        public boolean isVisible(int modifier) {
            return !this.hasNext || (modifier & 8) != 0;
        }
    }

    static class ObjectClassIterator
    extends ClassIterator {
        ObjectClassIterator() {
        }

        private Class next() {
            if (this.current == null) {
                this.current = this.object.getClass();
                return this.current;
            }
            return null;
        }

        @Override
        public Class getNext() {
            return this.match.findMatchingInterface(this.next());
        }

        @Override
        public boolean checkAccessible(AccessibleObject o) {
            return this.match.checkAccessible(o);
        }

        @Override
        public boolean isVisible(int modifier) {
            return true;
        }
    }

    private static abstract class ClassIterator {
        Object object;
        Class current;
        FindMatchingInterface match;

        private ClassIterator() {
        }

        public static ClassIterator getInstance(Object object, FindMatchingInterface match) {
            ClassIterator c = object instanceof Class ? JavaBridge.getClassClassIterator((Class)object) : new ObjectClassIterator();
            c.match = match;
            c.object = object;
            c.current = null;
            return c;
        }

        public abstract Class getNext();

        public abstract boolean checkAccessible(AccessibleObject var1);

        public abstract boolean isVisible(int var1);
    }

    static class FindMatchingInterfaceForGetSetProp
    extends FindMatchingInterface {
        protected FindMatchingInterfaceForGetSetProp(JavaBridge bridge, String name, Object[] args, boolean ignoreCase) {
            super(bridge, name, args, ignoreCase);
        }

        public static FindMatchingInterface getInstance(JavaBridge bridge, String name, Object[] args, boolean ignoreCase, boolean canModifySecurityPermission) {
            if (canModifySecurityPermission) {
                return ignoreCase ? MATCH_VOID_ICASE : MATCH_VOID_CASE;
            }
            return new FindMatchingInterfaceForGetSetProp(bridge, name, args, ignoreCase);
        }

        @Override
        Class findMatchingInterface(Class jclass) {
            if (jclass == null) {
                return jclass;
            }
            if (this.bridge.logLevel > 3 && this.bridge.logLevel > 3) {
                this.bridge.logDebug("searching for matching interface for GetSetProp for class " + jclass);
            }
            while (!Modifier.isPublic(jclass.getModifiers())) {
                Class<?>[] interfaces = jclass.getInterfaces();
                Class superclass = jclass.getSuperclass();
                int i = interfaces.length;
                while (i-- > 0) {
                    if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                    jclass = interfaces[i];
                    Field[] jfields = jclass.getFields();
                    for (int j = 0; j < jfields.length; ++j) {
                        boolean eq;
                        String nm = jfields[j].getName();
                        boolean bl = eq = this.ignoreCase ? nm.equalsIgnoreCase(this.name) : nm.equals(this.name);
                        if (!eq) continue;
                        if (this.bridge.logLevel > 3) {
                            this.bridge.logDebug("matching interface for GetSetProp: " + jclass);
                        }
                        return jclass;
                    }
                }
                jclass = superclass;
            }
            if (this.bridge.logLevel > 3) {
                this.bridge.logDebug("interface for GetSetProp: " + jclass);
            }
            return jclass;
        }
    }

    static class FindMatchingInterfaceForInvoke
    extends FindMatchingInterface {
        protected FindMatchingInterfaceForInvoke(JavaBridge bridge, String name, Object[] args, boolean ignoreCase) {
            super(bridge, name, args, ignoreCase);
        }

        public static FindMatchingInterface getInstance(JavaBridge bridge, String name, Object[] args, boolean ignoreCase, boolean canModifySecurityPermission) {
            if (canModifySecurityPermission) {
                return ignoreCase ? MATCH_VOID_ICASE : MATCH_VOID_CASE;
            }
            return new FindMatchingInterfaceForInvoke(bridge, name, args, ignoreCase);
        }

        @Override
        Class findMatchingInterface(Class jclass) {
            if (jclass == null) {
                return jclass;
            }
            if (this.bridge.logLevel > 3 && this.bridge.logLevel > 3) {
                this.bridge.logDebug("searching for matching interface for Invoke for class " + jclass);
            }
            while (!Modifier.isPublic(jclass.getModifiers())) {
                Class<?>[] interfaces = jclass.getInterfaces();
                Class superclass = jclass.getSuperclass();
                int i = interfaces.length;
                while (i-- > 0) {
                    if (!Modifier.isPublic(interfaces[i].getModifiers())) continue;
                    jclass = interfaces[i];
                    Method[] methods = jclass.getMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        boolean eq;
                        String nm = methods[j].getName();
                        boolean bl = eq = this.ignoreCase ? nm.equalsIgnoreCase(this.name) : nm.equals(this.name);
                        if (!eq || methods[j].getParameterTypes().length != this.args.length) continue;
                        if (this.bridge.logLevel > 3) {
                            this.bridge.logDebug("matching interface for Invoke: " + jclass);
                        }
                        return jclass;
                    }
                }
                jclass = superclass;
            }
            if (this.bridge.logLevel > 3) {
                this.bridge.logDebug("interface for Invoke: " + jclass);
            }
            return jclass;
        }
    }

    static class FindMatchingInterfaceVoid
    extends FindMatchingInterface {
        public FindMatchingInterfaceVoid(boolean b) {
            super(null, null, null, b);
        }

        @Override
        Class findMatchingInterface(Class jclass) {
            return jclass;
        }

        @Override
        public boolean checkAccessible(AccessibleObject o) {
            if (!o.isAccessible()) {
                try {
                    o.setAccessible(true);
                }
                catch (SecurityException ex) {
                    return false;
                }
            }
            return true;
        }
    }

    static abstract class FindMatchingInterface {
        JavaBridge bridge;
        String name;
        Object[] args;
        boolean ignoreCase;

        public FindMatchingInterface(JavaBridge bridge, String name, Object[] args, boolean ignoreCase) {
            this.bridge = bridge;
            this.name = name;
            this.args = args;
            this.ignoreCase = ignoreCase;
        }

        abstract Class findMatchingInterface(Class var1);

        public boolean checkAccessible(AccessibleObject o) {
            return true;
        }
    }
}

