/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import javax.swing.JOptionPane;
import php.java.bridge.JavaBridge;
import php.java.bridge.Util;
import php.java.bridge.http.ISocketFactory;
import php.java.bridge.http.JavaBridgeRunner;
import php.java.bridge.http.TCPServerSocket;
import php.java.bridge.util.Logger;
import php.java.bridge.util.Thread;

public class Standalone {
    public static final int HTTP_PORT_BASE = 8080;
    public static final int HTTPS_PORT_BASE = 8443;

    public static ISocketFactory bind(int logLevel, String sockname) throws IOException {
        ISocketFactory socket = null;
        socket = TCPServerSocket.create(sockname, 20);
        if (null == socket) {
            throw new IOException("Could not create socket: " + sockname);
        }
        return socket;
    }

    protected static void disclaimer() {
        System.err.println("Copyright (C) 2003, 2006 Jost Boekemeier and others.");
        System.err.println("This is free software; see the source for copying conditions.  There is NO");
        System.err.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
    }

    protected void javaUsage() {
        System.err.println("PHP/Java Bridge version " + Util.VERSION);
        Standalone.disclaimer();
        System.err.println("Usage: java -jar JavaBridge.jar [SOCKETNAME LOGLEVEL LOGFILE]");
        System.err.println("SOCKETNAME is one of INET_LOCAL, INET, HTTP_LOCAL, HTTP, HTTPS_LOCAL, HTTPS");
        System.err.println("");
        System.err.println("Example 1: java -jar JavaBridge.jar");
        System.err.println("Example 2: java -jar JavaBridge.jar HTTP_LOCAL:8080 3 JavaBridge.log");
        System.err.println("Example 3: java -Djavax.net.ssl.keyStore=mySrvKeystore -Djavax.net.ssl.keyStorePassword=YOURPASSWD -jar JavaBridge.jar HTTPS:8443 3 JavaBridge.log");
        System.err.println("The certificate for example 3 can be created with e.g.: jdk1.6.0/bin/keytool -keystore mySrvKeystore -genkey -keyalg RSA");
        System.err.println("");
        System.err.println("Influential system properties: threads, daemon, php_exec, default_log_file, default_log_level, base.");
        System.err.println("Example: java -Djava.awt.headless=\"true\" -Dphp.java.bridge.threads=50 -Dphp.java.bridge.base=/usr/lib/php/modules -Dphp.java.bridge.php_exec=/usr/local/bin/php-cgi -Dphp.java.bridge.default_log_file= -Dphp.java.bridge.default_log_level=5 -jar JavaBridge.jar");
        System.err.println("Example: java -Dphp.java.bridge.daemon=\"true\" -jar JavaBridge.jar");
    }

    protected void usage() {
        this.javaUsage();
        System.exit(1);
    }

    protected void checkOption(String[] s) {
        if ("--version".equals(s[0])) {
            System.out.println(Util.VERSION);
            System.exit(0);
        }
        this.usage();
    }

    private static boolean testPort(int port) {
        try {
            ServerSocket sock = new ServerSocket(port);
            sock.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static int findFreePort(int start) {
        for (int port = start; port < start + 100; ++port) {
            if (!Standalone.testPort(port)) continue;
            return port;
        }
        return start;
    }

    public void init(String[] s) {
        String sockname = null;
        int logLevel = -1;
        String tcpSocketName = "9267";
        if (s.length > 3) {
            this.checkOption(s);
        }
        try {
            if (s.length > 0 && (sockname = s[0]).startsWith("-")) {
                this.checkOption(s);
            }
            try {
                if (s.length > 1) {
                    logLevel = Integer.parseInt(s[1]);
                }
            }
            catch (NumberFormatException e) {
                this.usage();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (s.length == 0) {
                try {
                    int tcpSocket = Integer.parseInt(tcpSocketName);
                    int freeJavaPort = Standalone.findFreePort(tcpSocket);
                    int freeHttpPort = Standalone.findFreePort(8080);
                    int freeHttpsPort = Standalone.findFreePort(8443);
                    Object result = JOptionPane.showInputDialog(null, "Start a socket listener on port", "Starting the PHP/Java Bridge ...", 3, null, new String[]{"INET_LOCAL:" + freeJavaPort, "INET:" + freeJavaPort, "HTTP_LOCAL:" + freeHttpPort, "HTTP:" + freeHttpPort, "HTTPS_LOCAL:" + freeHttpsPort, "HTTPS:" + freeHttpsPort}, "HTTP_LOCAL:" + freeHttpPort);
                    if (result == null) {
                        System.exit(0);
                    }
                    sockname = result.toString();
                }
                catch (Throwable tcpSocket) {
                    // empty catch block
                }
            }
            if (s.length == 0) {
                TCPServerSocket.TCP_PORT_BASE = Integer.parseInt(tcpSocketName);
            }
            if (Standalone.checkServlet(logLevel, sockname, s)) {
                return;
            }
            ISocketFactory socket = Standalone.bind(logLevel, sockname);
            if ("true".equals(System.getProperty("php.java.bridge.test.startup"))) {
                System.exit(0);
            }
            JavaBridge.initLog(String.valueOf(socket), logLevel, s);
            JavaBridge.init(socket, logLevel, s);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File getCanonicalWindowsFile(String path) {
        try {
            return new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            return new File(path);
        }
    }

    private static boolean checkServlet(int logLevel, String sockname, String[] s) throws InterruptedException, IOException {
        JavaBridgeRunner r;
        if (sockname == null) {
            return false;
        }
        if (sockname.startsWith("SERVLET_LOCAL:") || sockname.startsWith("HTTP_LOCAL:") || sockname.startsWith("HTTPS_LOCAL:")) {
            Util.JAVABRIDGE_PROMISCUOUS = false;
            System.setProperty("php.java.bridge.promiscuous", "false");
        } else if (sockname.startsWith("SERVLET:") || sockname.startsWith("HTTP:") || sockname.startsWith("HTTPS:")) {
            Util.JAVABRIDGE_PROMISCUOUS = true;
            System.setProperty("php.java.bridge.promiscuous", "true");
        } else {
            return false;
        }
        boolean isSecure = sockname.startsWith("HTTPS");
        JavaBridge.initLog(sockname, logLevel, s);
        sockname = sockname.substring(sockname.indexOf(58) + 1);
        String serverPort = (Util.JAVABRIDGE_PROMISCUOUS ? "INET:" : "INET_LOCAL:") + sockname;
        Logger.logMessage("JavaBridgeRunner started on port " + serverPort);
        Class runner = JavaBridgeRunner.class;
        try {
            runner = Util.classForName("php.java.script.JavaBridgeScriptRunner");
            Method m = runner.getMethod("getRequiredInstance", String.class, Boolean.TYPE);
            r = (JavaBridgeRunner)m.invoke((Object)runner, serverPort, new Boolean(isSecure));
        }
        catch (Throwable e) {
            r = JavaBridgeRunner.getRequiredInstance(serverPort, isSecure);
        }
        r.waitFor();
        r.destroy();
        return true;
    }

    private static final boolean checkGNUVM() {
        try {
            return "libgcj".equals(System.getProperty("gnu.classpath.vm.shortname"));
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void main(String[] s) {
        if (!System.getProperty("php.java.bridge.daemon", "false").equals("false")) {
            final String[] args = new String[s.length + 8];
            args[0] = System.getProperty("php.java.bridge.daemon");
            if ("true".equals(args[0])) {
                args[0] = "java";
            }
            args[1] = "-Djava.library.path=" + System.getProperty("java.library.path", ".");
            args[2] = "-Djava.ext.dirs=" + System.getProperty("java.ext.dirs", ".");
            args[3] = "-Djava.awt.headless=" + System.getProperty("java.awt.headless", "true");
            args[4] = "-Dphp.java.bridge.asDaemon=true";
            args[5] = "-classpath";
            args[6] = System.getProperty("java.class.path", ".");
            args[7] = "php.java.bridge.Standalone";
            for (int j = 0; j < s.length; ++j) {
                args[j + 8] = s[j];
            }
            try {
                System.in.close();
                System.out.close();
                System.err.close();
            }
            catch (IOException e) {
                System.exit(12);
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(args);
                    }
                    catch (IOException e) {
                        System.exit(13);
                    }
                }
            }).start();
            try {
                java.lang.Thread.sleep(20000L);
            }
            catch (Throwable e) {
                // empty catch block
            }
            System.exit(0);
        }
        try {
            System.loadLibrary("natcJavaBridge");
        }
        catch (Throwable args) {
            // empty catch block
        }
        try {
            Process p;
            String javaExec;
            String cp = System.getProperty("java.class.path", ".");
            File jbFile = null;
            boolean isExecutableJavaBridgeJar = cp.indexOf(File.pathSeparatorChar) == -1 && cp.endsWith("JavaBridge.jar") && (jbFile = new File(cp)).isAbsolute();
            File wd = Standalone.getCanonicalWindowsFile(isExecutableJavaBridgeJar ? jbFile.getParent() : "");
            boolean sunJavaInstalled = new File("/usr/java/default/bin/java").exists();
            String string = javaExec = sunJavaInstalled ? "/usr/java/default/bin/java" : "java";
            if (s.length == 0 && System.getProperty("php.java.bridge.exec_sun_vm", "true").equals("true") && (sunJavaInstalled && Standalone.checkGNUVM() || isExecutableJavaBridgeJar) && (p = Runtime.getRuntime().exec(new String[]{javaExec, "-Dphp.java.bridge.exec_sun_vm=false", "-classpath", cp, "php.java.bridge.Standalone"}, null, wd)) != null) {
                System.exit(p.waitFor());
            }
        }
        catch (Throwable cp) {
            // empty catch block
        }
        try {
            new Standalone().init(s);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(9);
        }
    }
}

