/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.classloader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import php.java.bridge.classloader.DynamicHttpURLConnectionHandler;
import php.java.bridge.util.Logger;

class DynamicJarURLConnection
extends JarURLConnection {
    private DynamicHttpURLConnectionHandler handler;
    private Map headerFields;
    private JarFile jarFile;
    private JarEntry entry;

    protected DynamicJarURLConnection(URL u, DynamicHttpURLConnectionHandler handler) throws MalformedURLException {
        super(u);
        this.handler = handler;
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("tempfile create DynamicJarURLConnection for " + handler);
        }
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            if (Logger.getLogLevel() > 4) {
                Logger.logDebug("tempfile open connection for " + this.handler);
            }
            this.jarFileURLConnection = this.getJarFileURL().openConnection();
            this.jarFileURLConnection.connect();
            this.connected = true;
        }
    }

    public Map getHeaderFields() {
        if (this.headerFields != null) {
            return this.headerFields;
        }
        this.headerFields = this.handler.getHeaderFields();
        if (this.headerFields != null) {
            return this.headerFields;
        }
        try {
            if (!this.connected) {
                this.connect();
            }
            if (Logger.getLogLevel() > 4) {
                Logger.logDebug("tempfile getHeaderFields for " + this.handler);
            }
            this.headerFields = new HashMap();
            Map<String, List<String>> headerFields = this.jarFileURLConnection.getHeaderFields();
            StringBuffer b = new StringBuffer();
            for (Map.Entry<String, List<String>> e : headerFields.entrySet()) {
                List<String> value;
                String key = e.getKey();
                if (key == null || (value = e.getValue()) == null) continue;
                List<String> list = value;
                Iterator<String> ii1 = list.iterator();
                if (ii1.hasNext()) {
                    b.append((Object)ii1.next());
                }
                while (ii1.hasNext()) {
                    b.append(", ");
                    b.append((Object)ii1.next());
                }
                String k = key;
                k = k.toLowerCase();
                this.headerFields.put(k, b.toString());
                b.setLength(0);
            }
            this.handler.setHeaderFields(this.headerFields);
            return this.headerFields;
        }
        catch (IOException e) {
            Logger.printStackTrace(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getHeaderField(String key) {
        String val = (String)this.getHeaderFields().get(key);
        return val;
    }

    @Override
    public JarFile getJarFile() throws IOException {
        if (this.jarFile != null) {
            return this.jarFile;
        }
        this.jarFile = this.handler.getTempFile();
        if (this.jarFile != null) {
            return this.jarFile;
        }
        if (!this.connected) {
            this.connect();
        }
        if (Logger.getLogLevel() > 4) {
            Logger.logDebug("tempfile getJarFile for " + this.handler);
        }
        InputStream is = this.jarFileURLConnection.getInputStream();
        byte[] buf = new byte[8192];
        File f = File.createTempFile("pjbcache", "jar");
        f.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(f);
        int len = 0;
        while ((len = is.read(buf)) != -1) {
            fos.write(buf, 0, len);
        }
        fos.close();
        JarFile zipFile = new JarFile(f, true, 1);
        this.handler.setTempFile(zipFile, f);
        this.jarFile = zipFile;
        return this.jarFile;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.entry != null) {
            return this.getJarFile().getInputStream(this.entry);
        }
        if (!this.connected) {
            this.connect();
        }
        this.entry = this.getJarEntry();
        long size = this.entry.getSize();
        if (size > Integer.MAX_VALUE) {
            throw new IOException("zip file too large");
        }
        int len = (int)size;
        this.getHeaderFields().put("content-length", String.valueOf(len));
        return this.getJarFile().getInputStream(this.entry);
    }

    @Override
    public long getLastModified() {
        long lastModified = 0L;
        try {
            if (!this.connected) {
                this.connect();
            }
            if (Logger.getLogLevel() > 4) {
                Logger.logDebug("tempfile getLastModified for " + this.handler);
            }
            lastModified = this.jarFileURLConnection.getLastModified();
        }
        catch (IOException e) {
            Logger.printStackTrace(e);
        }
        return lastModified;
    }
}

