/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import php.java.bridge.http.Context;
import php.java.bridge.http.HttpRequest;
import php.java.bridge.http.HttpResponse;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.IContextFactoryVisitor;
import php.java.bridge.http.ISession;
import php.java.bridge.http.SessionFactory;
import php.java.bridge.parser.Request;

public class RemoteHttpContextFactory
extends SessionFactory
implements IContextFactory,
Serializable {
    private HttpResponse out;
    private static final long serialVersionUID = -7009009517347609467L;
    private IContext context;
    private IContextFactoryVisitor impl;
    private String id;

    public RemoteHttpContextFactory(HttpRequest req, HttpResponse res) {
        this.out = res;
        this.id = "";
    }

    protected void accept(IContextFactoryVisitor impl) {
        this.impl = impl;
        impl.visit(this);
    }

    public static IContextFactory addNew(HttpRequest req, HttpResponse res, IContextFactoryVisitor impl) {
        RemoteHttpContextFactory factory = new RemoteHttpContextFactory(req, res);
        factory.accept(impl);
        return factory;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void recycle(String id) {
    }

    @Override
    public void release() {
        if (this.impl != null) {
            this.impl.release();
        }
    }

    @Override
    public void releaseManaged() throws InterruptedException {
        if (this.impl != null) {
            this.impl.releaseManaged();
        }
    }

    @Override
    public void waitFor(long timeout) throws InterruptedException {
    }

    @Override
    public void parseHeader(Request req, InputStream in) throws IOException {
        throw new IllegalStateException("parseHeader");
    }

    @Override
    public void setContext(IContext context) {
        if (this.impl != null) {
            this.impl.setContext(context);
        }
        this.context = context;
    }

    @Override
    public IContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        if (this.impl != null) {
            this.context = this.impl.getContext();
        } else {
            this.setContext(this.createContext());
        }
        this.context.setAttribute("php.java.bridge.JavaBridge", this.getBridge(), 100);
        return this.context;
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    private IContext createContext() {
        return new Context();
    }

    @Override
    public void flushBuffer() throws IOException {
        this.out.flushBuffer();
    }

    public void setResponse(HttpResponse out) {
        this.out = out;
    }

    @Override
    public ISession getSimpleSession(String name, short clientIsNew, int timeout) {
        return super.getSession(name, clientIsNew, timeout);
    }
}

