/*
 * Decompiled with CFR 0.152.
 */
package php.java.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import php.java.bridge.JavaBridgeFactory;
import php.java.bridge.classloader.SimpleJavaBridgeClassLoader;
import php.java.bridge.http.IContext;
import php.java.bridge.http.IContextFactory;
import php.java.bridge.http.IContextFactoryVisitor;
import php.java.bridge.http.ISession;
import php.java.bridge.parser.Request;
import php.java.servlet.HttpContext;
import php.java.servlet.HttpSessionFacade;
import php.java.servlet.RemoteHttpServletResponse;
import php.java.servlet.SimpleServletContextFactory;

public class RemoteHttpServletContextFactory
extends JavaBridgeFactory
implements IContextFactory,
Serializable {
    public static final String CONTEXT_FACTORY_ATTRIBUTE = RemoteHttpServletContextFactory.class.getName() + ".ROOT";
    private static final long serialVersionUID = -7009009517347609467L;
    protected Servlet servlet;
    protected ServletContext kontext;
    protected HttpServletRequest proxy;
    protected HttpServletRequest req;
    protected HttpServletResponse res;
    protected HttpServletResponse out;
    private IContext context;
    private ISession session;
    private IContextFactoryVisitor impl;
    private String id;

    public RemoteHttpServletContextFactory(Servlet servlet, ServletContext ctx, HttpServletRequest proxy, HttpServletRequest req, HttpServletResponse res) {
        this.kontext = ctx;
        this.proxy = proxy;
        this.req = req;
        this.out = this.res = res;
        this.servlet = servlet;
        this.id = "";
    }

    protected void accept(IContextFactoryVisitor impl) {
        this.impl = impl;
        impl.visit((IContextFactory)this);
    }

    public static IContextFactory addNew(Servlet servlet, ServletContext kontext, HttpServletRequest proxy, HttpServletRequest req, HttpServletResponse res, IContextFactoryVisitor impl) {
        RemoteHttpServletContextFactory factory = new RemoteHttpServletContextFactory(servlet, kontext, proxy, req, res);
        factory.accept(impl);
        return factory;
    }

    public String getId() {
        return this.id;
    }

    public ISession getSimpleSession(String name, short clientIsNew, int timeout) {
        throw new IllegalStateException("Named sessions not supported by servlet.");
    }

    public ISession getSession(String name, short clientIsNew, int timeout) {
        if (name != null) {
            return this.getSimpleSession(name, clientIsNew, timeout);
        }
        if (this.session != null) {
            return this.session;
        }
        if (this.proxy == null) {
            throw new NullPointerException("This context " + this.getId() + " doesn't have a session proxy.");
        }
        this.session = HttpSessionFacade.getFacade(this, this.kontext, this.proxy, this.res, clientIsNew, timeout);
        return this.session;
    }

    HttpSession getCurrentSession() {
        if (this.session != null) {
            return ((HttpSessionFacade)this.session).getCachedSession();
        }
        SimpleServletContextFactory.throwJavaSessionException();
        return null;
    }

    public void initialize() {
    }

    public void invalidate() {
    }

    public void recycle(String id) {
    }

    public void release() {
        if (this.impl != null) {
            this.impl.release();
        }
    }

    public void releaseManaged() throws InterruptedException {
        if (this.impl != null) {
            this.impl.releaseManaged();
        }
    }

    public void waitFor(long timeout) throws InterruptedException {
    }

    public SimpleJavaBridgeClassLoader getJavaBridgeClassLoader() {
        return this.javaBridgeClassLoader;
    }

    public void parseHeader(Request req, InputStream in) throws IOException {
        throw new IllegalStateException("parseHeader");
    }

    public void setContext(IContext context) {
        if (this.impl != null) {
            this.impl.setContext(context);
        }
        this.context = context;
    }

    public IContext getContext() {
        if (this.context != null) {
            return this.context;
        }
        if (this.impl != null) {
            this.context = this.impl.getContext();
        } else {
            this.setContext(this.createContext());
        }
        this.context.setAttribute("php.java.bridge.JavaBridge", (Object)this.getBridge(), 100);
        return this.context;
    }

    public void destroy() {
        super.destroy();
    }

    private IContext createContext() {
        HttpContext ctx = new HttpContext(this.kontext, this.req, this.res);
        ctx.setAttribute("php.java.servlet.ServletContext", this.kontext, 100);
        ctx.setAttribute("php.java.servlet.ServletConfig", this.servlet.getServletConfig(), 100);
        ctx.setAttribute("php.java.servlet.Servlet", this.servlet, 100);
        ctx.setAttribute("php.java.servlet.HttpServletRequest", new HttpServletRequestWrapper(this.req){

            public HttpSession getSession() {
                return RemoteHttpServletContextFactory.this.getCurrentSession();
            }

            public HttpSession getSession(boolean clientIsNew) {
                HttpSession session = this.getSession();
                if (clientIsNew && !session.isNew()) {
                    throw new IllegalStateException("To obtain a new session call java_session() at the beginning of your PHP script.");
                }
                return session;
            }
        }, 100);
        ctx.setAttribute("php.java.servlet.HttpServletResponse", new RemoteHttpServletResponse(this.res), 100);
        return ctx;
    }

    public void flushBuffer() throws IOException {
        this.out.flushBuffer();
    }

    public void setResponse(HttpServletResponse out) {
        this.out = out;
    }

    public void handleRequests(InputStream in, OutputStream out) throws IOException {
        this.getBridge().handleRequests(in, out);
    }
}

