/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.classloader;

import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import php.java.bridge.classloader.DynamicHttpURLConnectionHandler;
import php.java.bridge.http.SessionFactory;
import php.java.bridge.util.Logger;

public class DynamicClassLoader
extends SecureClassLoader {
    protected static Map classLoaderCache = Collections.synchronizedMap(new HashMap());
    protected static Map parentCacheMap = new WeakHashMap();
    public static long defaultCacheTimeout = 2000L;
    public static boolean defaultLazy = true;
    protected static final String nf = "not found";
    private static int instanceCount = 0;
    private static long debugStart = System.currentTimeMillis();
    private static String ENTRY_SEPARATOR = ";";
    protected int instanceIndex;
    protected HashMap classLoaders;
    protected LinkedList classPaths;
    protected LinkedList urlsToAdd;
    protected long cacheTimeout;
    protected boolean lazy;
    protected HashMap parentCache;
    private URLClassLoaderFactory factory = new URLClassLoaderFactory();
    private static final ReferenceQueue TEMP_FILE_QUEUE = new ReferenceQueue();
    private static final Set DELETE_TEMP_FILE_ACTIONS = Collections.synchronizedSet(new HashSet());
    static final TempFileObserver THE_TEMP_FILE_OBSERVER = new TempFileObserver("JavaBridgeTempFileObserver");

    protected String arrayToString(URL[] array) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buf.append(String.valueOf(array[i]));
            if (i + 1 == array.length) continue;
            buf.append(ENTRY_SEPARATOR);
        }
        return buf.toString();
    }

    static void debugMsg(String str) {
        if (Logger.getLogLevel() > 5) {
            Logger.logDebug(System.currentTimeMillis() - debugStart + "::" + str);
        }
    }

    static void clearCache() {
        classLoaderCache.clear();
    }

    public static void invalidate(URL[] urls) {
        DynamicClassLoader.invalidate(DynamicClassLoader.getStringFromURLArray(urls));
    }

    public static void invalidate(String classpath) {
        if (Logger.getLogLevel() > 5) {
            Logger.logDebug("DynamicClassLoader.invalidate(" + classpath + ")\n");
        }
        classLoaderCache.remove(classpath);
    }

    static final String getStringFromURLArray(URL[] urls) {
        if (urls.length == 0) {
            return "";
        }
        StringBuffer cp = new StringBuffer(urls[0].toExternalForm());
        for (int i = 1; i < urls.length; ++i) {
            cp.append(';');
            cp.append(urls[i].toExternalForm());
        }
        return cp.toString();
    }

    static final URL[] getURLArrayFromString(String cp) throws MalformedURLException {
        StringTokenizer st = new StringTokenizer(cp, ";", false);
        ArrayList<URL> urls = new ArrayList<URL>();
        while (st.hasMoreTokens()) {
            String urlStr = st.nextToken();
            URL u = new URL(urlStr);
            urls.add(u);
        }
        URL[] u = new URL[urls.size()];
        urls.toArray(u);
        return u;
    }

    private void init() {
        this.classLoaders = new HashMap();
        this.classPaths = new LinkedList();
        this.urlsToAdd = new LinkedList();
    }

    protected void copyInto(DynamicClassLoader that) {
        that.instanceIndex = this.instanceIndex;
        that.classLoaders = this.classLoaders;
        that.classPaths = this.classPaths;
        that.urlsToAdd = this.urlsToAdd;
        that.cacheTimeout = this.cacheTimeout;
        that.lazy = this.lazy;
        that.parentCache = this.parentCache;
    }

    protected DynamicClassLoader(DynamicClassLoader other) {
        super(other.getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DynamicClassLoader(ClassLoader parent) {
        super(parent);
        this.init();
        this.cacheTimeout = defaultCacheTimeout;
        this.lazy = defaultLazy;
        this.instanceIndex = instanceCount++;
        Map map = parentCacheMap;
        synchronized (map) {
            this.parentCache = (HashMap)parentCacheMap.get(parent);
            if (this.parentCache == null) {
                this.parentCache = new HashMap();
                parentCacheMap.put(parent, this.parentCache);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DynamicClassLoader() {
        this.init();
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        this.cacheTimeout = defaultCacheTimeout;
        this.lazy = defaultLazy;
        Map map = parentCacheMap;
        synchronized (map) {
            this.parentCache = (HashMap)parentCacheMap.get(parent);
            if (this.parentCache == null) {
                this.parentCache = new HashMap();
                parentCacheMap.put(parent, this.parentCache);
            }
        }
    }

    protected void clearLoader() {
        if (Logger.getLogLevel() > 5) {
            Logger.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").clear()\n");
        }
        this.classLoaders.clear();
        this.classPaths.clear();
        this.urlsToAdd.clear();
    }

    protected void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    protected void setCacheTimeout(long cacheTimeoutMilliseconds) {
        this.cacheTimeout = cacheTimeoutMilliseconds;
    }

    protected void addURLs(URL[] urls) {
        this.addURLs(DynamicClassLoader.getStringFromURLArray(urls), urls, this.lazy);
    }

    protected void addURLs(URL[] urls, boolean lazy) {
        this.addURLs(DynamicClassLoader.getStringFromURLArray(urls), urls, lazy);
    }

    protected void addURLs(String urlClassPath) throws MalformedURLException {
        this.addURLs(urlClassPath, DynamicClassLoader.getURLArrayFromString(urlClassPath), this.lazy);
    }

    protected void addURLs(String urlClassPath, boolean lazy) throws MalformedURLException {
        this.addURLs(urlClassPath, DynamicClassLoader.getURLArrayFromString(urlClassPath), lazy);
    }

    protected void addURL(URL url, boolean lazy) {
        URL[] u = new URL[]{url};
        this.addURLs(u, lazy);
    }

    protected void addURL(URL url) {
        URL[] u = new URL[]{url};
        this.addURLs(u, this.lazy);
    }

    protected void addURLs(String classPath, URL[] urls, boolean lazy) {
        if (lazy) {
            this.lazyAddURLs(classPath, urls);
        } else {
            this.realAddURLs(classPath, urls);
        }
    }

    protected URLClassLoaderEntry realAddURLs(String classPath, URL[] urls) {
        URLClassLoaderEntry entry;
        if (Logger.getLogLevel() > 5) {
            Logger.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").realAddURLs(\"" + classPath + "\"," + DynamicClassLoader.getStringFromURLArray(urls) + ")\n");
        }
        if ((entry = this.getClassPathFromCache(classPath)) == null) {
            entry = this.createURLClassLoader(classPath, urls);
        } else {
            long urlsLastModified;
            long time = System.currentTimeMillis();
            if (entry.lastModified + this.cacheTimeout < time && (urlsLastModified = this.getLastModified(urls)) > entry.lastModified) {
                entry = this.createURLClassLoader(classPath, urls);
            }
        }
        if (entry != null) {
            if (!this.classLoaders.containsKey(classPath)) {
                this.classPaths.add(classPath);
            }
            this.classLoaders.put(classPath, entry);
        }
        return entry;
    }

    protected void lazyAddURLs(String classPath, URL[] urls) {
        if (Logger.getLogLevel() > 5) {
            Logger.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").lazyAddURLs(\"" + classPath + "\"," + DynamicClassLoader.getStringFromURLArray(urls) + ")\n");
        }
        Object[] params = new Object[]{classPath, urls};
        this.urlsToAdd.add(params);
    }

    protected URLClassLoaderEntry addDelayedURLs() {
        if (this.urlsToAdd.isEmpty()) {
            return null;
        }
        Object[] params = (Object[])this.urlsToAdd.getFirst();
        this.urlsToAdd.removeFirst();
        return this.realAddURLs((String)params[0], (URL[])params[1]);
    }

    protected long getLastModified(URL[] urls) {
        long lastModified = 0L;
        for (int i = 0; i < urls.length; ++i) {
            URL u = urls[i];
            long lm = 0L;
            try {
                if (u.getProtocol().equals("file")) {
                    File f = new File(u.getPath());
                    if (f.isFile()) {
                        lm = f.lastModified();
                    } else if (f.isDirectory()) {
                        return 0L;
                    }
                } else {
                    URLConnection conn = u.openConnection();
                    lm = conn.getLastModified();
                }
                if (lm <= lastModified) continue;
                lastModified = lm;
                continue;
            }
            catch (IOException e) {
                Logger.printStackTrace(e);
            }
        }
        return lastModified;
    }

    protected void setUrlClassLoaderFactory(URLClassLoaderFactory factory) {
        this.factory = factory;
    }

    public static final void destroyObserver() {
        THE_TEMP_FILE_OBSERVER.interrupt();
    }

    private static URL[] rewriteURLs(URL[] urls, List handlers) {
        URL[] newUrls = new URL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            String protocol = url.getProtocol();
            if (!"file".equals(protocol) && !"jar".equals(protocol)) {
                try {
                    DynamicHttpURLConnectionHandler handler = new DynamicHttpURLConnectionHandler();
                    url = new URL("jar", null, -1, url.toExternalForm() + "!/", handler);
                    handlers.add(handler);
                }
                catch (MalformedURLException e) {
                    Logger.printStackTrace(e);
                }
            }
            newUrls[i] = url;
        }
        return newUrls;
    }

    private SoftReference getReference(URLClassLoaderEntry entry, List handlers) {
        if (handlers.isEmpty()) {
            return new SoftReference<URLClassLoaderEntry>(entry);
        }
        return new DeleteTempFileAction(entry, TEMP_FILE_QUEUE, handlers);
    }

    protected URLClassLoaderEntry createURLClassLoader(String classPath, URL[] urls) {
        LinkedList handlers = new LinkedList();
        urls = DynamicClassLoader.rewriteURLs(urls, handlers);
        if (Logger.getLogLevel() > 5) {
            Logger.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").createURLClassLoader(\"" + classPath + "\"," + DynamicClassLoader.getStringFromURLArray(urls) + ")\n");
        }
        URLClassLoader cl = this.factory.createUrlClassLoader(classPath, urls, this.getParent());
        URLClassLoaderEntry entry = new URLClassLoaderEntry(cl, System.currentTimeMillis());
        SoftReference cacheEntry = this.getReference(entry, handlers);
        classLoaderCache.put(classPath, cacheEntry);
        return entry;
    }

    protected URLClassLoaderEntry getClassPathFromCache(String classPath) {
        Object o = this.classLoaders.get(classPath);
        if (o == null && (o = classLoaderCache.get(classPath)) != null) {
            o = ((SoftReference)o).get();
        }
        return (URLClassLoaderEntry)o;
    }

    protected void addURLClassLoader(String loaderClasspath, URLClassLoader cl, long lastModified) {
        URLClassLoaderEntry entry = (URLClassLoaderEntry)this.classLoaders.get(loaderClasspath);
        if (entry == null) {
            entry = new URLClassLoaderEntry(cl, lastModified);
            this.classLoaders.put(loaderClasspath, entry);
        } else if (entry.lastModified < lastModified) {
            entry.cl = cl;
            entry.lastModified = lastModified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name) throws ClassNotFoundException {
        HashMap hashMap;
        Class<?> result = null;
        if (Logger.getLogLevel() > 5) {
            Logger.logDebug("DynamicClassLoader(" + System.identityHashCode(this) + ").loadClass(" + name + ")\n");
        }
        if (Logger.getLogLevel() > 5) {
            Logger.logDebug("Trying parent\n");
        }
        Object c = null;
        HashMap hashMap2 = this.parentCache;
        synchronized (hashMap2) {
            c = this.parentCache.get(name);
            if (c != nf && c != null) {
                return c;
            }
        }
        Iterator iter = this.classPaths.iterator();
        URLClassLoaderEntry e = null;
        while (iter.hasNext()) {
            e = (URLClassLoaderEntry)this.classLoaders.get(iter.next());
            if (Logger.getLogLevel() > 5) {
                Logger.logDebug("Trying " + System.identityHashCode(e.cl) + "\n");
            }
            hashMap = e.cache;
            synchronized (hashMap) {
                c = e.cache.get(name);
                if (c != nf) {
                    if (c != null) {
                        return c;
                    }
                    try {
                        result = e.cl.loadClass(name);
                        e.cache.put(name, result);
                        return result;
                    }
                    catch (ClassNotFoundException cnfe) {
                        e.cache.put(name, nf);
                    }
                }
            }
        }
        e = this.addDelayedURLs();
        while (e != null) {
            if (Logger.getLogLevel() > 5) {
                Logger.logDebug("Trying " + System.identityHashCode(e.cl) + "\n");
            }
            hashMap = e.cache;
            synchronized (hashMap) {
                c = e.cache.get(name);
                if (c != nf) {
                    if (c != null) {
                        return c;
                    }
                    try {
                        result = e.cl.loadClass(name);
                        e.cache.put(name, result);
                        return result;
                    }
                    catch (ClassNotFoundException cnfe) {
                        e.cache.put(name, nf);
                    }
                }
            }
            e = this.addDelayedURLs();
        }
        try {
            result = super.loadClass(name);
            this.parentCache.put(name, result);
            return result;
        }
        catch (ClassNotFoundException cnfe) {
            this.parentCache.put(name, nf);
            if (result == null) {
                throw new ClassNotFoundException("Class " + name + " not found");
            }
            return result;
        }
    }

    protected Enumeration findResources(String name) throws IOException {
        Vector<URL> result = new Vector<URL>();
        Enumeration<URL> enumeration = super.findResources(name);
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        Iterator iter = this.classPaths.iterator();
        URLClassLoaderEntry e = null;
        while (iter.hasNext()) {
            e = (URLClassLoaderEntry)this.classLoaders.get(iter.next());
            enumeration = e.cl.findResources(name);
            while (enumeration.hasMoreElements()) {
                result.add(enumeration.nextElement());
            }
        }
        e = this.addDelayedURLs();
        while (e != null) {
            enumeration = e.cl.findResources(name);
            while (enumeration.hasMoreElements()) {
                result.add(enumeration.nextElement());
            }
            e = this.addDelayedURLs();
        }
        return result.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URL findResource(String name) {
        HashMap hashMap;
        String cacheName = "@" + name;
        URL c = null;
        HashMap hashMap2 = this.parentCache;
        synchronized (hashMap2) {
            c = (URL)this.parentCache.get(cacheName);
            if (c != nf && c != null) {
                return c;
            }
        }
        Iterator iter = this.classPaths.iterator();
        URLClassLoaderEntry e = null;
        while (iter.hasNext()) {
            e = (URLClassLoaderEntry)this.classLoaders.get(iter.next());
            hashMap = e.cache;
            synchronized (hashMap) {
                c = e.cache.get(cacheName);
                if (c != nf && c != null) {
                    return c;
                }
                c = e.cl.findResource(name);
                if (c != null) {
                    e.cache.put(cacheName, c);
                    return c;
                }
                e.cache.put(cacheName, nf);
            }
        }
        e = this.addDelayedURLs();
        while (e != null) {
            hashMap = e.cache;
            synchronized (hashMap) {
                c = e.cache.get(cacheName);
                if (c != nf && c != null) {
                    return c;
                }
                c = e.cl.findResource(name);
                if (c != null) {
                    e.cache.put(cacheName, c);
                    return c;
                }
                e.cache.put(cacheName, nf);
            }
            e = this.addDelayedURLs();
        }
        c = super.findResource(name);
        if (c != null) {
            this.parentCache.put(cacheName, c);
            return c;
        }
        this.parentCache.put(cacheName, nf);
        return null;
    }

    private static class DeleteTempFileAction
    extends SoftReference {
        List handlers;

        public DeleteTempFileAction(Object arg0, ReferenceQueue arg1, List handlers) {
            super(arg0, arg1);
            this.handlers = handlers;
            DELETE_TEMP_FILE_ACTIONS.add(this);
            if (Logger.getLogLevel() > 4) {
                int count = 0;
                int orphaned = 0;
                for (SoftReference val : DELETE_TEMP_FILE_ACTIONS) {
                    ++count;
                    if (val.get() != null) continue;
                    ++orphaned;
                }
                Logger.logDebug("classloader stats: entries: " + count + " orphaned: " + orphaned);
            }
        }

        public void command() {
            for (DynamicHttpURLConnectionHandler handler : this.handlers) {
                handler.deleteTempFile();
            }
        }
    }

    private static final class TempFileObserver
    extends Thread {
        public TempFileObserver(String name) {
            super(name);
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            block5: {
                if (Logger.getLogLevel() > 5) {
                    System.out.println("lifecycle: init observer " + System.identityHashCode(DynamicClassLoader.class));
                }
                try {
                    while (!TempFileObserver.interrupted()) {
                        DeleteTempFileAction action = (DeleteTempFileAction)TEMP_FILE_QUEUE.remove();
                        action.command();
                        DELETE_TEMP_FILE_ACTIONS.remove(action);
                    }
                }
                catch (InterruptedException e) {
                    if (Logger.getLogLevel() <= 5) break block5;
                    System.out.println("lifecycle: observer got interrupt" + System.identityHashCode(SessionFactory.class));
                }
            }
            if (Logger.getLogLevel() > 5) {
                System.out.println("lifecycle: observer terminating " + System.identityHashCode(DynamicClassLoader.class));
            }
        }
    }

    protected static class URLClassLoaderFactory {
        protected URLClassLoaderFactory() {
        }

        public URLClassLoader createUrlClassLoader(String classPath, URL[] urls, ClassLoader parent) {
            return new URLClassLoader(urls, parent);
        }
    }

    protected class URLClassLoaderEntry {
        URLClassLoader cl;
        long lastModified;
        HashMap cache = new HashMap();

        public String toString() {
            return String.valueOf(DynamicClassLoader.this.arrayToString(this.cl.getURLs()));
        }

        protected URLClassLoaderEntry(URLClassLoader cl, long lastModified) {
            this.cl = cl;
            this.lastModified = lastModified;
        }
    }
}

