/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.classloader;

import java.io.IOException;
import php.java.bridge.classloader.DynamicJavaBridgeClassLoader;
import php.java.bridge.classloader.JarLibraryPath;
import php.java.bridge.classloader.SimpleJavaBridgeClassLoader;
import php.java.bridge.util.Logger;

public class StandaloneJavaBridgeClassLoader
extends SimpleJavaBridgeClassLoader {
    protected DynamicJavaBridgeClassLoader cl = null;
    protected JarLibraryPath cachedPath;

    private StandaloneJavaBridgeClassLoader(DynamicJavaBridgeClassLoader loader, ClassLoader xloader) {
        super(xloader);
        this.cl = loader;
        if (this.checkCl()) {
            this.cl.clear();
        }
    }

    public StandaloneJavaBridgeClassLoader(ClassLoader xloader) {
        this(null, xloader);
    }

    @Override
    protected boolean checkCl() {
        return this.cl != null;
    }

    @Override
    protected void setClassLoader(DynamicJavaBridgeClassLoader loader) {
        if (loader == null) {
            this.cachedPath = null;
            this.cl = null;
            return;
        }
        if (this.cl != null) {
            throw new IllegalStateException("cl");
        }
        this.cl = loader;
        if (this.cachedPath != null) {
            this.cl.updateJarLibraryPath(this.cachedPath);
        }
    }

    @Override
    public void updateJarLibraryPath(String path, String extensionDir, String cwd, String searchpath) throws IOException {
        if (!this.checkCl()) {
            DynamicJavaBridgeClassLoader loader = DynamicJavaBridgeClassLoader.newInstance(this.scl);
            this.setClassLoader(loader);
            try {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
            }
            catch (SecurityException e) {
                Logger.printStackTrace(e);
            }
        }
        this.cl.updateJarLibraryPath(path, extensionDir, cwd, searchpath);
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.checkCl()) {
            return this.cl;
        }
        return this.scl;
    }

    @Override
    protected void doReset() {
        this.cl.reset();
        this.cl = this.cl.clearVMLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cl);
        }
        catch (SecurityException e) {
            Logger.printStackTrace(e);
        }
    }

    @Override
    public void reset() {
        if (this.checkCl()) {
            this.doReset();
        }
    }

    @Override
    public Class forName(String name) throws ClassNotFoundException {
        if (!this.checkCl()) {
            return super.forName(name);
        }
        return Class.forName(name, false, this.cl);
    }

    @Override
    protected void doClear() {
        this.cl.clear();
    }

    @Override
    public void clear() {
        if (this.checkCl()) {
            this.doClear();
        }
    }

    @Override
    protected void recycle() {
        block2: {
            this.cl = null;
            this.cachedPath = null;
            try {
                Thread.currentThread().setContextClassLoader(this.scl);
            }
            catch (SecurityException e) {
                if (Logger.getLogLevel() <= 4) break block2;
                Logger.printStackTrace(e);
            }
        }
    }

    @Override
    public void switcheThreadContextClassLoader() {
        throw new IllegalStateException("Use the JavaBridgeClassLoader instead");
    }
}

