/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import php.java.bridge.JavaBridge;
import php.java.bridge.http.ISession;
import php.java.bridge.util.Logger;

class Session
implements ISession {
    protected Map map;
    protected String name;
    private static int sessionCount = 0;
    boolean isNew = true;
    protected long creationTime;
    protected long lastAccessedTime;
    protected long timeout;

    @Override
    public Object get(Object ob) {
        this.lastAccessedTime = System.currentTimeMillis();
        return this.map.get(ob);
    }

    @Override
    public void put(Object ob1, Object ob2) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.map.put(ob1, ob2);
    }

    @Override
    public Object remove(Object ob) {
        this.lastAccessedTime = System.currentTimeMillis();
        return this.map.remove(ob);
    }

    Session(String name) {
        this.name = name;
        ++sessionCount;
        this.map = Collections.synchronizedMap(new HashMap());
        this.creationTime = this.lastAccessedTime = System.currentTimeMillis();
        this.timeout = 1440000L;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout * 1000;
        this.lastAccessedTime = System.currentTimeMillis();
    }

    @Override
    public int getTimeout() {
        return (int)(this.timeout / 1000L);
    }

    @Override
    public int getSessionCount() {
        return sessionCount;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        --sessionCount;
        HashMap hashMap = JavaBridge.getSessionHash();
        synchronized (hashMap) {
            if (JavaBridge.getSessionHash() != null) {
                JavaBridge.getSessionHash().remove(this.name);
            }
        }
    }

    public void invalidate() {
        this.destroy();
    }

    @Override
    public void putAll(Map vars) {
        this.lastAccessedTime = System.currentTimeMillis();
        this.map.putAll(vars);
    }

    @Override
    public Map getAll() {
        this.lastAccessedTime = System.currentTimeMillis();
        return new HashMap(this.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void expire() {
        if (JavaBridge.getSessionHash() == null) {
            return;
        }
        HashMap hashMap = JavaBridge.getSessionHash();
        synchronized (hashMap) {
            Iterator e = JavaBridge.getSessionHash().values().iterator();
            while (e.hasNext()) {
                Session ref = (Session)e.next();
                if (ref.timeout <= 0L || ref.lastAccessedTime + ref.timeout > System.currentTimeMillis()) continue;
                --sessionCount;
                e.remove();
                if (Logger.getLogLevel() <= 3) continue;
                Logger.logDebug("Session " + ref.name + " expired.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        if (JavaBridge.getSessionHash() == null) {
            return;
        }
        HashMap hashMap = JavaBridge.getSessionHash();
        synchronized (hashMap) {
            Iterator e = JavaBridge.getSessionHash().values().iterator();
            while (e.hasNext()) {
                Session ref = (Session)e.next();
                --sessionCount;
                e.remove();
                if (Logger.getLogLevel() <= 3) continue;
                Logger.logDebug("Session " + ref.name + " destroyed.");
            }
        }
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }
}

