/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge.parser;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import php.java.bridge.JavaBridge;
import php.java.bridge.util.Logger;

public final class StringCache {
    private Map map;
    private JavaBridge bridge;

    private void init() {
        this.map = new HashMap();
    }

    public StringCache(JavaBridge bridge) {
        this.bridge = bridge;
        this.init();
    }

    protected String get(Entry entry) {
        return (String)this.map.get(entry);
    }

    protected void put(Entry entry, String method) {
        byte[] b = new byte[entry.length];
        System.arraycopy(entry.name, entry.start, b, 0, entry.length);
        entry.start = 0;
        entry.name = b;
        this.map.put(entry, method);
    }

    protected Entry getEntry(byte[] name, int start, int length, String enc) {
        return new Entry(name, start, length, enc);
    }

    private String createString(byte[] name, int start, int length, String encoding) {
        try {
            return new String(name, start, length, encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.bridge.printStackTrace(e);
            return new String(name, start, length);
        }
    }

    public String getString(byte[] name, int start, int length, String encoding) {
        Entry e = this.getEntry(name, start, length, encoding);
        String s = this.get(e);
        if (s == null) {
            s = this.createString(name, start, length, encoding);
            this.put(e, s);
        }
        return s;
    }

    public void clear() {
        this.init();
    }

    protected static class Entry {
        byte[] name;
        String enc;
        int start;
        int length;
        private boolean hasResult = false;
        private int result = 1;

        protected Entry() {
        }

        protected Entry(byte[] name, int start, int length, String enc) {
            this.name = name;
            this.start = start;
            this.length = length;
            this.enc = enc;
        }

        public int hashCode() {
            if (this.hasResult) {
                return this.result;
            }
            int d = this.start + this.length;
            for (int i = this.start; i < d; ++i) {
                this.result = this.result * 7 + this.name[i];
            }
            this.result = this.result * 31 + this.length;
            this.result = this.result * 31 + this.enc.hashCode();
            this.hasResult = true;
            return this.result;
        }

        public boolean equals(Object o) {
            Entry that = (Entry)o;
            if (this.enc != that.enc) {
                return false;
            }
            if (this.length != that.length) {
                return false;
            }
            int i = this.length;
            while (i-- > 0) {
                if (this.name[i + this.start] == that.name[i]) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            try {
                return new String(this.name, this.start, this.length, this.enc);
            }
            catch (UnsupportedEncodingException e) {
                Logger.printStackTrace(e);
                return new String(this.name, this.start, this.length);
            }
        }
    }
}

