/*
 * Decompiled with CFR 0.152.
 */
package php.java.script;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import php.java.bridge.http.HttpRequest;
import php.java.bridge.http.HttpResponse;
import php.java.bridge.http.JavaBridgeRunner;
import php.java.bridge.util.Logger;
import php.java.script.PhpJavaBridgeRunnerScriptContext;
import php.java.script.PhpScriptLogWriter;
import php.java.script.PhpSecureScriptContext;

public class JavaBridgeScriptRunner
extends JavaBridgeRunner {
    private ScriptEngineManager m = new ScriptEngineManager();

    protected JavaBridgeScriptRunner() throws IOException {
    }

    public JavaBridgeScriptRunner(String serverPort, boolean isSecure) throws IOException {
        super(serverPort, isSecure);
    }

    public JavaBridgeScriptRunner(String serverPort) throws IOException {
        super(serverPort);
    }

    public static synchronized JavaBridgeRunner getRequiredInstance(String serverPort, boolean isSecure) throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeScriptRunner(serverPort, isSecure);
        return runner;
    }

    public static synchronized JavaBridgeRunner getInstance(String serverPort, boolean isSecure) {
        if (runner != null) {
            return runner;
        }
        try {
            runner = new JavaBridgeScriptRunner(serverPort, isSecure);
        }
        catch (IOException e) {
            Logger.printStackTrace(e);
        }
        return runner;
    }

    public static synchronized JavaBridgeRunner getRequiredInstance(String serverPort) throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeScriptRunner(serverPort);
        return runner;
    }

    public static synchronized JavaBridgeRunner getInstance(String serverPort) {
        if (runner != null) {
            return runner;
        }
        try {
            runner = new JavaBridgeScriptRunner(serverPort);
        }
        catch (IOException e) {
            Logger.printStackTrace(e);
        }
        return runner;
    }

    public static synchronized JavaBridgeRunner getRequiredInstance() throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeScriptRunner();
        return runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean handleScriptContent(String name, String params, File f, int length, HttpRequest req, HttpResponse res) throws IOException {
        if ("show".equals(params)) {
            return false;
        }
        int extIdx = name.lastIndexOf(46);
        if (extIdx == -1) {
            return false;
        }
        String ext = name.substring(extIdx + 1);
        try {
            ScriptEngine engine;
            if ("php".equals(ext)) {
                ext = "phtml";
            }
            if ((engine = this.m.getEngineByExtension(ext)) == null) {
                return false;
            }
            ByteArrayOutputStream xout = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)xout, "UTF-8"));
            ScriptContext ctx = engine.getContext();
            ctx = new PhpJavaBridgeRunnerScriptContext(ctx, this);
            ctx.setWriter(writer);
            ctx.setErrorWriter(PhpScriptLogWriter.getWriter(Logger.getLogger()));
            if (this.isSecure) {
                engine.setContext(new PhpSecureScriptContext(ctx));
            }
            StringBuffer buf = new StringBuffer("/");
            buf.append(name);
            if (params != null) {
                buf.append("?");
                buf.append(params);
            }
            FileReader r = null;
            try {
                r = new FileReader(f);
                engine.eval(r);
            }
            catch (Throwable e1) {
                e1.printStackTrace(writer);
                Logger.printStackTrace(e1);
            }
            finally {
                try {
                    engine.eval((Reader)null);
                }
                catch (Exception exception) {}
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (Exception exception) {}
                }
            }
            res.addHeader("Content-Type", "text/html; charset=UTF-8");
            res.setContentLength(xout.size());
            OutputStream out = res.getOutputStream();
            writer.close();
            xout.writeTo(out);
        }
        catch (Exception e) {
            Logger.printStackTrace(e);
            return false;
        }
        return true;
    }
}

