/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public final class FacesServlet
implements Servlet {
    public static final String CONFIG_FILES_ATTR = "javax.faces.CONFIG_FILES";
    public static final String LIFECYCLE_ID_ATTR = "javax.faces.LIFECYCLE_ID";
    private Application application = null;
    private FacesContextFactory facesContextFactory = null;
    private Lifecycle lifecycle = null;
    private ServletConfig servletConfig = null;

    public void destroy() {
        this.application = null;
        this.facesContextFactory = null;
        this.lifecycle = null;
        this.servletConfig = null;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return this.getClass().getName();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        try {
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory("javax.faces.context.FacesContextFactory");
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new ServletException(e.getMessage(), rootCause);
        }
        try {
            ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
            this.application = applicationFactory.getApplication();
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new ServletException(e.getMessage(), rootCause);
        }
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = servletConfig.getServletContext().getInitParameter(LIFECYCLE_ID_ATTR);
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            this.lifecycle = lifecycleFactory.getLifecycle(lifecycleId);
        }
        catch (FacesException e) {
            Throwable rootCause = e.getCause();
            if (rootCause == null) {
                throw e;
            }
            throw new ServletException(e.getMessage(), rootCause);
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        FacesContext context = this.facesContextFactory.getFacesContext(this.servletConfig.getServletContext(), request, response, this.lifecycle);
        try {
            try {
                this.lifecycle.execute(context);
                this.lifecycle.render(context);
            }
            catch (FacesException e) {
                Throwable t = e.getCause();
                if (t == null) {
                    throw new ServletException(e.getMessage(), (Throwable)e);
                }
                if (t instanceof ServletException) {
                    throw (ServletException)t;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new ServletException(t.getMessage(), t);
            }
            Object var7_4 = null;
            context.release();
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            context.release();
            throw throwable;
        }
    }
}

