/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.bc.asn1;

import com.lowagie.bc.asn1.ASN1OctetString;
import com.lowagie.bc.asn1.ASN1TaggedObject;
import com.lowagie.bc.asn1.DERObject;
import com.lowagie.bc.asn1.DEROutputStream;
import com.lowagie.bc.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERUTF8String
extends DERObject
implements DERString {
    String string;

    public static DERUTF8String getInstance(Object object) {
        if (object == null || object instanceof DERUTF8String) {
            return (DERUTF8String)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUTF8String(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERUTF8String.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUTF8String.getInstance(aSN1TaggedObject.getObject());
    }

    DERUTF8String(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            ++n2;
            if ((byArray[n] & 0xE0) == 224) {
                n += 3;
                continue;
            }
            if ((byArray[n] & 0xC0) == 192) {
                n += 2;
                continue;
            }
            ++n;
        }
        char[] cArray = new char[n2];
        n = 0;
        n2 = 0;
        while (n < byArray.length) {
            char c;
            if ((byArray[n] & 0xE0) == 224) {
                c = (char)((byArray[n] & 0x1F) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F);
                n += 3;
            } else if ((byArray[n] & 0xC0) == 192) {
                c = (char)((byArray[n] & 0x3F) << 6 | byArray[n + 1] & 0x3F);
                n += 2;
            } else {
                c = (char)(byArray[n] & 0xFF);
                ++n;
            }
            cArray[n2++] = c;
        }
        this.string = new String(cArray);
    }

    public DERUTF8String(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String dERUTF8String = (DERUTF8String)object;
        return this.getString().equals(dERUTF8String.getString());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.string.toCharArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n != cArray.length) {
            char c = cArray[n];
            if (c < '\u0080') {
                byteArrayOutputStream.write(c);
            } else if (c < '\u0800') {
                byteArrayOutputStream.write(0xC0 | c >> 6);
                byteArrayOutputStream.write(0x80 | c & 0x3F);
            } else {
                byteArrayOutputStream.write(0xE0 | c >> 12);
                byteArrayOutputStream.write(0x80 | c >> 6 & 0x3F);
                byteArrayOutputStream.write(0x80 | c & 0x3F);
            }
            ++n;
        }
        dEROutputStream.writeEncoded(12, byteArrayOutputStream.toByteArray());
    }
}

