/*
 * Decompiled with CFR 0.152.
 */
package gnu.ecmascript;

import gnu.ecmascript.Lexer;
import gnu.ecmascript.Prompter;
import gnu.ecmascript.Reserved;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SetExp;
import gnu.lists.Sequence;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.SFormat;
import gnu.mapping.TtyInPort;
import gnu.mapping.Values;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.Vector;
import kawa.standard.Scheme;

public class Parser {
    InPort port;
    Lexer lexer;
    Object previous_token;
    Object token;
    public static Expression eofExpr = new QuoteExp(Sequence.eofValue);
    public static final Expression[] emptyArgs = new Expression[0];
    public int errors;
    static Expression emptyStatement = new QuoteExp(Values.empty);

    public Parser(InPort inPort) {
        this.port = inPort;
        this.lexer = new Lexer(inPort);
    }

    public Expression parseConditionalExpression() throws IOException, SyntaxException {
        Expression expression = this.parseBinaryExpression(1);
        Object object2 = this.peekToken();
        if (object2 != Lexer.condToken) {
            return expression;
        }
        this.skipToken();
        Expression expression2 = this.parseAssignmentExpression();
        if (this.getToken() != Lexer.colonToken) {
            return this.syntaxError("expected ':' in conditional expression");
        }
        Expression expression3 = this.parseAssignmentExpression();
        return new IfExp(expression, expression2, expression3);
    }

    public Expression parseAssignmentExpression() throws IOException, SyntaxException {
        Expression expression = this.parseConditionalExpression();
        Object object2 = this.peekToken();
        if (object2 == Lexer.equalToken) {
            this.skipToken();
            Expression expression2 = this.parseAssignmentExpression();
            if (expression instanceof ReferenceExp) {
                SetExp setExp = new SetExp(((ReferenceExp)expression).getName(), expression2);
                setExp.setDefining(true);
                return setExp;
            }
            return this.syntaxError("unmplemented non-symbol ihs in assignment");
        }
        if (!(object2 instanceof Reserved)) {
            return expression;
        }
        Reserved reserved = (Reserved)object2;
        if (!reserved.isAssignmentOp()) {
            return expression;
        }
        this.skipToken();
        Expression expression3 = this.parseAssignmentExpression();
        Expression[] expressionArray = new Expression[]{expression, expression3};
        return new ApplyExp(new QuoteExp(reserved.proc), expressionArray);
    }

    public Expression parseExpression() throws IOException, SyntaxException {
        Expression[] expressionArray = null;
        int n = 0;
        while (true) {
            boolean bl;
            Expression expression = this.parseAssignmentExpression();
            boolean bl2 = bl = this.peekToken() != Lexer.commaToken;
            if (expressionArray == null) {
                if (bl) {
                    return expression;
                }
                expressionArray = new Expression[2];
            } else {
                boolean bl3 = bl ? expressionArray.length != n + 1 : expressionArray.length <= n;
                if (bl3) {
                    int n2 = bl ? n + 1 : 2 * expressionArray.length;
                    Expression[] expressionArray2 = new Expression[n2];
                    System.arraycopy(expressionArray, 0, expressionArray2, 0, n);
                    expressionArray = expressionArray2;
                }
            }
            expressionArray[n++] = expression;
            if (bl) {
                return new BeginExp(expressionArray);
            }
            this.skipToken();
        }
    }

    public Object peekTokenOrLine() throws IOException, SyntaxException {
        if (this.token == null) {
            this.token = this.lexer.getToken();
        }
        return this.token;
    }

    public Object peekToken() throws IOException, SyntaxException {
        if (this.token == null) {
            this.token = this.lexer.getToken();
        }
        while (this.token == Lexer.eolToken) {
            this.skipToken();
            this.token = this.lexer.getToken();
        }
        return this.token;
    }

    public Object getToken() throws IOException, SyntaxException {
        Object object2 = this.peekToken();
        this.skipToken();
        return object2;
    }

    public final void skipToken() {
        if (this.token != Lexer.eofToken) {
            this.previous_token = this.token;
            this.token = null;
        }
    }

    public void getSemicolon() throws IOException, SyntaxException {
        this.token = this.peekToken();
        if (this.token == Lexer.semicolonToken) {
            this.skipToken();
        } else if (this.token != Lexer.rbraceToken && this.token != Lexer.eofToken && this.previous_token != Lexer.eolToken) {
            this.syntaxError("missing ';' after expression");
        }
    }

    public Expression parsePrimaryExpression() throws IOException, SyntaxException {
        Object object2 = this.getToken();
        if (object2 instanceof QuoteExp) {
            return (QuoteExp)object2;
        }
        if (object2 instanceof String) {
            return new ReferenceExp((String)object2);
        }
        if (object2 == Lexer.lparenToken) {
            Expression expression = this.parseExpression();
            Object object3 = this.getToken();
            if (object3 != Lexer.rparenToken) {
                return this.syntaxError("expected ')' - got:" + object3);
            }
            return expression;
        }
        return this.syntaxError("unexpected token: " + object2);
    }

    public Expression makePropertyAccessor(Expression expression, Expression expression2) {
        return null;
    }

    public Expression[] parseArguments() throws IOException, SyntaxException {
        Object[] objectArray;
        this.skipToken();
        Object object2 = this.peekToken();
        if (object2 == Lexer.rparenToken) {
            this.skipToken();
            return emptyArgs;
        }
        Vector<Object[]> vector = new Vector<Object[]>(10);
        while (true) {
            objectArray = this.parseAssignmentExpression();
            vector.addElement(objectArray);
            object2 = this.getToken();
            if (object2 == Lexer.rparenToken) break;
            if (object2 == Lexer.commaToken) continue;
            this.syntaxError("invalid token '" + object2 + "' in argument list");
        }
        objectArray = new Expression[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Expression makeNewExpression(Expression expression, Expression[] expressionArray) {
        if (expressionArray == null) {
            expressionArray = emptyArgs;
        }
        expression = null;
        return new ApplyExp(expression, expressionArray);
    }

    public Expression makeCallExpression(Expression expression, Expression[] expressionArray) {
        return new ApplyExp(expression, expressionArray);
    }

    public String getIdentifier() throws IOException, SyntaxException {
        Object object2 = this.getToken();
        if (object2 instanceof String) {
            return (String)object2;
        }
        this.syntaxError("missing identifier");
        return "??";
    }

    /*
     * Unable to fully structure code
     */
    public Expression parseLeftHandSideExpression() throws IOException, SyntaxException {
        var1_1 = 0;
        while (this.peekToken() == Lexer.newToken) {
            ++var1_1;
            this.skipToken();
        }
        var2_2 = this.parsePrimaryExpression();
        while (true) {
            if ((var3_3 = this.peekToken()) == Lexer.dotToken) {
                this.skipToken();
                var4_4 = this.getIdentifier();
                var2_2 = this.makePropertyAccessor(var2_2, new QuoteExp(var4_4));
                continue;
            }
            if (var3_3 == Lexer.lbracketToken) {
                this.skipToken();
                var4_4 = this.parseExpression();
                var3_3 = this.getToken();
                if (var3_3 != Lexer.rbracketToken) {
                    return this.syntaxError("expected ']' - got:" + var3_3);
                }
                var2_2 = this.makePropertyAccessor(var2_2, (Expression)var4_4);
                continue;
            }
            if (var3_3 != Lexer.lparenToken) ** GOTO lbl32
            var4_4 = this.parseArguments();
            System.err.println("after parseArgs:" + this.peekToken());
            if (var1_1 > 0) {
                var2_2 = this.makeNewExpression(var2_2, var4_4);
                --var1_1;
                continue;
            }
            var2_2 = this.makeCallExpression(var2_2, var4_4);
        }
lbl-1000:
        // 1 sources

        {
            var2_2 = this.makeNewExpression(var2_2, null);
            --var1_1;
lbl32:
            // 2 sources

            ** while (var1_1 > 0)
        }
lbl33:
        // 1 sources

        return var2_2;
    }

    public Expression parsePostfixExpression() throws IOException, SyntaxException {
        Expression expression = this.parseLeftHandSideExpression();
        Object object2 = this.peekTokenOrLine();
        if (object2 != Reserved.opPlusPlus && object2 != Reserved.opMinusMinus) {
            return expression;
        }
        this.skipToken();
        Expression[] expressionArray = new Expression[]{expression};
        return new ApplyExp(new QuoteExp(((Reserved)object2).proc), expressionArray);
    }

    public Expression parseUnaryExpression() throws IOException, SyntaxException {
        return this.parsePostfixExpression();
    }

    public Expression syntaxError(String string) {
        ++this.errors;
        OutPort outPort = OutPort.errDefault();
        String string2 = this.port.getName();
        int n = this.port.getLineNumber() + 1;
        int n2 = this.port.getColumnNumber() + 1;
        if (n > 0) {
            if (string2 != null) {
                outPort.print(string2);
            }
            outPort.print(':');
            outPort.print(n);
            if (n2 > 1) {
                outPort.print(':');
                outPort.print(n2);
            }
            outPort.print(": ");
        }
        outPort.println(string);
        return new ErrorExp(string);
    }

    public Expression parseBinaryExpression(int n) throws IOException, SyntaxException {
        Expression expression = this.parseUnaryExpression();
        while (true) {
            this.token = this.peekToken();
            if (!(this.token instanceof Reserved)) {
                return expression;
            }
            Reserved reserved = (Reserved)this.token;
            if (reserved.prio < n) {
                return expression;
            }
            this.getToken();
            Expression expression2 = this.parseBinaryExpression(reserved.prio + 1);
            Expression[] expressionArray = new Expression[]{expression, expression2};
            expression = new ApplyExp(new QuoteExp(reserved.proc), expressionArray);
        }
    }

    public Expression parseIfStatement() throws IOException, SyntaxException {
        Expression expression;
        this.skipToken();
        Object object2 = this.getToken();
        if (object2 != Lexer.lparenToken) {
            return this.syntaxError("expected '(' - got:" + object2);
        }
        Expression expression2 = this.parseExpression();
        object2 = this.getToken();
        if (object2 != Lexer.rparenToken) {
            return this.syntaxError("expected ')' - got:" + object2);
        }
        Expression expression3 = this.parseStatement();
        object2 = this.peekToken();
        if (object2 == Lexer.elseToken) {
            this.skipToken();
            expression = this.parseStatement();
        } else {
            expression = null;
        }
        return new IfExp(expression2, expression3, expression);
    }

    public Expression buildLoop(Expression expression, Expression expression2, Expression expression3, Expression expression4) {
        if (expression != null) {
            Expression[] expressionArray = new Expression[]{expression, this.buildLoop(null, expression2, expression3, expression4)};
            return new BeginExp(expressionArray);
        }
        throw new Error("not implemented - buildLoop");
    }

    public Expression parseWhileStatement() throws IOException, SyntaxException {
        this.skipToken();
        Object object2 = this.getToken();
        if (object2 != Lexer.lparenToken) {
            return this.syntaxError("expected '(' - got:" + object2);
        }
        Expression expression = this.parseExpression();
        object2 = this.getToken();
        if (object2 != Lexer.rparenToken) {
            return this.syntaxError("expected ')' - got:" + object2);
        }
        Expression expression2 = this.parseStatement();
        return this.buildLoop(null, expression, null, expression2);
    }

    public Expression parseFunctionDefinition() throws IOException, SyntaxException {
        Object object2;
        this.skipToken();
        String string = this.getIdentifier();
        Object object3 = this.getToken();
        if (object3 != Lexer.lparenToken) {
            return this.syntaxError("expected '(' - got:" + object3);
        }
        Vector<String> vector = new Vector<String>(10);
        if (this.peekToken() == Lexer.rparenToken) {
            this.skipToken();
        } else {
            while (true) {
                object2 = this.getIdentifier();
                vector.addElement((String)object2);
                object3 = this.getToken();
                if (object3 == Lexer.rparenToken) break;
                if (object3 == Lexer.commaToken) continue;
                this.syntaxError("invalid token '" + object3 + "' in argument list");
            }
        }
        object2 = this.parseBlock();
        LambdaExp lambdaExp = new LambdaExp((Expression)object2);
        lambdaExp.name = string;
        SetExp setExp = new SetExp(string, (Expression)lambdaExp);
        setExp.setDefining(true);
        return setExp;
    }

    public Expression parseBlock() throws IOException, SyntaxException {
        Expression[] expressionArray = null;
        if (this.getToken() != Lexer.lbraceToken) {
            return this.syntaxError("extened '{'");
        }
        int n = 0;
        while (true) {
            boolean bl;
            this.token = this.peekToken();
            if (this.token == Lexer.rbraceToken) {
                this.skipToken();
                if (expressionArray == null) {
                    return emptyStatement;
                }
                bl = true;
            } else {
                bl = false;
            }
            if (expressionArray == null) {
                expressionArray = new Expression[2];
            } else {
                boolean bl2 = bl ? expressionArray.length != n : expressionArray.length <= n;
                if (bl2) {
                    int n2 = bl ? n : 2 * expressionArray.length;
                    Expression[] expressionArray2 = new Expression[n2];
                    System.arraycopy(expressionArray, 0, expressionArray2, 0, n);
                    expressionArray = expressionArray2;
                }
            }
            if (bl) {
                return new BeginExp(expressionArray);
            }
            expressionArray[n++] = this.parseStatement();
        }
    }

    public Expression parseStatement() throws IOException, SyntaxException {
        Object object2 = this.peekToken();
        if (object2 instanceof Reserved) {
            switch (((Reserved)object2).prio) {
                case 31: {
                    return this.parseIfStatement();
                }
                case 32: {
                    return this.parseWhileStatement();
                }
                case 41: {
                    return this.parseFunctionDefinition();
                }
            }
        }
        if (object2 == Lexer.eofToken) {
            return eofExpr;
        }
        if (object2 == Lexer.semicolonToken) {
            this.skipToken();
            return emptyStatement;
        }
        if (object2 == Lexer.lbraceToken) {
            return this.parseBlock();
        }
        Expression expression = this.parseExpression();
        this.getSemicolon();
        return expression;
    }

    public static void main(String[] stringArray) {
        Object object2;
        Scheme scheme = new Scheme();
        Environment.setCurrent(scheme.getEnvironment());
        InPort inPort = InPort.inDefault();
        if (inPort instanceof TtyInPort) {
            object2 = new Prompter();
            ((TtyInPort)inPort).setPrompter((Procedure)object2);
        }
        object2 = new Parser(inPort);
        OutPort outPort = OutPort.outDefault();
        try {
            Expression expression;
            while ((expression = ((Parser)object2).parseStatement()) != eofExpr) {
                outPort.print("[Expression: ");
                expression.print(outPort);
                outPort.println("]");
                Object object3 = expression.eval(Environment.user());
                outPort.print("result: ");
                SFormat.print(object3, outPort);
                outPort.println();
            }
        }
        catch (Exception exception) {
            System.err.println("caught exception:" + exception);
            exception.printStackTrace(System.err);
            return;
        }
    }
}

