/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.LitTable;

public class Literal {
    Literal next;
    public Field field;
    Object value;
    int index;
    public Type type;
    public int flags;
    static final int WRITING = 1;
    static final int WRITTEN = 2;
    static final int CYCLIC = 4;
    static final int EMITTED = 8;
    Object[] argValues;
    Type[] argTypes;
    public static final Literal nullLiteral = new Literal(null, Type.nullType);

    public final Object getValue() {
        return this.value;
    }

    void assign(Compilation compilation) {
        this.assign((String)null, compilation);
    }

    void assign(String string, Compilation compilation) {
        int n;
        int n2 = n = compilation.immediate ? 9 : 24;
        if (string == null) {
            this.index = compilation.literalsCount++;
            string = "Lit" + this.index;
        } else {
            n |= 1;
        }
        this.assign(compilation.mainClass.addField(string, this.type, n), compilation);
    }

    void assign(Field field, Compilation compilation) {
        this.next = compilation.literalsChain;
        compilation.literalsChain = this;
        this.field = field;
    }

    public Literal(Object object2, Compilation compilation) {
        this(object2, (String)null, compilation);
    }

    public Literal(Object object2, String string, Compilation compilation) {
        this.value = object2;
        compilation.literalTable.put(object2, this);
        this.type = Type.make(object2.getClass());
        this.assign(string, compilation);
    }

    public Literal(Object object2, Field field, Compilation compilation) {
        this.value = object2;
        compilation.literalTable.put(object2, this);
        this.field = field;
        this.type = field.getType();
        this.flags = 10;
    }

    public Literal(Object object2, Type type, Compilation compilation) {
        this.value = object2;
        compilation.literalTable.put(object2, this);
        this.type = type;
    }

    Literal(Object object2, Type type) {
        this.value = object2;
        this.type = type;
    }

    public static void emit(Compilation compilation) {
        if (!compilation.immediate && compilation.literalsChain != null && compilation.litTable == null) {
            compilation.litTable = new LitTable(compilation);
            try {
                compilation.litTable.emit();
            }
            catch (Throwable throwable) {
                compilation.error('e', "Literals: Internal error:" + throwable);
                throwable.printStackTrace(System.err);
            }
        }
    }
}

