/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.Parser;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.Binding;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Named;
import gnu.mapping.Procedure;
import gnu.mapping.WrongArguments;
import gnu.text.SourceMessages;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;
import kawa.lang.AutoloadProcedure;
import kawa.lang.Syntax;
import kawa.standard.StaticFieldConstraint;

public class Translator
extends Parser {
    public Environment environ;
    public boolean immediate;
    private static Expression errorExp = new ErrorExp("unknown syntax error");
    private Environment env;
    Syntax currentSyntax;
    ModuleExp module;
    Stack shadowStack = new Stack();

    public boolean isLexical(Declaration declaration) {
        if (declaration == null) {
            return false;
        }
        if (!declaration.isFluid()) {
            return true;
        }
        ScopeExp scopeExp = this.currentScope();
        ScopeExp scopeExp2 = declaration.getContext();
        while (scopeExp != null) {
            if (scopeExp == scopeExp2) {
                return true;
            }
            if (scopeExp instanceof LambdaExp && !((LambdaExp)scopeExp).getInlineOnly()) {
                return false;
            }
            scopeExp = scopeExp.outer;
        }
        return false;
    }

    public Translator(Environment environment, SourceMessages sourceMessages) {
        super(sourceMessages);
        this.env = environment;
        this.environ = new Environment();
    }

    public Translator(Environment environment) {
        super(new SourceMessages());
        this.env = environment;
        this.environ = new Environment();
    }

    public Translator() {
        this(Environment.user());
    }

    public final Environment getGlobalEnvironment() {
        return this.env;
    }

    public Expression parse(Object object2) {
        return this.rewrite(object2);
    }

    final Expression rewrite_car(Pair pair, boolean bl) {
        Object object2 = pair.car;
        if (pair instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, bl, (PairWithPosition)pair);
        }
        return this.rewrite(object2, bl);
    }

    public Syntax getCurrentSyntax() {
        return this.currentSyntax;
    }

    Expression apply_rewrite(Syntax syntax2, Pair pair) {
        Expression expression = errorExp;
        Syntax syntax3 = this.currentSyntax;
        this.currentSyntax = syntax2;
        try {
            expression = syntax2.rewriteForm(pair, this);
            Object var6_5 = null;
            this.currentSyntax = syntax3;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.currentSyntax = syntax3;
            throw throwable;
        }
        return expression;
    }

    public Expression syntaxError(String string) {
        this.error('e', string);
        return new ErrorExp(string);
    }

    Object getBinding(Object object2, boolean bl) {
        if (object2 instanceof String || object2 instanceof Binding) {
            Object object3;
            String string = object2.toString();
            Binding binding = this.environ.lookup(string);
            if (binding == null) {
                binding = object2 instanceof Binding ? (Binding)object2 : this.env.lookup(string);
            } else if (binding.isBound() && (object3 = binding.getValue()) instanceof String) {
                string = (String)object3;
                binding = this.env.lookup(string);
            }
            object2 = binding == null ? null : (bl && this.getInterpreter().hasSeparateFunctionNamespace() ? binding.getFunctionValue(null) : (binding.isBound() ? binding.getValue() : null));
            if (object2 instanceof Syntax) {
                return object2;
            }
            if (object2 instanceof Declaration && (object3 = ((Declaration)object2).getValue()) instanceof QuoteExp) {
                return ((QuoteExp)object3).getValue();
            }
            binding = null;
            if (object2 != null) {
                if (object2 instanceof Declaration && !this.isLexical((Declaration)object2)) {
                    object2 = null;
                }
            } else {
                binding = this.env.lookup(string);
            }
            if (binding != null && binding.isBound()) {
                return binding.get();
            }
            return null;
        }
        return object2;
    }

    public Syntax check_if_Syntax(Object object2) {
        if ((object2 = this.getBinding(object2, true)) instanceof Syntax) {
            return (Syntax)object2;
        }
        return null;
    }

    public Expression rewrite_pair(Pair pair) {
        Object object2;
        Object object3;
        if (pair.car instanceof Syntax) {
            return this.apply_rewrite((Syntax)pair.car, pair);
        }
        Object object4 = pair.cdr;
        Expression expression = this.rewrite_car(pair, true);
        Object object5 = null;
        ReferenceExp referenceExp = null;
        if (expression instanceof ReferenceExp) {
            Serializable serializable;
            referenceExp = (ReferenceExp)expression;
            Declaration declaration = referenceExp.getBinding();
            if (declaration == null) {
                object3 = referenceExp.getName();
                serializable = this.env.lookup((String)object3);
                if (serializable != null) {
                    object5 = this.getInterpreter().hasSeparateFunctionNamespace() ? serializable.getFunctionValue(null) : serializable.getValue();
                }
                if (object5 instanceof Syntax) {
                    return this.apply_rewrite((Syntax)object5, pair);
                }
                if (object5 instanceof AutoloadProcedure) {
                    try {
                        object5 = ((AutoloadProcedure)object5).getLoaded();
                    }
                    catch (RuntimeException runtimeException) {
                        object5 = null;
                    }
                }
            } else if (declaration.getFlag(32768)) {
                return this.apply_rewrite((Syntax)declaration.getConstantValue(), pair);
            }
            if (object5 != null && object5 instanceof Procedure && !this.immediate && referenceExp.getBinding() == null) {
                int n;
                Object object6;
                object3 = (Procedure)object5;
                serializable = PrimProcedure.getProcedureClass(object3);
                if (serializable != null) {
                    ClassType classType = (ClassType)Type.make((Class)serializable);
                    object6 = Compilation.mangleName(((Procedure)object3).getName());
                    object2 = classType.getDeclaredField((String)object6);
                } else {
                    object2 = null;
                }
                if (object2 != null && ((n = ((Field)object2).getModifiers()) & 8) != 0) {
                    object6 = new Declaration(((Procedure)object3).getName(), (Field)object2);
                    ((Declaration)object6).noteValue(new QuoteExp(object3));
                    referenceExp.setBinding((Declaration)object6);
                    if ((n & 0x10) != 0) {
                        ((Declaration)object6).setFlag(16384);
                    }
                }
            }
            referenceExp.setProcedureName(true);
            if (this.getInterpreter().hasSeparateFunctionNamespace()) {
                expression.setFlag(ReferenceExp.PREFER_BINDING2);
            }
        }
        int n = LList.listLength(object4, false);
        if (expression instanceof QuoteExp && (object5 = ((QuoteExp)expression).getValue()) instanceof Procedure && (object3 = WrongArguments.checkArgCount((Procedure)object5, n)) != null) {
            return this.syntaxError((String)object3);
        }
        object3 = new Expression[n];
        int n2 = 0;
        while (n2 < n) {
            object2 = (Pair)object4;
            object3[n2] = this.rewrite_car((Pair)object2, false);
            object4 = ((Pair)object2).cdr;
            ++n2;
        }
        return new ApplyExp(expression, (Expression[])object3);
    }

    public Expression rewrite(Object object2) {
        return this.rewrite(object2, false);
    }

    public Expression rewrite(Object object2, boolean bl) {
        if (object2 instanceof PairWithPosition) {
            return this.rewrite_with_position(object2, bl, (PairWithPosition)object2);
        }
        if (object2 instanceof Pair) {
            return this.rewrite_pair((Pair)object2);
        }
        if (object2 instanceof String || object2 instanceof Binding) {
            Object object3;
            Object object4;
            String string = object2.toString();
            Binding binding = this.environ.lookup(string);
            if (binding == null) {
                binding = object2 instanceof Binding ? (Binding)object2 : this.env.lookup(string);
            } else if (binding.isBound() && (object4 = binding.getValue()) instanceof String) {
                string = (String)object4;
                binding = this.env.lookup(string);
            }
            object4 = binding == null ? null : (bl && this.getInterpreter().hasSeparateFunctionNamespace() ? binding.getFunctionValue(null) : (binding.isBound() ? binding.getValue() : null));
            boolean bl2 = this.getInterpreter().hasSeparateFunctionNamespace();
            Declaration declaration = null;
            if (object4 instanceof Declaration) {
                declaration = (Declaration)object4;
                if (!this.isLexical(declaration) || bl2 && declaration.isProcedureDecl()) {
                    declaration = null;
                }
            } else if (!this.immediate && object4 instanceof Named) {
                if (object4 instanceof AutoloadProcedure) {
                    try {
                        object4 = ((AutoloadProcedure)object4).getLoaded();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                object3 = (Named)object4;
                Constraint constraint = binding.getConstraint();
                if (constraint instanceof StaticFieldConstraint) {
                    StaticFieldConstraint staticFieldConstraint = (StaticFieldConstraint)constraint;
                    String string2 = staticFieldConstraint.getName();
                    ClassType classType = staticFieldConstraint.getDeclaringClass();
                    Field field = classType.getDeclaredField(string2);
                    if (field != null && field.getStaticFlag()) {
                        int n = field.getModifiers();
                        declaration = new Declaration(object3.getName(), field);
                        declaration.noteValue(new QuoteExp(object3));
                        if ((n & 0x10) != 0) {
                            declaration.setFlag(16384);
                        }
                        if (object4 instanceof Syntax) {
                            declaration.setFlag(32768);
                        }
                    }
                } else {
                    declaration = Declaration.getDeclaration((Named)object3);
                }
            }
            object3 = new ReferenceExp(string, declaration);
            if (bl2) {
                ((Expression)object3).setFlag(ReferenceExp.PREFER_BINDING2);
            }
            return object3;
        }
        if (object2 instanceof Expression) {
            return (Expression)object2;
        }
        return new QuoteExp(object2);
    }

    public static void setLine(Declaration declaration, Object object2) {
        if (object2 instanceof PairWithPosition) {
            PairWithPosition pairWithPosition = (PairWithPosition)object2;
            declaration.setFile(pairWithPosition.getFile());
            declaration.setLine(pairWithPosition.getLine(), pairWithPosition.getColumn());
        }
    }

    public void setLine(Object object2) {
        if (object2 instanceof PairWithPosition) {
            PairWithPosition pairWithPosition = (PairWithPosition)object2;
            this.setLine(pairWithPosition.getFile(), pairWithPosition.getLine(), pairWithPosition.getColumn());
        }
    }

    public Expression rewrite_with_position(Object object2, boolean bl, PairWithPosition pairWithPosition) {
        Expression expression;
        String string = this.current_filename;
        int n = this.current_line;
        int n2 = this.current_column;
        try {
            String string2 = pairWithPosition.getFile();
            int n3 = pairWithPosition.getLine();
            int n4 = pairWithPosition.getColumn();
            this.current_filename = string2;
            this.current_line = n3;
            this.current_column = n4;
            expression = object2 == pairWithPosition ? this.rewrite_pair(pairWithPosition) : this.rewrite(object2, bl);
            if (expression.getFile() == null) {
                expression.setFile(string2);
            }
            if (expression.getLine() == 0) {
                expression.setLine(n3, n4);
            }
            Object var12_11 = null;
            this.current_filename = string;
            this.current_line = n;
            this.current_column = n2;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.current_filename = string;
            this.current_line = n;
            this.current_column = n2;
            throw throwable;
        }
        return expression;
    }

    boolean scan_form(Object object2, Vector vector, ScopeExp scopeExp) {
        if (!(object2 instanceof Pair)) {
            vector.addElement(object2);
        } else {
            Pair pair = (Pair)object2;
            Object object3 = pair.car;
            Syntax syntax2 = this.check_if_Syntax(object3);
            if (syntax2 == null) {
                vector.addElement(object2);
            } else {
                String string = this.current_filename;
                int n = this.current_line;
                int n2 = this.current_column;
                try {
                    this.setLine(pair);
                    if (!syntax2.scanForDefinitions(pair, vector, scopeExp, this)) {
                        boolean bl = false;
                        Object var12_11 = null;
                        this.current_filename = string;
                        this.current_line = n;
                        this.current_column = n2;
                        return bl;
                    }
                    Object var12_12 = null;
                    this.current_filename = string;
                    this.current_line = n;
                    this.current_column = n2;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    this.current_filename = string;
                    this.current_line = n;
                    this.current_column = n2;
                    throw throwable;
                }
            }
        }
        return true;
    }

    public boolean scan_body(Object object2, Vector vector, ScopeExp scopeExp) {
        boolean bl = true;
        while (object2 != LList.Empty) {
            if (!(object2 instanceof Pair)) {
                vector.addElement(this.syntaxError("body is not a proper list"));
                return false;
            }
            Pair pair = (Pair)object2;
            Object object3 = pair.car;
            if (!this.scan_form(object3, vector, scopeExp)) {
                bl = false;
            }
            object2 = pair.cdr;
        }
        return bl;
    }

    public static Pair makePair(Pair pair, Object object2, Object object3) {
        if (pair instanceof PairWithPosition) {
            return new PairWithPosition((PairWithPosition)pair, object2, object3);
        }
        return new Pair(object2, object3);
    }

    public Expression rewrite_body(Object object2) {
        Vector vector = new Vector(20);
        LetExp letExp = new LetExp(null);
        if (!this.scan_body(object2, vector, letExp)) {
            return new ErrorExp("error while scanning in body");
        }
        return this.rewrite_body(vector, letExp);
    }

    public Expression rewrite_body(Vector vector, LetExp letExp) {
        Object object2;
        int n = vector.size();
        if (n == 0) {
            return this.syntaxError("body with no expressions");
        }
        int n2 = letExp.countDecls();
        if (n2 != 0) {
            object2 = new Expression[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                object2[n3] = QuoteExp.nullExp;
            }
            letExp.inits = object2;
            this.push(letExp);
        }
        if (n == 1) {
            object2 = this.rewrite(vector.elementAt(0));
        } else {
            Expression[] expressionArray = new Expression[n];
            int n4 = 0;
            while (n4 < n) {
                expressionArray[n4] = this.rewrite(vector.elementAt(n4));
                ++n4;
            }
            object2 = new BeginExp(expressionArray);
        }
        if (n2 == 0) {
            return object2;
        }
        letExp.body = object2;
        this.pop(letExp);
        return letExp;
    }

    public final ModuleExp getModule() {
        return this.module;
    }

    public void finishModule(ModuleExp moduleExp, Vector vector) {
        Expression expression;
        boolean bl = moduleExp.isStatic();
        Declaration declaration = moduleExp.firstDecl();
        while (declaration != null) {
            if (declaration.getFlag(512)) {
                String string = "'";
                String string2 = declaration.getFlag(1024) ? "' exported but never defined" : (declaration.getFlag(2048) ? "' declared static but never defined" : "' declared but never defined");
                this.error('e', declaration, string, string2);
            }
            if (moduleExp.getFlag(2048)) {
                if (declaration.getFlag(1024)) {
                    if (declaration.isPrivate()) {
                        this.error('e', declaration, "'", "' is declared both private and exported");
                        declaration.setPrivate(false);
                    }
                } else {
                    declaration.setPrivate(true);
                }
            }
            if (bl) {
                declaration.setFlag(2048);
            } else if (moduleExp.getFlag(8192) && !declaration.getFlag(2048) || Compilation.moduleStatic < 0 || moduleExp.getFlag(16384)) {
                declaration.setFlag(4096);
            }
            declaration = declaration.nextDecl();
        }
        if (!bl) {
            moduleExp.declareThis(null);
        }
        this.module = moduleExp;
        int n = vector.size();
        int n2 = moduleExp.countDecls();
        this.pushDecls(moduleExp);
        if (n == 1) {
            expression = this.rewrite(vector.elementAt(0));
        } else if (n == 0) {
            expression = QuoteExp.voidExp;
        } else {
            Expression[] expressionArray = new Expression[n];
            int n3 = 0;
            while (n3 < n) {
                expressionArray[n3] = this.rewrite(vector.elementAt(n3));
                ++n3;
            }
            expression = new BeginExp(expressionArray);
        }
        moduleExp.body = expression;
        this.pop(moduleExp);
    }

    public void pushBinding(String string, Object object2) {
        Object object3 = this.environ.put(string, object2);
        if (object2 == object3) {
            return;
        }
        this.shadowStack.push(object3);
        this.shadowStack.push(string);
    }

    public boolean popBinding() {
        Object e = this.shadowStack.pop();
        if (e == null) {
            return false;
        }
        Object e2 = this.shadowStack.pop();
        if (e2 == null) {
            this.environ.remove(e);
        } else {
            this.environ.put(e, e2);
        }
        return true;
    }
}

