/*-*- mode: Java; tab-width:8 -*-*/

package php.java.bridge;

/*
 * Copyright (C) 2006 Jost Boekemeier
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class LocalSocket extends Socket {

    private OutputStream ostream;
    private InputStream istream;
    private boolean closed=true;
    private int peer;
	
    public LocalSocket(int peer) {
    	closed=false;
    	this.peer=peer;
	this.ostream = new LocalSocketOutputStream(this, peer);
	this.istream = new LocalSocketInputStream(this, peer);
    }
    public OutputStream getOutputStream() throws IOException {
	return ostream;
    }
    public InputStream getInputStream() throws IOException {
	return istream;
    }
    public synchronized void close() throws IOException {
	synchronized(this) {
	    if (closed) return;
	    closed = true;
	    JavaBridge.sclose(peer);
	}
    }
		
	
}
