/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

public class ArrayClassLoader
extends ClassLoader {
    byte[][] classBytes;
    int size;
    Class[] loadedClasses;
    String[] classNames;

    public ArrayClassLoader(byte[][] byArray) {
        this.classBytes = byArray;
        this.size = byArray.length;
        this.loadedClasses = new Class[this.size];
        this.classNames = new String[this.size];
        int n = 0;
        while (n < this.size) {
            this.classNames[n] = "lambda" + n;
            ++n;
        }
    }

    public ArrayClassLoader(String[] stringArray, byte[][] byArray) {
        this.classBytes = byArray;
        this.size = byArray.length;
        this.loadedClasses = new Class[this.size];
        this.classNames = stringArray;
    }

    private void reserve(int n) {
        Object object2;
        int n2;
        if (n <= 0) {
            return;
        }
        int n3 = n2 = this.size < n ? this.size + n : 2 * this.size;
        if (this.loadedClasses == null) {
            this.loadedClasses = new Class[n2];
        } else if (this.size + n > this.loadedClasses.length) {
            object2 = new Class[n2];
            System.arraycopy(this.loadedClasses, 0, object2, 0, this.size);
            this.loadedClasses = object2;
        }
        if (this.classBytes == null) {
            this.classBytes = new byte[n2][];
        } else if (this.size + n > this.classBytes.length) {
            object2 = new byte[n2][];
            System.arraycopy(this.classBytes, 0, object2, 0, this.size);
            this.classBytes = (byte[][])object2;
        }
        if (this.classNames == null) {
            this.classNames = new String[n2];
        } else if (this.size + n > this.classNames.length) {
            object2 = new String[n2];
            System.arraycopy(this.classNames, 0, object2, 0, this.size);
            this.classNames = object2;
        }
    }

    public void addClass(String string, byte[] byArray) {
        this.reserve(1);
        this.classNames[this.size] = string == null ? "lambda" + this.size : string;
        this.classBytes[this.size] = byArray;
        ++this.size;
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        int n = 0;
        while (true) {
            if (n >= this.size) {
                clazz = Class.forName(string);
                break;
            }
            if (string.equals(this.classNames[n])) {
                clazz = this.loadedClasses[n];
                if (clazz != null) break;
                byte[] byArray = this.classBytes[n];
                this.loadedClasses[n] = clazz = this.defineClass(string, byArray, 0, byArray.length);
                this.classBytes[n] = null;
                break;
            }
            ++n;
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }
}

