/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.S64Vector;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class U64Vector
extends SimpleVector
implements Externalizable {
    long[] data;

    public U64Vector() {
        this.data = S64Vector.empty;
    }

    public U64Vector(int n, long l) {
        long[] lArray = new long[n];
        this.data = lArray;
        this.size = n;
        while (--n >= 0) {
            lArray[n] = l;
        }
    }

    public U64Vector(int n) {
        this.data = new long[n];
        this.size = n;
    }

    public U64Vector(long[] lArray) {
        this.data = lArray;
        this.size = lArray.length;
    }

    public U64Vector(Sequence sequence) {
        this.data = new long[sequence.size()];
        this.addAll((Collection)sequence);
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            long[] lArray = new long[n];
            System.arraycopy(this.data, 0, lArray, 0, n2 < n ? n2 : n);
            this.data = lArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final int intAtBuffer(int n) {
        return (int)this.data[n];
    }

    public final long longAt(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[n];
    }

    public final long longAtBuffer(int n) {
        return this.data[n];
    }

    public final Object get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObjectUnsigned(this.data[n]);
    }

    public final Object getBuffer(int n) {
        return Convert.toObjectUnsigned(this.data[n]);
    }

    public Object setBuffer(int n, Object object2) {
        long l = this.data[n];
        this.data[n] = Convert.toLongUnsigned(object2);
        return Convert.toObjectUnsigned(l);
    }

    public final void setLongAt(int n, long l) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[n] = l;
    }

    public final void setLongAtBuffer(int n, long l) {
        this.data[n] = l;
    }

    protected void clearBuffer(int n, int n2) {
        while (--n2 >= 0) {
            this.data[n++] = 0L;
        }
    }

    public int getElementKind() {
        return 23;
    }

    public String getTag() {
        return "u64";
    }

    public boolean consumeNext(int n, Object object2, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeLong(this.data[n2]);
        return true;
    }

    public void consume(int n, Object object2, int n2, Object object3, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        while (n3 < n4) {
            consumer.writeLong(this.data[n3]);
            ++n3;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeLong(this.data[n2]);
            ++n2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = objectInput.readLong();
            ++n2;
        }
        this.data = lArray;
        this.size = n;
    }
}

