/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Procedure;
import gnu.mapping.WrappedException;

public class WrongType
extends WrappedException {
    public int number;
    public static final int ARG_UNKNOWN = -1;
    public static final int ARG_VARNAME = -2;
    public static final int ARG_DESCRIPTION = -3;
    public String typeExpected;
    public String procname;
    public Procedure proc;

    public WrongType(String string, int n, String string2) {
        super(null, null);
        this.procname = string;
        this.number = n - 1;
        this.typeExpected = string2;
    }

    public WrongType(Procedure procedure, int n, ClassCastException classCastException) {
        super(classCastException);
        this.proc = procedure;
        this.procname = procedure.getName();
        this.number = n;
    }

    public WrongType(String string, int n, ClassCastException classCastException) {
        super(classCastException);
        this.procname = string;
        this.number = n;
    }

    public static WrongType make(ClassCastException classCastException, Procedure procedure, int n) {
        return new WrongType(procedure, n, classCastException);
    }

    public static WrongType make(ClassCastException classCastException, String string, int n) {
        return new WrongType(string, n, classCastException);
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.number == -2) {
            stringBuffer.append("Value for variable `");
            stringBuffer.append(this.procname);
            stringBuffer.append("' has wrong type");
        } else if (this.number == -3) {
            stringBuffer.append(this.procname);
            stringBuffer.append(" has wrong type");
        } else {
            stringBuffer.append("Argument ");
            if (this.number >= 0) {
                stringBuffer.append('#');
                stringBuffer.append(this.number);
            }
            stringBuffer.append(" to `");
            stringBuffer.append(this.procname);
            stringBuffer.append("' has wrong type");
        }
        Exception exception = this.getException();
        if (exception != null) {
            stringBuffer.append(" (");
            stringBuffer.append(exception.getMessage());
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }
}

