/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class RtfFontList
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] DEFAULT_FONT = "\\deff".getBytes();
    private static final byte[] FONT_TABLE = "\\fonttbl".getBytes();
    public static final byte[] FONT_NUMBER = "\\f".getBytes();
    private ArrayList fontList = new ArrayList();

    public RtfFontList(RtfDocument rtfDocument) {
        super(rtfDocument);
        this.fontList.add(new RtfFont(this.document, 0));
    }

    public int getFontNumber(RtfFont rtfFont) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.fontList.size()) {
            if (this.fontList.get(n2).equals(rtfFont)) {
                n = n2;
            }
            ++n2;
        }
        if (n == -1) {
            n = this.fontList.size();
            this.fontList.add(rtfFont);
        }
        return n;
    }

    public byte[] writeDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(DEFAULT_FONT);
            byteArrayOutputStream.write(this.intToByteArray(0));
            byteArrayOutputStream.write(OPEN_GROUP);
            byteArrayOutputStream.write(FONT_TABLE);
            int n = 0;
            while (n < this.fontList.size()) {
                byteArrayOutputStream.write(OPEN_GROUP);
                byteArrayOutputStream.write(FONT_NUMBER);
                byteArrayOutputStream.write(this.intToByteArray(n));
                byteArrayOutputStream.write(((RtfFont)this.fontList.get(n)).writeDefinition());
                byteArrayOutputStream.write(COMMA_DELIMITER);
                byteArrayOutputStream.write(CLOSE_GROUP);
                ++n;
            }
            byteArrayOutputStream.write(CLOSE_GROUP);
            byteArrayOutputStream.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

