/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import java.io.IOException;

public class PdfBarcode
extends Chunk {
    public static final int CODE39 = 1;
    public static final int UPCA = 2;
    public static final int EAN13 = 3;
    public static final int INTERLEAVED_2_OF_5 = 4;
    public static final int[][] variableParity;

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[12];
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[12];
        nArray2[2] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 2;
        nArray2[8] = 2;
        nArray2[9] = 2;
        nArray2[10] = 2;
        nArray2[11] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[12];
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[5] = 1;
        nArray3[6] = 2;
        nArray3[7] = 2;
        nArray3[8] = 2;
        nArray3[9] = 2;
        nArray3[10] = 2;
        nArray3[11] = 2;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[12];
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 1;
        nArray4[6] = 2;
        nArray4[7] = 2;
        nArray4[8] = 2;
        nArray4[9] = 2;
        nArray4[10] = 2;
        nArray4[11] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[12];
        nArray5[1] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArray5[6] = 2;
        nArray5[7] = 2;
        nArray5[8] = 2;
        nArray5[9] = 2;
        nArray5[10] = 2;
        nArray5[11] = 2;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[12];
        nArray6[1] = 1;
        nArray6[2] = 1;
        nArray6[5] = 1;
        nArray6[6] = 2;
        nArray6[7] = 2;
        nArray6[8] = 2;
        nArray6[9] = 2;
        nArray6[10] = 2;
        nArray6[11] = 2;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[12];
        nArray7[1] = 1;
        nArray7[2] = 1;
        nArray7[3] = 1;
        nArray7[6] = 2;
        nArray7[7] = 2;
        nArray7[8] = 2;
        nArray7[9] = 2;
        nArray7[10] = 2;
        nArray7[11] = 2;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[12];
        nArray8[1] = 1;
        nArray8[3] = 1;
        nArray8[5] = 1;
        nArray8[6] = 2;
        nArray8[7] = 2;
        nArray8[8] = 2;
        nArray8[9] = 2;
        nArray8[10] = 2;
        nArray8[11] = 2;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[12];
        nArray9[1] = 1;
        nArray9[3] = 1;
        nArray9[4] = 1;
        nArray9[6] = 2;
        nArray9[7] = 2;
        nArray9[8] = 2;
        nArray9[9] = 2;
        nArray9[10] = 2;
        nArray9[11] = 2;
        nArrayArray[8] = nArray9;
        int[] nArray10 = new int[12];
        nArray10[1] = 1;
        nArray10[2] = 1;
        nArray10[4] = 1;
        nArray10[6] = 2;
        nArray10[7] = 2;
        nArray10[8] = 2;
        nArray10[9] = 2;
        nArray10[10] = 2;
        nArray10[11] = 2;
        nArrayArray[9] = nArray10;
        variableParity = nArrayArray;
    }

    public PdfBarcode(String string, int n, int n2, String string2) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(n, string2), new Font(BaseFont.createFont(string, "winansi", true), (float)n2));
    }

    public PdfBarcode(String string, int n, int n2, long l) throws BadElementException, DocumentException, IOException {
        super(PdfBarcode.convertToCode(n, String.valueOf(l)), new Font(BaseFont.createFont(string, "winansi", true), (float)n2));
    }

    private static String convertToCode(int n, String string) throws BadElementException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = 0;
        try {
            switch (n) {
                case 1: {
                    stringBuffer.append('*');
                    while (n3 < n2) {
                        stringBuffer.append(string.substring(n3++, n3));
                    }
                    stringBuffer.append('*');
                    break;
                }
                case 2: {
                    if (n2 > 12) {
                        throw new BadElementException("An UPC-A barcode can only encode a 12 digit number (your number was " + string + ").");
                    }
                    string = PdfBarcode.addZero(string, 12);
                    int n4 = Integer.parseInt(string.substring(n3++, n3));
                    stringBuffer.append((char)(n4 + 80));
                    while (n3 < 6) {
                        n4 = Integer.parseInt(string.substring(n3++, n3));
                        stringBuffer.append((char)(n4 + 48));
                    }
                    stringBuffer.append('p');
                    while (n3 < 11) {
                        n4 = Integer.parseInt(string.substring(n3++, n3));
                        stringBuffer.append((char)(n4 + 64));
                    }
                    n4 = Integer.parseInt(string.substring(11));
                    stringBuffer.append((char)(n4 + 96));
                    break;
                }
                case 3: {
                    if (n2 > 13) {
                        throw new BadElementException("An EAN-13 barcode can only encode a 13 digit number (your number was " + string + ").");
                    }
                    string = PdfBarcode.addZero(string, 13);
                    int n5 = Integer.parseInt(string.substring(n3++, n3));
                    stringBuffer.append((char)(n5 + 33));
                    int n6 = Integer.parseInt(string.substring(n3++, n3));
                    stringBuffer.append((char)(n6 + 96));
                    while (n3 < 7) {
                        n6 = Integer.parseInt(string.substring(n3++, n3));
                        stringBuffer.append((char)(n6 + 48 + 16 * variableParity[n5][n3 - 2]));
                    }
                    stringBuffer.append('|');
                    while (n3 < 12) {
                        n6 = Integer.parseInt(string.substring(n3++, n3));
                        stringBuffer.append((char)(n6 + 48 + 16 * variableParity[n5][n3 - 2]));
                    }
                    n6 = Integer.parseInt(string.substring(12));
                    stringBuffer.append((char)(n6 + 112));
                    break;
                }
                case 4: {
                    int n7;
                    if (n2 % 2 == 1) {
                        string = PdfBarcode.addZero(string, n2 + 1);
                    }
                    stringBuffer.append('(');
                    while (string.length() > 2) {
                        n7 = Integer.parseInt(string.substring(0, 2));
                        stringBuffer.append(PdfBarcode.convertInterleaved(n7));
                        n3 += 2;
                        string = string.substring(2);
                    }
                    n7 = Integer.parseInt(string);
                    stringBuffer.append(PdfBarcode.convertInterleaved(n7));
                    stringBuffer.append(')');
                    break;
                }
                default: {
                    throw new BadElementException("This type of barcode is not supported yet: " + n);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BadElementException("NumberFormatException at position " + n3 + " in " + string + ": " + numberFormatException.getMessage());
        }
        return stringBuffer.toString();
    }

    private static char convertInterleaved(int n) throws NumberFormatException {
        int n2;
        if (n < 50) {
            n2 = 48;
        } else if (n < 100) {
            n2 = 142;
        } else {
            throw new NumberFormatException(String.valueOf(n));
        }
        return (char)(n + n2);
    }

    private static String addZero(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n - string.length();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append('0');
            ++n3;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

