/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.fonts.FontsResourceAnchor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

class Type1Font
extends BaseFont {
    private static FontsResourceAnchor resourceAnchor;
    protected byte[] pfb;
    private String FontName;
    private String FullName;
    private String FamilyName;
    private String Weight;
    private float ItalicAngle;
    private boolean IsFixedPitch;
    private String CharacterSet;
    private int llx;
    private int lly;
    private int urx;
    private int ury;
    private int UnderlinePosition;
    private int UnderlineThickness;
    private String EncodingScheme;
    private int CapHeight;
    private int XHeight;
    private int Ascender;
    private int Descender;
    private int StdHW;
    private int StdVW;
    private ArrayList CharMetrics;
    private HashMap KernPairs;
    private String fileName;
    private boolean builtinFont;
    private static final int[] pfbTypes;

    static {
        pfbTypes = new int[]{1, 2, 1};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Type1Font(String var1_1, String var2_2, boolean var3_3, byte[] var4_4, byte[] var5_5) throws DocumentException, IOException {
        block28: {
            block29: {
                super();
                this.Weight = "";
                this.ItalicAngle = 0.0f;
                this.IsFixedPitch = false;
                this.llx = -50;
                this.lly = -200;
                this.urx = 1000;
                this.ury = 900;
                this.UnderlinePosition = -100;
                this.UnderlineThickness = 50;
                this.EncodingScheme = "FontSpecific";
                this.CapHeight = 700;
                this.XHeight = 480;
                this.Ascender = 800;
                this.Descender = -200;
                this.StdVW = 80;
                this.CharMetrics = new ArrayList<E>();
                this.KernPairs = new HashMap<K, V>();
                this.builtinFont = false;
                if (var3_3 && var4_4 != null && var5_5 == null) {
                    throw new DocumentException("Two byte arrays are needed if the Type1 font is embedded.");
                }
                if (var3_3 && var4_4 != null) {
                    this.pfb = var5_5;
                }
                this.encoding = var2_2;
                this.embedded = var3_3;
                this.fileName = var1_1;
                this.fontType = 0;
                var6_6 = null;
                var7_7 = null;
                if (!Type1Font.BuiltinFonts14.containsKey(var1_1)) break block29;
                this.embedded = false;
                this.builtinFont = true;
                var8_8 = new byte[1024];
                try {
                    if (Type1Font.resourceAnchor == null) {
                        Type1Font.resourceAnchor = new FontsResourceAnchor();
                    }
                    if ((var7_7 = Type1Font.getResourceStream("com/lowagie/text/pdf/fonts/" + var1_1 + ".afm", Type1Font.resourceAnchor.getClass().getClassLoader())) == null) {
                        var9_12 = String.valueOf(var1_1) + " not found as resource. (The *.afm files must exist as resources in the package com.lowagie.text.pdf.fonts)";
                        System.err.println(var9_12);
                        throw new DocumentException(var9_12);
                    }
                    var9_13 = new ByteArrayOutputStream();
                    while (true) {
                        block30: {
                            if ((var10_15 = var7_7.read(var8_8)) >= 0) break block30;
                            var8_8 = var9_13.toByteArray();
                            break;
                        }
                        var9_13.write(var8_8, 0, var10_15);
                    }
                }
                catch (Throwable var12_17) {
                    var11_18 = null;
                    if (var7_7 == null) throw var12_17;
                    try {
                        var7_7.close();
                        throw var12_17;
                    }
                    catch (Exception v0) {}
                    throw var12_17;
                }
                {
                    var11_19 = null;
                    if (var7_7 == null) ** GOTO lbl-1000
                }
                try {}
                catch (Exception v1) {}
                var7_7.close();
lbl-1000:
                // 3 sources

                {
                    var6_6 = new RandomAccessFileOrArray(var8_8);
                    this.process(var6_6);
                    var9_13 = null;
                    if (var6_6 != null) {
                        try {
                            var6_6.close();
                        }
                        catch (Exception v2) {}
                    }
                    break block28;
                }
            }
            if (var1_1.toLowerCase().endsWith(".afm") == false) throw new DocumentException(String.valueOf(var1_1) + " is not an AFM font file.");
            try {
                var6_6 = var4_4 == null ? new RandomAccessFileOrArray(var1_1) : new RandomAccessFileOrArray(var4_4);
                this.process(var6_6);
            }
            catch (Throwable var9_14) {
                var8_9 = null;
                if (var6_6 == null) throw var9_14;
                try {
                    var6_6.close();
                    throw var9_14;
                }
                catch (Exception v3) {}
                throw var9_14;
            }
            {
                var8_8 = null;
                if (var6_6 == null) break block28;
                try {}
                catch (Exception v4) {}
                var6_6.close();
            }
        }
        try {
            this.EncodingScheme = this.EncodingScheme.trim();
            if (this.EncodingScheme.equals("AdobeStandardEncoding") || this.EncodingScheme.equals("StandardEncoding")) {
                this.fontSpecific = false;
            }
            PdfEncodings.convertToBytes(" ", var2_2);
            this.createEncoding();
            return;
        }
        catch (RuntimeException var8_10) {
            throw var8_10;
        }
        catch (Exception var8_11) {
            throw new DocumentException(var8_11);
        }
    }

    int getRawWidth(int n, String string) {
        try {
            if (string == null) {
                int n2 = 0;
                while (n2 < this.CharMetrics.size()) {
                    Object[] objectArray = (Object[])this.CharMetrics.get(n2);
                    if ((Integer)objectArray[0] == n) {
                        return (Integer)objectArray[1];
                    }
                    ++n2;
                }
            } else {
                if (string.equals(".notdef")) {
                    return 0;
                }
                int n3 = 0;
                while (n3 < this.CharMetrics.size()) {
                    Object[] objectArray = (Object[])this.CharMetrics.get(n3);
                    if (string.equals(objectArray[2])) {
                        return (Integer)objectArray[1];
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return 0;
    }

    public int getKerning(char c, char c2) {
        String string = GlyphList.unicodeToName(c);
        if (string == null) {
            return 0;
        }
        String string2 = GlyphList.unicodeToName(c2);
        if (string2 == null) {
            return 0;
        }
        Object[] objectArray = (Object[])this.KernPairs.get(string);
        if (objectArray == null) {
            return 0;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (string2.equals(objectArray[n])) {
                return (Integer)objectArray[n + 1];
            }
            n += 2;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void process(RandomAccessFileOrArray var1_1) throws DocumentException, IOException {
        var3_2 = false;
        while ((var2_3 = var1_1.readLine()) != null) {
            var4_4 = new StringTokenizer(var2_3);
            if (!var4_4.hasMoreTokens()) continue;
            var5_5 = var4_4.nextToken();
            if (var5_5.equals("FontName")) {
                this.FontName = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("FullName")) {
                this.FullName = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("FamilyName")) {
                this.FamilyName = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("Weight")) {
                this.Weight = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("ItalicAngle")) {
                this.ItalicAngle = Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("IsFixedPitch")) {
                this.IsFixedPitch = var4_4.nextToken().equals("true");
                continue;
            }
            if (var5_5.equals("CharacterSet")) {
                this.CharacterSet = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("FontBBox")) {
                this.llx = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                this.lly = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                this.urx = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                this.ury = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("UnderlinePosition")) {
                this.UnderlinePosition = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("UnderlineThickness")) {
                this.UnderlineThickness = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("EncodingScheme")) {
                this.EncodingScheme = var4_4.nextToken("\u00ff").substring(1);
                continue;
            }
            if (var5_5.equals("CapHeight")) {
                this.CapHeight = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("XHeight")) {
                this.XHeight = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("Ascender")) {
                this.Ascender = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("Descender")) {
                this.Descender = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("StdHW")) {
                this.StdHW = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (var5_5.equals("StdVW")) {
                this.StdVW = (int)Float.valueOf(var4_4.nextToken()).floatValue();
                continue;
            }
            if (!var5_5.equals("StartCharMetrics")) continue;
            var3_2 = true;
            break;
        }
        if (var3_2) ** GOTO lbl94
        throw new DocumentException("Missing StartCharMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            var4_4 = new StringTokenizer(var2_3);
            if (!var4_4.hasMoreTokens()) continue;
            var5_5 = var4_4.nextToken();
            if (var5_5.equals("EndCharMetrics")) {
                var3_2 = false;
                break;
            }
            var6_6 = new Integer(-1);
            var7_7 = new Integer(250);
            var8_8 = "";
            var9_9 /* !! */  = null;
            var4_4 = new StringTokenizer(var2_3, ";");
            while (var4_4.hasMoreTokens()) {
                var10_10 = new StringTokenizer(var4_4.nextToken());
                if (!var10_10.hasMoreTokens()) continue;
                var5_5 = var10_10.nextToken();
                if (var5_5.equals("C")) {
                    var6_6 = Integer.valueOf(var10_10.nextToken());
                    continue;
                }
                if (var5_5.equals("WX")) {
                    var7_7 = new Integer(Float.valueOf(var10_10.nextToken()).intValue());
                    continue;
                }
                if (var5_5.equals("N")) {
                    var8_8 = var10_10.nextToken();
                    continue;
                }
                if (!var5_5.equals("B")) continue;
                var9_9 /* !! */  = new int[]{Integer.parseInt(var10_10.nextToken()), Integer.parseInt(var10_10.nextToken()), Integer.parseInt(var10_10.nextToken()), Integer.parseInt(var10_10.nextToken())};
            }
            this.CharMetrics.add(new Object[]{var6_6, var7_7, var8_8, var9_9 /* !! */ });
lbl94:
            // 3 sources

            ** while ((var2_3 = var1_1.readLine()) != null)
        }
lbl95:
        // 2 sources

        if (!var3_2) ** GOTO lbl105
        throw new DocumentException("Missing EndCharMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            var4_4 = new StringTokenizer(var2_3);
            if (!var4_4.hasMoreTokens()) continue;
            var5_5 = var4_4.nextToken();
            if (var5_5.equals("EndFontMetrics")) {
                return;
            }
            if (!var5_5.equals("StartKernPairs")) continue;
            var3_2 = true;
            break;
lbl105:
            // 3 sources

            ** while ((var2_3 = var1_1.readLine()) != null)
        }
lbl106:
        // 2 sources

        if (var3_2) ** GOTO lbl131
        throw new DocumentException("Missing EndFontMetrics in " + this.fileName);
lbl-1000:
        // 1 sources

        {
            var4_4 = new StringTokenizer(var2_3);
            if (!var4_4.hasMoreTokens()) continue;
            var5_5 = var4_4.nextToken();
            if (var5_5.equals("KPX")) {
                var6_6 = var4_4.nextToken();
                var7_7 = var4_4.nextToken();
                var8_8 = new Integer(Float.valueOf(var4_4.nextToken()).intValue());
                var9_9 /* !! */  = (int[])((Object[])this.KernPairs.get(var6_6));
                if (var9_9 /* !! */  == null) {
                    this.KernPairs.put(var6_6, new Object[]{var7_7, var8_8});
                    continue;
                }
                var10_11 = var9_9 /* !! */ .length;
                var11_12 = new Object[var10_11 + 2];
                System.arraycopy(var9_9 /* !! */ , 0, var11_12, 0, var10_11);
                var11_12[var10_11] = var7_7;
                var11_12[var10_11 + 1] = var8_8;
                this.KernPairs.put(var6_6, var11_12);
                continue;
            }
            if (!var5_5.equals("EndKernPairs")) continue;
            var3_2 = false;
            break;
lbl131:
            // 5 sources

            ** while ((var2_3 = var1_1.readLine()) != null)
        }
lbl132:
        // 2 sources

        if (var3_2) {
            throw new DocumentException("Missing EndKernPairs in " + this.fileName);
        }
        var1_1.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PdfStream getFontStream() throws DocumentException {
        BaseFont.StreamFont streamFont;
        if (this.builtinFont) return null;
        if (!this.embedded) {
            return null;
        }
        RandomAccessFileOrArray randomAccessFileOrArray = null;
        try {
            try {
                String string = String.valueOf(this.fileName.substring(0, this.fileName.length() - 3)) + "pfb";
                randomAccessFileOrArray = this.pfb == null ? new RandomAccessFileOrArray(string) : new RandomAccessFileOrArray(this.pfb);
                int n = randomAccessFileOrArray.length();
                byte[] byArray = new byte[n - 18];
                int[] nArray = new int[3];
                int n2 = 0;
                int n3 = 0;
                block7: while (true) {
                    if (n3 >= 3) {
                        streamFont = new BaseFont.StreamFont(byArray, nArray);
                        Object var10_12 = null;
                        if (randomAccessFileOrArray == null) return streamFont;
                        break;
                    }
                    if (randomAccessFileOrArray.read() != 128) {
                        throw new DocumentException("Start marker missing in " + string);
                    }
                    if (randomAccessFileOrArray.read() != pfbTypes[n3]) {
                        throw new DocumentException("Incorrect segment type in " + string);
                    }
                    int n4 = randomAccessFileOrArray.read();
                    n4 += randomAccessFileOrArray.read() << 8;
                    n4 += randomAccessFileOrArray.read() << 16;
                    nArray[n3] = n4 += randomAccessFileOrArray.read() << 24;
                    while (true) {
                        if (n4 == 0) {
                            ++n3;
                            continue block7;
                        }
                        int n5 = randomAccessFileOrArray.read(byArray, n2, n4);
                        if (n5 < 0) {
                            throw new DocumentException("Premature end in " + string);
                        }
                        n2 += n5;
                        n4 -= n5;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (randomAccessFileOrArray == null) throw throwable;
            try {
                randomAccessFileOrArray.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        randomAccessFileOrArray.close();
        return streamFont;
    }

    private PdfDictionary getFontDescriptor(PdfIndirectReference pdfIndirectReference) {
        if (this.builtinFont) {
            return null;
        }
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONTDESCRIPTOR);
        pdfDictionary.put(PdfName.ASCENT, new PdfNumber(this.Ascender));
        pdfDictionary.put(PdfName.CAPHEIGHT, new PdfNumber(this.CapHeight));
        pdfDictionary.put(PdfName.DESCENT, new PdfNumber(this.Descender));
        pdfDictionary.put(PdfName.FONTBBOX, new PdfRectangle(this.llx, this.lly, this.urx, this.ury));
        pdfDictionary.put(PdfName.FONTNAME, new PdfName(this.FontName));
        pdfDictionary.put(PdfName.ITALICANGLE, new PdfNumber(this.ItalicAngle));
        pdfDictionary.put(PdfName.STEMV, new PdfNumber(this.StdVW));
        if (pdfIndirectReference != null) {
            pdfDictionary.put(PdfName.FONTFILE, pdfIndirectReference);
        }
        int n = 0;
        if (this.IsFixedPitch) {
            n |= 1;
        }
        n |= this.fontSpecific ? 4 : 32;
        if (this.ItalicAngle < 0.0f) {
            n |= 0x40;
        }
        if (this.FontName.indexOf("Caps") >= 0 || this.FontName.endsWith("SC")) {
            n |= 0x20000;
        }
        if (this.Weight.equals("Bold")) {
            n |= 0x40000;
        }
        pdfDictionary.put(PdfName.FLAGS, new PdfNumber(n));
        return pdfDictionary;
    }

    private PdfDictionary getFontBaseType(PdfIndirectReference pdfIndirectReference, int n, int n2, byte[] byArray) {
        boolean bl;
        PdfDictionary pdfDictionary = new PdfDictionary(PdfName.FONT);
        pdfDictionary.put(PdfName.SUBTYPE, PdfName.TYPE1);
        pdfDictionary.put(PdfName.BASEFONT, new PdfName(this.FontName));
        boolean bl2 = bl = this.encoding.equals("Cp1252") || this.encoding.equals("MacRoman");
        if (!this.fontSpecific) {
            int n3 = n;
            while (n3 <= n2) {
                if (!this.differences[n3].equals(".notdef")) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            if (bl) {
                pdfDictionary.put(PdfName.ENCODING, this.encoding.equals("Cp1252") ? PdfName.WIN_ANSI_ENCODING : PdfName.MAC_ROMAN_ENCODING);
            } else {
                PdfDictionary pdfDictionary2 = new PdfDictionary(PdfName.ENCODING);
                PdfArray pdfArray = new PdfArray();
                boolean bl3 = true;
                int n4 = n;
                while (n4 <= n2) {
                    if (byArray[n4] != 0) {
                        if (bl3) {
                            pdfArray.add(new PdfNumber(n4));
                            bl3 = false;
                        }
                        pdfArray.add(new PdfName(this.differences[n4]));
                    } else {
                        bl3 = true;
                    }
                    ++n4;
                }
                pdfDictionary2.put(PdfName.DIFFERENCES, pdfArray);
                pdfDictionary.put(PdfName.ENCODING, pdfDictionary2);
            }
        }
        if (this.forceWidthsOutput || !this.builtinFont || !this.fontSpecific && !bl) {
            pdfDictionary.put(PdfName.FIRSTCHAR, new PdfNumber(n));
            pdfDictionary.put(PdfName.LASTCHAR, new PdfNumber(n2));
            PdfArray pdfArray = new PdfArray();
            int n5 = n;
            while (n5 <= n2) {
                if (byArray[n5] == 0) {
                    pdfArray.add(new PdfNumber(0));
                } else {
                    pdfArray.add(new PdfNumber(this.widths[n5]));
                }
                ++n5;
            }
            pdfDictionary.put(PdfName.WIDTHS, pdfArray);
        }
        if (!this.builtinFont && pdfIndirectReference != null) {
            pdfDictionary.put(PdfName.FONTDESCRIPTOR, pdfIndirectReference);
        }
        return pdfDictionary;
    }

    void writeFont(PdfWriter pdfWriter, PdfIndirectReference pdfIndirectReference, Object[] objectArray) throws DocumentException, IOException {
        int n = (Integer)objectArray[0];
        int n2 = (Integer)objectArray[1];
        byte[] byArray = (byte[])objectArray[2];
        if (!this.subset) {
            n = 0;
            n2 = byArray.length - 1;
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = 1;
                ++n3;
            }
        }
        PdfIndirectReference pdfIndirectReference2 = null;
        PdfDictionary pdfDictionary = null;
        PdfIndirectObject pdfIndirectObject = null;
        pdfDictionary = this.getFontStream();
        if (pdfDictionary != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        if ((pdfDictionary = this.getFontDescriptor(pdfIndirectReference2)) != null) {
            pdfIndirectObject = pdfWriter.addToBody(pdfDictionary);
            pdfIndirectReference2 = pdfIndirectObject.getIndirectReference();
        }
        pdfDictionary = this.getFontBaseType(pdfIndirectReference2, n, n2, byArray);
        pdfWriter.addToBody((PdfObject)pdfDictionary, pdfIndirectReference);
    }

    public float getFontDescriptor(int n, float f) {
        switch (n) {
            case 1: 
            case 9: {
                return (float)this.Ascender * f / 1000.0f;
            }
            case 2: {
                return (float)this.CapHeight * f / 1000.0f;
            }
            case 3: 
            case 10: {
                return (float)this.Descender * f / 1000.0f;
            }
            case 4: {
                return this.ItalicAngle;
            }
            case 5: {
                return (float)this.llx * f / 1000.0f;
            }
            case 6: {
                return (float)this.lly * f / 1000.0f;
            }
            case 7: {
                return (float)this.urx * f / 1000.0f;
            }
            case 8: {
                return (float)this.ury * f / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (float)(this.urx - this.llx) * f / 1000.0f;
            }
        }
        return 0.0f;
    }

    public String getPostscriptFontName() {
        return this.FontName;
    }

    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.FullName}};
    }

    public String[][] getFamilyFontName() {
        return new String[][]{{"", "", "", this.FamilyName}};
    }

    public boolean hasKernPairs() {
        return this.KernPairs.size() > 0;
    }

    public void setPostscriptFontName(String string) {
        this.FontName = string;
    }

    public boolean setKerning(char c, char c2, int n) {
        String string = GlyphList.unicodeToName(c);
        if (string == null) {
            return false;
        }
        String string2 = GlyphList.unicodeToName(c2);
        if (string2 == null) {
            return false;
        }
        Object[] objectArray = (Object[])this.KernPairs.get(string);
        if (objectArray == null) {
            objectArray = new Object[]{string2, new Integer(n)};
            this.KernPairs.put(string, objectArray);
            return true;
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (string2.equals(objectArray[n2])) {
                objectArray[n2 + 1] = new Integer(n);
                return true;
            }
            n2 += 2;
        }
        n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2 + 2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        objectArray2[n2] = string2;
        objectArray2[n2 + 1] = new Integer(n);
        this.KernPairs.put(string, objectArray2);
        return true;
    }

    protected int[] getRawCharBBox(int n, String string) {
        if (string == null) {
            int n2 = 0;
            while (n2 < this.CharMetrics.size()) {
                Object[] objectArray = (Object[])this.CharMetrics.get(n2);
                if ((Integer)objectArray[0] == n) {
                    return (int[])objectArray[3];
                }
                ++n2;
            }
        } else {
            if (string.equals(".notdef")) {
                return null;
            }
            int n3 = 0;
            while (n3 < this.CharMetrics.size()) {
                Object[] objectArray = (Object[])this.CharMetrics.get(n3);
                if (string.equals(objectArray[2])) {
                    return (int[])objectArray[3];
                }
                ++n3;
            }
        }
        return null;
    }
}

