/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.CodeFragment;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.CpoolValue2;
import gnu.bytecode.Field;
import gnu.bytecode.IfState;
import gnu.bytecode.Label;
import gnu.bytecode.LineNumbersAttr;
import gnu.bytecode.LocalVarsAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.TryState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class CodeAttr
extends Attribute
implements AttrContainer {
    Attribute attributes;
    LineNumbersAttr lines;
    public LocalVarsAttr locals;
    Type[] stack_types;
    int SP;
    private int max_stack;
    private int max_locals;
    int PC;
    int readPC;
    byte[] code;
    short[] exception_table;
    int exception_table_length;
    Label labels;
    CodeFragment fragments;
    IfState if_stack;
    TryState try_stack;
    boolean unreachable_here;
    CodeFragment fragmentStack = null;

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attribute) {
        this.attributes = attribute;
    }

    public final Method getMethod() {
        return (Method)this.getContainer();
    }

    public final int getPC() {
        return this.PC;
    }

    public final ConstantPool getConstants() {
        return this.getMethod().classfile.constants;
    }

    public boolean reachableHere() {
        return !this.unreachable_here;
    }

    public final void setReachable(boolean bl) {
        this.unreachable_here = !bl;
    }

    public final void setUnreachable() {
        this.unreachable_here = true;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxLocals() {
        return this.max_locals;
    }

    public void setMaxStack(int n) {
        this.max_stack = n;
    }

    public void setMaxLocals(int n) {
        this.max_locals = n;
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] byArray) {
        this.code = byArray;
        this.readPC = this.PC = byArray.length;
    }

    public void setCodeLength(int n) {
        this.PC = n;
        this.readPC = n;
    }

    public int getCodeLength() {
        this.readPC = this.PC;
        return this.PC;
    }

    public CodeAttr(Method method) {
        super("Code");
        this.addToFrontOf(method);
        method.code = this;
    }

    public final void reserve(int n) {
        if (this.code == null) {
            this.code = new byte[100 + n];
        } else if (this.PC + n > this.code.length) {
            byte[] byArray = new byte[2 * this.code.length + n];
            System.arraycopy(this.code, 0, byArray, 0, this.PC);
            this.code = byArray;
        }
        while (this.labels != null && this.labels.fixups != null) {
            int n2;
            int n3 = this.labels.fixups[0];
            int n4 = n2 = this.unreachable_here ? 30000 : 32000;
            if (this.PC + n - n3 <= n2) break;
            this.labels.emit_spring(this);
        }
    }

    public final void put1(int n) {
        this.code[this.PC++] = (byte)n;
        this.unreachable_here = false;
    }

    public final void put2(int n) {
        this.code[this.PC++] = (byte)(n >> 8);
        this.code[this.PC++] = (byte)n;
        this.unreachable_here = false;
    }

    public final void put4(int n) {
        this.code[this.PC++] = (byte)(n >> 24);
        this.code[this.PC++] = (byte)(n >> 16);
        this.code[this.PC++] = (byte)(n >> 8);
        this.code[this.PC++] = (byte)n;
        this.unreachable_here = false;
    }

    public final void putIndex2(CpoolEntry cpoolEntry) {
        this.put2(cpoolEntry.index);
    }

    public final void putLineNumber(int n) {
        if (this.lines == null) {
            this.lines = new LineNumbersAttr(this);
        }
        this.readPC = this.PC;
        this.lines.put(n, this.PC);
    }

    public final void pushType(Type type) {
        if (type.size == 0) {
            throw new Error("pushing void type onto stack");
        }
        if (this.stack_types == null) {
            this.stack_types = new Type[20];
        } else if (this.SP + 1 >= this.stack_types.length) {
            Type[] typeArray = new Type[2 * this.stack_types.length];
            System.arraycopy(this.stack_types, 0, typeArray, 0, this.SP);
            this.stack_types = typeArray;
        }
        if (type.size == 8) {
            this.stack_types[this.SP++] = Type.void_type;
        }
        this.stack_types[this.SP++] = type;
        if (this.SP > this.max_stack) {
            this.max_stack = this.SP;
        }
    }

    public final Type popType() {
        if (this.SP <= 0) {
            throw new Error("popType called with empty stack " + this.getMethod());
        }
        Type type = this.stack_types[--this.SP];
        if (type.size == 8 && !this.popType().isVoid()) {
            throw new Error("missing void type on stack");
        }
        return type;
    }

    public final Type topType() {
        return this.stack_types[this.SP - 1];
    }

    public void emitPop(int n) {
        while (n > 0) {
            this.reserve(1);
            Type type = this.popType();
            if (type.size > 4) {
                this.put1(88);
            } else if (n > 1) {
                Type type2 = this.popType();
                if (type2.size > 4) {
                    this.put1(87);
                    this.reserve(1);
                }
                this.put1(88);
                --n;
            } else {
                this.put1(87);
            }
            --n;
        }
    }

    public void emitSwap() {
        this.reserve(1);
        Type type = this.popType();
        Type type2 = this.popType();
        if (type.size > 4 || type2.size > 4) {
            throw new Error("emitSwap:  not allowed for long or double");
        }
        this.pushType(type);
        this.put1(95);
        this.pushType(type2);
    }

    public void emitDup() {
        this.reserve(1);
        Type type = this.topType();
        this.put1(type.size <= 4 ? 89 : 92);
        this.pushType(type);
    }

    public void emitDupX() {
        this.reserve(1);
        Type type = this.popType();
        Type type2 = this.popType();
        if (type2.size <= 4) {
            this.put1(type.size <= 4 ? 90 : 93);
        } else {
            this.put1(type.size <= 4 ? 91 : 94);
        }
        this.pushType(type);
        this.pushType(type2);
        this.pushType(type);
    }

    public void emitDup(int n, int n2) {
        int n3;
        if (n == 0) {
            return;
        }
        this.reserve(1);
        Type type = this.popType();
        Type type2 = null;
        if (n == 1) {
            if (type.size > 4) {
                throw new Error("using dup for 2-word type");
            }
        } else {
            if (n != 2) {
                throw new Error("invalid size to emitDup");
            }
            if (type.size <= 4) {
                type2 = this.popType();
                if (type2.size > 4) {
                    throw new Error("dup will cause invalid types on stack");
                }
            }
        }
        Type type3 = null;
        Type type4 = null;
        if (n2 == 0) {
            n3 = n == 1 ? 89 : 92;
        } else if (n2 == 1) {
            n3 = n == 1 ? 90 : 93;
            type3 = this.popType();
            if (type3.size > 4) {
                throw new Error("dup will cause invalid types on stack");
            }
        } else if (n2 == 2) {
            n3 = n == 1 ? 91 : 94;
            type3 = this.popType();
            if (type3.size <= 4) {
                type4 = this.popType();
                if (type4.size > 4) {
                    throw new Error("dup will cause invalid types on stack");
                }
            }
        } else {
            throw new Error("emitDup:  invalid offset");
        }
        this.put1(n3);
        if (type2 != null) {
            this.pushType(type2);
        }
        this.pushType(type);
        if (type4 != null) {
            this.pushType(type4);
        }
        if (type3 != null) {
            this.pushType(type3);
        }
        if (type2 != null) {
            this.pushType(type2);
        }
        this.pushType(type);
    }

    public void emitDup(int n) {
        this.emitDup(n, 0);
    }

    public void emitDup(Type type) {
        this.emitDup(type.size > 4 ? 2 : 1, 0);
    }

    public void enterScope(Scope scope) {
        scope.setStartPC(this.PC);
        this.locals.enterScope(scope);
    }

    public Scope pushScope() {
        Scope scope = new Scope();
        scope.start_pc = this.PC;
        this.readPC = this.PC;
        if (this.locals == null) {
            this.locals = new LocalVarsAttr(this.getMethod());
        }
        this.locals.enterScope(scope);
        if (this.locals.parameter_scope == null) {
            this.locals.parameter_scope = scope;
        }
        return scope;
    }

    public Scope popScope() {
        Scope scope = this.locals.current_scope;
        this.locals.current_scope = scope.parent;
        scope.end_pc = this.PC;
        this.readPC = this.PC;
        Variable variable = scope.vars;
        while (variable != null) {
            if (variable.isSimple() && !variable.dead()) {
                variable.freeLocal(this);
            }
            variable = variable.next;
        }
        return scope;
    }

    public Variable getArg(int n) {
        return this.locals.parameter_scope.find_var(n);
    }

    public Variable lookup(String string) {
        Scope scope = this.locals.current_scope;
        while (scope != null) {
            Variable variable = scope.lookup(string);
            if (variable != null) {
                return variable;
            }
            scope = scope.parent;
        }
        return null;
    }

    public Variable addLocal(Type type) {
        return this.locals.current_scope.addVariable(this, type, null);
    }

    public Variable addLocal(Type type, String string) {
        return this.locals.current_scope.addVariable(this, type, string);
    }

    public void addParamLocals() {
        Method method = this.getMethod();
        if ((method.access_flags & 8) == 0) {
            this.addLocal(method.classfile).setParameter(true);
        }
        int n = method.arg_types.length;
        int n2 = 0;
        while (n2 < n) {
            this.addLocal(method.arg_types[n2]).setParameter(true);
            ++n2;
        }
    }

    public final void emitPushConstant(int n, Type type) {
        switch (type.getSignature().charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                this.emitPushInt(n);
                break;
            }
            case 'J': {
                this.emitPushLong(n);
                break;
            }
            case 'F': {
                this.emitPushFloat(n);
                break;
            }
            case 'D': {
                this.emitPushDouble(n);
                break;
            }
            default: {
                throw new Error("bad type to emitPushConstant");
            }
        }
    }

    public final void emitPushConstant(CpoolEntry cpoolEntry) {
        this.reserve(3);
        int n = cpoolEntry.index;
        if (cpoolEntry instanceof CpoolValue2) {
            this.put1(20);
            this.put2(n);
        } else if (n < 256) {
            this.put1(18);
            this.put1(n);
        } else {
            this.put1(19);
            this.put2(n);
        }
    }

    public final void emitPushInt(int n) {
        this.reserve(3);
        if (n >= -1 && n <= 5) {
            this.put1(n + 3);
        } else if (n >= -128 && n < 128) {
            this.put1(16);
            this.put1(n);
        } else if (n >= Short.MIN_VALUE && n < 32768) {
            this.put1(17);
            this.put2(n);
        } else {
            this.emitPushConstant(this.getConstants().addInt(n));
        }
        this.pushType(Type.int_type);
    }

    public void emitPushLong(long l) {
        if (l == 0L || l == 1L) {
            this.reserve(1);
            this.put1(9 + (int)l);
        } else if ((long)((int)l) == l) {
            this.emitPushInt((int)l);
            this.reserve(1);
            this.popType();
            this.put1(133);
        } else {
            this.emitPushConstant(this.getConstants().addLong(l));
        }
        this.pushType(Type.long_type);
    }

    public void emitPushFloat(float f) {
        int n = (int)f;
        if ((float)n == f && n >= -128 && n < 128) {
            if (n >= 0 && n <= 2) {
                this.reserve(1);
                this.put1(11 + n);
                if (n == 0 && Float.floatToIntBits(f) != 0) {
                    this.reserve(1);
                    this.put1(118);
                }
            } else {
                this.emitPushInt(n);
                this.reserve(1);
                this.popType();
                this.put1(134);
            }
        } else {
            this.emitPushConstant(this.getConstants().addFloat(f));
        }
        this.pushType(Type.float_type);
    }

    public void emitPushDouble(double d) {
        int n = (int)d;
        if ((double)n == d && n >= -128 && n < 128) {
            if (n == 0 || n == 1) {
                this.reserve(1);
                this.put1(14 + n);
                if (n == 0 && Double.doubleToLongBits(d) != 0L) {
                    this.reserve(1);
                    this.put1(119);
                }
            } else {
                this.emitPushInt(n);
                this.reserve(1);
                this.popType();
                this.put1(135);
            }
        } else {
            this.emitPushConstant(this.getConstants().addDouble(d));
        }
        this.pushType(Type.double_type);
    }

    public final void emitPushString(String string) {
        this.emitPushConstant(this.getConstants().addString(string));
        this.pushType(Type.string_type);
    }

    public void emitPushNull() {
        this.reserve(1);
        this.put1(1);
        this.pushType(Type.pointer_type);
    }

    public final void emitPushThis() {
        this.reserve(1);
        this.put1(42);
        this.pushType(this.getMethod().getDeclaringClass());
    }

    void emitNewArray(int n) {
        this.reserve(2);
        this.put1(188);
        this.put1(n);
    }

    public final void emitArrayLength() {
        if (!(this.popType() instanceof ArrayType)) {
            throw new Error("non-array type in emitArrayLength");
        }
        this.reserve(1);
        this.put1(190);
        this.pushType(Type.int_type);
    }

    private int adjustTypedOp(char c) {
        switch (c) {
            case 'I': {
                return 0;
            }
            case 'J': {
                return 1;
            }
            case 'F': {
                return 2;
            }
            case 'D': {
                return 3;
            }
            default: {
                return 4;
            }
            case 'B': 
            case 'Z': {
                return 5;
            }
            case 'C': {
                return 6;
            }
            case 'S': 
        }
        return 7;
    }

    private int adjustTypedOp(Type type) {
        return this.adjustTypedOp(type.getSignature().charAt(0));
    }

    private void emitTypedOp(int n, Type type) {
        this.reserve(1);
        this.put1(n + this.adjustTypedOp(type));
    }

    private void emitTypedOp(int n, char c) {
        this.reserve(1);
        this.put1(n + this.adjustTypedOp(c));
    }

    public void emitArrayStore(Type type) {
        this.popType();
        this.popType();
        this.popType();
        this.emitTypedOp(79, type);
    }

    public void emitArrayLoad(Type type) {
        this.popType();
        this.popType();
        this.emitTypedOp(46, type);
        this.pushType(type);
    }

    public void emitNew(ClassType classType) {
        this.reserve(3);
        this.put1(187);
        this.putIndex2(this.getConstants().addClass(classType));
        this.pushType(classType);
    }

    public void emitNewArray(Type type, int n) {
        if (this.popType().promote() != Type.int_type) {
            throw new Error("non-int dim. spec. in emitNewArray");
        }
        if (type instanceof PrimType) {
            int n2;
            switch (type.getSignature().charAt(0)) {
                case 'B': {
                    n2 = 8;
                    break;
                }
                case 'S': {
                    n2 = 9;
                    break;
                }
                case 'I': {
                    n2 = 10;
                    break;
                }
                case 'J': {
                    n2 = 11;
                    break;
                }
                case 'F': {
                    n2 = 6;
                    break;
                }
                case 'D': {
                    n2 = 7;
                    break;
                }
                case 'Z': {
                    n2 = 4;
                    break;
                }
                case 'C': {
                    n2 = 5;
                    break;
                }
                default: {
                    throw new Error("bad PrimType in emitNewArray");
                }
            }
            this.emitNewArray(n2);
        } else if (type instanceof ObjectType) {
            this.reserve(3);
            this.put1(189);
            this.putIndex2(this.getConstants().addClass((ObjectType)type));
        } else if (type instanceof ArrayType) {
            this.reserve(4);
            this.put1(197);
            this.putIndex2(this.getConstants().addClass(new ArrayType(type)));
            if (n < 1 || n > 255) {
                throw new Error("dims out of range in emitNewArray");
            }
            this.put1(n);
            while (--n > 0) {
                if (this.popType().promote() == Type.int_type) continue;
                throw new Error("non-int dim. spec. in emitNewArray");
            }
        } else {
            throw new Error("unimplemented type in emitNewArray");
        }
        this.pushType(new ArrayType(type));
    }

    public void emitNewArray(Type type) {
        this.emitNewArray(type, 1);
    }

    private void emitBinop(int n) {
        Type type = this.popType().promote();
        Type type2 = this.popType();
        Type type3 = type2.promote();
        if (type3 != type || !(type3 instanceof PrimType)) {
            throw new Error("non-matching or bad types in binary operation");
        }
        this.emitTypedOp(n, type3);
        this.pushType(type2);
    }

    private void emitBinop(int n, char c) {
        this.popType();
        this.popType();
        this.emitTypedOp(n, c);
        this.pushType(Type.signatureToPrimitive(c));
    }

    private void emitBinop(int n, Type type) {
        this.popType();
        this.popType();
        this.emitTypedOp(n, type);
        this.pushType(type);
    }

    public final void emitAdd(char c) {
        this.emitBinop(96, c);
    }

    public final void emitAdd(PrimType primType) {
        this.emitBinop(96, primType);
    }

    public final void emitAdd() {
        this.emitBinop(96);
    }

    public final void emitSub(char c) {
        this.emitBinop(100, c);
    }

    public final void emitSub(PrimType primType) {
        this.emitBinop(100, primType);
    }

    public final void emitSub() {
        this.emitBinop(100);
    }

    public final void emitMul() {
        this.emitBinop(104);
    }

    public final void emitDiv() {
        this.emitBinop(108);
    }

    public final void emitRem() {
        this.emitBinop(112);
    }

    public final void emitShl() {
        this.emitBinop(120);
    }

    public final void emitShr() {
        this.emitBinop(122);
    }

    public final void emitUshr() {
        this.emitBinop(124);
    }

    public final void emitAnd() {
        this.emitBinop(126);
    }

    public final void emitIOr() {
        this.emitBinop(128);
    }

    public final void emitXOr() {
        this.emitBinop(130);
    }

    public final void emitNot(Type type) {
        this.emitPushConstant(1, type);
        this.emitAdd();
        this.emitPushConstant(1, type);
        this.emitAnd();
    }

    public void emitPrimop(int n, int n2, Type type) {
        this.reserve(1);
        while (--n2 >= 0) {
            this.popType();
        }
        this.put1(n);
        this.pushType(type);
    }

    void emitMaybeWide(int n, int n2) {
        if (n2 >= 256) {
            this.put1(196);
            this.put1(n);
            this.put2(n2);
        } else {
            this.put1(n);
            this.put1(n2);
        }
    }

    public final void emitLoad(Variable variable) {
        if (variable.dead()) {
            throw new Error("attempting to push dead variable");
        }
        int n = variable.offset;
        if (n < 0 || !variable.isSimple()) {
            throw new Error("attempting to load from unassigned variable " + variable + " simple:" + variable.isSimple() + ", offset: " + n);
        }
        Type type = variable.getType().promote();
        this.reserve(4);
        int n2 = this.adjustTypedOp(type);
        if (n <= 3) {
            this.put1(26 + 4 * n2 + n);
        } else {
            this.emitMaybeWide(21 + n2, n);
        }
        this.pushType(variable.getType());
    }

    public void emitStore(Variable variable) {
        if (variable.dead()) {
            throw new Error("attempting to push dead variable");
        }
        int n = variable.offset;
        if (n < 0 || !variable.isSimple()) {
            throw new Error("attempting to store in unassigned variable " + variable.getName() + " simple:" + variable.isSimple() + ", offset: " + n);
        }
        Type type = variable.getType().promote();
        this.reserve(4);
        this.popType();
        int n2 = this.adjustTypedOp(type);
        if (n <= 3) {
            this.put1(59 + 4 * n2 + n);
        } else {
            this.emitMaybeWide(54 + n2, n);
        }
    }

    public void emitInc(Variable variable, short s) {
        boolean bl;
        if (variable.dead()) {
            throw new Error("attempting to increment dead variable");
        }
        int n = variable.offset;
        if (n < 0 || !variable.isSimple()) {
            throw new Error("attempting to increment unassigned variable" + variable.getName() + " simple:" + variable.isSimple() + ", offset: " + n);
        }
        Type type = variable.getType().promote();
        this.reserve(6);
        if (type != Type.int_type) {
            throw new Error("attempting to increment non-int variable");
        }
        boolean bl2 = bl = n > 255 || s > 255 || s < -256;
        if (bl) {
            this.put1(196);
            this.put1(132);
            this.put2(n);
            this.put2(s);
        } else {
            this.put1(132);
            this.put1(n);
            this.put1(s);
        }
    }

    private final void emitFieldop(Field field, int n) {
        this.reserve(3);
        this.put1(n);
        this.putIndex2(this.getConstants().addFieldRef(field));
    }

    public final void emitGetStatic(Field field) {
        this.pushType(field.type);
        this.emitFieldop(field, 178);
    }

    public final void emitGetField(Field field) {
        this.popType();
        this.pushType(field.type);
        this.emitFieldop(field, 180);
    }

    public final void emitPutStatic(Field field) {
        this.popType();
        this.emitFieldop(field, 179);
    }

    public final void emitPutField(Field field) {
        this.popType();
        this.popType();
        this.emitFieldop(field, 181);
    }

    private int words(Type[] typeArray) {
        int n = 0;
        int n2 = typeArray.length;
        while (--n2 >= 0) {
            if (typeArray[n2].size > 4) {
                n += 2;
                continue;
            }
            ++n;
        }
        return n;
    }

    public void emitInvokeMethod(Method method, int n) {
        this.reserve(n == 185 ? 5 : 3);
        int n2 = method.arg_types.length;
        boolean bl = n == 184;
        if (bl != ((method.access_flags & 8) != 0)) {
            throw new Error("emitInvokeXxx static flag mis-match method.flags=" + method.access_flags);
        }
        if (!bl) {
            ++n2;
        }
        this.put1(n);
        this.putIndex2(this.getConstants().addMethodRef(method));
        if (n == 185) {
            this.put1(this.words(method.arg_types) + 1);
            this.put1(0);
        }
        while (--n2 >= 0) {
            this.popType();
        }
        if (method.return_type.size != 0) {
            this.pushType(method.return_type);
        }
    }

    public void emitInvoke(Method method) {
        int n = (method.access_flags & 8) != 0 ? 184 : (this.getMethod().classfile.isInterface() ? 185 : 182);
        this.emitInvokeMethod(method, n);
    }

    public void emitInvokeVirtual(Method method) {
        this.emitInvokeMethod(method, 182);
    }

    public void emitInvokeSpecial(Method method) {
        this.emitInvokeMethod(method, 183);
    }

    public void emitInvokeStatic(Method method) {
        this.emitInvokeMethod(method, 184);
    }

    public void emitInvokeInterface(Method method) {
        this.emitInvokeMethod(method, 185);
    }

    final void emitTransfer(Label label, int n) {
        this.put1(n);
        label.emit(this);
    }

    public final void emitGoto(Label label, int n) {
        this.reserve(5);
        if (label.defined()) {
            this.readPC = this.PC;
            int n2 = label.position - this.PC;
            if (n2 < Short.MIN_VALUE) {
                this.put1(n - 167);
                this.put4(n2);
            } else {
                this.put1(n);
                this.put2(n2);
            }
        } else {
            this.emitTransfer(label, n);
        }
    }

    public final void emitGoto(Label label) {
        this.emitGoto(label, 167);
        this.setUnreachable();
    }

    public final void emitGotoIfEq(Label label, boolean bl) {
        int n;
        Type type = this.popType().promote();
        Type type2 = this.popType().promote();
        this.reserve(4);
        char c = type2.getSignature().charAt(0);
        char c2 = type.getSignature().charAt(0);
        if (c == 'I' && c2 == 'I') {
            n = 159;
        } else if (c == 'J' && c2 == 'J') {
            this.put1(148);
            n = 153;
        } else if (c == 'F' && c2 == 'F') {
            this.put1(149);
            n = 153;
        } else if (c == 'D' && c2 == 'D') {
            this.put1(151);
            n = 153;
        } else if (!(c != 'L' && c != '[' || c2 != 'L' && c2 != '[')) {
            n = 165;
        } else {
            throw new Error("non-matching types to emitGotoIfEq");
        }
        if (bl) {
            ++n;
        }
        this.emitTransfer(label, n);
    }

    public final void emitGotoIfEq(Label label) {
        this.emitGotoIfEq(label, false);
    }

    public final void emitGotoIfNE(Label label) {
        this.emitGotoIfEq(label, true);
    }

    public final void emitGotoIfCompare1(Label label, int n) {
        this.popType();
        this.reserve(3);
        this.emitTransfer(label, n);
    }

    public final void emitGotoIfIntEqZero(Label label) {
        this.emitGotoIfCompare1(label, 153);
    }

    public final void emitGotoIfIntNeZero(Label label) {
        this.emitGotoIfCompare1(label, 154);
    }

    public final void emitGotoIfIntLtZero(Label label) {
        this.emitGotoIfCompare1(label, 155);
    }

    public final void emitGotoIfIntGeZero(Label label) {
        this.emitGotoIfCompare1(label, 156);
    }

    public final void emitGotoIfIntGtZero(Label label) {
        this.emitGotoIfCompare1(label, 157);
    }

    public final void emitGotoIfIntLeZero(Label label) {
        this.emitGotoIfCompare1(label, 158);
    }

    public final void emitGotoIfCompare2(Label label, int n) {
        boolean bl;
        if (n < 155 || n > 158) {
            throw new Error("emitGotoIfCompare2: logop must be one of iflt, ifgt, ifle, ifge");
        }
        Type type = this.popType().promote();
        Type type2 = this.popType().promote();
        this.reserve(4);
        char c = type2.getSignature().charAt(0);
        char c2 = type.getSignature().charAt(0);
        boolean bl2 = bl = n == 155 || n == 158;
        if (c == 'I' && c2 == 'I') {
            n += 6;
        } else if (c == 'J' && c2 == 'J') {
            this.put1(148);
        } else if (c == 'F' && c2 == 'F') {
            this.put1(bl ? 149 : 150);
        } else if (c == 'D' && c2 == 'D') {
            this.put1(bl ? 151 : 152);
        } else {
            throw new Error("non-matching types to emitGotoIfCompare2");
        }
        this.emitTransfer(label, n);
    }

    public final void emitGotoIfLt(Label label) {
        this.emitGotoIfCompare2(label, 155);
    }

    public final void emitGotoIfGe(Label label) {
        this.emitGotoIfCompare2(label, 156);
    }

    public final void emitGotoIfGt(Label label) {
        this.emitGotoIfCompare2(label, 157);
    }

    public final void emitGotoIfLe(Label label) {
        this.emitGotoIfCompare2(label, 158);
    }

    public final void emitIfCompare1(int n) {
        IfState ifState = new IfState(this);
        if (this.popType().promote() != Type.int_type) {
            throw new Error("non-int type to emitIfCompare1");
        }
        this.reserve(3);
        this.emitTransfer(ifState.end_label, n);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfIntNotZero() {
        this.emitIfCompare1(153);
    }

    public final void emitIfIntLEqZero() {
        this.emitIfCompare1(157);
    }

    public final void emitIfRefCompare1(int n) {
        IfState ifState = new IfState(this);
        if (!(this.popType() instanceof ObjectType)) {
            throw new Error("non-ref type to emitIfRefCompare1");
        }
        this.reserve(3);
        this.emitTransfer(ifState.end_label, n);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfNotNull() {
        this.emitIfRefCompare1(198);
    }

    public final void emitIfNull() {
        this.emitIfRefCompare1(199);
    }

    public final void emitIfIntCompare(int n) {
        IfState ifState = new IfState(this);
        this.popType();
        this.popType();
        this.reserve(3);
        this.emitTransfer(ifState.end_label, n);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfIntLt() {
        this.emitIfIntCompare(162);
    }

    public final void emitIfNEq() {
        IfState ifState = new IfState(this);
        this.emitGotoIfEq(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfEq() {
        IfState ifState = new IfState(this);
        this.emitGotoIfNE(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfLt() {
        IfState ifState = new IfState(this);
        this.emitGotoIfGe(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfGe() {
        IfState ifState = new IfState(this);
        this.emitGotoIfLt(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfGt() {
        IfState ifState = new IfState(this);
        this.emitGotoIfLe(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public final void emitIfLe() {
        IfState ifState = new IfState(this);
        this.emitGotoIfGt(ifState.end_label);
        ifState.start_stack_size = this.SP;
    }

    public void emitRet(Variable variable) {
        int n = variable.offset;
        if (n < 256) {
            this.reserve(2);
            this.put1(169);
            this.put1(n);
        } else {
            this.reserve(4);
            this.put1(196);
            this.put1(169);
            this.put2(n);
        }
    }

    public final void emitIfThen() {
        new IfState(this, null);
    }

    public final void emitElse() {
        Label label;
        Label label2 = this.if_stack.end_label;
        this.if_stack.end_label = label = new Label(this);
        if (this.reachableHere()) {
            int n;
            this.if_stack.stack_growth = n = this.SP - this.if_stack.start_stack_size;
            if (n >= 0) {
                this.if_stack.then_stacked_types = new Type[n];
                System.arraycopy(this.stack_types, this.if_stack.start_stack_size, this.if_stack.then_stacked_types, 0, n);
            } else {
                this.if_stack.then_stacked_types = new Type[0];
            }
            this.emitGoto(label);
        }
        while (this.SP > this.if_stack.start_stack_size) {
            this.popType();
        }
        this.SP = this.if_stack.start_stack_size;
        if (label2 != null) {
            label2.define(this);
        }
        this.if_stack.doing_else = true;
    }

    public final void emitFi() {
        boolean bl = false;
        if (!this.if_stack.doing_else) {
            if (this.reachableHere() && this.SP != this.if_stack.start_stack_size) {
                throw new Error("at PC " + this.PC + " then clause grows stack with no else clause");
            }
        } else if (this.if_stack.then_stacked_types != null) {
            int n = this.if_stack.start_stack_size + this.if_stack.stack_growth;
            if (!this.reachableHere()) {
                if (this.if_stack.stack_growth > 0) {
                    System.arraycopy(this.if_stack.then_stacked_types, 0, this.stack_types, this.if_stack.start_stack_size, this.if_stack.stack_growth);
                }
                this.SP = n;
            } else if (this.SP != n) {
                throw new Error("at PC " + this.PC + ": SP at end of 'then' was " + n + " while SP at end of 'else' was " + this.SP);
            }
        } else if (this.unreachable_here) {
            bl = true;
        }
        if (this.if_stack.end_label != null) {
            this.if_stack.end_label.define(this);
        }
        if (bl) {
            this.setUnreachable();
        }
        this.if_stack = this.if_stack.previous;
    }

    public final void emitConvert(Type type, Type type2) {
        String string = type2.getSignature();
        String string2 = type.getSignature();
        int n = -1;
        if (string.length() == 1 || string2.length() == 1) {
            int n2 = string.charAt(0);
            int n3 = string2.charAt(0);
            if (n3 == n2) {
                return;
            }
            if (type.size < 4) {
                n3 = 73;
            }
            if (type2.size < 4) {
                this.emitConvert(type, Type.int_type);
                n3 = 73;
            }
            if (n3 == n2) {
                return;
            }
            block0 : switch (n3) {
                case 73: {
                    switch (n2) {
                        case 66: {
                            n = 145;
                            break;
                        }
                        case 67: {
                            n = 146;
                            break;
                        }
                        case 83: {
                            n = 147;
                            break;
                        }
                        case 74: {
                            n = 133;
                            break;
                        }
                        case 70: {
                            n = 134;
                            break;
                        }
                        case 68: {
                            n = 135;
                        }
                    }
                    break;
                }
                case 74: {
                    switch (n2) {
                        case 73: {
                            n = 136;
                            break;
                        }
                        case 70: {
                            n = 137;
                            break;
                        }
                        case 68: {
                            n = 138;
                        }
                    }
                    break;
                }
                case 70: {
                    switch (n2) {
                        case 73: {
                            n = 139;
                            break;
                        }
                        case 74: {
                            n = 140;
                            break;
                        }
                        case 68: {
                            n = 141;
                        }
                    }
                    break;
                }
                case 68: {
                    switch (n2) {
                        case 73: {
                            n = 142;
                            break block0;
                        }
                        case 74: {
                            n = 143;
                            break block0;
                        }
                        case 70: {
                            n = 144;
                        }
                    }
                }
            }
        }
        if (n < 0) {
            throw new Error("unsupported CodeAttr.emitConvert");
        }
        this.reserve(1);
        this.popType();
        this.put1(n);
        this.pushType(type2);
    }

    private void emitCheckcast(Type type, int n) {
        this.reserve(3);
        this.popType();
        this.put1(n);
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            CpoolUtf8 cpoolUtf8 = this.getConstants().addUtf8(arrayType.signature);
            this.putIndex2(this.getConstants().addClass(cpoolUtf8));
        } else if (type instanceof ClassType) {
            this.putIndex2(this.getConstants().addClass((ClassType)type));
        } else {
            throw new Error("unimplemented type " + type + " in emitCheckcast/emitInstanceof");
        }
    }

    public void emitCheckcast(Type type) {
        this.emitCheckcast(type, 192);
        this.pushType(type);
    }

    public void emitInstanceof(Type type) {
        this.emitCheckcast(type, 193);
        this.pushType(Type.boolean_type);
    }

    public final void emitThrow() {
        this.popType();
        this.reserve(1);
        this.put1(191);
        this.setUnreachable();
    }

    public final void emitMonitorEnter() {
        this.popType();
        this.reserve(1);
        this.put1(194);
    }

    public final void emitMonitorExit() {
        this.popType();
        this.reserve(1);
        this.put1(195);
    }

    public final void emitReturn() {
        if (this.getMethod().getReturnType().size == 0) {
            this.reserve(1);
            this.put1(177);
        } else {
            this.emitTypedOp(172, this.popType().promote());
        }
        this.setUnreachable();
    }

    public void addHandler(int n, int n2, int n3, int n4) {
        int n5 = 4 * this.exception_table_length;
        if (this.exception_table == null) {
            this.exception_table = new short[20];
        } else if (this.exception_table.length <= n5) {
            short[] sArray = new short[2 * this.exception_table.length];
            System.arraycopy(this.exception_table, 0, sArray, 0, n5);
            this.exception_table = sArray;
        }
        this.exception_table[n5++] = (short)n;
        this.exception_table[n5++] = (short)n2;
        this.exception_table[n5++] = (short)n3;
        this.exception_table[n5++] = (short)n4;
        ++this.exception_table_length;
    }

    public void addHandler(int n, int n2, int n3, ClassType classType, ConstantPool constantPool) {
        int n4 = classType == null ? 0 : constantPool.addClass((ObjectType)classType).index;
        this.addHandler(n, n2, n3, n4);
    }

    public void emitTryStart(boolean bl, Type type) {
        Variable[] variableArray;
        if (this.SP > 0) {
            variableArray = new Variable[this.SP];
            int n = 0;
            while (this.SP > 0) {
                Variable variable = this.addLocal(this.topType());
                this.emitStore(variable);
                variableArray[n++] = variable;
            }
        } else {
            variableArray = null;
        }
        TryState tryState = new TryState(this);
        tryState.savedStack = variableArray;
        if (type != null && type.size == 0) {
            type = null;
        }
        if (type != null || this.SP > 0) {
            this.pushScope();
            if (type != null) {
                tryState.saved_result = this.addLocal(type);
            }
        }
        if (bl) {
            tryState.finally_subr = new Label(this);
        }
    }

    public void emitTryEnd() {
        if (this.try_stack.end_label == null) {
            if (this.try_stack.saved_result != null) {
                this.emitStore(this.try_stack.saved_result);
            }
            this.try_stack.end_label = new Label(this);
            if (this.reachableHere()) {
                if (this.try_stack.finally_subr != null) {
                    this.emitGoto(this.try_stack.finally_subr, 168);
                }
                this.emitGoto(this.try_stack.end_label);
            }
            this.readPC = this.PC;
            this.try_stack.end_pc = this.PC;
        }
    }

    public void emitCatchStart(Variable variable) {
        ClassType classType;
        this.emitTryEnd();
        this.SP = 0;
        if (this.try_stack.try_type != null) {
            this.emitCatchEnd();
        }
        this.try_stack.try_type = classType = variable == null ? null : (ClassType)variable.getType();
        this.readPC = this.PC;
        this.addHandler(this.try_stack.start_pc, this.try_stack.end_pc, this.PC, classType, this.getConstants());
        if (variable != null) {
            this.pushType(classType);
            this.emitStore(variable);
        } else {
            this.pushType(Type.throwable_type);
        }
    }

    public void emitCatchEnd() {
        if (this.reachableHere()) {
            if (this.try_stack.saved_result != null) {
                this.emitStore(this.try_stack.saved_result);
            }
            if (this.try_stack.finally_subr != null) {
                this.emitGoto(this.try_stack.finally_subr, 168);
            }
            this.emitGoto(this.try_stack.end_label);
        }
        this.try_stack.try_type = null;
    }

    public void emitFinallyStart() {
        this.emitTryEnd();
        if (this.try_stack.try_type != null) {
            this.emitCatchEnd();
        }
        this.readPC = this.PC;
        this.SP = 0;
        this.try_stack.end_pc = this.PC;
        this.pushScope();
        ClassType classType = Type.pointer_type;
        Variable variable = this.addLocal(classType);
        this.emitCatchStart(null);
        this.emitStore(variable);
        this.emitGoto(this.try_stack.finally_subr, 168);
        this.emitLoad(variable);
        this.emitThrow();
        this.try_stack.finally_subr.define(this);
        ClassType classType2 = Type.pointer_type;
        this.try_stack.finally_ret_addr = this.addLocal(classType2);
        this.pushType(classType2);
        this.emitStore(this.try_stack.finally_ret_addr);
    }

    public void emitFinallyEnd() {
        this.emitRet(this.try_stack.finally_ret_addr);
        this.setUnreachable();
        this.popScope();
        this.try_stack.finally_subr = null;
    }

    public void emitTryCatchEnd() {
        if (this.try_stack.finally_subr != null) {
            this.emitFinallyEnd();
        }
        this.try_stack.end_label.define(this);
        Variable[] variableArray = this.try_stack.savedStack;
        if (variableArray != null) {
            int n = variableArray.length;
            while (--n >= 0) {
                Variable variable = variableArray[n];
                if (variable == null) continue;
                this.emitLoad(variable);
            }
        }
        if (this.try_stack.saved_result != null) {
            this.emitLoad(this.try_stack.saved_result);
        }
        if (this.try_stack.saved_result != null || variableArray != null) {
            this.popScope();
        }
        this.try_stack = this.try_stack.previous;
    }

    public final boolean isInTry() {
        return this.try_stack != null;
    }

    public void emitTailCall(boolean bl, Scope scope) {
        int n;
        if (bl) {
            Method method = this.getMethod();
            n = (method.access_flags & 8) != 0 ? 0 : 1;
            int n2 = method.arg_types.length;
            while (--n2 >= 0) {
                n += method.arg_types[n2].size > 4 ? 2 : 1;
            }
            int n3 = method.arg_types.length;
            while (--n3 >= 0) {
                this.emitStore(this.locals.used[n -= method.arg_types[n3].size > 4 ? 2 : 1]);
            }
        }
        this.reserve(5);
        int n4 = scope.start_pc;
        n = n4 - this.PC;
        if (n < Short.MIN_VALUE) {
            this.put1(200);
            this.put4(n);
        } else {
            this.put1(167);
            this.put2(n);
        }
        this.setUnreachable();
    }

    void reorder_fixups() {
        Label label = null;
        Label label2 = null;
        Label label3 = null;
        int n = this.PC + 100;
        Label label4 = this.labels;
        while (label4 != null) {
            if (label4.fixups != null && label4.fixups[0] < n) {
                label2 = label4;
                label3 = label;
                n = label4.fixups[0];
            }
            label = label4;
            label4 = label4.next;
        }
        if (label2 != this.labels && label2 != null) {
            label3.next = label2.next;
            label2.next = this.labels;
            this.labels = label2;
        }
    }

    public void finalize_labels() {
        while (this.labels != null && this.labels.fixups != null) {
            this.labels.emit_spring(this);
        }
        Label label = this.labels;
        while (label != null) {
            if (label.fixups != null || label.wide_fixups != null) {
                throw new Error("undefined label");
            }
            label = label.next;
        }
    }

    public void assignConstants(ClassType classType) {
        CodeFragment codeFragment;
        super.assignConstants(classType);
        while ((codeFragment = this.fragments) != null) {
            this.fragments = codeFragment.next;
            codeFragment.emit(this);
        }
        if (this.locals != null && this.locals.container == null && !this.locals.isEmpty()) {
            this.locals.addToFrontOf(this);
        }
        Attribute.assignConstants(this, classType);
        this.finalize_labels();
    }

    public final int getLength() {
        return 12 + this.getCodeLength() + 8 * this.exception_table_length + Attribute.getLengthAll(this);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.max_stack);
        dataOutputStream.writeShort(this.max_locals);
        dataOutputStream.writeInt(this.PC);
        dataOutputStream.write(this.code, 0, this.PC);
        dataOutputStream.writeShort(this.exception_table_length);
        int n = this.exception_table_length;
        int n2 = 0;
        while (--n >= 0) {
            dataOutputStream.writeShort(this.exception_table[n2]);
            dataOutputStream.writeShort(this.exception_table[n2 + 1]);
            dataOutputStream.writeShort(this.exception_table[n2 + 2]);
            dataOutputStream.writeShort(this.exception_table[n2 + 3]);
            n2 += 4;
        }
        Attribute.writeAll(this, dataOutputStream);
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", max_stack:");
        classTypeWriter.print(this.max_stack);
        classTypeWriter.print(", max_locals:");
        classTypeWriter.print(this.max_locals);
        classTypeWriter.print(", code_length:");
        int n = this.getCodeLength();
        classTypeWriter.println(n);
        this.disAssemble(classTypeWriter, 0, n);
        if (this.exception_table_length > 0) {
            classTypeWriter.print("Exceptions (count: ");
            classTypeWriter.print(this.exception_table_length);
            classTypeWriter.println("):");
            int n2 = this.exception_table_length;
            int n3 = 0;
            while (--n2 >= 0) {
                classTypeWriter.print("  start: ");
                classTypeWriter.print(this.exception_table[n3] & 0xFFFF);
                classTypeWriter.print(", end: ");
                classTypeWriter.print(this.exception_table[n3 + 1] & 0xFFFF);
                classTypeWriter.print(", handler: ");
                classTypeWriter.print(this.exception_table[n3 + 2] & 0xFFFF);
                classTypeWriter.print(", type: ");
                int n4 = this.exception_table[n3 + 3] & 0xFFFF;
                if (n4 == 0) {
                    classTypeWriter.print("0 /* finally */");
                } else {
                    classTypeWriter.printOptionalIndex(n4);
                    classTypeWriter.printConstantTersely(n4, 7);
                }
                classTypeWriter.println();
                n3 += 4;
            }
        }
        classTypeWriter.printAttributes(this);
    }

    public void disAssemble(ClassTypeWriter classTypeWriter, int n, int n2) {
        boolean bl = false;
        int n3 = n;
        while (n3 < n2) {
            int n4;
            int n5 = n3++;
            int n6 = this.code[n5] & 0xFF;
            String string = Integer.toString(n5);
            int n7 = 0;
            int n8 = string.length();
            while (++n8 <= 3) {
                classTypeWriter.print(' ');
            }
            classTypeWriter.print(string);
            classTypeWriter.print(": ");
            if (n6 < 120) {
                if (n6 < 87) {
                    if (n6 < 3) {
                        this.print("nop;aconst_null;iconst_m1;", n6, classTypeWriter);
                    } else if (n6 < 9) {
                        classTypeWriter.print("iconst_");
                        classTypeWriter.print(n6 - 3);
                    } else if (n6 < 16) {
                        char c;
                        if (n6 < 11) {
                            c = 'l';
                            n6 -= 9;
                        } else if (n6 < 14) {
                            c = 'f';
                            n6 -= 11;
                        } else {
                            c = 'd';
                            n6 -= 14;
                        }
                        classTypeWriter.print(c);
                        classTypeWriter.print("const_");
                        classTypeWriter.print(n6);
                    } else if (n6 < 21) {
                        if (n6 < 18) {
                            short s;
                            this.print("bipush ;sipush ;", n6 - 16, classTypeWriter);
                            if (n6 == 16) {
                                s = this.code[n3++];
                            } else {
                                s = (short)this.readUnsignedShort(n3);
                                n3 += 2;
                            }
                            classTypeWriter.print(s);
                        } else {
                            n7 = n6 == 18 ? 1 : 2;
                            this.print("ldc;ldc_w;ldc2_w;", n6 - 18, classTypeWriter);
                        }
                    } else {
                        String string2;
                        if (n6 < 54) {
                            string2 = "load";
                        } else {
                            string2 = "store";
                            n6 -= 33;
                        }
                        if (n6 < 26) {
                            n4 = -1;
                            n6 -= 21;
                        } else if (n6 < 46) {
                            n4 = (n6 -= 26) % 4;
                            n6 >>= 2;
                        } else {
                            n4 = -2;
                            n6 -= 46;
                        }
                        classTypeWriter.print("ilfdabcs".charAt(n6));
                        if (n4 == -2) {
                            classTypeWriter.write(97);
                        }
                        classTypeWriter.print(string2);
                        if (n4 >= 0) {
                            classTypeWriter.write(95);
                            classTypeWriter.print(n4);
                        } else if (n4 == -1) {
                            if (bl) {
                                n4 = this.readUnsignedShort(n3);
                                n3 += 2;
                            } else {
                                n4 = this.code[n3] & 0xFF;
                                ++n3;
                            }
                            bl = false;
                            classTypeWriter.print(' ');
                            classTypeWriter.print(n4);
                        }
                    }
                } else if (n6 < 96) {
                    this.print("pop;pop2;dup;dup_x1;dup_x2;dup2;dup2_x1;dup2_x2;swap;", n6 - 87, classTypeWriter);
                } else {
                    classTypeWriter.print("ilfda".charAt((n6 - 96) % 4));
                    this.print("add;sub;mul;div;rem;neg;", n6 - 96 >> 2, classTypeWriter);
                }
            } else if (n6 < 170) {
                if (n6 < 132) {
                    classTypeWriter.print((n6 & 1) == 0 ? (char)'i' : 'l');
                    this.print("shl;shr;ushr;and;or;xor;", n6 - 120 >> 1, classTypeWriter);
                } else if (n6 == 132) {
                    int n9;
                    classTypeWriter.print("iinc");
                    if (!bl) {
                        n9 = 0xFF & this.code[n3++];
                        n4 = this.code[n3++];
                    } else {
                        n9 = this.readUnsignedShort(n3);
                        n4 = this.readUnsignedShort(n3 += 2);
                        n3 += 2;
                        bl = false;
                    }
                    classTypeWriter.print(' ');
                    classTypeWriter.print(n9);
                    classTypeWriter.print(' ');
                    classTypeWriter.print(n4);
                } else if (n6 < 148) {
                    classTypeWriter.print("ilfdi".charAt((n6 - 133) / 3));
                    classTypeWriter.print('2');
                    classTypeWriter.print("lfdifdildilfbcs".charAt(n6 - 133));
                } else if (n6 < 153) {
                    this.print("lcmp;fcmpl;fcmpg;dcmpl;dcmpg;", n6 - 148, classTypeWriter);
                } else if (n6 < 169) {
                    if (n6 < 159) {
                        classTypeWriter.print("if");
                        this.print("eq;ne;lt;ge;gt;le;", n6 - 153, classTypeWriter);
                    } else if (n6 < 167) {
                        if (n6 < 165) {
                            classTypeWriter.print("if_icmp");
                        } else {
                            classTypeWriter.print("if_acmp");
                            n6 -= 6;
                        }
                        this.print("eq;ne;lt;ge;gt;le;", n6 - 159, classTypeWriter);
                    } else {
                        this.print("goto;jsr;", n6 - 167, classTypeWriter);
                    }
                    short s = (short)this.readUnsignedShort(n3);
                    n3 += 2;
                    classTypeWriter.print(' ');
                    classTypeWriter.print(n5 + s);
                } else {
                    int n10;
                    classTypeWriter.print("ret ");
                    if (bl) {
                        n10 = this.readUnsignedShort(n3);
                        n10 += 2;
                    } else {
                        n10 = this.code[n3] & 0xFF;
                        ++n3;
                    }
                    bl = false;
                    classTypeWriter.print(n10);
                }
            } else if (n6 < 172) {
                int n11;
                n3 = n3 + 3 & 0xFFFFFFFC;
                int n12 = this.readInt(n3);
                n3 += 4;
                if (n6 == 170) {
                    classTypeWriter.print("tableswitch");
                    n4 = this.readInt(n3);
                    n11 = this.readInt(n3 += 4);
                    n3 += 4;
                    classTypeWriter.print(" low: ");
                    classTypeWriter.print(n4);
                    classTypeWriter.print(" high: ");
                    classTypeWriter.print(n11);
                    classTypeWriter.print(" default: ");
                    classTypeWriter.print(n5 + n12);
                    while (n4 <= n11) {
                        n12 = this.readInt(n3);
                        n3 += 4;
                        classTypeWriter.println();
                        classTypeWriter.print("  ");
                        classTypeWriter.print(n4);
                        classTypeWriter.print(": ");
                        classTypeWriter.print(n5 + n12);
                        ++n4;
                    }
                } else {
                    classTypeWriter.print("lookupswitch");
                    n4 = this.readInt(n3);
                    n3 += 4;
                    classTypeWriter.print(" npairs: ");
                    classTypeWriter.print(n4);
                    classTypeWriter.print(" default: ");
                    classTypeWriter.print(n5 + n12);
                    while (--n4 >= 0) {
                        n11 = this.readInt(n3);
                        n12 = this.readInt(n3 += 4);
                        n3 += 4;
                        classTypeWriter.println();
                        classTypeWriter.print("  ");
                        classTypeWriter.print(n11);
                        classTypeWriter.print(": ");
                        classTypeWriter.print(n5 + n12);
                    }
                }
            } else if (n6 < 178) {
                if (n6 < 177) {
                    classTypeWriter.print("ilfda".charAt(n6 - 172));
                }
                classTypeWriter.print("return");
            } else if (n6 < 182) {
                this.print("getstatic;putstatic;getfield;putfield;", n6 - 178, classTypeWriter);
                n7 = 2;
            } else if (n6 < 185) {
                classTypeWriter.print("invoke");
                this.print("virtual;special;static;", n6 - 182, classTypeWriter);
                n7 = 2;
            } else if (n6 == 185) {
                classTypeWriter.print("invokeinterface (");
                int n13 = this.readUnsignedShort(n3);
                n4 = 0xFF & this.code[n3 += 2];
                n3 += 2;
                classTypeWriter.print(n4 + " args)");
                classTypeWriter.printConstantOperand(n13);
            } else if (n6 < 196) {
                this.print("186;new;newarray;anewarray;arraylength;athrow;checkcast;instanceof;monitorenter;monitorexit;", n6 - 186, classTypeWriter);
                if (n6 == 187 || n6 == 189 || n6 == 192 || n6 == 193) {
                    n7 = 2;
                } else if (n6 == 188) {
                    byte by = this.code[n3++];
                    classTypeWriter.print(' ');
                    if (by >= 4 && by <= 11) {
                        this.print("boolean;char;float;double;byte;short;int;long;", by - 4, classTypeWriter);
                    } else {
                        classTypeWriter.print(by);
                    }
                }
            } else if (n6 == 196) {
                classTypeWriter.print("wide");
                bl = true;
            } else if (n6 == 197) {
                classTypeWriter.print("multianewarray");
                int n14 = this.readUnsignedShort(n3);
                n3 += 2;
                classTypeWriter.printConstantOperand(n14);
                n4 = 0xFF & this.code[n3++];
                classTypeWriter.print(' ');
                classTypeWriter.print(n4);
            } else if (n6 < 200) {
                this.print("ifnull;ifnonnull;", n6 - 198, classTypeWriter);
                short s = (short)this.readUnsignedShort(n3);
                n3 += 2;
                classTypeWriter.print(' ');
                classTypeWriter.print(n5 + s);
            } else if (n6 < 202) {
                this.print("goto_w;jsr_w;", n6 - 200, classTypeWriter);
                int n15 = this.readInt(n3);
                n3 += 4;
                classTypeWriter.print(' ');
                classTypeWriter.print(n5 + n15);
            } else {
                classTypeWriter.print(n6);
            }
            if (n7 > 0) {
                int n16;
                if (n7 == 1) {
                    n16 = 0xFF & this.code[n3++];
                } else {
                    n16 = this.readUnsignedShort(n3);
                    n3 += 2;
                }
                classTypeWriter.printConstantOperand(n16);
            }
            classTypeWriter.println();
        }
    }

    private int readUnsignedShort(int n) {
        return (0xFF & this.code[n]) << 8 | 0xFF & this.code[n + 1];
    }

    private int readInt(int n) {
        return this.readUnsignedShort(n) << 16 | this.readUnsignedShort(n + 2);
    }

    private void print(String string, int n, PrintWriter printWriter) {
        int n2 = 0;
        int n3 = -1;
        while (n >= 0) {
            n2 = ++n3;
            n3 = string.indexOf(59, n2);
            --n;
        }
        printWriter.write(string, n2, n3 - n2);
    }

    public Type[] saveStackTypeState(boolean bl) {
        if (this.SP == 0) {
            return null;
        }
        Type[] typeArray = new Type[this.SP];
        System.arraycopy(this.stack_types, 0, typeArray, 0, this.SP);
        if (bl) {
            this.SP = 0;
        }
        return typeArray;
    }

    public void restoreStackTypeState(Type[] typeArray) {
        if (typeArray == null) {
            this.SP = 0;
        } else {
            this.SP = typeArray.length;
            System.arraycopy(typeArray, 0, this.stack_types, 0, this.SP);
        }
    }

    public void beginFragment(boolean bl) {
        CodeFragment codeFragment = new CodeFragment(this);
        codeFragment.next = this.fragmentStack;
        this.fragmentStack = codeFragment;
        codeFragment.length = this.PC;
        codeFragment.unreachable_save = this.unreachable_here;
        this.unreachable_here = false;
        if (bl) {
            codeFragment.handlerIndex = this.exception_table_length - 1;
        }
    }

    public void endFragment() {
        CodeFragment codeFragment = this.fragmentStack;
        this.fragmentStack = codeFragment.next;
        codeFragment.next = this.fragments;
        this.fragments = codeFragment;
        int n = codeFragment.length;
        codeFragment.length = this.PC - n;
        codeFragment.insns = new byte[codeFragment.length];
        System.arraycopy(this.code, n, codeFragment.insns, 0, codeFragment.length);
        this.PC = n;
        this.unreachable_here = codeFragment.unreachable_save;
        if (this.lines != null) {
            int n2;
            int n3 = n2 = 2 * this.lines.linenumber_count;
            short[] sArray = this.lines.linenumber_table;
            while (n3 > 0 && sArray[n3 - 2] >= n) {
                n3 -= 2;
            }
            if ((n2 -= n3) > 0) {
                short[] sArray2 = new short[n2];
                int n4 = 0;
                while (n4 < n2) {
                    sArray2[n4] = (short)((sArray[n3 + n4] & 0xFFFF) - n);
                    sArray2[n4 + 1] = sArray[n3 + n4 + 1];
                    n4 += 2;
                }
                codeFragment.linenumbers = sArray2;
                this.lines.linenumber_count = n3 >> 1;
            }
        }
    }
}

