/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.sql.DataSource;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.sql.DataSourceUtil;

public abstract class TransactionTagSupport
extends TagSupport
implements TryCatchFinally {
    private static final String TRANSACTION_READ_COMMITTED = "read_committed";
    private static final String TRANSACTION_READ_UNCOMMITTED = "read_uncommitted";
    private static final String TRANSACTION_REPEATABLE_READ = "repeatable_read";
    private static final String TRANSACTION_SERIALIZABLE = "serializable";
    protected Object rawDataSource;
    protected boolean dataSourceSpecified;
    private Connection conn;
    private int isolation;
    private int origIsolation;

    public TransactionTagSupport() {
        this.init();
    }

    private void init() {
        this.conn = null;
        this.dataSourceSpecified = false;
        this.rawDataSource = null;
        this.isolation = 0;
    }

    public int doStartTag() throws JspException {
        if (this.rawDataSource == null && this.dataSourceSpecified) {
            throw new JspException(Resources.getMessage("SQL_DATASOURCE_NULL"));
        }
        DataSource dataSource = DataSourceUtil.getDataSource(this.rawDataSource, this.pageContext);
        try {
            this.conn = dataSource.getConnection();
            this.origIsolation = this.conn.getTransactionIsolation();
            if (this.origIsolation == 0) {
                throw new JspTagException(Resources.getMessage("TRANSACTION_NO_SUPPORT"));
            }
            if (this.isolation != 0 && this.isolation != this.origIsolation) {
                this.conn.setTransactionIsolation(this.isolation);
            }
            this.conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new JspTagException(Resources.getMessage("ERROR_GET_CONNECTION", e.toString()), (Throwable)e);
        }
        return 1;
    }

    public int doEndTag() throws JspException {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new JspTagException(Resources.getMessage("TRANSACTION_COMMIT_ERROR", e.toString()), (Throwable)e);
        }
        return 6;
    }

    public void doCatch(Throwable t) throws Throwable {
        block2: {
            if (this.conn == null) break block2;
            try {
                this.conn.rollback();
            }
            catch (SQLException e) {}
        }
        throw t;
    }

    public void doFinally() {
        if (this.conn != null) {
            try {
                if (this.isolation != 0 && this.isolation != this.origIsolation) {
                    this.conn.setTransactionIsolation(this.origIsolation);
                }
                this.conn.setAutoCommit(true);
                this.conn.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        this.conn = null;
    }

    public void release() {
        this.init();
    }

    public void setIsolation(String iso) throws JspTagException {
        if (TRANSACTION_READ_COMMITTED.equals(iso)) {
            this.isolation = 2;
        } else if (TRANSACTION_READ_UNCOMMITTED.equals(iso)) {
            this.isolation = 1;
        } else if (TRANSACTION_REPEATABLE_READ.equals(iso)) {
            this.isolation = 4;
        } else if (TRANSACTION_SERIALIZABLE.equals(iso)) {
            this.isolation = 8;
        } else {
            throw new JspTagException(Resources.getMessage("TRANSACTION_INVALID_ISOLATION"));
        }
    }

    public Connection getSharedConnection() {
        return this.conn;
    }
}

