/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Arrays;

public class BarcodeEAN
extends Barcode {
    static int[] GUARD_EMPTY = new int[0];
    static int[] GUARD_UPCA;
    static int[] GUARD_EAN13;
    static int[] GUARD_EAN8;
    static int[] GUARD_UPCE;
    static float[] TEXTPOS_EAN13;
    static float[] TEXTPOS_EAN8;
    static byte[][] BARS;
    static final int TOTALBARS_EAN13 = 59;
    static final int TOTALBARS_EAN8 = 43;
    static final int TOTALBARS_UPCE = 33;
    static final int TOTALBARS_SUPP2 = 13;
    static final int TOTALBARS_SUPP5 = 31;
    static final int ODD = 0;
    static final int EVEN = 1;
    static byte[][] PARITY13;
    static byte[][] PARITY2;
    static byte[][] PARITY5;
    static byte[][] PARITYE;

    static {
        int[] nArray = new int[10];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 6;
        nArray[4] = 28;
        nArray[5] = 30;
        nArray[6] = 52;
        nArray[7] = 54;
        nArray[8] = 56;
        nArray[9] = 58;
        GUARD_UPCA = nArray;
        int[] nArray2 = new int[6];
        nArray2[1] = 2;
        nArray2[2] = 28;
        nArray2[3] = 30;
        nArray2[4] = 56;
        nArray2[5] = 58;
        GUARD_EAN13 = nArray2;
        int[] nArray3 = new int[6];
        nArray3[1] = 2;
        nArray3[2] = 20;
        nArray3[3] = 22;
        nArray3[4] = 40;
        nArray3[5] = 42;
        GUARD_EAN8 = nArray3;
        int[] nArray4 = new int[5];
        nArray4[1] = 2;
        nArray4[2] = 28;
        nArray4[3] = 30;
        nArray4[4] = 32;
        GUARD_UPCE = nArray4;
        TEXTPOS_EAN13 = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 34.5f, 41.5f, 53.5f, 60.5f, 67.5f, 74.5f, 81.5f, 88.5f};
        TEXTPOS_EAN8 = new float[]{6.5f, 13.5f, 20.5f, 27.5f, 39.5f, 46.5f, 53.5f, 60.5f};
        BARS = new byte[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
        byte[][] byArrayArray = new byte[10][];
        byArrayArray[0] = new byte[6];
        byte[] byArray = new byte[6];
        byArray[2] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArrayArray[1] = byArray;
        byte[] byArray2 = new byte[6];
        byArray2[2] = 1;
        byArray2[3] = 1;
        byArray2[5] = 1;
        byArrayArray[2] = byArray2;
        byte[] byArray3 = new byte[6];
        byArray3[2] = 1;
        byArray3[3] = 1;
        byArray3[4] = 1;
        byArrayArray[3] = byArray3;
        byte[] byArray4 = new byte[6];
        byArray4[1] = 1;
        byArray4[4] = 1;
        byArray4[5] = 1;
        byArrayArray[4] = byArray4;
        byte[] byArray5 = new byte[6];
        byArray5[1] = 1;
        byArray5[2] = 1;
        byArray5[5] = 1;
        byArrayArray[5] = byArray5;
        byte[] byArray6 = new byte[6];
        byArray6[1] = 1;
        byArray6[2] = 1;
        byArray6[3] = 1;
        byArrayArray[6] = byArray6;
        byte[] byArray7 = new byte[6];
        byArray7[1] = 1;
        byArray7[3] = 1;
        byArray7[5] = 1;
        byArrayArray[7] = byArray7;
        byte[] byArray8 = new byte[6];
        byArray8[1] = 1;
        byArray8[3] = 1;
        byArray8[4] = 1;
        byArrayArray[8] = byArray8;
        byte[] byArray9 = new byte[6];
        byArray9[1] = 1;
        byArray9[2] = 1;
        byArray9[4] = 1;
        byArrayArray[9] = byArray9;
        PARITY13 = byArrayArray;
        byte[][] byArrayArray2 = new byte[4][];
        byArrayArray2[0] = new byte[2];
        byte[] byArray10 = new byte[2];
        byArray10[1] = 1;
        byArrayArray2[1] = byArray10;
        byte[] byArray11 = new byte[2];
        byArray11[0] = 1;
        byArrayArray2[2] = byArray11;
        byArrayArray2[3] = new byte[]{1, 1};
        PARITY2 = byArrayArray2;
        byte[][] byArrayArray3 = new byte[10][];
        byte[] byArray12 = new byte[5];
        byArray12[0] = 1;
        byArray12[1] = 1;
        byArrayArray3[0] = byArray12;
        byte[] byArray13 = new byte[5];
        byArray13[0] = 1;
        byArray13[2] = 1;
        byArrayArray3[1] = byArray13;
        byte[] byArray14 = new byte[5];
        byArray14[0] = 1;
        byArray14[3] = 1;
        byArrayArray3[2] = byArray14;
        byte[] byArray15 = new byte[5];
        byArray15[0] = 1;
        byArray15[4] = 1;
        byArrayArray3[3] = byArray15;
        byte[] byArray16 = new byte[5];
        byArray16[1] = 1;
        byArray16[2] = 1;
        byArrayArray3[4] = byArray16;
        byte[] byArray17 = new byte[5];
        byArray17[2] = 1;
        byArray17[3] = 1;
        byArrayArray3[5] = byArray17;
        byte[] byArray18 = new byte[5];
        byArray18[3] = 1;
        byArray18[4] = 1;
        byArrayArray3[6] = byArray18;
        byte[] byArray19 = new byte[5];
        byArray19[1] = 1;
        byArray19[3] = 1;
        byArrayArray3[7] = byArray19;
        byte[] byArray20 = new byte[5];
        byArray20[1] = 1;
        byArray20[4] = 1;
        byArrayArray3[8] = byArray20;
        byte[] byArray21 = new byte[5];
        byArray21[2] = 1;
        byArray21[4] = 1;
        byArrayArray3[9] = byArray21;
        PARITY5 = byArrayArray3;
        byte[][] byArrayArray4 = new byte[10][];
        byte[] byArray22 = new byte[6];
        byArray22[0] = 1;
        byArray22[1] = 1;
        byArray22[2] = 1;
        byArrayArray4[0] = byArray22;
        byte[] byArray23 = new byte[6];
        byArray23[0] = 1;
        byArray23[1] = 1;
        byArray23[3] = 1;
        byArrayArray4[1] = byArray23;
        byte[] byArray24 = new byte[6];
        byArray24[0] = 1;
        byArray24[1] = 1;
        byArray24[4] = 1;
        byArrayArray4[2] = byArray24;
        byte[] byArray25 = new byte[6];
        byArray25[0] = 1;
        byArray25[1] = 1;
        byArray25[5] = 1;
        byArrayArray4[3] = byArray25;
        byte[] byArray26 = new byte[6];
        byArray26[0] = 1;
        byArray26[2] = 1;
        byArray26[3] = 1;
        byArrayArray4[4] = byArray26;
        byte[] byArray27 = new byte[6];
        byArray27[0] = 1;
        byArray27[3] = 1;
        byArray27[4] = 1;
        byArrayArray4[5] = byArray27;
        byte[] byArray28 = new byte[6];
        byArray28[0] = 1;
        byArray28[4] = 1;
        byArray28[5] = 1;
        byArrayArray4[6] = byArray28;
        byte[] byArray29 = new byte[6];
        byArray29[0] = 1;
        byArray29[2] = 1;
        byArray29[4] = 1;
        byArrayArray4[7] = byArray29;
        byte[] byArray30 = new byte[6];
        byArray30[0] = 1;
        byArray30[2] = 1;
        byArray30[5] = 1;
        byArrayArray4[8] = byArray30;
        byte[] byArray31 = new byte[6];
        byArray31[0] = 1;
        byArray31[3] = 1;
        byArray31[5] = 1;
        byArrayArray4[9] = byArray31;
        PARITYE = byArrayArray4;
    }

    public BarcodeEAN() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.guardBars = true;
            this.codeType = 1;
            this.code = "";
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public static int calculateEANParity(String string) {
        int n = 3;
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            int n4 = string.charAt(n3) - 48;
            n2 += n * n4;
            n ^= 2;
            --n3;
        }
        return (10 - n2 % 10) % 10;
    }

    public static String convertUPCAtoUPCE(String string) {
        if (string.length() != 12 || !string.startsWith("0") && !string.startsWith("1")) {
            return null;
        }
        if (string.substring(3, 6).equals("000") || string.substring(3, 6).equals("100") || string.substring(3, 6).equals("200")) {
            if (string.substring(6, 8).equals("00")) {
                return String.valueOf(string.substring(0, 1)) + string.substring(1, 3) + string.substring(8, 11) + string.substring(3, 4) + string.substring(11);
            }
        } else if (string.substring(4, 6).equals("00")) {
            if (string.substring(6, 9).equals("000")) {
                return String.valueOf(string.substring(0, 1)) + string.substring(1, 4) + string.substring(9, 11) + "3" + string.substring(11);
            }
        } else if (string.substring(5, 6).equals("0")) {
            if (string.substring(6, 10).equals("0000")) {
                return String.valueOf(string.substring(0, 1)) + string.substring(1, 5) + string.substring(10, 11) + "4" + string.substring(11);
            }
        } else if (string.charAt(10) >= '5' && string.substring(6, 10).equals("0000")) {
            return String.valueOf(string.substring(0, 1)) + string.substring(1, 6) + string.substring(10, 11) + string.substring(11);
        }
        return null;
    }

    public static byte[] getBarsEAN13(String string) {
        byte[] byArray;
        int n;
        int[] nArray = new int[string.length()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = string.charAt(n2) - 48;
            ++n2;
        }
        byte[] byArray2 = new byte[59];
        int n3 = 0;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byte[] byArray3 = PARITY13[nArray[0]];
        int n4 = 0;
        while (n4 < byArray3.length) {
            n = nArray[n4 + 1];
            byArray = BARS[n];
            if (byArray3[n4] == 0) {
                byArray2[n3++] = byArray[0];
                byArray2[n3++] = byArray[1];
                byArray2[n3++] = byArray[2];
                byArray2[n3++] = byArray[3];
            } else {
                byArray2[n3++] = byArray[3];
                byArray2[n3++] = byArray[2];
                byArray2[n3++] = byArray[1];
                byArray2[n3++] = byArray[0];
            }
            ++n4;
        }
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        n4 = 7;
        while (n4 < 13) {
            n = nArray[n4];
            byArray = BARS[n];
            byArray2[n3++] = byArray[0];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[3];
            ++n4;
        }
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        return byArray2;
    }

    public static byte[] getBarsEAN8(String string) {
        byte[] byArray;
        int n;
        int[] nArray = new int[string.length()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = string.charAt(n2) - 48;
            ++n2;
        }
        byte[] byArray2 = new byte[43];
        int n3 = 0;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        int n4 = 0;
        while (n4 < 4) {
            n = nArray[n4];
            byArray = BARS[n];
            byArray2[n3++] = byArray[0];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[3];
            ++n4;
        }
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        n4 = 4;
        while (n4 < 8) {
            n = nArray[n4];
            byArray = BARS[n];
            byArray2[n3++] = byArray[0];
            byArray2[n3++] = byArray[1];
            byArray2[n3++] = byArray[2];
            byArray2[n3++] = byArray[3];
            ++n4;
        }
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        byArray2[n3++] = 1;
        return byArray2;
    }

    public static byte[] getBarsUPCE(String string) {
        int[] nArray = new int[string.length()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = string.charAt(n) - 48;
            ++n;
        }
        byte[] byArray = new byte[33];
        boolean bl = nArray[0] != 0;
        int n2 = 0;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byte[] byArray2 = PARITYE[nArray[nArray.length - 1]];
        int n3 = 1;
        while (n3 < nArray.length - 1) {
            int n4 = nArray[n3];
            byte[] byArray3 = BARS[n4];
            if (byArray2[n3 - 1] == (bl ? (byte)1 : 0)) {
                byArray[n2++] = byArray3[0];
                byArray[n2++] = byArray3[1];
                byArray[n2++] = byArray3[2];
                byArray[n2++] = byArray3[3];
            } else {
                byArray[n2++] = byArray3[3];
                byArray[n2++] = byArray3[2];
                byArray[n2++] = byArray3[1];
                byArray[n2++] = byArray3[0];
            }
            ++n3;
        }
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        return byArray;
    }

    public static byte[] getBarsSupplemental2(String string) {
        int[] nArray = new int[2];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = string.charAt(n) - 48;
            ++n;
        }
        byte[] byArray = new byte[13];
        int n2 = 0;
        int n3 = (nArray[0] * 10 + nArray[1]) % 4;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 2;
        byte[] byArray2 = PARITY2[n3];
        int n4 = 0;
        while (n4 < byArray2.length) {
            if (n4 == 1) {
                byArray[n2++] = 1;
                byArray[n2++] = 1;
            }
            int n5 = nArray[n4];
            byte[] byArray3 = BARS[n5];
            if (byArray2[n4] == 0) {
                byArray[n2++] = byArray3[0];
                byArray[n2++] = byArray3[1];
                byArray[n2++] = byArray3[2];
                byArray[n2++] = byArray3[3];
            } else {
                byArray[n2++] = byArray3[3];
                byArray[n2++] = byArray3[2];
                byArray[n2++] = byArray3[1];
                byArray[n2++] = byArray3[0];
            }
            ++n4;
        }
        return byArray;
    }

    public static byte[] getBarsSupplemental5(String string) {
        int[] nArray = new int[5];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = string.charAt(n) - 48;
            ++n;
        }
        byte[] byArray = new byte[31];
        int n2 = 0;
        int n3 = ((nArray[0] + nArray[2] + nArray[4]) * 3 + (nArray[1] + nArray[3]) * 9) % 10;
        byArray[n2++] = 1;
        byArray[n2++] = 1;
        byArray[n2++] = 2;
        byte[] byArray2 = PARITY5[n3];
        int n4 = 0;
        while (n4 < byArray2.length) {
            if (n4 != 0) {
                byArray[n2++] = 1;
                byArray[n2++] = 1;
            }
            int n5 = nArray[n4];
            byte[] byArray3 = BARS[n5];
            if (byArray2[n4] == 0) {
                byArray[n2++] = byArray3[0];
                byArray[n2++] = byArray3[1];
                byArray[n2++] = byArray3[2];
                byArray[n2++] = byArray3[3];
            } else {
                byArray[n2++] = byArray3[3];
                byArray[n2++] = byArray3[2];
                byArray[n2++] = byArray3[1];
                byArray[n2++] = byArray3[0];
            }
            ++n4;
        }
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        float f = 0.0f;
        float f2 = this.barHeight;
        if (this.font != null) {
            f2 = this.baseline <= 0.0f ? (f2 += -this.baseline + this.size) : (f2 += this.baseline - this.font.getFontDescriptor(3, this.size));
        }
        switch (this.codeType) {
            case 1: {
                f = this.x * 95.0f;
                if (this.font == null) break;
                f += this.font.getWidthPoint(this.code.charAt(0), this.size);
                break;
            }
            case 2: {
                f = this.x * 67.0f;
                break;
            }
            case 3: {
                f = this.x * 95.0f;
                if (this.font == null) break;
                f += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(11), this.size);
                break;
            }
            case 4: {
                f = this.x * 51.0f;
                if (this.font == null) break;
                f += this.font.getWidthPoint(this.code.charAt(0), this.size) + this.font.getWidthPoint(this.code.charAt(7), this.size);
                break;
            }
            case 5: {
                f = this.x * 20.0f;
                break;
            }
            case 6: {
                f = this.x * 47.0f;
                break;
            }
            default: {
                throw new RuntimeException("Invalid code type.");
            }
        }
        return new Rectangle(f, f2);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        Rectangle rectangle = this.getBarcodeSize();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f3 = this.barHeight - this.baseline;
            } else {
                f3 = -this.font.getFontDescriptor(3, this.size);
                f2 = f3 + this.baseline;
            }
        }
        switch (this.codeType) {
            case 1: 
            case 3: 
            case 4: {
                if (this.font == null) break;
                f += this.font.getWidthPoint(this.code.charAt(0), this.size);
            }
        }
        byte[] byArray = null;
        int[] nArray = GUARD_EMPTY;
        switch (this.codeType) {
            case 1: {
                byArray = BarcodeEAN.getBarsEAN13(this.code);
                nArray = GUARD_EAN13;
                break;
            }
            case 2: {
                byArray = BarcodeEAN.getBarsEAN8(this.code);
                nArray = GUARD_EAN8;
                break;
            }
            case 3: {
                byArray = BarcodeEAN.getBarsEAN13("0" + this.code);
                nArray = GUARD_UPCA;
                break;
            }
            case 4: {
                byArray = BarcodeEAN.getBarsUPCE(this.code);
                nArray = GUARD_UPCE;
                break;
            }
            case 5: {
                byArray = BarcodeEAN.getBarsSupplemental2(this.code);
                break;
            }
            case 6: {
                byArray = BarcodeEAN.getBarsSupplemental5(this.code);
            }
        }
        float f4 = f;
        boolean bl = true;
        float f5 = 0.0f;
        if (this.font != null && this.baseline > 0.0f && this.guardBars) {
            f5 = this.baseline / 2.0f;
        }
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n = 0;
        while (n < byArray.length) {
            float f6 = (float)byArray[n] * this.x;
            if (bl) {
                if (Arrays.binarySearch(nArray, n) >= 0) {
                    pdfContentByte.rectangle(f, f2 - f5, f6 - this.inkSpreading, this.barHeight + f5);
                } else {
                    pdfContentByte.rectangle(f, f2, f6 - this.inkSpreading, this.barHeight);
                }
            }
            bl = !bl;
            f += f6;
            ++n;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            switch (this.codeType) {
                case 1: {
                    pdfContentByte.setTextMatrix(0.0f, f3);
                    pdfContentByte.showText(this.code.substring(0, 1));
                    n = 1;
                    while (n < 13) {
                        String string = this.code.substring(n, n + 1);
                        float f7 = this.font.getWidthPoint(string, this.size);
                        float f8 = f4 + TEXTPOS_EAN13[n - 1] * this.x - f7 / 2.0f;
                        pdfContentByte.setTextMatrix(f8, f3);
                        pdfContentByte.showText(string);
                        ++n;
                    }
                    break;
                }
                case 2: {
                    n = 0;
                    while (n < 8) {
                        String string = this.code.substring(n, n + 1);
                        float f9 = this.font.getWidthPoint(string, this.size);
                        float f10 = TEXTPOS_EAN8[n] * this.x - f9 / 2.0f;
                        pdfContentByte.setTextMatrix(f10, f3);
                        pdfContentByte.showText(string);
                        ++n;
                    }
                    break;
                }
                case 3: {
                    pdfContentByte.setTextMatrix(0.0f, f3);
                    pdfContentByte.showText(this.code.substring(0, 1));
                    n = 1;
                    while (n < 11) {
                        String string = this.code.substring(n, n + 1);
                        float f11 = this.font.getWidthPoint(string, this.size);
                        float f12 = f4 + TEXTPOS_EAN13[n] * this.x - f11 / 2.0f;
                        pdfContentByte.setTextMatrix(f12, f3);
                        pdfContentByte.showText(string);
                        ++n;
                    }
                    pdfContentByte.setTextMatrix(f4 + this.x * 95.0f, f3);
                    pdfContentByte.showText(this.code.substring(11, 12));
                    break;
                }
                case 4: {
                    pdfContentByte.setTextMatrix(0.0f, f3);
                    pdfContentByte.showText(this.code.substring(0, 1));
                    n = 1;
                    while (n < 7) {
                        String string = this.code.substring(n, n + 1);
                        float f13 = this.font.getWidthPoint(string, this.size);
                        float f14 = f4 + TEXTPOS_EAN13[n - 1] * this.x - f13 / 2.0f;
                        pdfContentByte.setTextMatrix(f14, f3);
                        pdfContentByte.showText(string);
                        ++n;
                    }
                    pdfContentByte.setTextMatrix(f4 + this.x * 51.0f, f3);
                    pdfContentByte.showText(this.code.substring(7, 8));
                    break;
                }
                case 5: 
                case 6: {
                    n = 0;
                    while (n < this.code.length()) {
                        String string = this.code.substring(n, n + 1);
                        float f15 = this.font.getWidthPoint(string, this.size);
                        float f16 = (7.5f + (float)(9 * n)) * this.x - f15 / 2.0f;
                        pdfContentByte.setTextMatrix(f16, f3);
                        pdfContentByte.showText(string);
                        ++n;
                    }
                    break;
                }
            }
            pdfContentByte.endText();
        }
        return rectangle;
    }

    public Image createAwtImage(Color color, Color color2) {
        int n = color.getRGB();
        int n2 = color2.getRGB();
        Canvas canvas = new Canvas();
        int n3 = 0;
        byte[] byArray = null;
        switch (this.codeType) {
            case 1: {
                byArray = BarcodeEAN.getBarsEAN13(this.code);
                n3 = 95;
                break;
            }
            case 2: {
                byArray = BarcodeEAN.getBarsEAN8(this.code);
                n3 = 67;
                break;
            }
            case 3: {
                byArray = BarcodeEAN.getBarsEAN13("0" + this.code);
                n3 = 95;
                break;
            }
            case 4: {
                byArray = BarcodeEAN.getBarsUPCE(this.code);
                n3 = 51;
                break;
            }
            case 5: {
                byArray = BarcodeEAN.getBarsSupplemental2(this.code);
                n3 = 20;
                break;
            }
            case 6: {
                byArray = BarcodeEAN.getBarsSupplemental5(this.code);
                n3 = 47;
                break;
            }
            default: {
                throw new RuntimeException("Invalid code type.");
            }
        }
        boolean bl = true;
        int n4 = 0;
        int n5 = (int)this.barHeight;
        int[] nArray = new int[n3 * n5];
        int n6 = 0;
        while (n6 < byArray.length) {
            int n7 = byArray[n6];
            int n8 = n2;
            if (bl) {
                n8 = n;
            }
            bl = !bl;
            int n9 = 0;
            while (n9 < n7) {
                nArray[n4++] = n8;
                ++n9;
            }
            ++n6;
        }
        n6 = n3;
        while (n6 < nArray.length) {
            System.arraycopy(nArray, 0, nArray, n6, n3);
            n6 += n3;
        }
        Image image = canvas.createImage(new MemoryImageSource(n3, n5, nArray, 0, n3));
        return image;
    }
}

