/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfFont;
import java.awt.Color;
import java.util.HashMap;

public class PdfChunk
implements SplitCharacter {
    private static final char[] singleSpace = new char[]{' '};
    private static final PdfChunk[] thisChunk = new PdfChunk[1];
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final HashMap keysAttributes = new HashMap();
    private static final HashMap keysNoStroke = new HashMap();
    protected String value = "";
    protected String encoding = "Cp1252";
    protected PdfFont font;
    protected BaseFont baseFont;
    protected SplitCharacter splitCharacter;
    protected HashMap attributes = new HashMap();
    protected HashMap noStroke = new HashMap();
    protected boolean newlineSplit;
    protected Image image;
    protected float offsetX;
    protected float offsetY;
    protected boolean changeLeading = false;

    static {
        keysAttributes.put("ACTION", null);
        keysAttributes.put("UNDERLINE", null);
        keysAttributes.put("REMOTEGOTO", null);
        keysAttributes.put("LOCALGOTO", null);
        keysAttributes.put("LOCALDESTINATION", null);
        keysAttributes.put("GENERICTAG", null);
        keysAttributes.put("NEWPAGE", null);
        keysAttributes.put("IMAGE", null);
        keysAttributes.put("BACKGROUND", null);
        keysAttributes.put("PDFANNOTATION", null);
        keysAttributes.put("SKEW", null);
        keysAttributes.put("HSCALE", null);
        keysNoStroke.put("SUBSUPSCRIPT", null);
        keysNoStroke.put("SPLITCHARACTER", null);
        keysNoStroke.put("HYPHENATION", null);
        keysNoStroke.put("TEXTRENDERMODE", null);
    }

    PdfChunk(String string, PdfChunk pdfChunk) {
        PdfChunk.thisChunk[0] = this;
        this.value = string;
        this.font = pdfChunk.font;
        this.attributes = pdfChunk.attributes;
        this.noStroke = pdfChunk.noStroke;
        this.baseFont = pdfChunk.baseFont;
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    PdfChunk(Chunk chunk, PdfAction pdfAction) {
        Object object;
        Object[] objectArray;
        PdfChunk.thisChunk[0] = this;
        this.value = chunk.content();
        Font font = chunk.font();
        float f = font.size();
        if (f == -1.0f) {
            f = 12.0f;
        }
        this.baseFont = font.getBaseFont();
        int n = font.style();
        if (n == -1) {
            n = 0;
        }
        if (this.baseFont == null) {
            this.baseFont = font.getCalculatedBaseFont(false);
        } else {
            if ((n & 1) != 0) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = new Integer(2);
                objectArray2[1] = new Float(f / 30.0f);
                this.attributes.put("TEXTRENDERMODE", objectArray2);
            }
            if ((n & 2) != 0) {
                this.attributes.put("SKEW", new float[]{0.0f, 0.21256f});
            }
        }
        this.font = new PdfFont(this.baseFont, f);
        HashMap hashMap = chunk.getAttributes();
        if (hashMap != null) {
            objectArray = hashMap.keySet().iterator();
            while (objectArray.hasNext()) {
                object = objectArray.next();
                if (keysAttributes.containsKey(object)) {
                    this.attributes.put(object, hashMap.get(object));
                    continue;
                }
                if (!keysNoStroke.containsKey(object)) continue;
                this.noStroke.put(object, hashMap.get(object));
            }
            if ("".equals(hashMap.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.content());
            }
        }
        if (font.isUnderlined()) {
            Object[] objectArray3 = new Object[2];
            objectArray3[1] = new float[]{0.0f, 0.06666667f, 0.0f, -0.33333334f, 0.0f};
            objectArray = objectArray3;
            object = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (font.isStrikethru()) {
            Object[] objectArray4 = new Object[2];
            objectArray4[1] = new float[]{0.0f, 0.06666667f, 0.0f, 0.33333334f, 0.0f};
            objectArray = objectArray4;
            object = Chunk.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (pdfAction != null) {
            this.attributes.put("ACTION", pdfAction);
        }
        this.noStroke.put("COLOR", font.color());
        this.noStroke.put("ENCODING", this.font.getFont().getEncoding());
        objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.attributes.remove("HSCALE");
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.font.setImage(this.image);
        object = (Float)this.attributes.get("HSCALE");
        if (object != null) {
            this.font.setHorizontalScaling(((Float)object).floatValue());
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = this;
        }
    }

    public char getUnicodeEquivalent(char c) {
        return this.baseFont.getUnicodeEquivalent(c);
    }

    protected int getWord(String string, int n) {
        int n2 = string.length();
        while (n < n2) {
            if (!Character.isLetter(string.charAt(n))) break;
            ++n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    PdfChunk split(float var1_1) {
        block19: {
            this.newlineSplit = false;
            if (this.image != null) {
                if (this.image.scaledWidth() > var1_1) {
                    var2_2 = new PdfChunk("\ufffc", this);
                    this.value = "";
                    this.attributes = new HashMap<K, V>();
                    this.image = null;
                    this.font = PdfFont.getDefaultFont();
                    return var2_2;
                }
                return null;
            }
            var2_3 = (HyphenationEvent)this.noStroke.get("HYPHENATION");
            var3_4 = 0;
            var4_5 = -1;
            var5_6 = 0.0f;
            var6_7 = -1;
            var7_8 = 0.0f;
            var8_9 = this.value.length();
            var9_10 = this.value.toCharArray();
            var10_11 = '\u0000';
            var11_12 = this.font.getFont();
            if (var11_12.getFontType() != 2 || var11_12.getUnicodeEquivalent(' ') == ' ') ** GOTO lbl64
            while (var3_4 < var8_9) {
                var12_13 = var9_10[var3_4];
                var10_11 = var11_12.getUnicodeEquivalent(var12_13);
                if (var10_11 == '\n') {
                    this.newlineSplit = true;
                    var13_17 = this.value.substring(var3_4 + 1);
                    this.value = this.value.substring(0, var3_4);
                    if (this.value.length() < 1) {
                        this.value = "\u0001";
                    }
                    var14_21 = new PdfChunk(var13_17, this);
                    return var14_21;
                }
                var5_6 += this.font.width(var12_13);
                if (var10_11 == ' ') {
                    var6_7 = var3_4 + 1;
                    var7_8 = var5_6;
                }
                if (!(var5_6 > var1_1)) {
                    if (this.splitCharacter.isSplitCharacter(0, var3_4, var8_9, var9_10, PdfChunk.thisChunk)) {
                        var4_5 = var3_4 + 1;
                    }
                    ++var3_4;
                    continue;
                }
                break block19;
            }
            break block19;
lbl-1000:
            // 1 sources

            {
                var10_11 = var9_10[var3_4];
                if (var10_11 == '\r' || var10_11 == '\n') {
                    this.newlineSplit = true;
                    var12_14 = 1;
                    if (var10_11 == '\r' && var3_4 + 1 < var8_9 && var9_10[var3_4 + 1] == '\n') {
                        var12_14 = 2;
                    }
                    var13_18 = this.value.substring(var3_4 + var12_14);
                    this.value = this.value.substring(0, var3_4);
                    if (this.value.length() < 1) {
                        this.value = " ";
                    }
                    var14_22 = new PdfChunk(var13_18, this);
                    return var14_22;
                }
                var5_6 += this.font.width(var10_11);
                if (var10_11 == ' ') {
                    var6_7 = var3_4 + 1;
                    var7_8 = var5_6;
                }
                if (var5_6 > var1_1) break;
                if (this.splitCharacter.isSplitCharacter(0, var3_4, var8_9, var9_10, null)) {
                    var4_5 = var3_4 + 1;
                }
                ++var3_4;
lbl64:
                // 2 sources

                ** while (var3_4 < var8_9)
            }
        }
        if (var3_4 == var8_9) {
            return null;
        }
        if (var4_5 < 0) {
            var12_15 = this.value;
            this.value = "";
            var13_19 = new PdfChunk(var12_15, this);
            return var13_19;
        }
        if (var6_7 > var4_5 && this.splitCharacter.isSplitCharacter(0, 0, 1, PdfChunk.singleSpace, null)) {
            var4_5 = var6_7;
        }
        if (var2_3 != null && var6_7 < var3_4 && (var12_13 = this.getWord(this.value, var6_7)) > var6_7) {
            var13_20 = var2_3.getHyphenatedWordPre(this.value.substring(var6_7, var12_13), this.font.getFont(), this.font.size(), var1_1 - var7_8);
            var14_23 = var2_3.getHyphenatedWordPost();
            if (var13_20.length() > 0) {
                var15_24 = String.valueOf(var14_23) + this.value.substring(var12_13);
                this.value = this.trim(String.valueOf(this.value.substring(0, var6_7)) + (String)var13_20);
                var16_25 = new PdfChunk(var15_24, this);
                return var16_25;
            }
        }
        var12_16 = this.value.substring(var4_5);
        this.value = this.trim(this.value.substring(0, var4_5));
        var13_20 = new PdfChunk(var12_16, this);
        return var13_20;
    }

    PdfChunk truncate(float f) {
        if (this.image != null) {
            if (this.image.scaledWidth() > f) {
                PdfChunk pdfChunk = new PdfChunk("", this);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = PdfFont.getDefaultFont();
                return pdfChunk;
            }
            return null;
        }
        int n = 0;
        float f2 = 0.0f;
        if (f < this.font.width()) {
            String string = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        int n2 = this.value.length();
        while (n < n2) {
            char c = this.value.charAt(n);
            if ((f2 += this.font.width(c)) > f) break;
            ++n;
        }
        if (n == n2) {
            return null;
        }
        if (n == 0) {
            n = 1;
        }
        String string = this.value.substring(n);
        this.value = this.value.substring(0, n);
        PdfChunk pdfChunk = new PdfChunk(string, this);
        return pdfChunk;
    }

    PdfFont font() {
        return this.font;
    }

    Color color() {
        return (Color)this.noStroke.get("COLOR");
    }

    float width() {
        return this.font.width(this.value);
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float f, float f2) {
        if (this.image != null) {
            return this.image.scaledWidth() + f;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = this.value.indexOf(32, n2 + 1)) >= 0) {
            ++n;
        }
        return this.width() + ((float)this.value.length() * f + (float)n * f2);
    }

    public float getTextRise() {
        Float f = (Float)this.getAttribute("SUBSUPSCRIPT");
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public float trimLastSpace() {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(' ') != ' ') {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.width('\u0001');
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.width(' ');
        }
        return 0.0f;
    }

    Object getAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return this.noStroke.get(string);
    }

    boolean isAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return true;
        }
        return this.noStroke.containsKey(string);
    }

    boolean isStroked() {
        return this.attributes.size() > 0;
    }

    boolean isImage() {
        return this.image != null;
    }

    Image getImage() {
        return this.image;
    }

    void setImageOffsetX(float f) {
        this.offsetX = f;
    }

    float getImageOffsetX() {
        return this.offsetX;
    }

    void setImageOffsetY(float f) {
        this.offsetY = f;
    }

    float getImageOffsetY() {
        return this.offsetY;
    }

    void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return this.value;
    }

    boolean isSpecialEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    String getEncoding() {
        return this.encoding;
    }

    int length() {
        return this.value.length();
    }

    public boolean isSplitCharacter(int n, int n2, int n3, char[] cArray, PdfChunk[] pdfChunkArray) {
        char c = pdfChunkArray == null ? cArray[n2] : pdfChunkArray[Math.min(n2, pdfChunkArray.length - 1)].getUnicodeEquivalent(cArray[n2]);
        if (c <= ' ' || c == '-') {
            return true;
        }
        if (c < '\u2e80') {
            return false;
        }
        return c >= '\u2e80' && c < '\ud7a0' || c >= '\uf900' && c < '\ufb00' || c >= '\ufe30' && c < '\ufe50' || c >= '\uff61' && c < '\uffa0';
    }

    boolean isExtSplitCharacter(int n, int n2, int n3, char[] cArray, PdfChunk[] pdfChunkArray) {
        return this.splitCharacter.isSplitCharacter(n, n2, n3, cArray, pdfChunkArray);
    }

    /*
     * Unable to fully structure code
     */
    String trim(String var1_1) {
        block2: {
            var2_2 = this.font.getFont();
            if (var2_2.getFontType() != 2 || var2_2.getUnicodeEquivalent(' ') == ' ') ** GOTO lbl8
            while (var1_1.endsWith("\u0001")) {
                var1_1 = var1_1.substring(0, var1_1.length() - 1);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.substring(0, var1_1.length() - 1);
lbl8:
                // 2 sources

                ** while (var1_1.endsWith((String)" ") || var1_1.endsWith((String)"\t"))
            }
        }
        return var1_1;
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    float getCharWidth(char c) {
        if (PdfChunk.noPrint(c)) {
            return 0.0f;
        }
        return this.font.width(c);
    }

    public static boolean noPrint(char c) {
        return c >= '\u200b' && c <= '\u200f' || c >= '\u202a' && c <= '\u202e';
    }
}

