/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

class TrueTypeFontSubSet {
    static final String[] tableNamesSimple = new String[]{"cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    static final String[] tableNamesCmap = new String[]{"cmap", "cvt ", "fpgm", "glyf", "head", "hhea", "hmtx", "loca", "maxp", "prep"};
    static final int[] entrySelectors;
    static final int TABLE_CHECKSUM = 0;
    static final int TABLE_OFFSET = 1;
    static final int TABLE_LENGTH = 2;
    static final int HEAD_LOCA_FORMAT_OFFSET = 51;
    static final int ARG_1_AND_2_ARE_WORDS = 1;
    static final int WE_HAVE_A_SCALE = 8;
    static final int MORE_COMPONENTS = 32;
    static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    static final int WE_HAVE_A_TWO_BY_TWO = 128;
    protected HashMap tableDirectory;
    protected RandomAccessFileOrArray rf;
    protected String fileName;
    protected boolean includeCmap;
    protected boolean locaShortTable;
    protected int[] locaTable;
    protected HashMap glyphsUsed;
    protected ArrayList glyphsInList;
    protected int tableGlyphOffset;
    protected int[] newLocaTable;
    protected byte[] newLocaTableOut;
    protected byte[] newGlyfTable;
    protected int glyfTableRealSize;
    protected int locaTableRealSize;
    protected byte[] outFont;
    protected int fontPtr;
    protected int directoryOffset;

    static {
        int[] nArray = new int[21];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 3;
        nArray[9] = 3;
        nArray[10] = 3;
        nArray[11] = 3;
        nArray[12] = 3;
        nArray[13] = 3;
        nArray[14] = 3;
        nArray[15] = 3;
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 4;
        nArray[19] = 4;
        nArray[20] = 4;
        entrySelectors = nArray;
    }

    TrueTypeFontSubSet(String string, RandomAccessFileOrArray randomAccessFileOrArray, HashMap hashMap, int n, boolean bl) {
        this.fileName = string;
        this.rf = randomAccessFileOrArray;
        this.glyphsUsed = hashMap;
        this.includeCmap = bl;
        this.directoryOffset = n;
        this.glyphsInList = new ArrayList(hashMap.keySet());
    }

    byte[] process() throws IOException, DocumentException {
        byte[] byArray;
        try {
            this.rf.reOpen();
            this.createTableDirectory();
            this.readLoca();
            this.flatGlyphs();
            this.createNewGlyphTables();
            this.locaTobytes();
            this.assembleFont();
            byArray = this.outFont;
            Object var1_2 = null;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            try {
                this.rf.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            this.rf.close();
        }
        catch (Exception exception) {}
        return byArray;
    }

    protected void assembleFont() throws IOException, DocumentException {
        String string;
        int[] nArray;
        int n = 0;
        String[] stringArray = this.includeCmap ? tableNamesCmap : tableNamesSimple;
        int n2 = 2;
        int n3 = 0;
        int n4 = 0;
        while (n4 < stringArray.length) {
            String string2 = stringArray[n4];
            if (!string2.equals("glyf") && !string2.equals("loca") && (nArray = (int[])this.tableDirectory.get(string2)) != null) {
                ++n2;
                n += nArray[2] + 3 & 0xFFFFFFFC;
            }
            ++n4;
        }
        n += this.newLocaTableOut.length;
        n += this.newGlyfTable.length;
        n4 = 16 * n2 + 12;
        this.outFont = new byte[n += n4];
        this.fontPtr = 0;
        this.writeFontInt(65536);
        this.writeFontShort(n2);
        int n5 = entrySelectors[n2];
        this.writeFontShort((1 << n5) * 16);
        this.writeFontShort(n5);
        this.writeFontShort((n2 - (1 << n5)) * 16);
        int n6 = 0;
        while (n6 < stringArray.length) {
            string = stringArray[n6];
            nArray = (int[])this.tableDirectory.get(string);
            if (nArray != null) {
                this.writeFontString(string);
                if (string.equals("glyf")) {
                    this.writeFontInt(this.calculateChecksum(this.newGlyfTable));
                    n3 = this.glyfTableRealSize;
                } else if (string.equals("loca")) {
                    this.writeFontInt(this.calculateChecksum(this.newLocaTableOut));
                    n3 = this.locaTableRealSize;
                } else {
                    this.writeFontInt(nArray[0]);
                    n3 = nArray[2];
                }
                this.writeFontInt(n4);
                this.writeFontInt(n3);
                n4 += n3 + 3 & 0xFFFFFFFC;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < stringArray.length) {
            string = stringArray[n6];
            nArray = (int[])this.tableDirectory.get(string);
            if (nArray != null) {
                if (string.equals("glyf")) {
                    System.arraycopy(this.newGlyfTable, 0, this.outFont, this.fontPtr, this.newGlyfTable.length);
                    this.fontPtr += this.newGlyfTable.length;
                    this.newGlyfTable = null;
                } else if (string.equals("loca")) {
                    System.arraycopy(this.newLocaTableOut, 0, this.outFont, this.fontPtr, this.newLocaTableOut.length);
                    this.fontPtr += this.newLocaTableOut.length;
                    this.newLocaTableOut = null;
                } else {
                    this.rf.seek(nArray[1]);
                    this.rf.readFully(this.outFont, this.fontPtr, nArray[2]);
                    this.fontPtr += nArray[2] + 3 & 0xFFFFFFFC;
                }
            }
            ++n6;
        }
    }

    protected void createTableDirectory() throws IOException, DocumentException {
        this.tableDirectory = new HashMap();
        this.rf.seek(this.directoryOffset);
        int n = this.rf.readInt();
        if (n != 65536) {
            throw new DocumentException(String.valueOf(this.fileName) + " is not a true type file.");
        }
        int n2 = this.rf.readUnsignedShort();
        this.rf.skipBytes(6);
        int n3 = 0;
        while (n3 < n2) {
            String string = this.readStandardString(4);
            int[] nArray = new int[]{this.rf.readInt(), this.rf.readInt(), this.rf.readInt()};
            this.tableDirectory.put(string, nArray);
            ++n3;
        }
    }

    protected void readLoca() throws IOException, DocumentException {
        int[] nArray = (int[])this.tableDirectory.get("head");
        if (nArray == null) {
            throw new DocumentException("Table 'head' does not exist in " + this.fileName);
        }
        this.rf.seek(nArray[1] + 51);
        this.locaShortTable = this.rf.readUnsignedShort() == 0;
        nArray = (int[])this.tableDirectory.get("loca");
        if (nArray == null) {
            throw new DocumentException("Table 'loca' does not exist in " + this.fileName);
        }
        this.rf.seek(nArray[1]);
        if (this.locaShortTable) {
            int n = nArray[2] / 2;
            this.locaTable = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.locaTable[n2] = this.rf.readUnsignedShort() * 2;
                ++n2;
            }
        } else {
            int n = nArray[2] / 4;
            this.locaTable = new int[n];
            int n3 = 0;
            while (n3 < n) {
                this.locaTable[n3] = this.rf.readInt();
                ++n3;
            }
        }
    }

    protected void createNewGlyphTables() throws IOException {
        int n;
        this.newLocaTable = new int[this.locaTable.length];
        int[] nArray = new int[this.glyphsInList.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = (Integer)this.glyphsInList.get(n2);
            ++n2;
        }
        Arrays.sort(nArray);
        n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            n = nArray[n3];
            n2 += this.locaTable[n + 1] - this.locaTable[n];
            ++n3;
        }
        this.glyfTableRealSize = n2;
        n2 = n2 + 3 & 0xFFFFFFFC;
        this.newGlyfTable = new byte[n2];
        n3 = 0;
        n = 0;
        int n4 = 0;
        while (n4 < this.newLocaTable.length) {
            this.newLocaTable[n4] = n3;
            if (n < nArray.length && nArray[n] == n4) {
                ++n;
                this.newLocaTable[n4] = n3;
                int n5 = this.locaTable[n4];
                int n6 = this.locaTable[n4 + 1] - n5;
                if (n6 > 0) {
                    this.rf.seek(this.tableGlyphOffset + n5);
                    this.rf.readFully(this.newGlyfTable, n3, n6);
                    n3 += n6;
                }
            }
            ++n4;
        }
    }

    protected void locaTobytes() {
        this.locaTableRealSize = this.locaShortTable ? this.newLocaTable.length * 2 : this.newLocaTable.length * 4;
        this.newLocaTableOut = new byte[this.locaTableRealSize + 3 & 0xFFFFFFFC];
        this.outFont = this.newLocaTableOut;
        this.fontPtr = 0;
        int n = 0;
        while (n < this.newLocaTable.length) {
            if (this.locaShortTable) {
                this.writeFontShort(this.newLocaTable[n] / 2);
            } else {
                this.writeFontInt(this.newLocaTable[n]);
            }
            ++n;
        }
    }

    protected void flatGlyphs() throws IOException, DocumentException {
        int[] nArray = (int[])this.tableDirectory.get("glyf");
        if (nArray == null) {
            throw new DocumentException("Table 'glyf' does not exist in " + this.fileName);
        }
        Integer n = new Integer(0);
        if (!this.glyphsUsed.containsKey(n)) {
            this.glyphsUsed.put(n, null);
            this.glyphsInList.add(n);
        }
        this.tableGlyphOffset = nArray[1];
        int n2 = 0;
        while (n2 < this.glyphsInList.size()) {
            int n3 = (Integer)this.glyphsInList.get(n2);
            this.checkGlyphComposite(n3);
            ++n2;
        }
    }

    protected void checkGlyphComposite(int n) throws IOException {
        int n2 = this.locaTable[n];
        if (n2 == this.locaTable[n + 1]) {
            return;
        }
        this.rf.seek(this.tableGlyphOffset + n2);
        short s = this.rf.readShort();
        if (s >= 0) {
            return;
        }
        this.rf.skipBytes(8);
        while (true) {
            int n3 = this.rf.readUnsignedShort();
            Integer n4 = new Integer(this.rf.readUnsignedShort());
            if (!this.glyphsUsed.containsKey(n4)) {
                this.glyphsUsed.put(n4, null);
                this.glyphsInList.add(n4);
            }
            if ((n3 & 0x20) == 0) {
                return;
            }
            int n5 = (n3 & 1) != 0 ? 4 : 2;
            if ((n3 & 8) != 0) {
                n5 += 2;
            } else if ((n3 & 0x40) != 0) {
                n5 += 4;
            }
            if ((n3 & 0x80) != 0) {
                n5 += 8;
            }
            this.rf.skipBytes(n5);
        }
    }

    protected String readStandardString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.rf.readFully(byArray);
        try {
            return new String(byArray, "Cp1252");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    protected void writeFontShort(int n) {
        this.outFont[this.fontPtr++] = (byte)(n >> 8);
        this.outFont[this.fontPtr++] = (byte)n;
    }

    protected void writeFontInt(int n) {
        this.outFont[this.fontPtr++] = (byte)(n >> 24);
        this.outFont[this.fontPtr++] = (byte)(n >> 16);
        this.outFont[this.fontPtr++] = (byte)(n >> 8);
        this.outFont[this.fontPtr++] = (byte)n;
    }

    protected void writeFontString(String string) {
        byte[] byArray = PdfEncodings.convertToBytes(string, "Cp1252");
        System.arraycopy(byArray, 0, this.outFont, this.fontPtr, byArray.length);
        this.fontPtr += byArray.length;
    }

    protected int calculateChecksum(byte[] byArray) {
        int n = byArray.length / 4;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            n5 += byArray[n6++] & 0xFF;
            n4 += byArray[n6++] & 0xFF;
            n3 += byArray[n6++] & 0xFF;
            n2 += byArray[n6++] & 0xFF;
            ++n7;
        }
        return n2 + (n3 << 8) + (n4 << 16) + (n5 << 24);
    }
}

