/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;

public class S16Vector
extends SimpleVector
implements Externalizable {
    short[] data;
    protected static short[] empty = new short[0];

    public S16Vector() {
        this.data = empty;
    }

    public S16Vector(int n, short s) {
        short[] sArray = new short[n];
        this.data = sArray;
        this.size = n;
        while (--n >= 0) {
            sArray[n] = s;
        }
    }

    public S16Vector(int n) {
        this.data = new short[n];
        this.size = n;
    }

    public S16Vector(short[] sArray) {
        this.data = sArray;
        this.size = sArray.length;
    }

    public S16Vector(Sequence sequence) {
        this.data = new short[sequence.size()];
        this.addAll((Collection)sequence);
    }

    public int getBufferLength() {
        return this.data.length;
    }

    public void setBufferLength(int n) {
        int n2 = this.data.length;
        if (n2 != n) {
            short[] sArray = new short[n];
            System.arraycopy(this.data, 0, sArray, 0, n2 < n ? n2 : n);
            this.data = sArray;
        }
    }

    protected Object getBuffer() {
        return this.data;
    }

    public final short shortAt(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[n];
    }

    public final short shortAtBuffer(int n) {
        return this.data[n];
    }

    public final int intAtBuffer(int n) {
        return this.data[n];
    }

    public final Object get(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[n]);
    }

    public final Object getBuffer(int n) {
        return Convert.toObject(this.data[n]);
    }

    public Object setBuffer(int n, Object object2) {
        short s = this.data[n];
        this.data[n] = Convert.toShort(object2);
        return Convert.toObject(s);
    }

    public final void setShortAt(int n, short s) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.data[n] = s;
    }

    public final void setShortAtBuffer(int n, short s) {
        this.data[n] = s;
    }

    protected void clearBuffer(int n, int n2) {
        while (--n2 >= 0) {
            this.data[n++] = 0;
        }
    }

    public int getElementKind() {
        return 20;
    }

    public String getTag() {
        return "s16";
    }

    public boolean consumeNext(int n, Object object2, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeInt(this.data[n2]);
        return true;
    }

    public void consume(int n, Object object2, int n2, Object object3, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        while (n3 < n4) {
            consumer.writeInt(this.data[n3]);
            ++n3;
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.size;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeShort(this.data[n2]);
            ++n2;
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = objectInput.readShort();
            ++n2;
        }
        this.data = sArray;
        this.size = n;
    }
}

