/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class PrettyWriter
extends Writer {
    protected Writer out;
    int lineLength = 80;
    public boolean isPrettyPrinting = true;
    public static int initialBufferSize = 126;
    public char[] buffer = new char[initialBufferSize];
    public int bufferFillPointer;
    int bufferOffset;
    int bufferStartColumn;
    int lineNumber;
    int[] blocks = new int[60];
    private static final int LOGICAL_BLOCK_LENGTH = 6;
    private static final int BLOCK_START_COLUMN = -1;
    private static final int BLOCK_SECTION_COLUMN = -2;
    private static final int BLOCK_PER_LINE_PREFIX_END = -3;
    private static final int BLOCK_PREFIX_LENGTH = -4;
    private static final int BLOCK_SUFFIX_LENGTH = -5;
    private static final int BLOCK_SECTION_START_LINE = -6;
    int blockDepth = 6;
    char[] prefix = new char[initialBufferSize];
    char[] suffix = new char[initialBufferSize];
    static final int QUEUE_INIT_ALLOC_SIZE = 300;
    int[] queueInts = new int[300];
    String[] queueStrings = new String[300];
    int queueTail;
    int queueSize;
    int currentBlock;
    public int pendingBlocksCount;
    static final int QUEUED_OP_TYPE = 0;
    static final int QUEUED_OP_POSN = 1;
    static final int QUEUED_OP_SIZE = 2;
    static final int QUEUED_OP_DUMMY_TYPE = 0;
    static final int QUEUED_OP_SECTION_START_SIZE = 4;
    static final int QUEUED_OP_SECTION_START_DEPTH = 2;
    static final int QUEUED_OP_SECTION_START_SECTION_END = 3;
    static final int QUEUED_OP_NEWLINE_TYPE = 2;
    static final int QUEUED_OP_NEWLINE_SIZE = 5;
    static final int QUEUED_OP_NEWLINE_KIND = 4;
    public static final int NEWLINE_LINEAR = 78;
    public static final int NEWLINE_LITERAL = 76;
    public static final int NEWLINE_FILL = 70;
    public static final int NEWLINE_MISER = 77;
    public static final int NEWLINE_MANDATORY = 82;
    static final int QUEUED_OP_INDENTATION_TYPE = 3;
    static final int QUEUED_OP_INDENTATION_SIZE = 4;
    static final int QUEUED_OP_INDENTATION_KIND = 2;
    static final int QUEUED_OP_INDENTATION_BLOCK = 66;
    static final int QUEUED_OP_INDENTATION_CURRENT = 67;
    static final int QUEUED_OP_INDENTATION_AMOUNT = 3;
    static final int QUEUED_OP_BLOCK_START_TYPE = 4;
    static final int QUEUED_OP_BLOCK_START_SIZE = 5;
    static final int QUEUED_OP_BLOCK_START_BLOCK_END = 4;
    static final int QUEUED_OP_BLOCK_PREFIX = 0;
    static final int QUEUED_OP_BLOCK_START_SUFFIX = 1;
    static final int QUEUED_OP_BLOCK_END_TYPE = 5;
    static final int QUEUED_OP_BLOCK_END_SIZE = 2;
    static final int QUEUED_OP_TAB_TYPE = 6;
    static final int QUEUED_OP_TAB_SIZE = 5;
    static final int QUEUED_OP_TAB_FLAGS = 2;
    static final int QUEUED_OP_TAB_IS_SECTION = 1;
    static final int QUEUED_OP_TAB_IS_RELATIVE = 2;
    static final int QUEUED_OP_TAB_COLNUM = 3;
    static final int QUEUED_OP_TAB_COLINC = 4;
    int miserWidth;

    public PrettyWriter(Writer writer) {
        this.out = this.out;
    }

    public PrettyWriter(Writer writer, int n) {
        this.out = writer;
        this.lineLength = n;
        this.isPrettyPrinting = n > 1;
    }

    public PrettyWriter(Writer writer, boolean bl) {
        this.out = writer;
        this.isPrettyPrinting = bl;
    }

    private int indexPosn(int n) {
        return n + this.bufferOffset;
    }

    private int posnIndex(int n) {
        return n - this.bufferOffset;
    }

    private int posnColumn(int n) {
        return this.indexColumn(this.posnIndex(n));
    }

    private int getQueueType(int n) {
        return this.queueInts[n] & 0xFF;
    }

    private int getQueueSize(int n) {
        return this.queueInts[n] >> 16;
    }

    private int getSectionColumn() {
        return this.blocks[this.blockDepth + -2];
    }

    private int getStartColumn() {
        return this.blocks[this.blockDepth + -1];
    }

    private int getPerLinePrefixEnd() {
        return this.blocks[this.blockDepth + -3];
    }

    private int getPrefixLength() {
        return this.blocks[this.blockDepth + -4];
    }

    private int getSuffixLength() {
        return this.blocks[this.blockDepth + -5];
    }

    private int getSectionStartLine() {
        return this.blocks[this.blockDepth + -6];
    }

    public void write(int n) {
        if (n == 10 && this.isPrettyPrinting) {
            this.enqueueNewline(76);
        } else {
            this.ensureSpaceInBuffer(1);
            int n2 = this.bufferFillPointer;
            this.buffer[n2] = (char)n;
            this.bufferFillPointer = 1 + n2;
        }
    }

    public void write(String string) {
        this.write(string, 0, string.length());
    }

    public void write(String string, int n, int n2) {
        while (n2 > 0) {
            int n3 = n2;
            int n4 = this.ensureSpaceInBuffer(n2);
            if (n3 > n4) {
                n3 = n4;
            }
            int n5 = this.bufferFillPointer;
            n2 -= n3;
            while (--n3 >= 0) {
                char c;
                if ((c = string.charAt(n++)) == '\n' && this.isPrettyPrinting) {
                    this.bufferFillPointer = n5;
                    this.enqueueNewline(76);
                    n5 = this.bufferFillPointer;
                    continue;
                }
                this.buffer[n5++] = c;
            }
            this.bufferFillPointer = n5;
        }
    }

    public void write(char[] cArray) {
        this.write(cArray, 0, cArray.length);
    }

    public void write(char[] cArray, int n, int n2) {
        int n3 = n + n2;
        block0: while (n2 > 0) {
            int n4;
            int n5 = n;
            while (n5 < n3) {
                if (cArray[n5] == '\n' && this.isPrettyPrinting) {
                    this.write(cArray, n, n5 - n);
                    this.enqueueNewline(76);
                    n = n5 + 1;
                    n2 = n3 - n;
                    continue block0;
                }
                ++n5;
            }
            do {
                int n6;
                n4 = (n6 = this.ensureSpaceInBuffer(n2)) < n2 ? n6 : n2;
                int n7 = this.bufferFillPointer;
                int n8 = n7 + n4;
                int n9 = n7;
                while (n9 < n8) {
                    this.buffer[n9] = cArray[n++];
                    ++n9;
                }
                this.bufferFillPointer = n8;
            } while ((n2 -= n4) != 0);
        }
    }

    private void pushLogicalBlock(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.blockDepth + 6;
        if (n6 >= this.blocks.length) {
            int[] nArray = new int[2 * this.blocks.length];
            System.arraycopy(this.blocks, 0, nArray, 0, this.blockDepth);
            this.blocks = nArray;
        }
        this.blockDepth = n6;
        this.blocks[this.blockDepth + -1] = n;
        this.blocks[this.blockDepth + -2] = n;
        this.blocks[this.blockDepth + -3] = n2;
        this.blocks[this.blockDepth + -4] = n3;
        this.blocks[this.blockDepth + -5] = n4;
        this.blocks[this.blockDepth + -6] = n5;
    }

    void reallyStartLogicalBlock(int n, String string, String string2) {
        int n2 = this.getPerLinePrefixEnd();
        int n3 = this.getPrefixLength();
        int n4 = this.getSuffixLength();
        this.pushLogicalBlock(n, n2, n3, n4, this.lineNumber);
        this.setIndentation(n);
        if (string != null) {
            this.blocks[this.blockDepth + -3] = n;
            int n5 = string.length();
            string.getChars(0, n5, this.suffix, n - n5);
        }
        if (string2 != null) {
            char[] cArray = this.suffix;
            int n6 = cArray.length;
            int n7 = string2.length();
            int n8 = n4 + n7;
            if (n8 > n6) {
                int n9 = PrettyWriter.enoughSpace(n6, n7);
                this.suffix = new char[n9];
                System.arraycopy(cArray, n6 - n4, this.suffix, n9 - n4, n4);
                n6 = n9;
            }
            string2.getChars(0, n7, cArray, n6 - n8);
            this.blocks[this.blockDepth + -5] = n8;
        }
    }

    int enqueueTab(int n, int n2, int n3) {
        int n4 = this.enqueue(6, 5);
        this.queueInts[n4 + 2] = n;
        this.queueInts[n4 + 3] = n2;
        this.queueInts[n4 + 4] = n3;
        return n4;
    }

    private static int enoughSpace(int n, int n2) {
        int n3 = 2 * n;
        int n4 = n + (5 * n2 >> 2);
        return n3 > n4 ? n3 : n4;
    }

    public void setIndentation(int n) {
        char[] cArray = this.prefix;
        int n2 = cArray.length;
        int n3 = this.getPrefixLength();
        int n4 = this.getPerLinePrefixEnd();
        if (n4 > n) {
            n = n4;
        }
        if (n > n2) {
            char[] cArray2 = new char[PrettyWriter.enoughSpace(n2, n - n2)];
            System.arraycopy(cArray, 0, cArray2, 0, n3);
            cArray = cArray2;
        }
        if (n > n3) {
            int n5 = n3;
            while (n5 < n) {
                this.prefix[n5] = 32;
                ++n5;
            }
        }
        this.blocks[this.blockDepth + -4] = n;
    }

    void reallyEndLogicalBlock() {
        int n = this.getPrefixLength();
        this.blockDepth -= 6;
        int n2 = this.getPrefixLength();
        if (n2 > n) {
            int n3 = n;
            while (n3 < n2) {
                this.prefix[n3] = 32;
                ++n3;
            }
        }
    }

    public int enqueue(int n, int n2) {
        int n3;
        int n4 = this.queueInts.length;
        int n5 = n4 - this.queueTail - this.queueSize;
        if (n5 > 0 && n2 > n5) {
            this.enqueue(0, n5);
        }
        if (this.queueSize + n2 > n4) {
            n3 = PrettyWriter.enoughSpace(n4, n2);
            int[] nArray = new int[n3];
            String[] stringArray = new String[n3];
            int n6 = this.queueTail + this.queueSize - n4;
            if (n6 > 0) {
                System.arraycopy(this.queueInts, 0, nArray, 0, n6);
                System.arraycopy(this.queueStrings, 0, stringArray, 0, n6);
            }
            int n7 = n4 - this.queueTail;
            int n8 = n3 - n4;
            System.arraycopy(this.queueInts, this.queueTail, nArray, this.queueTail + n8, n7);
            System.arraycopy(this.queueStrings, this.queueTail, stringArray, this.queueTail + n8, n7);
            this.queueInts = nArray;
            this.queueStrings = stringArray;
            if (this.currentBlock >= this.queueTail) {
                this.currentBlock += n8;
            }
            this.queueTail += n8;
        }
        if ((n3 = this.queueTail + this.queueSize) >= this.queueInts.length) {
            n3 -= this.queueInts.length;
        }
        this.queueInts[n3 + 0] = n | n2 << 16;
        if (n2 > 1) {
            this.queueInts[n3 + 1] = this.indexPosn(this.bufferFillPointer);
        }
        this.queueSize += n2;
        return n3;
    }

    public void enqueueNewline(int n) {
        int n2 = this.pendingBlocksCount;
        int n3 = this.enqueue(2, 5);
        this.queueInts[n3 + 4] = n;
        this.queueInts[n3 + 2] = this.pendingBlocksCount;
        this.queueInts[n3 + 3] = 0;
        int n4 = this.queueTail;
        int n5 = this.queueSize;
        while (n5 > 0) {
            int n6;
            if (n4 == this.queueInts.length) {
                n4 = 0;
            }
            if (n4 == n3) break;
            int n7 = this.getQueueType(n4);
            if ((n7 == 2 || n7 == 4) && this.queueInts[n4 + 3] == 0 && n2 <= this.queueInts[n4 + 2]) {
                n6 = n3 - n4;
                if (n6 < 0) {
                    n6 += this.queueInts.length;
                }
                this.queueInts[n4 + 3] = n6;
            }
            n6 = this.getQueueSize(n4);
            n5 -= n6;
            n4 += n6;
        }
        this.maybeOutput(n == 76 || n == 82);
    }

    public final void writeBreak(int n) {
        if (this.isPrettyPrinting) {
            this.enqueueNewline(n);
        }
    }

    public int enqueueIndent(int n, int n2) {
        int n3 = this.enqueue(3, 4);
        this.queueInts[n3 + 2] = n;
        this.queueInts[n3 + 3] = n2;
        return n3;
    }

    public void addIndentation(int n, boolean bl) {
        if (this.isPrettyPrinting) {
            this.enqueueIndent(bl ? 67 : 66, n);
        }
    }

    public void startLogicalBlock(String string, boolean bl, String string2) {
        if (string != null) {
            this.write(string);
        }
        if (!this.isPrettyPrinting) {
            return;
        }
        int n = this.enqueue(4, 5);
        this.queueInts[n + 2] = this.pendingBlocksCount;
        this.queueStrings[n + 0] = bl ? string : null;
        this.queueStrings[n + 1] = string2;
        ++this.pendingBlocksCount;
        this.currentBlock -= n;
        if (this.currentBlock > 0) {
            this.currentBlock -= this.queueInts.length;
        }
        this.queueInts[n + 3] = 0;
        this.queueInts[n + 4] = this.currentBlock;
        this.currentBlock = n;
    }

    public void endLogicalBlock() {
        int n;
        String string;
        int n2 = this.enqueue(5, 2);
        --this.pendingBlocksCount;
        if (this.blockDepth >= 6 * (this.pendingBlocksCount + 2)) {
            int n3 = this.blocks[this.blockDepth + -5];
            int n4 = this.blocks[this.blockDepth - 6 + -5];
            if (n3 > n4) {
                this.write(this.suffix, this.suffix.length - n3, n3 - n4);
            }
            return;
        }
        int n5 = this.currentBlock;
        this.currentBlock = this.queueInts[n5 + 4];
        this.currentBlock += n5;
        if (this.currentBlock < 0) {
            this.currentBlock += this.queueInts.length;
        }
        if ((string = this.queueStrings[n5 + 1]) != null) {
            this.write(string);
        }
        if ((n = n2 - n5) < 0) {
            n += this.queueInts.length;
        }
        this.queueInts[n5 + 4] = n;
    }

    public void endLogicalBlock(String string) {
        if (this.isPrettyPrinting) {
            this.endLogicalBlock();
        } else if (string != null) {
            this.write(string);
        }
    }

    int computeTabSize(int n, int n2, int n3) {
        int n4 = this.queueInts[n + 2];
        boolean bl = (n4 & 1) != 0;
        boolean bl2 = (n4 & 2) != 0;
        int n5 = bl ? n2 : 0;
        int n6 = this.queueInts[n + 3];
        int n7 = this.queueInts[n + 4];
        if (bl2) {
            int n8;
            int n9;
            if (n7 > 1 && (n9 = (n8 = n3 + n6) % n7) != 0) {
                n7 = n9;
                n6 += n7;
            }
            return n6;
        }
        if (n3 <= n6 + n5) {
            return n3 + n5 - n3;
        }
        return n7 - (n3 - n5) % n7;
    }

    int indexColumn(int n) {
        int n2 = this.bufferStartColumn;
        int n3 = this.getSectionColumn();
        int n4 = this.indexPosn(n);
        int n5 = this.queueTail;
        int n6 = this.queueSize;
        while (n6 > 0) {
            int n7;
            if (n5 >= this.queueInts.length - 1) {
                n5 = 0;
            }
            if ((n7 = this.queueInts[n5 + 1]) >= n4) break;
            int n8 = this.getQueueType(n5);
            if (n8 == 6) {
                n2 += this.computeTabSize(n5, n3, n2 + this.posnIndex(n7));
            } else if (n8 == 2 || n8 == 4) {
                n3 = n2 + this.posnIndex(this.queueInts[n5 + 1]);
            }
            int n9 = this.getQueueSize(n5);
            n6 -= n9;
            n5 += n9;
        }
        return n2 + n;
    }

    void expandTabs(int n) {
        Object[] objectArray;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.bufferStartColumn;
        int n7 = this.getSectionColumn();
        int n8 = this.queueTail;
        int n9 = this.queueSize;
        int n10 = 6 * this.pendingBlocksCount;
        while (n9 > 0) {
            if (n8 == this.queueInts.length) {
                n8 = 0;
            }
            if (n8 == n) break;
            n3 = this.getQueueType(n8);
            if (n3 == 6) {
                n2 = this.posnIndex(this.queueInts[n8 + 1]);
                int n11 = this.computeTabSize(n8, n7, n6 + n2);
                if (n11 != 0) {
                    if (n10 + 2 * n4 + 1 >= this.blocks.length) {
                        objectArray = new int[2 * this.blocks.length];
                        System.arraycopy(this.blocks, 0, objectArray, 0, this.blocks.length);
                        this.blocks = objectArray;
                    }
                    this.blocks[n10 + 2 * n4] = n2;
                    this.blocks[n10 + 2 * n4 + 1] = n11;
                    ++n4;
                    n5 += n11;
                    n6 += n11;
                }
            } else if (n8 == 2 || n8 == 4) {
                n7 = n6 + this.posnIndex(this.queueInts[n8 + 1]);
            }
            n2 = this.getQueueSize(n8);
            n9 -= n2;
            n8 += n2;
        }
        if (n4 > 0) {
            int n12;
            char[] cArray;
            n3 = this.bufferFillPointer;
            n2 = n3 + n5;
            objectArray = cArray = this.buffer;
            int n13 = cArray.length;
            int n14 = n3;
            if (n2 > n13) {
                n12 = PrettyWriter.enoughSpace(n3, n5);
                this.buffer = objectArray = new char[n12];
            }
            this.bufferFillPointer = n2;
            this.bufferOffset -= n5;
            n12 = n4;
            while (--n12 >= 0) {
                int n15 = this.blocks[n10 + 2 * n12];
                int n16 = this.blocks[n10 + 2 * n12 + 1];
                int n17 = n15 + n5;
                System.arraycopy(cArray, n15, objectArray, n17, n14 - n15);
                int n18 = n17 - n16;
                while (n18 < n17) {
                    objectArray[n18] = 32;
                    ++n18;
                }
                n5 -= n16;
                n14 = n15;
            }
            if (objectArray != cArray) {
                System.arraycopy(cArray, 0, objectArray, 0, n14);
            }
        }
    }

    int ensureSpaceInBuffer(int n) {
        char[] cArray = this.buffer;
        int n2 = cArray.length;
        int n3 = this.bufferFillPointer;
        int n4 = n2 - n3;
        if (n4 > 0) {
            return n4;
        }
        if (n3 > this.lineLength) {
            if (!this.maybeOutput(false)) {
                this.outputPartialLine();
            }
            return this.ensureSpaceInBuffer(n);
        }
        int n5 = PrettyWriter.enoughSpace(n2, n);
        char[] cArray2 = new char[n5];
        this.buffer = cArray2;
        int n6 = n3;
        while (--n6 >= 0) {
            cArray2[n6] = cArray[n6];
        }
        return n5 - n3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean maybeOutput(boolean bl) {
        boolean bl2 = false;
        block13: while (this.queueSize > 0) {
            int n;
            if (this.queueTail >= this.queueInts.length) {
                this.queueTail = 0;
            }
            int n2 = this.queueTail;
            int n3 = this.getQueueType(n2);
            switch (n3) {
                case 2: {
                    boolean bl3;
                    switch (this.queueInts[n2 + 4]) {
                        default: {
                            bl3 = true;
                            break;
                        }
                        case 77: {
                            bl3 = this.isMisering();
                            break;
                        }
                        case 70: {
                            if (this.isMisering() || this.lineNumber > this.getSectionStartLine()) {
                                bl3 = true;
                                break;
                            }
                            int n4 = this.queueInts[n2 + 3];
                            if (n4 == 0) {
                                n4 = -1;
                            } else if ((n4 = n2 + n4) >= this.queueInts.length) {
                                n4 -= this.queueInts.length;
                            }
                            int n5 = this.fitsOnLine(n4, bl);
                            if (n5 > 0) {
                                bl3 = false;
                                break;
                            }
                            if (n5 >= 0) break block13;
                            bl3 = true;
                        }
                    }
                    if (!bl3) break;
                    bl2 = true;
                    try {
                        this.outputLine(n2);
                        break;
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.toString());
                    }
                }
                case 3: {
                    if (this.isMisering()) break;
                    int n6 = this.queueInts[n2 + 2];
                    int n7 = this.queueInts[n2 + 3];
                    n7 = n6 == 66 ? (n7 += this.getStartColumn()) : (n7 += this.posnColumn(this.queueInts[n2 + 1]));
                    this.setIndentation(n7);
                    break;
                }
                case 4: {
                    int n6 = this.queueInts[n2 + 3];
                    n6 = n6 > 0 ? (n6 + n2) % this.queueInts.length : -1;
                    int n7 = this.fitsOnLine(n6, bl);
                    if (n7 > 0) {
                        n = this.queueInts[n2 + 4];
                        n2 = (n + n2) % this.queueInts.length;
                        this.expandTabs(n2);
                        this.queueTail = n2;
                        this.queueSize -= n;
                        break;
                    }
                    if (n7 >= 0) break block13;
                    String string = this.queueStrings[n2 + 0];
                    String string2 = this.queueStrings[n2 + 1];
                    this.reallyStartLogicalBlock(this.posnColumn(this.queueInts[n2 + 1]), string, string2);
                    break;
                }
                case 5: {
                    this.reallyEndLogicalBlock();
                    break;
                }
                case 6: {
                    this.expandTabs(n2);
                }
            }
            n = this.getQueueSize(this.queueTail);
            this.queueSize -= n;
            this.queueTail = n2 + n;
        }
        return bl2;
    }

    protected int getMiserWidth() {
        return 40;
    }

    boolean isMisering() {
        int n = this.getMiserWidth();
        return n > 0 && this.lineLength - this.getStartColumn() <= n;
    }

    int getMaxLines() {
        return -1;
    }

    boolean printReadably() {
        return true;
    }

    int fitsOnLine(int n, boolean bl) {
        int n2 = this.lineLength;
        if (!this.printReadably() && this.getMaxLines() == this.lineNumber) {
            n2 -= 3;
            n2 -= this.getSuffixLength();
        }
        if (n >= 0) {
            return this.posnColumn(this.queueInts[n + 1]) <= n2 ? 1 : -1;
        }
        if (bl) {
            return -1;
        }
        if (this.indexColumn(this.bufferFillPointer) > n2) {
            return -1;
        }
        return 0;
    }

    public void lineAbbreviationHappened() {
    }

    void outputLine(int n) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl;
        char[] cArray;
        block7: {
            cArray = this.buffer;
            int n8 = this.queueInts[n + 4];
            bl = n8 == 76;
            n7 = this.posnIndex(this.queueInts[n + 1]);
            if (bl) {
                n6 = n7;
            } else {
                n5 = n7;
                do {
                    if (--n5 >= 0) continue;
                    n6 = 0;
                    break block7;
                } while (cArray[n5] == ' ');
                n6 = n5 + 1;
            }
        }
        this.out.write(cArray, 0, n6);
        n5 = this.lineNumber;
        if (!this.printReadably() && (n4 = this.getMaxLines()) > 0 && ++n5 >= n4) {
            this.out.write(" ..");
            n3 = this.getSuffixLength();
            if (n3 != 0) {
                char[] cArray2 = this.suffix;
                n2 = cArray2.length;
                this.out.write(cArray2, n2 - n3, n3);
            }
            this.lineAbbreviationHappened();
        }
        this.lineNumber = n5;
        this.out.write(10);
        this.bufferStartColumn = 0;
        n4 = this.bufferFillPointer;
        n3 = bl ? this.getPerLinePrefixEnd() : this.getPrefixLength();
        int n9 = n7 - n3;
        n2 = n4 - n9;
        char[] cArray3 = cArray;
        int n10 = cArray.length;
        if (n2 > n10) {
            this.buffer = cArray3 = new char[PrettyWriter.enoughSpace(n10, n2 - n10)];
        }
        System.arraycopy(cArray, n7, cArray3, n3, n4 - n7);
        System.arraycopy(this.prefix, 0, cArray, 0, n3);
        this.bufferFillPointer = n2;
        this.bufferOffset += n9;
        if (!bl) {
            this.blocks[this.blockDepth + -2] = n3;
            this.blocks[this.blockDepth + -6] = n5;
        }
    }

    void outputPartialLine() {
        int n = this.bufferFillPointer;
        int n2 = this.queueTail;
        int n3 = this.queueSize > 0 ? this.posnIndex(this.queueInts[n2 + 1]) : n;
        int n4 = n - n3;
        if (n3 <= 0) {
            throw new Error("outputPartialLine called when nothing can be output.");
        }
        try {
            this.out.write(this.buffer, 0, n3);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        this.bufferStartColumn += n3;
        System.arraycopy(this.buffer, n3, this.buffer, 0, n4);
        this.bufferFillPointer = n4;
        this.bufferOffset += n3;
    }

    public void forcePrettyOutput() throws IOException {
        this.maybeOutput(false);
        this.expandTabs(-1);
        this.bufferStartColumn = this.getColumnNumber();
        this.out.write(this.buffer, 0, this.bufferFillPointer);
        this.bufferFillPointer = 0;
    }

    public void flush() {
        if (this.out == null) {
            return;
        }
        try {
            this.forcePrettyOutput();
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.forcePrettyOutput();
            this.out.close();
            this.out = null;
        }
        this.buffer = null;
    }

    public int getColumnNumber() {
        char c;
        int n = this.bufferFillPointer;
        do {
            if (--n >= 0) continue;
            return this.bufferStartColumn + this.bufferFillPointer;
        } while ((c = this.buffer[n]) != '\n' && c != '\r');
        return this.bufferFillPointer - n;
    }

    public void setColumnNumber(int n) {
        this.bufferStartColumn += n - this.getColumnNumber();
    }

    public void clearBuffer() {
        this.bufferStartColumn = 0;
        this.bufferFillPointer = 0;
        this.lineNumber = 0;
        this.bufferOffset = 0;
        this.blockDepth = 6;
        this.queueTail = 0;
        this.queueSize = 0;
        this.pendingBlocksCount = 0;
    }

    void dumpQueue() {
        PrintWriter printWriter = new PrintWriter(System.err);
        printWriter.println("Queue tail:" + this.queueTail + " size:" + this.queueSize);
        this.dumpQueue(this.queueTail, this.queueSize, printWriter);
        printWriter.flush();
    }

    void dumpQueue(int n, int n2, PrintWriter printWriter) {
        while (n2 > 0) {
            if (n == this.queueInts.length) {
                n = 0;
            }
            int n3 = this.getQueueType(n);
            int n4 = this.getQueueSize(n);
            printWriter.print('@');
            printWriter.print(n);
            printWriter.print(": ");
            printWriter.print("type:");
            printWriter.print(n3);
            switch (n3) {
                case 2: {
                    printWriter.print("(newline)");
                    break;
                }
                case 3: {
                    printWriter.print("(indentation)");
                    break;
                }
                case 4: {
                    printWriter.print("(block-start)");
                    break;
                }
                case 5: {
                    printWriter.print("(block-end)");
                    break;
                }
                case 6: {
                    printWriter.print("(tab)");
                }
            }
            printWriter.print(" size:");
            printWriter.print(n4);
            printWriter.print(";  @");
            printWriter.print(n + 1);
            printWriter.print(": posn:");
            printWriter.println(this.queueInts[n + 1]);
            if (n3 == 2 || n3 == 4) {
                printWriter.print('@');
                printWriter.print(n + 2);
                printWriter.print(": - depth:");
                printWriter.print(this.queueInts[n + 2]);
                printWriter.print(";  @");
                printWriter.print(n + 3);
                printWriter.print(": section-end:");
                printWriter.println(this.queueInts[n + 3]);
            }
            switch (n3) {
                case 4: {
                    this.printQueueWord(n, 4, "block-end", printWriter);
                    String string = this.queueStrings[n + 0];
                    this.printQueueStringWord(n, 0, "prefix", printWriter);
                    this.printQueueStringWord(n, 1, "suffix", printWriter);
                    break;
                }
                case 2: {
                    printWriter.print('@');
                    printWriter.print(n + 4);
                    printWriter.print(": - kind: ");
                    int n5 = this.queueInts[n + 4];
                    String string = "???";
                    switch (n5) {
                        case 78: {
                            string = "linear";
                            break;
                        }
                        case 76: {
                            string = "literal";
                            break;
                        }
                        case 70: {
                            string = "fill";
                            break;
                        }
                        case 77: {
                            string = "miser";
                            break;
                        }
                        case 82: {
                            string = "mandatory";
                        }
                    }
                    printWriter.print(n5);
                    printWriter.print('(');
                    printWriter.print(string);
                    printWriter.println(')');
                    break;
                }
                default: {
                    int n6 = 2;
                    while (n6 < n4) {
                        this.printQueueWord(n, n6, "word#" + n6, printWriter);
                        ++n6;
                    }
                    break block7;
                }
            }
            n2 -= n4;
            n += n4;
        }
    }

    private void printQueueWord(int n, int n2, String string, PrintWriter printWriter) {
        printWriter.print('@');
        printWriter.print(n + n2);
        printWriter.print(": - ");
        printWriter.print(string);
        printWriter.print(": ");
        printWriter.println(this.queueInts[n + n2]);
    }

    private void printQueueStringWord(int n, int n2, String string, PrintWriter printWriter) {
        printWriter.print('@');
        printWriter.print(n + n2);
        printWriter.print(": - ");
        printWriter.print(string);
        printWriter.print(": ");
        String string2 = this.queueStrings[n + n2];
        if (string2 == null) {
            printWriter.println("null");
        } else {
            printWriter.print('\"');
            printWriter.print(string2);
            printWriter.print('\"');
            printWriter.print(" length: ");
            printWriter.println(string2.length());
        }
    }
}

