/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import com.sun.faces.el.impl.ValueSuffix;
import java.util.List;

public class ComplexValue
extends Expression {
    Expression mPrefix;
    List mSuffixes;

    public Expression getPrefix() {
        return this.mPrefix;
    }

    public void setPrefix(Expression pPrefix) {
        this.mPrefix = pPrefix;
    }

    public List getSuffixes() {
        return this.mSuffixes;
    }

    public void setSuffixes(List pSuffixes) {
        this.mSuffixes = pSuffixes;
    }

    public ComplexValue(Expression pPrefix, List pSuffixes) {
        this.mPrefix = pPrefix;
        this.mSuffixes = pSuffixes;
    }

    public String getExpressionString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mPrefix.getExpressionString());
        int i = 0;
        while (this.mSuffixes != null && i < this.mSuffixes.size()) {
            ValueSuffix suffix = (ValueSuffix)this.mSuffixes.get(i);
            buf.append(suffix.getExpressionString());
            ++i;
        }
        return buf.toString();
    }

    public Object evaluate(ExpressionInfo exprInfo) throws ElException {
        Object ret = this.mPrefix.evaluate(exprInfo);
        int i = 0;
        while (this.mSuffixes != null && i < this.mSuffixes.size()) {
            ValueSuffix suffix = (ValueSuffix)this.mSuffixes.get(i);
            ret = suffix.evaluate(ret, exprInfo);
            ++i;
        }
        return ret;
    }

    public void setValue(ExpressionInfo exprInfo, Object newValue) throws ElException {
        Object ret = this.mPrefix.evaluate(exprInfo);
        int i = 0;
        while (this.mSuffixes != null && i < this.mSuffixes.size() - 1) {
            ValueSuffix suffix = (ValueSuffix)this.mSuffixes.get(i);
            ret = suffix.evaluate(ret, exprInfo);
            ++i;
        }
        if (this.mSuffixes != null && !this.mSuffixes.isEmpty()) {
            ValueSuffix last = (ValueSuffix)this.mSuffixes.get(this.mSuffixes.size() - 1);
            last.setValue(ret, newValue, exprInfo);
        }
    }

    public boolean isReadOnly(ExpressionInfo exprInfo) throws ElException {
        Object ret = this.mPrefix.evaluate(exprInfo);
        boolean result = this.mPrefix.isReadOnly(exprInfo);
        int i = 0;
        while (this.mSuffixes != null && i < this.mSuffixes.size() - 1) {
            ValueSuffix suffix = (ValueSuffix)this.mSuffixes.get(i);
            ret = suffix.evaluate(ret, exprInfo);
            ++i;
        }
        if (this.mSuffixes != null && !this.mSuffixes.isEmpty()) {
            ValueSuffix last = (ValueSuffix)this.mSuffixes.get(this.mSuffixes.size() - 1);
            result = last.isReadOnly(ret, exprInfo);
        }
        return result;
    }

    public Class getType(ExpressionInfo exprInfo) throws ElException {
        Object ret = this.mPrefix.evaluate(exprInfo);
        Class result = this.mPrefix.getType(exprInfo);
        int i = 0;
        while (this.mSuffixes != null && i < this.mSuffixes.size() - 1) {
            ValueSuffix suffix = (ValueSuffix)this.mSuffixes.get(i);
            ret = suffix.evaluate(ret, exprInfo);
            ++i;
        }
        if (this.mSuffixes != null && !this.mSuffixes.isEmpty()) {
            ValueSuffix last = (ValueSuffix)this.mSuffixes.get(this.mSuffixes.size() - 1);
            result = last.getType(ret, exprInfo);
        }
        return result;
    }
}

