/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.AliasConstraint;
import gnu.mapping.Binding;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.SFormat;
import gnu.mapping.Values;
import kawa.lang.Macro;

public class SetExp
extends Expression {
    private int flags;
    String name;
    public Declaration binding;
    Expression new_value;
    private static int DEFINING_FLAG = 1;
    private static int GLOBAL_FLAG = 2;
    public static int PREFER_BINDING2 = 4;
    private static int PROCEDURE = 8;
    private static int SET_IF_UNBOUND = 16;
    private static int HAS_VALUE = 32;
    static Method setMethod = null;

    public SetExp(String string, Expression expression) {
        this.name = string;
        this.new_value = expression;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isDefining() {
        return (this.flags & DEFINING_FLAG) != 0;
    }

    public final void setDefining(boolean bl) {
        this.flags = bl ? (this.flags |= DEFINING_FLAG) : (this.flags &= ~DEFINING_FLAG);
    }

    public final boolean getHasValue() {
        return (this.flags & HAS_VALUE) != 0;
    }

    public final void setHasValue(boolean bl) {
        this.flags = bl ? (this.flags |= HAS_VALUE) : (this.flags &= ~HAS_VALUE);
    }

    public final boolean isFuncDef() {
        return (this.flags & PROCEDURE) != 0;
    }

    public final void setFuncDef(boolean bl) {
        this.flags = bl ? (this.flags |= PROCEDURE) : (this.flags &= ~PROCEDURE);
    }

    public final boolean isSetIfUnbound() {
        return (this.flags & SET_IF_UNBOUND) != 0;
    }

    public final void setSetIfUnbound(boolean bl) {
        this.flags = bl ? (this.flags |= SET_IF_UNBOUND) : (this.flags &= ~SET_IF_UNBOUND);
    }

    public SetExp(Declaration declaration, Expression expression) {
        this.binding = declaration;
        this.name = declaration.getName();
        this.new_value = expression;
    }

    public Object eval(Environment environment) {
        if (this.isSetIfUnbound()) {
            Binding binding = environment.getBinding(this.name);
            if (!binding.isBound()) {
                binding.set(this.new_value.eval(environment));
            }
            if (this.getHasValue()) {
                return this.name;
            }
            return Interpreter.getInterpreter().noValue();
        }
        Object object2 = this.new_value.eval(environment);
        if (this.binding != null && (!this.binding.isStatic() || this.binding.isPrivate())) {
            throw new Error("internal error - SetExp.eval with lexical binding");
        }
        if (this.isDefining()) {
            if (this.binding != null && this.binding.isAlias()) {
                AliasConstraint.define(environment.getBinding(this.name), (Location)object2);
            } else {
                environment.define(this.name, object2);
            }
        } else {
            Binding binding = environment.lookup(this.name);
            if (binding != null) {
                environment.put(this.name, object2);
            } else {
                environment.define(this.name, object2);
            }
        }
        return this.getHasValue() ? object2 : Interpreter.getInterpreter().noValue();
    }

    public void compile(Compilation compilation, Target target) {
        if (this.new_value instanceof LambdaExp && target instanceof IgnoreTarget && ((LambdaExp)this.new_value).getInlineOnly()) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        boolean bl = this.getHasValue() && !(target instanceof IgnoreTarget);
        boolean bl2 = false;
        Declaration declaration = this.binding;
        if (!declaration.isPrivate() && !Compilation.usingCPStyle() && declaration.context instanceof ModuleExp && declaration.getValue() instanceof LambdaExp && ((LambdaExp)declaration.getValue()).getName() != null && declaration.getValue() == this.new_value) {
            ((LambdaExp)this.new_value).compileSetField(compilation);
        } else if (!(declaration.context instanceof ModuleExp) || !(this.new_value instanceof QuoteExp) || declaration.isPrivate() || compilation.immediate || declaration.getValue() == null) {
            Expression expression;
            if (declaration.getFlag(32768) && declaration.context instanceof ModuleExp && (expression = ((Macro)declaration.getConstantValue()).expander) instanceof LambdaExp && !declaration.isPrivate()) {
                LambdaExp lambdaExp = (LambdaExp)expression;
                if (!lambdaExp.isHandlingTailCalls()) {
                    lambdaExp.flags |= 0x100;
                    lambdaExp.compileAsMethod(compilation);
                    compilation.mainLambda.applyMethods.addElement(lambdaExp);
                }
                declaration.makeField(compilation, this.new_value);
            } else {
                if (!this.isDefining()) {
                    declaration = Declaration.followAliases(declaration);
                }
                if (declaration.ignorable()) {
                    this.new_value.compile(compilation, Target.Ignore);
                } else if (declaration.isAlias() && this.isDefining()) {
                    if (declaration.isPublic() || !(declaration.getValue() instanceof ReferenceExp)) {
                        declaration.load(compilation);
                        this.new_value.compile(compilation, Target.pushObject);
                        Method method = ClassType.make("gnu.mapping.AliasConstraint").getDeclaredMethod("define", 2);
                        codeAttr.emitInvokeStatic(method);
                    }
                } else if (declaration.isIndirectBinding() && (!this.isDefining() || declaration.isPublic())) {
                    declaration.load(compilation);
                    this.new_value.compile(compilation, Target.pushObject);
                    if (bl) {
                        codeAttr.emitDupX();
                        bl2 = true;
                    }
                    if (setMethod == null) {
                        setMethod = Compilation.typeLocation.addMethod("set", Compilation.apply1args, Type.void_type, 17);
                    }
                    codeAttr.emitInvokeVirtual(setMethod);
                } else if (declaration.isFluid()) {
                    declaration.load(compilation);
                    this.new_value.compile(compilation, Type.pointer_type);
                    codeAttr.emitPutField(FluidLetExp.valueField);
                } else if (declaration.isSimple()) {
                    Variable variable;
                    Type type = declaration.getType();
                    this.new_value.compile(compilation, type);
                    if (bl) {
                        codeAttr.emitDup(type);
                        bl2 = true;
                    }
                    if ((variable = declaration.getVariable()) == null) {
                        variable = declaration.allocateVariable(codeAttr);
                    }
                    codeAttr.emitStore(variable);
                } else {
                    Field field = declaration.field;
                    if (!field.getStaticFlag()) {
                        declaration.loadOwningObject(compilation);
                    }
                    Type type = field.getType();
                    this.new_value.compile(compilation, type);
                    if (field.getStaticFlag()) {
                        if (bl) {
                            codeAttr.emitDup(type);
                            bl2 = true;
                        }
                        codeAttr.emitPutStatic(field);
                    } else {
                        if (bl) {
                            codeAttr.emitDupX();
                            bl2 = true;
                        }
                        codeAttr.emitPutField(field);
                    }
                }
            }
        }
        if (bl && !bl2) {
            throw new Error("SetExp.compile: not implemented - return value");
        }
        if (bl) {
            target.compileFromStack(compilation, this.getType());
        } else {
            compilation.compileConstant(Values.empty, target);
        }
    }

    public final Type getType() {
        return !this.getHasValue() ? Type.void_type : (this.binding == null ? Type.pointer_type : this.binding.getType());
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkSetExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.new_value = this.new_value.walk(expWalker);
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock(this.isDefining() ? "(Define" : "(Set", ")", 2);
        outPort.writeSpaceFill();
        SFormat.print(this.name, outPort);
        outPort.writeSpaceLinear();
        this.new_value.print(outPort);
        outPort.endLogicalBlock(")");
    }
}

