/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.commonlisp.lang.Symbol;
import gnu.jemacs.buffer.BufferContent;
import gnu.jemacs.buffer.BufferKeymap;
import gnu.jemacs.buffer.BufferLocalConstraint;
import gnu.jemacs.buffer.BufferReader;
import gnu.jemacs.buffer.Frame;
import gnu.jemacs.buffer.Marker;
import gnu.jemacs.buffer.Mode;
import gnu.jemacs.buffer.Signal;
import gnu.jemacs.buffer.Window;
import gnu.lists.CharSequence;
import gnu.mapping.WrappedException;
import gnu.text.Char;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StringContent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class Buffer
extends DefaultStyledDocument {
    String name;
    String filename;
    String encoding;
    static Buffer current;
    static StyleContext styles;
    static Style defaultStyle;
    Style inputStyle = defaultStyle;
    static Style redStyle;
    static Style blueStyle;
    Marker pointMarker;
    Marker markMarker;
    Caret curPosition = null;
    BufferContent content;
    StyledDocument modelineDocument;
    public final BufferKeymap keymap = new BufferKeymap(this);
    Mode modes;
    public static Hashtable buffers;
    public static Hashtable fileBuffers;
    int tabWidth = 8;

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setFileName(String string) {
        if (this.filename != null && fileBuffers.get(this.filename) == this) {
            fileBuffers.remove(this.filename);
        }
        if (this.name != null && buffers.get(this.name) == this) {
            buffers.remove(this.name);
        }
        this.filename = string;
        this.name = Buffer.generateNewBufferName(new File(string).getName());
        buffers.put(this.name, this);
        fileBuffers.put(this.filename, this);
        this.redrawModeline();
    }

    public CharSequence getStringContent() {
        return this.content;
    }

    public static Buffer findFile(String string) {
        Buffer buffer = (Buffer)fileBuffers.get(string);
        if (buffer == null) {
            buffer = new Buffer(null);
            buffer.setFileName(string);
            buffer.encoding = System.getProperty("file.encoding", "UTF8");
            try {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), buffer.encoding);
                buffer.insertFile(inputStreamReader);
                ((Reader)inputStreamReader).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                Signal.message("New file");
            }
            catch (Exception exception) {
                throw new RuntimeException("error reading file \"" + string + "\": " + exception);
            }
        }
        return buffer;
    }

    public static Buffer getBuffer(String string) {
        return (Buffer)buffers.get(string);
    }

    public static Buffer coerceBuffer(Object object2) {
        if (object2 instanceof Buffer) {
            return (Buffer)object2;
        }
        return Buffer.getBuffer(object2.toString());
    }

    public static String generateNewBufferName(String string) {
        Buffer buffer = Buffer.getBuffer(string);
        if (buffer == null) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 5);
        stringBuffer.append(string);
        stringBuffer.append('<');
        int n2 = 2;
        while (true) {
            stringBuffer.append(n2);
            stringBuffer.append('>');
            String string2 = stringBuffer.toString();
            buffer = Buffer.getBuffer(string2);
            if (buffer == null) {
                return string2;
            }
            stringBuffer.setLength(n + 1);
            ++n2;
        }
    }

    public void redrawModeline() {
        try {
            this.modelineDocument.remove(0, this.modelineDocument.getLength());
            this.modelineDocument.insertString(0, "-----", redStyle);
            this.modelineDocument.insertString(this.modelineDocument.getLength(), "JEmacs: " + this.getName(), blueStyle);
            this.modelineDocument.insertString(this.modelineDocument.getLength(), " ---", redStyle);
        }
        catch (BadLocationException badLocationException) {
            throw new Error("internal error in redraw-modeline- " + badLocationException);
        }
    }

    public Buffer(String string) {
        this(string, new BufferContent());
    }

    public Buffer(String string, BufferContent bufferContent) {
        super((AbstractDocument.Content)bufferContent, styles);
        this.name = string;
        this.content = bufferContent;
        this.pointMarker = new Marker(this, 0, true);
        this.markMarker = new Marker();
        this.modelineDocument = new DefaultStyledDocument((AbstractDocument.Content)new StringContent(), styles);
        this.putProperty("i18n", Boolean.TRUE);
        this.redrawModeline();
    }

    public int checkMark() {
        return this.markMarker.getOffset();
    }

    public static Buffer getCurrent() {
        return current;
    }

    public static void setCurrent(Buffer buffer) {
        current = buffer;
    }

    public final int getDot() {
        return this.pointMarker.getOffset();
    }

    public int getPoint() {
        return 1 + this.getDot();
    }

    public final void setDot(int n) {
        if (n > this.maxDot()) {
            throw new Error("set dot to " + n + " max:" + this.maxDot());
        }
        this.pointMarker.set(this, n);
    }

    public final void setPoint(int n) {
        this.setDot(n - 1);
    }

    public int minDot() {
        return 0;
    }

    public int maxDot() {
        return this.content.length() - 1;
    }

    public void forwardChar(int n) {
        this.pointMarker.forwardChar(n);
    }

    public void backwardChar(int n) {
        this.pointMarker.backwardChar(n);
    }

    public String toString() {
        return "#<buffer \"" + this.name + "\">";
    }

    public void insertString(String string, Style style) {
        this.pointMarker.insert(string, style);
    }

    public void insertAll(Object[] objectArray, Style style) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2 = objectArray[n2];
            if (object2 instanceof Char) {
                this.insert(((Char)object2).charValue(), 1, style);
            } else {
                this.pointMarker.insert(object2.toString(), style);
            }
            ++n2;
        }
    }

    public void insert(Object object2, Style style) {
        if (object2 instanceof Char) {
            this.insert(((Char)object2).charValue(), 1, style);
        } else {
            this.pointMarker.insert(object2.toString(), style);
        }
    }

    public void insert(char c, int n, Style style) {
        this.pointMarker.insert(c, n, style);
    }

    public void deleteChar(int n) {
        this.pointMarker.deleteChar(n);
    }

    public void removeRegion(int n, int n2) throws BadLocationException {
        this.remove(n, n2 - n);
    }

    public void removeAll() {
        try {
            this.remove(0, this.maxDot());
        }
        catch (BadLocationException badLocationException) {
            throw new WrappedException(badLocationException);
        }
    }

    public Marker getPointMarker(boolean bl) {
        return bl ? this.pointMarker : new Marker(this.pointMarker);
    }

    public Marker getMarkMarker(boolean bl) {
        return this.markMarker;
    }

    public int positionToOffset(Object object2) {
        if (object2 instanceof Number) {
            int n = this.minDot();
            int n2 = this.maxDot();
            int n3 = ((Number)object2).intValue() - 1;
            return n3 < n ? n : (n3 > n2 ? n2 : n3);
        }
        return ((Position)object2).getOffset();
    }

    public void save(Writer writer) throws IOException, BadLocationException {
        int n;
        int n2 = n = this.getLength();
        Segment segment = new Segment();
        int n3 = 0;
        while (n3 < n) {
            int n4 = n;
            if (n4 > 4096) {
                n4 = 4096;
            }
            this.getText(n3, n4, segment);
            writer.write(segment.array, segment.offset, segment.count);
            n3 += n4;
        }
    }

    public void save() {
        try {
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding", "UTF8");
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), this.encoding);
            this.save(outputStreamWriter);
            ((Writer)outputStreamWriter).close();
        }
        catch (Exception exception) {
            throw new RuntimeException("error save-buffer: " + exception);
        }
    }

    public void insertFile(Reader reader) throws IOException, BadLocationException {
        int n;
        char[] cArray = new char[2048];
        int n2 = this.getDot();
        while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
            this.insertString(n2, new String(cArray, 0, n), null);
            n2 += n;
        }
    }

    public void insertFile(String string) {
        try {
            if (this.encoding == null) {
                this.encoding = System.getProperty("file.encoding", "UTF8");
            }
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string), this.encoding);
            this.insertFile(inputStreamReader);
            ((Reader)inputStreamReader).close();
        }
        catch (Exception exception) {
            throw new RuntimeException("error reading file \"" + string + "\": " + exception);
        }
    }

    public int charWidth(char c, int n) {
        if (c < '\u3000') {
            if (c < ' ') {
                if (c == '\t') {
                    return (n + this.tabWidth) / this.tabWidth * this.tabWidth - n;
                }
                return 0;
            }
        } else {
            if (c < '\ud800' || c >= '\uff01' && c <= '\uff5e' || c >= '\uffe0' && c <= '\uffe6') {
                return 2;
            }
            if (c < '\ue000') {
                return 0;
            }
        }
        return 1;
    }

    public int countColumns(char[] cArray, int n, int n2, int n3) {
        while (--n2 >= 0) {
            n3 += this.charWidth(cArray[n++], n3);
        }
        return n3;
    }

    public int currentColumn() {
        return this.currentColumn(this.getDot());
    }

    public int currentColumn(int n) {
        int n2 = this.lineStartOffset(n);
        BufferReader bufferReader = new BufferReader(this, n2, n - n2);
        int n3 = 0;
        while (bufferReader.read() >= 0) {
            int n4 = bufferReader.pos - 1;
            n3 = this.countColumns(bufferReader.buffer, n4, bufferReader.limit - n4, n3);
            bufferReader.pos = bufferReader.limit;
        }
        return n3;
    }

    public int moveToColumn(int n, boolean bl) {
        return this.pointMarker.moveToColumn(n, bl);
    }

    public int lineStartOffset(int n) {
        return (int)this.content.scan('\n', n, this.minDot(), -1, true);
    }

    public int lineStartOffset() {
        return this.lineStartOffset(this.getDot());
    }

    public final long scan(char c, int n, int n2, int n3, boolean bl) {
        if (n2 == 0) {
            n2 = n3 > 0 ? this.content.length() - 1 : 0;
        }
        return this.content.scan(c, n, n2, n3, bl);
    }

    public final long forwardLine(int n, int n2) {
        boolean bl = n <= 0;
        long l = this.scan('\n', n2, 0, n - (bl ? 1 : 0), true);
        int n3 = (int)(l >> 32);
        int n4 = (int)l;
        if (n3 > 0 && (bl || this.maxDot() > this.minDot() && n4 != n2 && this.content.charAt(n4 - 1) != '\n')) {
            --n3;
        }
        return (bl ? (long)(-n3) : (long)n3) << 32 | (long)n4;
    }

    public int forwardLine(int n) {
        long l = this.forwardLine(n, this.getDot());
        this.setDot((int)l);
        return (int)(l >> 32);
    }

    public Window display(boolean bl, Frame frame6) {
        Window window;
        Window window2;
        if (frame6 == null) {
            frame6 = Frame.getSelectedFrame();
        }
        if ((window2 = frame6.getSelectedWindow()) == (window = frame6.otherWindow(1)) && bl) {
            window = window2.split(-1, false);
        }
        window.setBuffer(this);
        return window;
    }

    public static void makeBufferLocal(Object object2, boolean bl) {
        BufferLocalConstraint.make(Symbol.getBinding(object2), bl);
    }

    static {
        styles = new StyleContext();
        defaultStyle = styles.addStyle("default", null);
        redStyle = styles.addStyle("red", null);
        blueStyle = styles.addStyle("blue", null);
        String string = System.getProperty("java.version");
        if (string != null && (string.startsWith("1.2") || string.startsWith("1.3"))) {
            StyleConstants.setFontFamily(defaultStyle, "Lucida Sans TypeWriter");
            StyleConstants.setFontSize(defaultStyle, 14);
        }
        StyleConstants.setForeground(redStyle, Color.red);
        StyleConstants.setForeground(blueStyle, Color.blue);
        buffers = new Hashtable(100);
        fileBuffers = new Hashtable(100);
    }
}

