/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.SourceFileAttr;
import gnu.bytecode.Type;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class ClassType
extends ObjectType
implements AttrContainer {
    public static final int minor_version = 3;
    public static final int major_version = 45;
    int thisClassIndex;
    ClassType superClass;
    int superClassIndex = -1;
    ClassType[] interfaces;
    int[] interfaceIndexes;
    public int access_flags;
    Attribute attributes;
    String sourcefile;
    boolean emitDebugInfo = true;
    ConstantPool constants;
    Field fields;
    int fields_count;
    Field last_field;
    int ConstantValue_name_index;
    int Code_name_index;
    int LocalVariableTable_name_index;
    int LineNumberTable_name_index;
    Method methods;
    int methods_count;
    Method last_method;
    public Method constructor;

    public static ClassType make(String string) {
        return (ClassType)Type.getType(string);
    }

    public static ClassType make(String string, ClassType classType) {
        ClassType classType2 = ClassType.make(string);
        if (classType2.superClass == null) {
            classType2.setSuper(classType);
        }
        return classType2;
    }

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attribute) {
        this.attributes = attribute;
    }

    public final ConstantPool getConstants() {
        return this.constants;
    }

    public final CpoolEntry getConstant(int n) {
        if (this.constants == null || this.constants.pool == null || n > this.constants.count) {
            return null;
        }
        return this.constants.pool[n];
    }

    public final int getModifiers() {
        if (this.access_flags == 0 && this.getReflectClass() != null) {
            this.access_flags = this.reflectClass.getModifiers();
        }
        return this.access_flags;
    }

    public final void setModifiers(int n) {
        this.access_flags = n;
    }

    public void setName(String string) {
        this.this_name = string;
        string = string.replace('.', '/');
        this.setSignature("L" + string + ";");
    }

    public void setSourceFile(String string) {
        SourceFileAttr.setSourceFile(this, string);
    }

    public void setSuper(String string) {
        this.setSuper(string == null ? Type.pointer_type : ClassType.make(string));
    }

    public void setSuper(ClassType classType) {
        this.superClass = classType;
    }

    public ClassType getSuperclass() {
        Class clazz;
        if (this.superClass == null && this.getReflectClass() != null && (clazz = this.reflectClass.getSuperclass()) != null) {
            this.superClass = (ClassType)Type.make(clazz);
        }
        return this.superClass;
    }

    public ClassType[] getInterfaces() {
        if (this.interfaces == null && this.reflectClass != null) {
            Class<?>[] classArray = this.reflectClass.getInterfaces();
            this.interfaces = new ClassType[classArray.length];
            int n = 0;
            while (n < classArray.length) {
                this.interfaces[n] = (ClassType)Type.make(classArray[n]);
                ++n;
            }
        }
        return this.interfaces;
    }

    public void setInterfaces(ClassType[] classTypeArray) {
        this.interfaces = classTypeArray;
    }

    public void addInterface(ClassType classType) {
        int n;
        if (this.interfaces == null || this.interfaces.length == 0) {
            n = 0;
            this.interfaces = new ClassType[1];
        } else {
            int n2 = n = this.interfaces.length;
            while (--n2 >= 0) {
                if (this.interfaces[n2] != classType) continue;
                return;
            }
            ClassType[] classTypeArray = new ClassType[n + 1];
            System.arraycopy(this.interfaces, 0, classTypeArray, 0, n);
            this.interfaces = classTypeArray;
        }
        this.interfaces[n] = classType;
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public ClassType() {
    }

    public ClassType(String string) {
        this.setName(string);
    }

    public final Field getFields() {
        if ((this.flags & 5) == 4) {
            this.addFields();
        }
        return this.fields;
    }

    public final int getFieldCount() {
        return this.fields_count;
    }

    public Field getDeclaredField(String string) {
        if ((this.flags & 5) == 4) {
            this.addFields();
        }
        Field field = this.fields;
        while (field != null) {
            if (string.equals(field.name)) {
                return field;
            }
            field = field.next;
        }
        return null;
    }

    public Field getField(String string) {
        ClassType classType = this;
        do {
            Field field;
            if ((field = classType.getDeclaredField(string)) == null) continue;
            return field;
        } while ((classType = classType.getSuperclass()) != null);
        return null;
    }

    public Field addField() {
        return new Field(this);
    }

    public Field addField(String string) {
        Field field = new Field(this);
        field.setName(string);
        return field;
    }

    public final Field addField(String string, Type type) {
        Field field = new Field(this);
        field.setName(string);
        field.setType(type);
        return field;
    }

    public final Field addField(String string, Type type, int n) {
        Field field = this.addField(string, type);
        field.flags = n;
        return field;
    }

    public void addFields() {
        java.lang.reflect.Field[] fieldArray;
        Class clazz = this.getReflectClass();
        try {
            fieldArray = clazz.getDeclaredFields();
        }
        catch (SecurityException securityException) {
            fieldArray = clazz.getFields();
        }
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            java.lang.reflect.Field field = fieldArray[n2];
            if (field.getDeclaringClass().equals(clazz) && ((n3 = field.getModifiers()) & 5) != 0) {
                this.addField(field.getName(), Type.make(field.getType()), n3);
            }
            ++n2;
        }
        this.flags |= 1;
    }

    public final Method getMethods() {
        return this.methods;
    }

    public final int getMethodCount() {
        return this.methods_count;
    }

    Method addMethod() {
        return new Method(this, 0);
    }

    public Method addMethod(String string) {
        Method method = new Method(this, 0);
        method.setName(string);
        return method;
    }

    public Method addMethod(String string, int n) {
        Method method = new Method(this, n);
        method.setName(string);
        return method;
    }

    public Method addMethod(String string, Type[] typeArray, Type type, int n) {
        return this.addMethod(string, n, typeArray, type);
    }

    public Method addMethod(String string, int n, Type[] typeArray, Type type) {
        Method method = this.getDeclaredMethod(string, typeArray);
        if (method != null && type.equals(method.getReturnType()) && (n & method.access_flags) == n) {
            return method;
        }
        method = new Method(this, n);
        method.setName(string);
        method.arg_types = typeArray;
        method.return_type = type;
        return method;
    }

    public Method addMethod(String string, String string2, int n) {
        Method method = this.addMethod(string, n);
        method.setSignature(string2);
        return method;
    }

    public Method getDeclaredMethods() {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        return this.methods;
    }

    public Method[] getMethods(Filter filter, boolean bl) {
        Object object2;
        int n = 0;
        ClassType classType = this;
        while (classType != null) {
            object2 = classType.getDeclaredMethods();
            while (object2 != null) {
                if (filter.select(object2)) {
                    ++n;
                }
                object2 = object2.getNext();
            }
            if (!bl) break;
            classType = classType.getSuperclass();
        }
        object2 = new Method[n];
        n = 0;
        ClassType classType2 = this;
        while (classType2 != null) {
            Method method = classType2.getDeclaredMethods();
            while (method != null) {
                if (filter.select(method)) {
                    object2[n++] = method;
                }
                method = method.getNext();
            }
            if (!bl) break;
            classType2 = classType2.getSuperclass();
        }
        return object2;
    }

    /*
     * Unable to fully structure code
     */
    public Method getDeclaredMethod(String var1_1, Type[] var2_2) {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        var3_3 = this.methods;
        while (var3_3 != null) {
            block5: {
                if (!var1_1.equals(var3_3.getName())) break block5;
                var4_4 = var3_3.getParameterTypes();
                if (var2_2 == null || var2_2 == var4_4) {
                    return var3_3;
                }
                var5_5 = var2_2.length;
                if (var5_5 == var4_4.length) ** GOTO lbl-1000
                break block5;
                while (var2_2[var5_5] == var4_4[var5_5]) lbl-1000:
                // 2 sources

                {
                    if (--var5_5 >= 0) continue;
                }
                if (var5_5 < 0) {
                    return var3_3;
                }
            }
            var3_3 = var3_3.next;
        }
        return null;
    }

    public Method getDeclaredMethod(String string, int n) {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        Method method = null;
        Method method2 = this.methods;
        while (method2 != null) {
            if (string.equals(method2.getName()) && n == method2.getParameterTypes().length) {
                if (method != null) {
                    throw new Error("ambiguous call to getDeclaredMethod(\"" + string + "\", " + n + ")\n - " + method + "\n - " + method2);
                }
                method = method2;
            }
            method2 = method2.next;
        }
        return method;
    }

    public Method getMethod(String string, Type[] typeArray) {
        ClassType classType = this;
        do {
            Method method;
            if ((method = classType.getDeclaredMethod(string, typeArray)) == null) continue;
            return method;
        } while ((classType = classType.getSuperclass()) != null);
        return null;
    }

    public void addMethods(Class clazz) {
        Object[] objectArray;
        int n;
        Class<?>[] classArray;
        Object object2;
        java.lang.reflect.Method[] methodArray;
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (SecurityException securityException) {
            methodArray = clazz.getMethods();
        }
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            object2 = methodArray[n3];
            if (((java.lang.reflect.Method)object2).getDeclaringClass().equals(clazz) && ((n4 = ((java.lang.reflect.Method)object2).getModifiers()) & 5) != 0) {
                classArray = ((java.lang.reflect.Method)object2).getParameterTypes();
                n = classArray.length;
                objectArray = new Type[n];
                while (--n >= 0) {
                    objectArray[n] = Type.make(classArray[n]);
                }
                Method method = new Method(this, n4);
                method.setName(((java.lang.reflect.Method)object2).getName());
                method.arg_types = objectArray;
                method.return_type = Type.make(((java.lang.reflect.Method)object2).getReturnType());
            }
            ++n3;
        }
        try {
            object2 = clazz.getDeclaredConstructors();
        }
        catch (SecurityException securityException) {
            object2 = clazz.getConstructors();
        }
        n2 = ((Object)object2).length;
        int n5 = 0;
        while (n5 < n2) {
            classArray = object2[n5];
            if (classArray.getDeclaringClass().equals(clazz) && ((n = classArray.getModifiers()) & 5) != 0) {
                objectArray = classArray.getParameterTypes();
                int n6 = objectArray.length;
                Type[] typeArray = new Type[n6];
                while (--n6 >= 0) {
                    typeArray[n6] = Type.make((Class)objectArray[n6]);
                }
                Method method = new Method(this, n);
                method.setName("<init>");
                method.arg_types = typeArray;
                method.return_type = Type.void_type;
            }
            ++n5;
        }
        this.flags |= 2;
    }

    public Method[] getMatchingMethods(String string, Type[] typeArray, int n) {
        Object[] objectArray;
        int n2 = this.getMethodCount();
        int n3 = 0;
        Vector<Method> vector = new Vector<Method>(10);
        Method method = this.methods;
        while (method != null) {
            if (string.equals(method.getName()) && (n & 8) == (method.access_flags & 8) && (n & 1) <= (method.access_flags & 1) && (objectArray = method.arg_types).length == typeArray.length) {
                ++n3;
                vector.addElement(method);
            }
            method = method.getNext();
        }
        objectArray = new Method[n3];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void doFixups() {
        if (this.constants == null) {
            this.constants = new ConstantPool();
        }
        if (this.thisClassIndex == 0) {
            this.thisClassIndex = this.constants.addClass((ObjectType)this).index;
        }
        if (this.superClass == this) {
            this.setSuper((ClassType)null);
        }
        if (this.superClassIndex < 0) {
            int n = this.superClassIndex = this.superClass == null ? 0 : this.constants.addClass((ObjectType)this.superClass).index;
        }
        if (this.interfaces != null && this.interfaceIndexes == null) {
            int n = this.interfaces.length;
            this.interfaceIndexes = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.interfaceIndexes[n2] = this.constants.addClass((ObjectType)this.interfaces[n2]).index;
                ++n2;
            }
        }
        Field field = this.fields;
        while (field != null) {
            field.assign_constants(this);
            field = field.next;
        }
        Method method = this.methods;
        while (method != null) {
            method.assignConstants();
            method = method.next;
        }
        Attribute.assignConstants(this, this);
    }

    public void writeToStream(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.doFixups();
        dataOutputStream.writeInt(-889275714);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(45);
        if (this.constants == null) {
            dataOutputStream.writeShort(1);
        } else {
            this.constants.write(dataOutputStream);
        }
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.thisClassIndex);
        dataOutputStream.writeShort(this.superClassIndex);
        if (this.interfaceIndexes == null) {
            dataOutputStream.writeShort(0);
        } else {
            int n = this.interfaceIndexes.length;
            dataOutputStream.writeShort(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeShort(this.interfaceIndexes[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeShort(this.fields_count);
        Field field = this.fields;
        while (field != null) {
            field.write(dataOutputStream, this);
            field = field.next;
        }
        dataOutputStream.writeShort(this.methods_count);
        Method method = this.methods;
        while (method != null) {
            method.write(dataOutputStream, this);
            method = method.next;
        }
        Attribute.writeAll(this, dataOutputStream);
        this.flags |= 3;
    }

    public void writeToFile(String string) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
        this.writeToStream(bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
    }

    public void writeToFile() throws IOException {
        this.writeToFile(this.this_name.replace('.', File.separatorChar) + ".class");
    }

    public byte[] writeToArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(500);
        this.writeToStream(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] to_utf8(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            n2 = c > '\u0000' && c <= '\u007f' ? ++n2 : (c <= '\u07ff' ? (n2 += 2) : (n2 += 3));
            ++n3;
        }
        byte[] byArray = new byte[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            char c = string.charAt(n5);
            if (c > '\u0000' && c <= '\u007f') {
                byArray[n4++] = (byte)c;
            } else if (c <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                byArray[n4++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++n5;
        }
        return byArray;
    }

    public final boolean implementsInterface(ClassType classType) {
        if (this == classType) {
            return true;
        }
        ClassType classType2 = this.getSuperclass();
        if (classType2 != null && classType2.implementsInterface(classType)) {
            return true;
        }
        ClassType[] classTypeArray = this.getInterfaces();
        if (classTypeArray != null) {
            int n = classTypeArray.length;
            while (--n >= 0) {
                if (!classTypeArray[n].implementsInterface(classType)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isSubclass(ClassType classType) {
        ClassType classType2 = this;
        while (classType2 != null) {
            if (classType2 == classType) {
                return true;
            }
            classType2 = classType2.getSuperclass();
        }
        return false;
    }

    public int compare(Type type) {
        if (type == Type.nullType) {
            return 1;
        }
        if (type instanceof PrimType) {
            return Type.swappedCompareResult(((PrimType)type).compare(this));
        }
        if (type instanceof ArrayType) {
            return Type.swappedCompareResult(((ArrayType)type).compare(this));
        }
        if (!(type instanceof ClassType)) {
            return -3;
        }
        String string = this.getName();
        if (string != null && string.equals(type.getName())) {
            return 0;
        }
        ClassType classType = (ClassType)type;
        if (this.isInterface()) {
            if (classType.implementsInterface(this)) {
                return 1;
            }
            return -2;
        }
        if (classType.isInterface()) {
            if (this.implementsInterface(classType)) {
                return -1;
            }
            return -2;
        }
        if (this.isSubclass(classType)) {
            return -1;
        }
        if (classType.isSubclass(this)) {
            return 1;
        }
        return -3;
    }

    public String toString() {
        return "ClassType " + this.getName();
    }
}

