/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.CpoolUtf8;
import java.io.DataOutputStream;
import java.io.IOException;

public class SourceFileAttr
extends Attribute {
    String filename;
    int filename_index;

    public String getSourceFile() {
        return this.filename;
    }

    public void setSourceFile(String string) {
        this.filename = string;
        this.filename_index = 0;
    }

    public static void setSourceFile(ClassType classType, String string) {
        Attribute attribute = Attribute.get(classType, "SourceFile");
        if (attribute != null && attribute instanceof SourceFileAttr) {
            ((SourceFileAttr)attribute).setSourceFile(string);
        } else {
            SourceFileAttr sourceFileAttr = new SourceFileAttr(string);
            sourceFileAttr.addToFrontOf(classType);
        }
    }

    public SourceFileAttr(String string) {
        super("SourceFile");
        this.filename = string;
    }

    public SourceFileAttr(int n, ClassType classType) {
        super("SourceFile");
        CpoolUtf8 cpoolUtf8 = (CpoolUtf8)classType.constants.getForced(n, 1);
        this.filename = cpoolUtf8.string;
        this.filename_index = n;
    }

    public void assignConstants(ClassType classType) {
        super.assignConstants(classType);
        if (this.filename_index == 0) {
            this.filename_index = classType.getConstants().addUtf8(this.filename).getIndex();
        }
    }

    public final int getLength() {
        return 2;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.filename_index);
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", \"");
        classTypeWriter.print(this.getSourceFile());
        classTypeWriter.println('\"');
    }
}

