/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Target;

public class ConsumerTarget
extends Target {
    Declaration consumer;

    public ConsumerTarget(Declaration declaration) {
        this.consumer = declaration;
    }

    public void compileFromStack(Compilation compilation, Type type) {
        CodeAttr codeAttr = compilation.getCode();
        String string = null;
        Method method = null;
        if (type instanceof PrimType) {
            char c = type.getSignature().charAt(0);
            switch (c) {
                case 'B': 
                case 'I': 
                case 'S': {
                    string = "writeInt";
                    break;
                }
                case 'J': {
                    string = "writeLong";
                    break;
                }
                case 'F': {
                    string = "writeFloat";
                    break;
                }
                case 'D': {
                    string = "writeDouble";
                    break;
                }
                case 'C': {
                    string = "writeChar";
                    break;
                }
                case 'Z': {
                    string = "writeBoolean";
                    break;
                }
                case 'V': {
                    return;
                }
            }
        } else {
            string = "writeObject";
        }
        codeAttr.emitLoad(this.consumer.getVariable());
        codeAttr.emitSwap();
        if (method == null && string != null) {
            method = ClassType.make("gnu.kawa.util.Consumer").getDeclaredMethod(string, 1);
        }
        if (method != null) {
            codeAttr.emitInvokeInterface(method);
        }
    }

    public Type getType() {
        return Compilation.scmSequenceType;
    }
}

