/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Consumer;
import gnu.lists.PositionContainer;
import gnu.lists.SeqPosition;
import gnu.lists.Sequence;
import gnu.lists.SubSequence;
import gnu.lists.TreePosition;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractSequence {
    public abstract int size();

    public boolean isEmpty() {
        return this.size() > 0;
    }

    public int rank() {
        return 1;
    }

    public abstract Object get(int var1);

    public int getEffectiveIndex(int[] nArray) {
        return nArray[0];
    }

    public Object get(int[] nArray) {
        return this.get(nArray[0]);
    }

    public Object set(int[] nArray, Object object2) {
        return this.set(nArray[0], object2);
    }

    protected RuntimeException unsupported(String string) {
        string = this.getClass().getName() + " does not implement " + string;
        return new UnsupportedOperationException(string);
    }

    public Object set(int n, Object object2) {
        throw this.unsupported("set");
    }

    public void fill(Object object2) {
        SeqPosition seqPosition = this.getIterator();
        while (this.gotoNext(seqPosition)) {
            this.setPrevious(seqPosition.ipos, seqPosition.xpos, object2);
        }
        seqPosition.finalize();
    }

    public void fill(int n, int n2, Object object2) {
        int n3 = n;
        while (n3 < n2) {
            this.set(n3, object2);
            ++n3;
        }
    }

    public int indexOf(Object object2) {
        int n = 0;
        SeqPosition seqPosition = this.getIterator();
        while (seqPosition.hasNext()) {
            Object object3 = seqPosition.next();
            boolean bl = object2 == null ? object3 == null : object2.equals(object3);
            if (bl) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(Object object2) {
        int n = this.size();
        while (--n >= 0) {
            Object object3 = this.get(n);
            boolean bl = object2 == null ? object3 == null : object2.equals(object3);
            if (!bl) continue;
            return n;
        }
        return -1;
    }

    public boolean contains(Object object2) {
        SeqPosition seqPosition = this.getIterator();
        while (seqPosition.hasNext()) {
            Object object3 = seqPosition.next();
            boolean bl = object2 == null ? object3 == null : object2.equals(object3);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        SeqPosition seqPosition = this.getIterator();
        while (seqPosition.hasNext()) {
            Object object2 = seqPosition.next();
            if (this.contains(object2)) continue;
            return false;
        }
        return true;
    }

    public Enumeration elements() {
        SeqPosition seqPosition = new SeqPosition();
        this.makeStartPosition(seqPosition);
        return seqPosition;
    }

    public SeqPosition getIterator() {
        SeqPosition seqPosition = new SeqPosition();
        this.makeStartPosition(seqPosition);
        return seqPosition;
    }

    public Iterator iterator() {
        SeqPosition seqPosition = new SeqPosition();
        this.makeStartPosition(seqPosition);
        return seqPosition;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int n) {
        SeqPosition seqPosition = new SeqPosition();
        this.makePosition(n, seqPosition);
        return seqPosition;
    }

    protected void add(PositionContainer positionContainer, int n, Object object2) {
        throw this.unsupported("add");
    }

    public boolean add(Object object2) {
        this.add(this.size(), object2);
        return true;
    }

    public void add(int n, Object object2) {
        throw this.unsupported("add single Object at index");
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n++, iterator.next());
            bl = true;
        }
        return bl;
    }

    protected void remove(int n, Object object2, int n2) {
        SeqPosition seqPosition = new SeqPosition(this);
        this.makeRelativePosition(n, object2, n2, true, seqPosition, 0);
        if (n2 >= 0) {
            this.remove(n, object2, seqPosition.ipos, seqPosition.xpos);
        } else {
            this.remove(seqPosition.ipos, seqPosition.xpos, n, object2);
        }
    }

    protected void remove(int n, Object object2, int n2, Object object3) {
        throw this.unsupported("remove (with range)");
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        SeqPosition seqPosition = new SeqPosition(this);
        this.makePosition(n, seqPosition);
        Object object2 = this.getNext(seqPosition.ipos, seqPosition.xpos);
        this.remove(seqPosition.ipos, seqPosition.xpos, 1);
        return object2;
    }

    public boolean remove(Object object2) {
        int n = this.indexOf(object2);
        if (n < 0) {
            return false;
        }
        SeqPosition seqPosition = new SeqPosition();
        this.makePosition(n, seqPosition);
        this.remove(seqPosition.ipos, seqPosition.xpos, 1);
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        SeqPosition seqPosition = this.getIterator();
        while (seqPosition.hasNext()) {
            Object object2 = seqPosition.next();
            if (!collection.contains(object2)) continue;
            seqPosition.remove();
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        SeqPosition seqPosition = this.getIterator();
        while (seqPosition.hasNext()) {
            Object object2 = seqPosition.next();
            if (collection.contains(object2)) continue;
            seqPosition.remove();
            bl = true;
        }
        return bl;
    }

    public void clear() {
        SeqPosition seqPosition = new SeqPosition();
        this.makeStartPosition(seqPosition);
        this.remove(seqPosition.ipos, seqPosition.xpos, this.size());
    }

    protected boolean isAfter(int n, Object object2) {
        return false;
    }

    protected final void makePosition(int n, SeqPosition seqPosition) {
        this.makePosition(n, true, seqPosition);
    }

    public void makePosition(int n, boolean bl, SeqPosition seqPosition) {
        this.makePosition(n, bl, seqPosition, 0);
    }

    protected abstract void makePosition(int var1, boolean var2, PositionContainer var3, int var4);

    protected void makeRelativePosition(int n, Object object2, int n2, boolean bl, PositionContainer positionContainer, int n3) {
        this.makePosition(this.nextIndex(n, object2) + n2, bl, positionContainer, n3);
    }

    public void makeStartPosition(SeqPosition seqPosition) {
        this.makeStartPosition(seqPosition, 0);
    }

    protected void makeStartPosition(PositionContainer positionContainer, int n) {
        this.makePosition(0, false, positionContainer, n);
    }

    public void makeEndPosition(SeqPosition seqPosition) {
        this.makeEndPosition(seqPosition, 0);
        seqPosition.setSequence(0, this);
    }

    protected void makeEndPosition(PositionContainer positionContainer, int n) {
        this.makePosition(this.size(), true, positionContainer, n);
    }

    protected void releasePosition(int n, Object object2) {
    }

    protected final void releasePosition(SeqPosition seqPosition) {
        this.releasePosition(seqPosition.ipos, seqPosition.xpos);
    }

    protected void releasePosition(PositionContainer positionContainer, int n) {
        int n2 = positionContainer.getPositionInt(n);
        Object object2 = positionContainer.getPositionPtr(n);
        this.releasePosition(n2, object2);
    }

    public void copyPosition(int n, Object object2, PositionContainer positionContainer, int n2) {
        positionContainer.setSequence(n2, this);
        positionContainer.setPosition(n2, n, object2);
    }

    protected int getIndexDifference(int n, Object object2, int n2, Object object3) {
        return this.nextIndex(n, object2) - this.nextIndex(n2, object3);
    }

    protected int nextIndex(int n, Object object2) {
        throw this.unsupported("nextIndex");
    }

    protected int fromEndIndex(int n, Object object2) {
        return this.size() - this.nextIndex(n, object2);
    }

    protected int getContainingSequenceSize(int n, Object object2) {
        return this.size();
    }

    protected boolean hasNext(int n, Object object2) {
        return this.nextIndex(n, object2) != this.size();
    }

    protected int getNextKind(int n, Object object2) {
        return this.hasNext(n, object2) ? 32 : 0;
    }

    protected String getNextTypeName(int n, Object object2) {
        return null;
    }

    protected Object getNextTypeObject(int n, Object object2) {
        return null;
    }

    protected boolean hasPrevious(int n, Object object2) {
        return this.nextIndex(n, object2) != 0;
    }

    protected boolean gotoNext(PositionContainer positionContainer, int n) {
        Object object2;
        int n2 = positionContainer.getPositionInt(n);
        if (!this.hasNext(n2, object2 = positionContainer.getPositionPtr(n))) {
            return false;
        }
        this.makeRelativePosition(n2, object2, 1, true, positionContainer, n);
        return true;
    }

    protected boolean gotoNext(SeqPosition seqPosition) {
        return this.gotoNext(seqPosition, 0);
    }

    protected boolean gotoPrevious(PositionContainer positionContainer, int n) {
        Object object2;
        int n2 = positionContainer.getPositionInt(n);
        if (!this.hasPrevious(n2, object2 = positionContainer.getPositionPtr(n))) {
            return false;
        }
        this.makeRelativePosition(n2, object2, -1, false, positionContainer, n);
        return true;
    }

    protected boolean gotoChildrenStart(TreePosition treePosition) {
        return false;
    }

    protected boolean gotoParent(TreePosition treePosition) {
        if (treePosition.depth < 0) {
            return false;
        }
        treePosition.pop();
        return true;
    }

    public int getAttributeLength() {
        return 0;
    }

    public Object getAttribute(int n) {
        return null;
    }

    protected boolean gotoAttributesStart(TreePosition treePosition) {
        return false;
    }

    protected Object getNext(int n, Object object2) {
        return this.get(this.nextIndex(n, object2));
    }

    protected Object getPrevious(int n, Object object2) {
        return this.get(this.nextIndex(n, object2) - 1);
    }

    protected void setNext(int n, Object object2, Object object3) {
        int n2 = this.nextIndex(n, object2);
        if (n2 >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.set(n2, object3);
    }

    protected void setPrevious(int n, Object object2, Object object3) {
        int n2 = this.nextIndex(n, object2);
        if (n2 == 0) {
            throw new IndexOutOfBoundsException();
        }
        this.set(n2 - 1, object3);
    }

    public final int nextIndex(SeqPosition seqPosition) {
        return this.nextIndex(seqPosition.ipos, seqPosition.xpos);
    }

    public boolean equals(int n, Object object2, int n2, Object object3) {
        return this.compare(n, object2, n2, object3) == 0;
    }

    public int compare(int n, Object object2, int n2, Object object3) {
        int n3;
        int n4 = this.nextIndex(n, object2);
        return n4 < (n3 = this.nextIndex(n2, object3)) ? -1 : (n4 > n3 ? 1 : 0);
    }

    public final int compare(SeqPosition seqPosition, SeqPosition seqPosition2) {
        return this.compare(seqPosition.ipos, seqPosition.xpos, seqPosition2.ipos, seqPosition2.xpos);
    }

    public Object[] toArray() {
        return this.toArray(null);
    }

    public Object[] toArray(Object[] objectArray) {
        Object object2;
        int n = objectArray == null ? -1 : objectArray.length;
        int n2 = this.size();
        if (n2 > n) {
            object2 = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(object2, n2);
            n = n2;
        }
        object2 = this.elements();
        int n3 = 0;
        while (object2.hasMoreElements()) {
            objectArray[n3] = object2.nextElement();
            ++n3;
        }
        if (n2 < n) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    public int hashCode() {
        int n = 1;
        SeqPosition seqPosition = this.getIterator();
        while (seqPosition.hasNext()) {
            Object object2 = seqPosition.next();
            n = 31 * n + (object2 == null ? 0 : object2.hashCode());
        }
        return n;
    }

    public boolean equals(Object object2) {
        Object e;
        Object e2;
        if (!(object2 instanceof List)) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ((List)object2).iterator();
        do {
            boolean bl;
            boolean bl2;
            if ((bl2 = iterator.hasNext()) != (bl = iterator2.hasNext())) {
                return false;
            }
            if (!bl2) {
                return true;
            }
            e2 = iterator.next();
            e = iterator2.next();
        } while (!(e2 == null ? e != null : !e2.equals(e)));
        return false;
    }

    public Sequence subSequence(SeqPosition seqPosition, SeqPosition seqPosition2) {
        return this.subSequence(seqPosition.ipos, seqPosition.xpos, seqPosition2.ipos, seqPosition2.xpos);
    }

    protected Sequence subSequence(int n, Object object2, int n2, Object object3) {
        SubSequence subSequence = new SubSequence(this);
        this.copyPosition(n, object2, subSequence, 0);
        this.copyPosition(n2, object3, subSequence, 1);
        return subSequence;
    }

    public List subList(int n, int n2) {
        SubSequence subSequence = new SubSequence(this);
        this.makePosition(n, false, subSequence, 0);
        this.makePosition(n2, true, subSequence, 1);
        return subSequence;
    }

    public boolean consumeNext(int n, Object object2, Consumer consumer) {
        if (!this.hasNext(n, object2)) {
            return false;
        }
        consumer.writeObject(this.getNext(n, object2));
        return true;
    }

    protected void consume(int n, Object object2, int n2, Object object3, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        SeqPosition seqPosition = new SeqPosition();
        this.copyPosition(n, object2, seqPosition, 0);
        while (!this.equals(seqPosition.ipos, seqPosition.xpos, n2, object3)) {
            if (!seqPosition.hasNext()) {
                throw new RuntimeException();
            }
            consumer.writeObject(seqPosition.nextElement());
        }
        seqPosition.finalize();
    }

    public void consume(Consumer consumer) {
        String string;
        String string2 = string = "#sequence";
        consumer.beginGroup(string, string2);
        consumer.endAttributes();
        Enumeration enumeration = this.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            consumer.writeObject(enumeration.nextElement());
            ++n;
        }
        consumer.endGroup(string);
    }
}

